/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetUnitNumber;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.chart.JetChartElement;

public class JetChartPenStyle
extends JetChartElement {
    public JetEnumeration style;
    public JetColor color;
    public JetUnitNumber thickness;
    public JetEnumeration endCaps;
    public JetEnumeration lineJoint;
    public JetBoolean outlined;
    public JetBoolean variabledDash;
    public JetNumber transparency;

    public JetChartPenStyle(JetObject jetObject, String string) {
        super(jetObject, string + "Pen");
        string = this.prefix;
        this.style = new JetEnumeration(jetObject, string + "Style", 18);
        this.color = new JetColor(jetObject, string + "Color", Color.black, true);
        this.thickness = new JetUnitNumber(jetObject, string + "Thickness", JRObjectTemplate.convertSize(1));
        this.endCaps = new JetEnumeration(jetObject, string + "EndCaps", 14);
        this.lineJoint = new JetEnumeration(jetObject, string + "LineJoint", 57);
        this.outlined = new JetBoolean(jetObject, string + "Outlined", false);
        this.variabledDash = new JetBoolean(jetObject, string + "VariabledDash", false);
        this.transparency = new JetNumber(jetObject, string + "Transparency", 0);
        this.style.set("Solid Line");
        this.endCaps.set("Square");
        this.lineJoint.set("Miter");
    }

    public String getGroupName() {
        return "Pen";
    }

    public void addToGroup(String string) {
        this.owner.addPropertyToGroup(this.style.getName(), string);
        this.owner.addPropertyToGroup(this.color.getName(), string);
        this.owner.addPropertyToGroup(this.transparency.getName(), string);
        this.owner.addPropertyToGroup(this.thickness.getName(), string);
        this.owner.addPropertyToGroup(this.endCaps.getName(), string);
        this.owner.addPropertyToGroup(this.lineJoint.getName(), string);
        this.owner.addPropertyToGroup(this.outlined.getName(), string);
        this.owner.addPropertyToGroup(this.variabledDash.getName(), string);
    }

    public ChartPenStyle getChartPenStyle() {
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setPenWidth(this.thickness.intValue());
        chartPenStyle.setEndCaps(this.endCaps.intValue());
        chartPenStyle.setLineJoints(this.lineJoint.intValue());
        chartPenStyle.setDashPattern(this.style.intValue());
        chartPenStyle.setOutlined(this.outlined.booleanValue());
        chartPenStyle.setVariabledDash(this.variabledDash.booleanValue());
        ChartColorPattern chartColorPattern = new ChartColorPattern();
        chartColorPattern.setColor(this.color.get());
        chartColorPattern.setAlpha((float)this.transparency.intValue() / 100.0f);
        chartPenStyle.setPenColor(chartColorPattern);
        return chartPenStyle;
    }

    public void setChartPenStyle(ChartPenStyle chartPenStyle) {
        this.thickness.set((int)chartPenStyle.getPenWidth());
        this.endCaps.set((String)JetChartPropertyValues.PEN_ENDCAPS_INTEGERS.get(new Integer(chartPenStyle.getEndCaps())));
        this.lineJoint.set((String)JetChartPropertyValues.PEN_LINEJOINT_INTEGERS.get(new Integer(chartPenStyle.getLineJoints())));
        this.style.set((String)JetChartPropertyValues.PEN_STYLE_INTEGERS.get(new Integer(chartPenStyle.getDashPattern())));
        this.outlined.set(chartPenStyle.isOutlined());
        this.variabledDash.set(chartPenStyle.isVariabledDash());
        this.color.set(chartPenStyle.getPenColor().getColor());
        this.transparency.set(chartPenStyle.getPenColor().getAlpha() * 100.0f);
    }
}

