/*
 * Decompiled with CFR 0.152.
 */
package jet.report.xls.chart;

import java.io.IOException;
import jet.report.xls.Biff;
import jet.report.xls.GlobalWorksheet;
import util.RandomAccessStream;

public class Tick
extends Biff {
    public static final byte NONE = 0;
    public static final byte INSIDE = 1;
    public static final byte OUTSIDE = 2;
    public static final byte CROSS = 3;
    public static final byte SHOWNONE = 0;
    public static final byte LOWAREA = 1;
    public static final byte HIGHAREA = 2;
    public static final byte NEXTAXIS = 3;
    public static final byte TRANSPARENT = 1;
    public static final byte OPAQUE = 2;
    public static final short AUTOCOLOR = 1;
    public static final short AUTOBG = 2;
    public static final short DEFAULT = -29;
    public static final short NOROTATION = 0;
    public static final short UPRIGHT = 4;
    public static final short ROT90COUNTERCLOCK = 8;
    public static final short ROT90CLOCK = 12;
    public static final short AUTOROT = 32;
    byte QOIV;
    byte getColorIndex;
    byte output;
    byte readByte;
    int readInt;
    short readShort;
    short writeByte;
    short writeInt;

    public Tick() {
    }

    public Tick(byte by, byte by2, byte by3, byte by4, int n, short s, short s2, short s3) {
        this.QOIV = by;
        this.getColorIndex = by2;
        this.output = by3;
        this.readByte = by4;
        this.readInt = n;
        this.readShort = s;
        this.writeByte = s2;
        this.writeInt = s3;
        this.length = 30;
    }

    public Tick(byte by, byte by2, byte by3, byte by4, int n, short s, GlobalWorksheet globalWorksheet) {
        this.QOIV = by;
        this.getColorIndex = by2;
        this.output = by3;
        this.readByte = by4;
        this.readInt = n;
        this.readShort = s;
        this.writeByte = (short)globalWorksheet.getColorIndex(n);
        this.length = 30;
    }

    public final int opcode() {
        return 4126;
    }

    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        randomAccessStream.writeByte(this.QOIV);
        randomAccessStream.writeByte(this.getColorIndex);
        randomAccessStream.writeByte(this.output);
        randomAccessStream.writeByte(this.readByte);
        this.writeInt(randomAccessStream, this.readInt);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeShort(randomAccessStream, this.readShort);
        this.writeShort(randomAccessStream, this.writeByte);
        this.writeShort(randomAccessStream, this.writeInt);
        return this.length + 4;
    }

    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.QOIV = randomAccessStream.readByte();
        this.getColorIndex = randomAccessStream.readByte();
        this.output = randomAccessStream.readByte();
        this.readByte = randomAccessStream.readByte();
        this.readInt = this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readShort = this.readShort(randomAccessStream);
        this.writeByte = this.readShort(randomAccessStream);
        this.writeInt = this.readShort(randomAccessStream);
    }

    public void setTickMajor(byte by) {
        this.QOIV = by;
    }

    public byte getTickMajor() {
        return this.QOIV;
    }

    public void setTickMinor(byte by) {
        this.getColorIndex = by;
    }

    public byte getTickMinor() {
        return this.getColorIndex;
    }

    public void setTlt(byte by) {
        this.output = by;
    }

    public byte getTlt() {
        return this.output;
    }

    public void setBgMode(byte by) {
        this.readByte = by;
    }

    public byte getBgMode() {
        return this.readByte;
    }

    public void setRotation(short s) {
        this.writeInt = s;
    }

    public short getRotation() {
        return this.writeInt;
    }

    public boolean isAutoColor() {
        return (this.readShort & 1) == 1;
    }

    public void setAutoColor(boolean bl) {
        this.readShort = (short)(bl ? this.readShort | 1 : this.readShort & 0xFFFFFFFE);
    }

    public boolean isAutoBg() {
        return (this.readShort & 2) == 2;
    }

    public void setAutoBg(boolean bl) {
        this.readShort = (short)(bl ? this.readShort | 2 : this.readShort & 0xFFFFFFFD);
    }

    public void setRot(short s) {
        this.readShort = (short)(this.readShort & 0xFFFFFFE3);
        this.readShort = (short)(this.readShort | s);
    }

    public short getRot() {
        return (short)(this.readShort | 0x1C);
    }

    public boolean isAutoRot() {
        return (this.readShort & 0x20) == 32;
    }

    public void setAutoRot(boolean bl) {
        this.readShort = (short)(bl ? this.readShort | 0x20 : this.readShort & 0xFFFFFFDF);
    }
}

