/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.crosstabLogic;

import java.util.Vector;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTAggInfo;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptCTHdDBTitleField;
import jet.report.JetRptCTHdLabelField;
import jet.report.JetRptCTHdTextField;
import jet.report.JetRptField;
import jet.report.JetRptObject;

public class CrosstableGeometryState {
    public static final int SCALE = 1;
    public static final int DefaultMinGridCellLength = 300;
    public int columnSize = 0;
    public int rowSize = 0;
    public int aggInfoSize = 0;
    public int[] rowWidths;
    public int[] colHeights;
    public int[] aggHeightList;
    public int[] aggWidthList;
    public int[] aggTitleWidths;
    public int[] aggTitleHeights;
    public int[] rowHeights;
    public int[] colWidthes;
    public int boundaryValue;
    public boolean isVertical;
    public boolean has_M_Label = false;
    public boolean has_D_Label = false;
    public boolean hasSpecialAgg = false;
    public int aggBreakNumber = 0;
    public boolean isRepeatAgg = false;
    public int vGap;
    public int hGap;

    public CrosstableGeometryState(JetRptCTCrossTab jetRptCTCrossTab) {
        this.aggBreakNumber(jetRptCTCrossTab);
    }

    private void QOIV() {
        this.columnSize = 0;
        this.rowSize = 0;
        this.aggInfoSize = 0;
        this.rowWidths = null;
        this.colHeights = null;
        this.aggHeightList = null;
        this.aggWidthList = null;
        this.aggTitleWidths = null;
        this.aggTitleHeights = null;
        this.boundaryValue = 0;
        this.isVertical = false;
        this.has_M_Label = false;
        this.has_D_Label = false;
        this.aggBreakNumber = 0;
        this.isRepeatAgg = false;
        this.vGap = 0;
        this.hGap = 0;
    }

    private CrosstableGeometryState aggBreakNumber(JetRptCTCrossTab jetRptCTCrossTab) {
        int n;
        this.QOIV();
        int n2 = jetRptCTCrossTab.boundaryValue.get();
        this.boundaryValue = n2 > 0 ? n2 : -1;
        this.isVertical = jetRptCTCrossTab.verticalLayout.get();
        this.isRepeatAgg = jetRptCTCrossTab.repeatAgg.get();
        this.vGap = jetRptCTCrossTab.vGap.getUnit();
        this.hGap = jetRptCTCrossTab.hGap.getUnit();
        Vector vector = jetRptCTCrossTab.getChildren();
        int n3 = 0;
        while (n3 < vector.size()) {
            JetRptObject jetRptObject;
            Object e = vector.elementAt(n3);
            if (e instanceof JetRptCTHdDBField) {
                jetRptObject = (JetRptCTHdDBField)e;
                n = jetRptObject.isXheader.get();
                int n4 = jetRptObject.depth.get();
                if (n != 0) {
                    if (n4 >= this.columnSize) {
                        this.columnSize = n4 + 1;
                    }
                } else if (n4 >= this.rowSize) {
                    this.rowSize = n4 + 1;
                }
            } else if (e instanceof JetRptCTAggInfo) {
                jetRptObject = (JetRptCTAggInfo)e;
                n = ((JetRptCTAggInfo)jetRptObject).index.get();
                if (n >= this.aggInfoSize) {
                    this.aggInfoSize = n + 1;
                }
            } else if (e instanceof JetRptCTHdLabelField) {
                this.has_M_Label = true;
            } else if (e instanceof JetRptCTHdDBTitleField) {
                this.has_D_Label = true;
            }
            ++n3;
        }
        this.aggBreakNumber = this.arraycopy();
        this.rowWidths = new int[this.rowSize == 0 ? 1 : this.rowSize];
        this.colHeights = new int[this.columnSize == 0 ? 1 : this.columnSize];
        this.rowHeights = new int[this.rowSize == 0 ? 1 : this.rowSize + 1];
        this.colWidthes = new int[this.columnSize == 0 ? 1 : this.columnSize + 1];
        if (this.aggInfoSize == 0) {
            this.aggWidthList = new int[0];
            this.aggHeightList = new int[0];
            this.aggTitleHeights = new int[0];
            this.aggTitleWidths = new int[0];
        } else {
            int n5 = 0;
            if (this.has_D_Label || this.has_M_Label) {
                n5 = 1;
            }
            if (this.isVertical) {
                if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                    this.aggWidthList = new int[(this.columnSize + 1) * this.aggBreakNumber];
                    this.aggHeightList = new int[(this.rowSize + 1) * this.boundaryValue];
                    this.aggTitleWidths = new int[this.aggBreakNumber * n5];
                    this.aggTitleHeights = new int[0];
                } else {
                    this.aggWidthList = new int[this.columnSize + 1];
                    this.aggHeightList = new int[(this.rowSize + 1) * this.aggInfoSize];
                    this.aggTitleWidths = new int[1 * n5];
                    this.aggTitleHeights = new int[0];
                }
            } else if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggWidthList = new int[(this.columnSize + 1) * this.boundaryValue];
                this.aggHeightList = new int[(this.rowSize + 1) * this.aggBreakNumber];
                this.aggTitleWidths = new int[0];
                this.aggTitleHeights = new int[this.aggBreakNumber * n5];
            } else {
                this.aggWidthList = new int[(this.columnSize + 1) * this.aggInfoSize];
                this.aggHeightList = new int[this.rowSize + 1];
                this.aggTitleWidths = new int[0];
                this.aggTitleHeights = new int[1 * n5];
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        n = 0;
        while (n < vector.size()) {
            int n6;
            JetRptField jetRptField;
            Object e = vector.elementAt(n);
            if (e instanceof JetRptCTHdDBField) {
                jetRptField = (JetRptCTHdDBField)e;
                n6 = jetRptField.depth.get();
                if (jetRptField.isXheader.get()) {
                    bl2 = true;
                    this.colHeights[n6] = jetRptField.height.getUnit();
                } else {
                    bl = true;
                    this.rowWidths[n6] = jetRptField.width.getUnit();
                }
            } else if (e instanceof JetRptCTAggField) {
                jetRptField = (JetRptCTAggField)e;
                n6 = ((JetRptCTAggField)jetRptField).index.get();
                int n7 = ((JetRptCTAggField)jetRptField).xdepth.get();
                int n8 = ((JetRptCTAggField)jetRptField).ydepth.get();
                this.setAggFieldWidth(n7, n6, ((JetRptCTAggField)jetRptField).width.getUnit());
                this.setAggFieldHeight(n8, n6, ((JetRptCTAggField)jetRptField).height.getUnit());
            } else if (e instanceof JetRptCTHdLabelField) {
                jetRptField = (JetRptCTHdLabelField)e;
                n6 = ((JetRptCTHdLabelField)jetRptField).index.get();
                this.setVerticalAggTitleWidht(n6, ((JetRptCTHdLabelField)jetRptField).width.getUnit());
                this.setHorizontalAggTitleHeight(n6, ((JetRptCTHdLabelField)jetRptField).height.getUnit());
            } else if (e instanceof JetRptCTHdTextField) {
                jetRptField = (JetRptCTHdTextField)e;
                n6 = ((JetRptCTHdTextField)jetRptField).depth.get();
                if (n6 == 0) {
                    if (((JetRptCTHdTextField)jetRptField).isXheader.get()) {
                        if (!bl2) {
                            this.colHeights[n6] = ((JetRptCTHdTextField)jetRptField).height.getUnit();
                        }
                    } else if (!bl) {
                        this.rowWidths[n6] = ((JetRptCTHdTextField)jetRptField).width.getUnit();
                    }
                }
            }
            ++n;
        }
        this.aggHeightList();
        return this;
    }

    private void aggHeightList() {
        int[][] nArray = this.aggInfoSize();
        int[][] nArray2 = this.aggTitleWidths();
        this.aggTitleHeights(nArray);
        this.aggWidthList(nArray2);
    }

    private int[][] aggInfoSize() {
        int[][] nArray = new int[this.colWidthes.length][this.aggInfoSize];
        int n = 0;
        while (n < this.columnSize + 1) {
            int n2 = 0;
            while (n2 < this.aggInfoSize) {
                nArray[n][n2] = this.getAggFieldWidth(n, n2);
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    private void aggTitleHeights(int[][] nArray) {
        int n = 0;
        while (n < this.colWidthes.length) {
            int n2;
            if (this.isVertical) {
                if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                    n2 = 0;
                    while (n2 < this.boundaryValue) {
                        this.colWidthes[n] = this.colWidthes[n] + nArray[n][n2];
                        ++n2;
                    }
                } else {
                    this.colWidthes[n] = nArray[n][0];
                }
            } else if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                n2 = 0;
                while (n2 < this.aggBreakNumber) {
                    if (n2 % this.boundaryValue == 0) {
                        this.colWidthes[n] = this.colWidthes[n] + nArray[n][n2];
                    }
                    ++n2;
                }
            } else {
                this.colWidthes[n] = nArray[n][0];
            }
            ++n;
        }
    }

    private int[][] aggTitleWidths() {
        int[][] nArray = new int[this.rowHeights.length][this.aggInfoSize];
        int n = 0;
        while (n < this.rowSize + 1) {
            int n2 = 0;
            while (n2 < this.aggInfoSize) {
                nArray[n][n2] = this.getAggFieldHeight(n, n2);
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    private void aggWidthList(int[][] nArray) {
        int n = 0;
        while (n < this.rowHeights.length) {
            int n2;
            if (this.isVertical) {
                if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                    n2 = 0;
                    while (n2 < this.aggBreakNumber) {
                        if (n2 % this.boundaryValue == 0 && nArray[n][n2] > this.rowHeights[n]) {
                            this.rowHeights[n] = nArray[n][n2];
                        }
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.aggInfoSize) {
                        if (nArray[n][n2] > this.rowHeights[n]) {
                            this.rowHeights[n] = nArray[n][n2];
                        }
                        ++n2;
                    }
                }
            } else if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                n2 = 0;
                while (n2 < this.boundaryValue) {
                    if (nArray[n][n2] > this.rowHeights[n]) {
                        this.rowHeights[n] = nArray[n][n2];
                    }
                    ++n2;
                }
            } else {
                this.rowHeights[n] = nArray[n][0];
            }
            ++n;
        }
    }

    public int getColCTDBFieldWidth(int n) {
        int n2 = 0;
        int n3 = this.columnSize - 1 - n;
        int n4 = 0;
        while (n4 <= n3) {
            if (n4 > 0) {
                n2 += this.hGap * 2;
            }
            int n5 = this.colWidthes.length - 1 - n4;
            n2 += this.colWidthes[n5];
            ++n4;
        }
        return n2;
    }

    public int getColCTTextFieldWidth(int n) {
        return this.colWidthes[n];
    }

    public int getRowCTDBFieldHeight(int n) {
        int n2 = 0;
        int n3 = this.rowSize - 1 - n;
        int n4 = 0;
        while (n4 <= n3) {
            if (n4 > 0) {
                n2 += this.hGap * 2;
            }
            int n5 = this.rowHeights.length - 1 - n4;
            n2 += this.rowHeights[n5];
            ++n4;
        }
        return n2;
    }

    public int getRowCTTextFieldHeight(int n) {
        return this.rowHeights[n];
    }

    private int arraycopy() {
        int n = 0;
        n = this.aggInfoSize / this.boundaryValue;
        if (this.aggInfoSize % this.boundaryValue != 0) {
            ++n;
        }
        return n;
    }

    public int getAggFieldWidth(int n, int n2) {
        int n3 = 0;
        n3 = this.isVertical ? (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggWidthList[n * this.aggBreakNumber + n2 / this.boundaryValue] : this.aggWidthList[n]) : (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggWidthList[n * this.boundaryValue + n2 % this.boundaryValue] : this.aggWidthList[n * this.aggInfoSize + n2]);
        return n3;
    }

    public void setAggFieldWidth(int n, int n2, int n3) {
        if (this.isVertical) {
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggWidthList[n * this.aggBreakNumber + n2 / this.boundaryValue] = n3;
            } else {
                this.aggWidthList[n] = n3;
            }
        } else if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
            this.aggWidthList[n * this.boundaryValue + n2 % this.boundaryValue] = n3;
        } else {
            this.aggWidthList[n * this.aggInfoSize + n2] = n3;
        }
        this.aggTitleHeights(this.aggInfoSize());
    }

    public int getAggFieldHeight(int n, int n2) {
        int n3 = 0;
        n3 = this.isVertical ? (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggHeightList[n * this.boundaryValue + n2 % this.boundaryValue] : this.aggHeightList[n * this.aggInfoSize + n2]) : (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggHeightList[n * this.aggBreakNumber + n2 / this.boundaryValue] : this.aggHeightList[n]);
        return n3;
    }

    public void setAggFieldHeight(int n, int n2, int n3) {
        if (this.isVertical) {
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggHeightList[n * this.boundaryValue + n2 % this.boundaryValue] = n3;
            } else {
                this.aggHeightList[n * this.aggInfoSize + n2] = n3;
            }
        } else if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
            this.aggHeightList[n * this.aggBreakNumber + n2 / this.boundaryValue] = n3;
        } else {
            this.aggHeightList[n] = n3;
        }
        this.aggWidthList(this.aggTitleWidths());
    }

    public int getVerticalAggTitleWidth(int n) {
        int n2 = 0;
        if (this.aggTitleWidths.length > 0) {
            n2 = this.isVertical ? (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggTitleWidths[n / this.boundaryValue] : this.aggTitleWidths[0]) : -1;
        }
        return n2;
    }

    public void setVerticalAggTitleWidht(int n, int n2) {
        if (this.isVertical) {
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggTitleWidths[n / this.boundaryValue] = n2;
            } else {
                this.aggTitleWidths[0] = n2;
            }
        }
    }

    public int getHorizontalAggTitleHeight(int n) {
        int n2 = 0;
        if (this.aggTitleHeights.length > 0) {
            n2 = this.isVertical ? -1 : (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggTitleHeights[n / this.boundaryValue] : this.aggTitleHeights[0]);
        }
        return n2;
    }

    public void setHorizontalAggTitleHeight(int n, int n2) {
        if (!this.isVertical) {
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggTitleHeights[n / this.boundaryValue] = n2;
            } else {
                this.aggTitleHeights[0] = n2;
            }
        }
    }

    public int getRowCTDBFieldWidth(int n) {
        return this.rowWidths[n];
    }

    public void setRowCTDBFieldWidth(int n, int n2) {
        this.rowWidths[n] = n2;
    }

    public int getColCTDBFieldHeight(int n) {
        return this.colHeights[n];
    }

    public void setColCTDBFieldHeight(int n, int n2) {
        this.colHeights[n] = n2;
    }

    public void setRowHeaderWidth(int n) {
        int n2 = n - this.colWidthes(this.rowWidths);
        this.columnSize(this.rowWidths, 0, this.rowWidths.length - 1, n2);
    }

    public void setColHeaderHeight(int n) {
        int n2 = n - this.colWidthes(this.colHeights);
        this.columnSize(this.colHeights, 0, this.colHeights.length - 1, n2);
    }

    public void setAggBodyWidth(int n) {
        int n2 = n - this.colWidthes(this.aggWidthList);
        this.columnSize(this.aggWidthList, 0, this.aggWidthList.length - 1, n2);
    }

    public void setAggBodyHeight(int n) {
        int n2 = n - this.colWidthes(this.aggHeightList);
        this.columnSize(this.aggHeightList, 0, this.aggHeightList.length - 1, n2);
    }

    public void setVerticalAggTitleListWidth(int n) {
        int n2 = n - this.colWidthes(this.aggTitleWidths);
        this.columnSize(this.aggTitleWidths, 0, this.aggTitleWidths.length - 1, n2);
    }

    public void setHorizontalAggTitleListHeight(int n) {
        int n2 = n - this.colWidthes(this.aggTitleHeights);
        this.columnSize(this.aggTitleHeights, 0, this.aggTitleHeights.length - 1, n2);
    }

    private int boundaryValue(int n) {
        int n2;
        if (this.isRepeatAgg && !this.isVertical) {
            n2 = 0;
            while (n2 < this.colHeights.length + 1) {
                int n3 = 0;
                while (n3 < this.aggInfoSize) {
                    n -= 2 * this.hGap;
                    ++n3;
                }
                ++n2;
            }
        } else {
            n -= (this.colHeights.length + 1) * 2 * this.hGap;
        }
        if (this.rowSize == 0) {
            n -= this.hGap * 2;
        } else {
            n2 = 0;
            while (n2 < this.rowWidths.length) {
                n -= this.hGap * 2;
                ++n2;
            }
        }
        if (this.aggTitleWidths.length > 0 && this.isVertical) {
            n -= this.hGap * 2;
        }
        return n;
    }

    public void setCrosstableWidth(int n) {
        n = this.boundaryValue(n);
        int[] nArray = new int[this.rowWidths.length + this.aggTitleWidths.length + this.aggWidthList.length];
        System.arraycopy(this.rowWidths, 0, nArray, 0, this.rowWidths.length);
        if (this.aggTitleWidths.length > 0) {
            System.arraycopy(this.aggTitleWidths, 0, nArray, this.rowWidths.length, this.aggTitleWidths.length);
        }
        System.arraycopy(this.aggWidthList, 0, nArray, this.rowWidths.length + this.aggTitleWidths.length, this.aggWidthList.length);
        int n2 = n - this.colWidthes(nArray);
        this.columnSize(nArray, 0, nArray.length - 1, n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.rowWidths.length) {
            this.rowWidths[n4] = nArray[n3++];
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.aggTitleWidths.length) {
            this.aggTitleWidths[n5] = nArray[n3++];
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.aggWidthList.length) {
            this.aggWidthList[n6] = nArray[n3++];
            ++n6;
        }
        nArray = null;
    }

    private int colHeights(int n) {
        int n2;
        if (this.isRepeatAgg && this.isVertical) {
            n2 = 0;
            while (n2 < this.rowWidths.length + 1) {
                int n3 = 0;
                while (n3 < this.aggInfoSize) {
                    n -= 2 * this.vGap;
                    ++n3;
                }
                ++n2;
            }
        } else {
            n -= (this.rowWidths.length + 1) * 2 * this.vGap;
        }
        if (this.columnSize == 0) {
            n -= this.vGap * 2;
        } else {
            n2 = 0;
            while (n2 < this.colHeights.length) {
                n -= this.vGap * 2;
                ++n2;
            }
        }
        if (this.aggTitleHeights.length > 0 && !this.isVertical) {
            n -= 2 * this.vGap;
        }
        return n;
    }

    public void setCrosstableHeight(int n) {
        n = this.colHeights(n);
        int[] nArray = new int[this.colHeights.length + this.aggTitleHeights.length + this.aggHeightList.length];
        System.arraycopy(this.colHeights, 0, nArray, 0, this.colHeights.length);
        if (this.aggTitleHeights.length > 0) {
            System.arraycopy(this.aggTitleHeights, 0, nArray, this.colHeights.length, this.aggTitleHeights.length);
        }
        System.arraycopy(this.aggHeightList, 0, nArray, this.colHeights.length + this.aggTitleHeights.length, this.aggHeightList.length);
        int n2 = n - this.colWidthes(nArray);
        this.columnSize(nArray, 0, nArray.length - 1, n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.colHeights.length) {
            this.colHeights[n4] = nArray[n3++];
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.aggTitleHeights.length) {
            this.aggTitleHeights[n5] = nArray[n3++];
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.aggHeightList.length) {
            this.aggHeightList[n6] = nArray[n3++];
            ++n6;
        }
        nArray = null;
    }

    public int getRowHeaderWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rowWidths.length) {
            n += this.hGap * 2 + this.rowWidths[n2];
            ++n2;
        }
        return n;
    }

    public int getRowHeaderTextWidth(int n) {
        int n2 = 0;
        int n3 = this.rowWidths.length - 1;
        while (n3 >= 0) {
            n2 += this.hGap * 2 + this.rowWidths[n3];
            if (++n == this.rowWidths.length) break;
            --n3;
        }
        return n2;
    }

    public int getColHeaderTextHeight(int n) {
        int n2 = 0;
        int n3 = this.colHeights.length - 1;
        while (n3 >= 0) {
            n2 += this.hGap * 2 + this.colHeights[n3];
            if (++n == this.colHeights.length) break;
            --n3;
        }
        return n2;
    }

    public int getColHeaderHeight() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.colHeights.length) {
            n += this.vGap * 2 + this.colHeights[n2];
            ++n2;
        }
        return n;
    }

    public int getVerticalAggTitleListWidth() {
        int n = 0;
        if (this.aggTitleWidths.length > 0 && this.isVertical) {
            n += 2 * this.hGap + this.colWidthes(this.aggTitleWidths);
        }
        return n;
    }

    public int getHorizontalAggTitleListHeight() {
        int n = 0;
        if (this.aggTitleHeights.length > 0 && !this.isVertical) {
            n += 2 * this.vGap + this.colWidthes(this.aggTitleHeights);
        }
        return n;
    }

    public int getAggBodyWidth() {
        int n = 0;
        if (this.aggInfoSize == 0) {
            int n2 = 0;
            while (n2 < this.colHeights.length + 1) {
                n += 2 * this.hGap + 4800;
                ++n2;
            }
        } else if (this.isRepeatAgg && !this.isVertical) {
            int n3 = 0;
            int n4 = this.colHeights.length + 1;
            if (this.columnSize == 0) {
                n4 = this.colHeights.length;
            }
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                while (n6 < this.aggInfoSize) {
                    n3 = this.getAggFieldWidth(n5, n6);
                    if (n3 == 0) {
                        n3 = 4800;
                    }
                    n += 2 * this.hGap + n3;
                    ++n6;
                }
                ++n5;
            }
        } else {
            n += this.colWidthes(this.aggWidthList) + (this.colHeights.length + 1) * 2 * this.hGap;
        }
        return n;
    }

    public int getAggBodyHeight() {
        int n = 0;
        if (this.aggInfoSize == 0) {
            int n2 = 0;
            while (n2 < this.rowWidths.length + 1) {
                n += 2 * this.vGap + 1037;
                ++n2;
            }
        } else if (this.isRepeatAgg && this.isVertical) {
            int n3 = 0;
            int n4 = this.rowWidths.length + 1;
            if (this.rowSize == 0) {
                n4 = this.rowWidths.length;
            }
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                while (n6 < this.aggInfoSize) {
                    n3 = this.getAggFieldHeight(n5, n6);
                    if (n3 == 0) {
                        n3 = 1037;
                    }
                    n += 2 * this.vGap + n3;
                    ++n6;
                }
                ++n5;
            }
        } else {
            n += this.colWidthes(this.aggHeightList) + (this.rowWidths.length + 1) * 2 * this.vGap;
        }
        return n;
    }

    public int getCrosstabWidth() {
        return this.getRowHeaderWidth() + this.getVerticalAggTitleListWidth() + this.getAggBodyWidth();
    }

    public int getCrosstabHeight() {
        return this.getColHeaderHeight() + this.getHorizontalAggTitleListHeight() + this.getAggBodyHeight();
    }

    private int colWidthes(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    private void columnSize(int[] nArray, int n, int n2, int n3) {
        if (n2 >= n && n >= 0 && n2 < nArray.length) {
            int n4 = 0;
            int n5 = 0;
            if (n3 > 0) {
                block0: while (n3 >= 1) {
                    int n6 = n;
                    while (n6 <= n2) {
                        n5 = nArray[n6];
                        if (n5 > 0) {
                            nArray[n6] = n5 + 1;
                            --n3;
                        }
                        if (n3 < 1) continue block0;
                        ++n6;
                    }
                }
            } else if (n3 < 0) {
                block2: while (n3 <= -1) {
                    int n7 = n;
                    while (n7 <= n2) {
                        n5 = nArray[n7];
                        if (n5 > 0) {
                            n4 = nArray[n7] - 1;
                            if (n4 < 300) {
                                n4 = 300;
                            }
                            nArray[n7] = n4;
                            ++n3;
                        }
                        if (n3 > -1) continue block2;
                        ++n7;
                    }
                }
            }
            nArray[nArray.length - 1] = nArray[nArray.length - 1] + n3;
        }
    }
}

