/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.exception.FormulaSyntaxErrorException;
import jet.formula.DataTypeDef;
import jet.formula.FormulaInfo;
import jet.formula.JetRptFormula;
import jet.formula.SqlwNode;
import jet.log.JRLogger;
import jet.universe.JetUCloneable;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUSummary;
import jet.util.HashVector;
import toolkit.db.gui.MappingSQLType;

public class JetUFormula
extends JetUResourceField
implements JetUFormulaInterface,
JetUCloneable {
    public JetNumber sqlType;
    public JetNumber precision;
    public JetNumber length;
    public JetNumber scale;
    public JetNumber radix;
    public JetString expr;
    protected JetRptFormula rptFormula = null;
    public FormulaInfo formulainfo;
    protected boolean bParsedOK = false;
    private static JRLogger COMBO_EDITOR;
    private static final HashMap FmlToSql;
    private static final HashVector FormulaModified;
    static Class class$jet$universe$JetUFormula;
    static final boolean $assertionsDisabled;

    public JetUFormula() {
    }

    public JetUFormula(String string, String string2, String string3) {
        super(string, string2);
        this.expr.set(string3);
    }

    void I() {
        super.I();
        this.sqlType = new JetNumber(this, "SQLType");
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision = new JetNumber(this, "Precision");
        this.length = new JetNumber(this, "Length");
        this.scale = new JetNumber(this, "Scale");
        this.radix = new JetNumber(this, "Radix");
        this.expr = new JetString(this, "Expression");
        this.formulainfo = new FormulaInfo(this, "formulainfo");
    }

    public JetUFormula createNew() {
        return this.$assertionsDisabled(this.getResourceName());
    }

    public JetUDBTreeNode copy() {
        JetUDatabase jetUDatabase = this.getDatabase();
        String string = this.getResourceName();
        int n = 1;
        String string2 = "Copy_of_" + string;
        while (jetUDatabase.IsMappingNameExist(string2)) {
            string2 = "Copy_(" + String.valueOf(++n) + ")_of_" + string;
        }
        JetUFormula jetUFormula = this.$assertionsDisabled(string2);
        JetObject.copyProperties(jetUFormula, this);
        jetUFormula.setResourceName(string2);
        return jetUFormula;
    }

    private JetUFormula $assertionsDisabled(String string) {
        JetUFormula jetUFormula = new JetUFormula(string, this.getDesc(), this.getExpression());
        jetUFormula.rptFormula = this.getRptFormula();
        jetUFormula.HandleRptFormula();
        jetUFormula.createProperties();
        return jetUFormula;
    }

    public void InitAfterCreate() {
        super.InitAfterCreate();
        this.FormulaModified();
    }

    public void InitAfterLoad() {
        super.InitAfterLoad();
        if (!(this.formulainfo.formulatype == null || this.getSqlType() == 3 && this instanceof JetUSummary)) {
            if (DataTypeDef.isArray(this.formulainfo.formulatype.getDataType())) {
                int n = this.formulainfo.formulatype.getDataType();
                this.sqlType.set(DataTypeDef.FmlToSql(n - 11));
            } else {
                this.sqlType.set(DataTypeDef.FmlToSql(this.formulainfo.formulatype.getDataType()));
            }
        }
        if (this.getPrecision() == 0) {
            this.createProperties();
        }
        this.bParsedOK = this.formulainfo.parseOK;
    }

    public void FormulaModified() {
        JetUDatabase jetUDatabase = this.getDatabase();
        if (!$assertionsDisabled && jetUDatabase == null) {
            throw new AssertionError((Object)"database can not be null when in aftercreate");
        }
        if (jetUDatabase != null) {
            jetUDatabase.FormulaModified();
        }
    }

    public FormulaInfo getFormulaInfo() {
        return this.formulainfo;
    }

    public void setResourceName(String string) {
        super.setResourceName(string);
        this.FormulaModified();
    }

    public String getExpression() {
        return this.expr.get();
    }

    public void setExpression(String string) {
        this.expr.set(string);
        this.FormulaModified();
    }

    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int n) {
        if (this.sqlType.get() != n) {
            this.setHAlignmentDefault(n);
            this.setVAlignmentDefault(n);
        }
        this.sqlType.set(n);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int n) {
        this.precision.set(n);
    }

    public int getLength() {
        return this.length.get();
    }

    public void setLength(int n) {
        this.length.set(n);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int n) {
        this.scale.set(n);
    }

    public int getRadix() {
        return this.radix.get();
    }

    public void setRadix(int n) {
        this.radix.set(n);
    }

    public JetUDatabase getDatabase() {
        return (JetUDatabase)this.getParent();
    }

    public DbColDesc getColDesc() {
        if (this.formulainfo != null && this.formulainfo.parseOK) {
            int n = this.formulainfo.formulatype.getDataType();
            DbColDesc dbColDesc = new DbColDesc(this.getResourceName(), this.getSqlType(), this.getPrecision(), this.getScale(), 2);
            if (n == 3) {
                dbColDesc.setCurrency(true);
            }
            dbColDesc.setGroupable(this.formulainfo.formulatype.IsSum());
            this.addCaseSensitiveInfo(dbColDesc);
            this.addEncodingPattern(dbColDesc);
            return dbColDesc;
        }
        return null;
    }

    public void createProperties() {
        int[] nArray = MappingSQLType.getColumnProperty(this.getSqlType());
        this.setPrecision(nArray[0]);
        this.setScale(nArray[2]);
    }

    public JetRptFormula createRptFormula() {
        if (this.rptFormula == null) {
            this.rptFormula = new JetRptFormula();
        }
        this.rptFormula.setDataSource(this.getDatabase());
        this.rptFormula.setName(this.getResourceName());
        this.rptFormula.setExpression(this.getExpression());
        return this.rptFormula;
    }

    public boolean isParsedOK() {
        return this.bParsedOK;
    }

    public JetRptFormula getRptFormula() {
        if (this.rptFormula != null) {
            return this.rptFormula;
        }
        JetRptFormula jetRptFormula = new JetRptFormula();
        jetRptFormula.setDataSource(this.getDatabase());
        jetRptFormula.setName(this.getResourceName());
        jetRptFormula.setExpression(this.getExpression());
        jetRptFormula.setFormulaInfo(this.formulainfo);
        jetRptFormula.setColDesc(this.getColDesc());
        return jetRptFormula;
    }

    public void HandleRptFormula() {
        block4: {
            try {
                if (this.rptFormula.isparsedOK()) {
                    this.bParsedOK = true;
                    this.setFormulaType(this.rptFormula.getFormulaInfo(null));
                } else {
                    this.bParsedOK = false;
                    this.setFormulaType(null);
                }
            }
            catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
                if (!COMBO_EDITOR.isErrorEnabled()) break block4;
                COMBO_EDITOR.error("", formulaSyntaxErrorException);
            }
        }
        this.rptFormula = null;
    }

    public void setFormulaType(FormulaInfo formulaInfo) {
        if (formulaInfo != null) {
            this.formulainfo.formulatype = formulaInfo.formulatype;
            if (this.getSqlType() != 3 || !(this instanceof JetUSummary)) {
                if (DataTypeDef.isArray(this.formulainfo.formulatype.getDataType())) {
                    int n = formulaInfo.formulatype.getDataType();
                    this.setSqlType(DataTypeDef.FmlToSql(n - 11));
                } else {
                    this.setSqlType(DataTypeDef.FmlToSql(formulaInfo.formulatype.getDataType()));
                }
            }
            this.formulainfo.setState(formulaInfo.getState());
            this.formulainfo.isGlobal = formulaInfo.isGlobal;
            this.formulainfo.isGroupby = formulaInfo.isGroupby;
            this.formulainfo.GroupbyNames = formulaInfo.GroupbyNames;
            this.formulainfo.refFormula = formulaInfo.refFormula;
            this.formulainfo.refDBfield = formulaInfo.refDBfield;
            this.formulainfo.refParameter = formulaInfo.refParameter;
            this.formulainfo.refAggregation = formulaInfo.refAggregation;
            this.formulainfo.callee = formulaInfo.callee;
            this.formulainfo.parseOK = formulaInfo.parseOK;
            this.formulainfo.root = formulaInfo.root;
            this.formulainfo.aggdesc = formulaInfo.aggdesc;
            this.formulainfo.refEnFormula = formulaInfo.refEnFormula;
            this.formulainfo.refEnDbField = formulaInfo.refEnDbField;
            this.formulainfo.refEnParameter = formulaInfo.refEnParameter;
            this.formulainfo.refUDFClass = formulaInfo.refUDFClass;
            this.formulainfo.refSysVars = formulaInfo.refSysVars;
            this.formulainfo.globalVars = formulaInfo.globalVars;
            this.formulainfo.refBuildInFunctions = formulaInfo.refBuildInFunctions;
        } else {
            this.formulainfo.formulatype = null;
            this.formulainfo.setState((byte)0);
            this.formulainfo.isGlobal = false;
            this.formulainfo.isGroupby = false;
            this.formulainfo.GroupbyNames = new Vector();
            this.formulainfo.refFormula = new Vector();
            this.formulainfo.refDBfield = new Vector();
            this.formulainfo.refParameter = new Vector();
            this.formulainfo.refAggregation = new Vector();
            this.formulainfo.callee = 0;
            this.formulainfo.parseOK = false;
            this.formulainfo.root = null;
            this.formulainfo.aggdesc = null;
            this.formulainfo.refEnFormula = new Vector();
            this.formulainfo.refEnDbField = new Vector();
            this.formulainfo.refEnParameter = new Vector();
            this.formulainfo.refUDFClass = new Vector();
            this.formulainfo.refSysVars = new Vector();
            this.formulainfo.globalVars = new Hashtable();
            this.formulainfo.refBuildInFunctions = new Vector();
        }
    }

    public boolean useSysVars() {
        return this.formulainfo.isSysVar();
    }

    public boolean isConstant() {
        if (this.formulainfo.formulatype != null) {
            return this.formulainfo.formulatype.getAttr() == 9;
        }
        return false;
    }

    public boolean isUsePageVars() {
        return this.formulainfo.isUsePageVar();
    }

    public Vector getRefDbFld() {
        return this.formulainfo.refDBfield;
    }

    public Vector getRefFormuFld() {
        return this.formulainfo.refFormula;
    }

    public Vector getRefParamFld() {
        return this.formulainfo.refParameter;
    }

    public Vector getGroupByVector() {
        return this.formulainfo.GroupbyNames;
    }

    public boolean isGroupBy(String string) {
        return this.formulainfo.GroupbyNames.contains(string.toUpperCase());
    }

    public boolean isGroupBy() {
        return this.formulainfo.GroupbyNames.size() != 0;
    }

    public String getDefinition() {
        return "expression: " + this.getExpression();
    }

    public String toString() {
        String string = "Formula [ " + this.getExpression() + " ]";
        return string;
    }

    public JetRptFormula createJetRptFormula() {
        JetRptFormula jetRptFormula = this.createRptFormula();
        jetRptFormula.setFormulaInfo(this.formulainfo);
        return jetRptFormula;
    }

    public SqlwNode getSqlWhere() throws Exception {
        return this.formulainfo.root;
    }

    public boolean canSummary() {
        return this.isParsedOK() && !this.isConstant() && !this.formulainfo.isGlobal && !this.isGroupBy();
    }

    public String getInstancePrefix() {
        return "Formula";
    }

    public boolean isSimilar(JetUResourceEntity jetUResourceEntity) {
        return super.isSimilar(jetUResourceEntity) && this.sqlType.equal(((JetUFormula)jetUResourceEntity).sqlType) && this.expr.equal(((JetUFormula)jetUResourceEntity).expr);
    }

    public HashMap getIndecialMap() {
        return FmlToSql;
    }

    public HashVector getPropGrpsDesc() {
        return FormulaModified;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUFormula == null ? (class$jet$universe$JetUFormula = JetUFormula.class$("jet.universe.JetUFormula")) : class$jet$universe$JetUFormula).desiredAssertionStatus();
        COMBO_EDITOR = JRLogger.getLogger((class$jet$universe$JetUFormula == null ? (class$jet$universe$JetUFormula = JetUFormula.class$("jet.universe.JetUFormula")) : class$jet$universe$JetUFormula).getName());
        FmlToSql = new HashMap(41);
        FmlToSql.put("SQLType", new Integer(0));
        FmlToSql.put("padding-right", new Integer(1));
        FmlToSql.put("RightLine", new Integer(2));
        FmlToSql.put("HorizontalAlignment", new Integer(3));
        FmlToSql.put("Expression", new Integer(4));
        FmlToSql.put("PatternStyle", new Integer(5));
        FmlToSql.put("Format", new Integer(6));
        FmlToSql.put("Precision", new Integer(7));
        FmlToSql.put("Length", new Integer(8));
        FmlToSql.put("Bold", new Integer(9));
        FmlToSql.put("AutoFit", new Integer(10));
        FmlToSql.put("Width", new Integer(11));
        FmlToSql.put("formulainfo", new Integer(12));
        FmlToSql.put("GUIField", new Integer(13));
        FmlToSql.put("Height", new Integer(14));
        FmlToSql.put("Radix", new Integer(15));
        FmlToSql.put("padding-bottom", new Integer(16));
        FmlToSql.put("Name", new Integer(17));
        FmlToSql.put("ShadowColor", new Integer(18));
        FmlToSql.put("BottomLine", new Integer(19));
        FmlToSql.put("padding-top", new Integer(20));
        FmlToSql.put("Description", new Integer(21));
        FmlToSql.put("BorderWidth", new Integer(22));
        FmlToSql.put("Background", new Integer(23));
        FmlToSql.put("Scale", new Integer(24));
        FmlToSql.put("DisplayWidth", new Integer(25));
        FmlToSql.put("VerticalAlignment", new Integer(26));
        FmlToSql.put("PatternColor", new Integer(27));
        FmlToSql.put("TopLine", new Integer(28));
        FmlToSql.put("FontSize", new Integer(29));
        FmlToSql.put("Underline", new Integer(30));
        FmlToSql.put("LeftLine", new Integer(31));
        FmlToSql.put("FontFace", new Integer(32));
        FmlToSql.put("Alignment", new Integer(33));
        FmlToSql.put("padding-left", new Integer(34));
        FmlToSql.put("WordWrap", new Integer(35));
        FmlToSql.put("Italic", new Integer(36));
        FmlToSql.put("StrikeOut", new Integer(37));
        FmlToSql.put("BorderColor", new Integer(38));
        FmlToSql.put("Foreground", new Integer(39));
        FmlToSql.put("Shadow", new Integer(40));
        FormulaModified = new HashVector(7);
        String string = null;
        Vector<String> vector = null;
        string = "General";
        vector = new Vector<String>(11);
        vector.add("Name");
        vector.add("Description");
        vector.add("GUIField");
        vector.add("DisplayWidth");
        vector.add("SQLType");
        vector.add("Precision");
        vector.add("Scale");
        vector.add("Length");
        vector.add("Radix");
        vector.add("Expression");
        FormulaModified.put(string, vector);
        string = "TextFormat";
        vector = new Vector(11);
        vector.add("FontFace");
        vector.add("FontSize");
        vector.add("Bold");
        vector.add("Italic");
        vector.add("StrikeOut");
        vector.add("Underline");
        vector.add("Format");
        vector.add("AutoFit");
        vector.add("WordWrap");
        vector.add("VerticalAlignment");
        vector.add("HorizontalAlignment");
        FormulaModified.put(string, vector);
        string = "Padding";
        vector = new Vector(4);
        vector.add("padding-top");
        vector.add("padding-bottom");
        vector.add("padding-left");
        vector.add("padding-right");
        FormulaModified.put(string, vector);
        string = "Geometry";
        vector = new Vector(2);
        vector.add("Width");
        vector.add("Height");
        FormulaModified.put(string, vector);
        string = "Color";
        vector = new Vector(2);
        vector.add("Background");
        vector.add("Foreground");
        FormulaModified.put(string, vector);
        string = "Border";
        vector = new Vector(8);
        vector.add("BorderWidth");
        vector.add("TopLine");
        vector.add("BottomLine");
        vector.add("LeftLine");
        vector.add("RightLine");
        vector.add("Shadow");
        vector.add("BorderColor");
        vector.add("ShadowColor");
        FormulaModified.put(string, vector);
        string = "Pattern";
        vector = new Vector(2);
        vector.add("PatternColor");
        vector.add("PatternStyle");
        FormulaModified.put(string, vector);
    }
}

