/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetString;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.universe.JetUResourceContainer;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.convert.IExpression2Jet;
import jet.universe.businesslogic.filter.convert.Jet2IExpression;
import jet.util.HashVector;
import toolkit.db.PsqlJoin;

public class JetPsqlJoin
extends JetUResourceContainer {
    public JetString name = new JetString(this, "name");
    public JetNumber idxTblFrom = new JetNumber(this, "idxTblFrom");
    public JetNumber idxTblTo = new JetNumber(this, "idxTblTo");
    public JetString fromCol = new JetString(this, "fromColumn");
    public JetString toCol = new JetString(this, "toColumn");
    public JetString operator = new JetString(this, "operator");
    public JetNumber outerJoin = new JetNumber(this, "outerJoin");
    public JetBoolean isOrcl = new JetBoolean(this, "isOrclOJ");
    private static final HashMap I = new HashMap(8);

    public JetPsqlJoin() {
    }

    public JetPsqlJoin(PsqlJoin psqlJoin) {
        this.name.set(psqlJoin.name);
        this.idxTblFrom.set(psqlJoin.getIndexOfTableFrom());
        this.idxTblTo.set(psqlJoin.getIndexOfTableTo());
        this.fromCol.set(psqlJoin.getColumnFrom().getMappingName());
        this.toCol.set(psqlJoin.getColumnTo().getMappingName());
        this.operator.set(psqlJoin.getOperator());
        this.outerJoin.set(psqlJoin.getOuterJoin());
        this.isOrcl.set(!psqlJoin.isSql92());
        this.setJoinCondition(psqlJoin.getJoinCondition());
    }

    public PsqlJoin makePsqlJoin(int n) {
        PsqlJoin psqlJoin = new PsqlJoin();
        psqlJoin.name = this.name.get();
        psqlJoin.idxTblFrom = this.idxTblFrom.get();
        psqlJoin.idxTblTo = this.idxTblTo.get();
        psqlJoin.sColFrom = this.fromCol.get();
        psqlJoin.sColTo = this.toCol.get();
        psqlJoin.strOperator = this.operator.get();
        psqlJoin.setOuterJoin(this.outerJoin.get());
        psqlJoin.setSql92(!this.isOrcl.get());
        psqlJoin.setJoinCondition(this.getJoinCondition());
        return psqlJoin;
    }

    public String getInstancePrefix() {
        return "PsqlJoin";
    }

    public HashMap getIndecialMap() {
        return I;
    }

    public HashVector getPropertyGroups() {
        HashVector hashVector = super.getPropertyGroups();
        if (hashVector.size() == 0) {
            return null;
        }
        return hashVector;
    }

    public void setJoinCondition(IExpression iExpression) {
        if (iExpression == null) {
            return;
        }
        IExpression2Jet iExpression2Jet = new IExpression2Jet();
        UFilterExpression uFilterExpression = null;
        try {
            uFilterExpression = iExpression2Jet.convert(iExpression);
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        if (this.getChildren().size() != 0) {
            this.removeall();
        }
        this.add(uFilterExpression);
        uFilterExpression.setParent(this);
    }

    public IExpression getJoinCondition() {
        if (this.getChildren().size() == 0) {
            return null;
        }
        Jet2IExpression jet2IExpression = new Jet2IExpression();
        IExpression iExpression = null;
        try {
            iExpression = jet2IExpression.convert((UFilterExpression)this.getChildren().get(0), null, null, null);
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        return iExpression;
    }

    public void BeforeRemove() {
    }

    static {
        I.put("fromColumn", new Integer(0));
        I.put("isOrclOJ", new Integer(1));
        I.put("name", new Integer(2));
        I.put("outerJoin", new Integer(3));
        I.put("toColumn", new Integer(4));
        I.put("idxTblFrom", new Integer(5));
        I.put("idxTblTo", new Integer(6));
        I.put("operator", new Integer(7));
    }
}

