/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbBuffer;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbRecordModel;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.datasource.JRResultSet;
import jet.datasource.JRResultSetException;

public abstract class XResultFileResultSet
extends JRResultSet {
    protected DbRecordModel recordModel;
    protected DbBuffer dbBuffer;
    private DbColDesc[] clearMem;
    protected Record record;
    protected int iRcdCount;
    protected int iRecordIndex;
    private int[] currentRecord = null;
    private boolean elementAt;
    private DbValue equalsIgnoreCase;

    public XResultFileResultSet() {
    }

    public XResultFileResultSet(DbBuffer dbBuffer, Vector vector) throws JRResultSetException {
        this.init(dbBuffer, vector);
    }

    protected final void init(DbBuffer dbBuffer, Vector vector) throws JRResultSetException {
        this.dbBuffer = dbBuffer;
        this.recordModel = dbBuffer.getRecordModel();
        this.initResultSet();
        this.setColumnMap(vector);
    }

    protected void initResultSet() {
        this.clearMem = this.recordModel.getColDescs();
        this.record = this.recordModel.currentRecord;
        this.iRecordIndex = -1;
    }

    public void setColumnMap(Vector vector) throws JRResultSetException {
        int n = vector.size();
        this.currentRecord = new int[n + 1];
        int n2 = 1;
        while (n2 <= n) {
            DbColDesc dbColDesc = (DbColDesc)vector.elementAt(n2 - 1);
            String string = dbColDesc.getColName();
            int n3 = this.getColumnIndex(string);
            if (n3 < 0) {
                throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_5", (Object)string));
            }
            if (!dbColDesc.typeEquals(this.clearMem[n3])) {
                throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n3)));
            }
            this.currentRecord[n2] = n3;
            ++n2;
        }
    }

    protected int getColumnIndex(String string) {
        int n = this.clearMem.length;
        int n2 = 0;
        while (n2 < n) {
            DbColDesc dbColDesc = this.clearMem[n2];
            if (string.equalsIgnoreCase(dbColDesc.getColName())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected DbValue getDbValue(int n) {
        DbValue dbValue = this.record.getCell(this.currentRecord[n]);
        return dbValue;
    }

    public boolean next() throws JRResultSetException {
        ++this.iRecordIndex;
        if (this.iRecordIndex < this.iRcdCount) {
            this.recordModel.currentRecord.setRecordIndex(this.iRecordIndex);
            this.recordModel.currentRecord.refresh(true);
            return true;
        }
        return false;
    }

    public void close() throws JRResultSetException {
        try {
            try {
                this.dbBuffer.clearMem();
            }
            catch (Exception exception) {
                throw new JRResultSetException(JResource.getMessage("CAT_CQR_TITLE_2"));
            }
            Object var3_1 = null;
            this.dbBuffer = null;
            this.recordModel = null;
            this.clearMem = null;
            this.record = null;
            this.currentRecord = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.dbBuffer = null;
            this.recordModel = null;
            this.clearMem = null;
            this.record = null;
            this.currentRecord = null;
            throw throwable;
        }
    }

    public boolean wasNull() throws JRResultSetException {
        return this.elementAt;
    }

    public String getString(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == -1 || n2 == 1 || n2 == 12 || n2 == 2005) {
                this.elementAt = false;
                return ((DbChar)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return null;
    }

    public Array getArray(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            this.elementAt = false;
            return ((DbArray)this.equalsIgnoreCase).toSqlArray();
        }
        this.elementAt = true;
        return null;
    }

    public boolean getBoolean(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == -7) {
                this.elementAt = false;
                return ((DbBit)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return false;
    }

    public byte getByte(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == -6) {
                this.elementAt = false;
                return (byte)((DbTinyInt)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return 0;
    }

    public short getShort(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == 5) {
                this.elementAt = false;
                return ((DbSmallInt)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return 0;
    }

    public int getInt(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == 4) {
                this.elementAt = false;
                return ((DbInteger)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return 0;
    }

    public long getLong(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == -5) {
                this.elementAt = false;
                return ((DbBigInt)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return 0L;
    }

    public float getFloat(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == 6 || n2 == 7) {
                this.elementAt = false;
                return ((DbReal)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return 0.0f;
    }

    public double getDouble(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == 8) {
                this.elementAt = false;
                return ((DbDouble)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return 0.0;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n3 = this.equalsIgnoreCase.getSqlType();
            if (n3 == 3 || n3 == 2) {
                this.elementAt = false;
                return ((DbDecimal)this.equalsIgnoreCase).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return null;
    }

    public byte[] getBytes(int n) throws JRResultSetException {
        return null;
    }

    public Date getDate(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == 91) {
                this.elementAt = false;
                return ((DbDate)this.equalsIgnoreCase).getDate();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return null;
    }

    public Time getTime(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == 92) {
                this.elementAt = false;
                return ((DbTime)this.equalsIgnoreCase).getTime();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return null;
    }

    public Timestamp getTimestamp(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == 93) {
                this.elementAt = false;
                return ((DbTimestamp)this.equalsIgnoreCase).getTimestamp();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return null;
    }

    public InputStream getBinaryStream(int n) throws JRResultSetException {
        this.equalsIgnoreCase = this.getDbValue(n);
        if (!this.equalsIgnoreCase.isNull()) {
            int n2 = this.equalsIgnoreCase.getSqlType();
            if (n2 == -2 || n2 == -3 || n2 == -4 || n2 == 2004) {
                this.elementAt = false;
                return new ByteArrayInputStream(((DbBinary)this.equalsIgnoreCase).get());
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(n)));
        }
        this.elementAt = true;
        return null;
    }

    public InputStream getAsciiStream(int n) throws JRResultSetException {
        return null;
    }

    public InputStream getUnicodeStream(int n) throws JRResultSetException {
        return null;
    }

    public String getString(String string) throws JRResultSetException {
        return null;
    }

    public boolean getBoolean(String string) throws JRResultSetException {
        return false;
    }

    public byte getByte(String string) throws JRResultSetException {
        return 0;
    }

    public short getShort(String string) throws JRResultSetException {
        return 0;
    }

    public int getInt(String string) throws JRResultSetException {
        return 0;
    }

    public long getLong(String string) throws JRResultSetException {
        return 0L;
    }

    public float getFloat(String string) throws JRResultSetException {
        return 0.0f;
    }

    public double getDouble(String string) throws JRResultSetException {
        return 0.0;
    }

    public BigDecimal getBigDecimal(String string, int n) throws JRResultSetException {
        return null;
    }

    public byte[] getBytes(String string) throws JRResultSetException {
        return null;
    }

    public Date getDate(String string) throws JRResultSetException {
        return null;
    }

    public Time getTime(String string) throws JRResultSetException {
        return null;
    }

    public Timestamp getTimestamp(String string) throws JRResultSetException {
        return null;
    }

    public InputStream getAsciiStream(String string) throws JRResultSetException {
        return null;
    }

    public InputStream getUnicodeStream(String string) throws JRResultSetException {
        return null;
    }

    public InputStream getBinaryStream(String string) throws JRResultSetException {
        return null;
    }

    public SQLWarning getWarnings() throws JRResultSetException {
        return null;
    }

    public void clearWarnings() throws JRResultSetException {
    }

    public String getCursorName() throws JRResultSetException {
        return null;
    }

    public ResultSetMetaData getMetaData() throws JRResultSetException {
        return null;
    }

    public Object getObject(int n) throws JRResultSetException {
        return null;
    }

    public Object getObject(String string) throws JRResultSetException {
        return null;
    }

    public int findColumn(String string) throws JRResultSetException {
        return 0;
    }
}

