/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetProperty;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.report.JetRptFilter;
import jet.report.JetRptFilterContainer;
import jet.report.JetRptObject;
import jet.report.JetRptSort;
import jet.report.JetRptSortContainer;
import jet.report.filter.JetFilterExpression;
import jet.report.filter.set.JetSetExpression;
import jet.report.filter.set.JetSortExpression;
import jet.report.filter.set.JetSortInfo;
import jet.report.filter.tuple.JetBinaryConditionExpression;
import jet.report.filter.tuple.JetBinaryLogicExpression;
import jet.report.filter.tuple.JetTupleExpression;
import jet.report.filter.variable.JetConstantExpression;
import jet.report.filter.variable.JetReferenceExpression;
import jet.upgrade.UpgradeRpt;
import jet.upgrade.UpgradeToV8Util;

class UpgradeFilterToV8Impl
implements UpgradeRpt {
    UpgradeFilterToV8Impl() {
    }

    public JetRptObject upgrade(JetRptObject jetRptObject) {
        if (jetRptObject instanceof JetRptSortContainer) {
            return this.QOIV((JetRptSortContainer)jetRptObject);
        }
        if (jetRptObject instanceof JetRptFilterContainer) {
            return this.addSortInfo((JetRptFilterContainer)jetRptObject);
        }
        return null;
    }

    public JetRptObject upgrade(JetRptObject jetRptObject, JetRptObject jetRptObject2) {
        JetFilterExpression jetFilterExpression = null;
        JetFilterExpression jetFilterExpression2 = null;
        if (jetRptObject instanceof JetRptSortContainer) {
            jetFilterExpression = this.QOIV((JetRptSortContainer)jetRptObject);
        } else if (jetRptObject instanceof JetRptFilterContainer) {
            jetFilterExpression = this.addSortInfo((JetRptFilterContainer)jetRptObject);
        } else {
            return null;
        }
        if (jetRptObject2 instanceof JetRptSortContainer) {
            jetFilterExpression2 = this.QOIV((JetRptSortContainer)jetRptObject2);
        } else if (jetRptObject2 instanceof JetRptFilterContainer) {
            jetFilterExpression2 = this.addSortInfo((JetRptFilterContainer)jetRptObject2);
        } else {
            return null;
        }
        if (jetFilterExpression == null) {
            if (jetFilterExpression2 == null) {
                return null;
            }
            return jetFilterExpression2;
        }
        if (jetFilterExpression2 == null) {
            return jetFilterExpression;
        }
        if (ExpressionToolKit.isSetExp(jetFilterExpression.getType())) {
            if (ExpressionToolKit.isSetExp(jetFilterExpression2.getType())) {
                ((JetSetExpression)jetFilterExpression).setExpression((JetSetExpression)jetFilterExpression2);
            } else if (ExpressionToolKit.isTupleExp(jetFilterExpression2.getType())) {
                ((JetSetExpression)jetFilterExpression).setExpression((JetTupleExpression)jetFilterExpression2);
            }
            return jetFilterExpression;
        }
        if (ExpressionToolKit.isSetExp(jetFilterExpression2.getType())) {
            if (ExpressionToolKit.isTupleExp(jetFilterExpression.getType())) {
                ((JetSetExpression)jetFilterExpression2).setExpression((JetTupleExpression)jetFilterExpression);
            }
            return jetFilterExpression2;
        }
        return null;
    }

    private JetFilterExpression QOIV(JetRptSortContainer jetRptSortContainer) {
        JetRptObject jetRptObject;
        Vector vector = jetRptSortContainer.getChildren();
        int n = vector.size();
        if (n < 1) {
            return null;
        }
        JetSortInfo[] jetSortInfoArray = new JetSortInfo[n];
        int n2 = 0;
        while (n2 < n) {
            jetRptObject = (JetRptSort)vector.get(n2);
            JetReferenceExpression jetReferenceExpression = this.getColumn(((JetRptSort)jetRptObject).getColumn(), ((JetRptSort)jetRptObject).getColumn());
            jetSortInfoArray[n2] = this.getKey(jetReferenceExpression, this.compareTo(((JetRptSort)jetRptObject).getOrder()), false);
            ++n2;
        }
        jetRptObject = this.getLogic(jetSortInfoArray);
        this.getChildren((JetFilterExpression)jetRptObject, jetRptSortContainer, new String[]{"Column", "Order"});
        return jetRptObject;
    }

    private JetFilterExpression addSortInfo(JetRptFilterContainer jetRptFilterContainer) {
        Vector vector = jetRptFilterContainer.getChildren();
        int n = vector.size();
        if (n < 1) {
            return null;
        }
        if (n == 1) {
            JetRptFilter jetRptFilter = (JetRptFilter)vector.get(0);
            JetReferenceExpression jetReferenceExpression = this.getColumn(jetRptFilter.getColumn(), jetRptFilter.getColumn());
            JetConstantExpression jetConstantExpression = this.getOperator(jetRptFilter.getValue(), jetRptFilter.getValue());
            JetBinaryConditionExpression jetBinaryConditionExpression = this.getOrder(this.entrySet(jetRptFilter.getOperator()), jetReferenceExpression, jetConstantExpression);
            this.getChildren(jetBinaryConditionExpression, jetRptFilterContainer, new String[0]);
            return jetBinaryConditionExpression;
        }
        JetBinaryLogicExpression jetBinaryLogicExpression = null;
        JetRptFilter jetRptFilter = (JetRptFilter)vector.get(0);
        JetReferenceExpression jetReferenceExpression = this.getColumn(jetRptFilter.getColumn(), jetRptFilter.getColumn());
        JetConstantExpression jetConstantExpression = this.getOperator(jetRptFilter.getValue(), jetRptFilter.getValue());
        JetBinaryConditionExpression jetBinaryConditionExpression = this.getOrder(this.entrySet(jetRptFilter.getOperator()), jetReferenceExpression, jetConstantExpression);
        JetRptFilter jetRptFilter2 = (JetRptFilter)vector.get(1);
        JetReferenceExpression jetReferenceExpression2 = this.getColumn(jetRptFilter2.getColumn(), jetRptFilter2.getColumn());
        JetConstantExpression jetConstantExpression2 = this.getOperator(jetRptFilter2.getValue(), jetRptFilter2.getValue());
        JetBinaryConditionExpression jetBinaryConditionExpression2 = this.getOrder(this.entrySet(jetRptFilter2.getOperator()), jetReferenceExpression2, jetConstantExpression2);
        jetBinaryLogicExpression = this.getProperties(this.get(jetRptFilter.getLogic()), jetBinaryConditionExpression, jetBinaryConditionExpression2);
        int n2 = 2;
        while (n2 < n) {
            jetRptFilter = (JetRptFilter)vector.get(n2 - 1);
            jetRptFilter2 = (JetRptFilter)vector.get(n2);
            jetReferenceExpression2 = this.getColumn(jetRptFilter2.getColumn(), jetRptFilter2.getColumn());
            jetConstantExpression2 = this.getOperator(jetRptFilter2.getValue(), jetRptFilter2.getValue());
            jetBinaryConditionExpression2 = this.getOrder(this.entrySet(jetRptFilter2.getOperator()), jetReferenceExpression2, jetConstantExpression2);
            jetBinaryLogicExpression = this.getType(this.get(jetRptFilter.getLogic()), jetBinaryLogicExpression, jetBinaryConditionExpression2);
            ++n2;
        }
        this.getChildren(jetBinaryLogicExpression, jetRptFilterContainer, new String[]{"Logic", "Value", "Operator", "Column"});
        return jetBinaryLogicExpression;
    }

    private int compareTo(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    private int entrySet(int n) {
        switch (n) {
            case 0: {
                return 556793872;
            }
            case 1: {
                return 556793984;
            }
            case 2: {
                return 556793920;
            }
            case 3: {
                return 556794112;
            }
            case 4: {
                return 556794368;
            }
            case 5: {
                return 556793888;
            }
        }
        return n;
    }

    private int get(int n) {
        switch (n) {
            case 0: {
                return -2125463550;
            }
            case 2: {
                return -1;
            }
            case 1: {
                return -2125463548;
            }
        }
        return n;
    }

    private void getChildren(JetFilterExpression jetFilterExpression, JetRptObject jetRptObject, String[] stringArray) {
        Hashtable hashtable = jetFilterExpression.getProperties();
        Hashtable hashtable2 = jetRptObject.getProperties();
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            JetProperty jetProperty;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            int n = stringArray == null ? 0 : stringArray.length;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].compareTo(string) == 0) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl || (jetProperty = (JetProperty)hashtable2.get(string)) == null) continue;
            UpgradeToV8Util.setProperty(jetFilterExpression, jetProperty);
        }
    }

    private JetReferenceExpression getColumn(String string, String string2) {
        JetReferenceExpression jetReferenceExpression = new JetReferenceExpression();
        jetReferenceExpression.setEditable();
        jetReferenceExpression.setName(string);
        jetReferenceExpression.setAttributeName(string2);
        return jetReferenceExpression;
    }

    private JetSortInfo getKey(JetReferenceExpression jetReferenceExpression, int n, boolean bl) {
        JetSortInfo jetSortInfo = new JetSortInfo();
        jetSortInfo.setEditable();
        jetSortInfo.setReference(jetReferenceExpression);
        jetSortInfo.setSortType(n);
        jetSortInfo.setIgnoreCase(bl);
        return jetSortInfo;
    }

    private JetSortExpression getLogic(JetSortInfo[] jetSortInfoArray) {
        if (jetSortInfoArray == null || jetSortInfoArray.length == 0) {
            return null;
        }
        JetSortExpression jetSortExpression = new JetSortExpression();
        jetSortExpression.setEditable();
        int n = 0;
        while (n < jetSortInfoArray.length) {
            jetSortExpression.addSortInfo(jetSortInfoArray[n]);
            ++n;
        }
        return jetSortExpression;
    }

    private JetConstantExpression getOperator(String string, String string2) {
        JetConstantExpression jetConstantExpression = new JetConstantExpression();
        jetConstantExpression.setEditable();
        jetConstantExpression.setName(string);
        jetConstantExpression.setValueString(string2);
        return jetConstantExpression;
    }

    private JetBinaryConditionExpression getOrder(int n, JetReferenceExpression jetReferenceExpression, JetConstantExpression jetConstantExpression) {
        JetBinaryConditionExpression jetBinaryConditionExpression = new JetBinaryConditionExpression();
        jetBinaryConditionExpression.setEditable();
        jetBinaryConditionExpression.setOperator(n);
        jetBinaryConditionExpression.setExpression1(jetReferenceExpression);
        jetBinaryConditionExpression.setExpression2(jetConstantExpression);
        return jetBinaryConditionExpression;
    }

    private JetBinaryLogicExpression getProperties(int n, JetBinaryConditionExpression jetBinaryConditionExpression, JetBinaryConditionExpression jetBinaryConditionExpression2) {
        JetBinaryLogicExpression jetBinaryLogicExpression = new JetBinaryLogicExpression();
        jetBinaryLogicExpression.setEditable();
        jetBinaryLogicExpression.setOperator(n);
        jetBinaryLogicExpression.setExpression1(jetBinaryConditionExpression);
        jetBinaryLogicExpression.setExpression2(jetBinaryConditionExpression2);
        return jetBinaryLogicExpression;
    }

    private JetBinaryLogicExpression getType(int n, JetBinaryLogicExpression jetBinaryLogicExpression, JetBinaryConditionExpression jetBinaryConditionExpression) {
        JetBinaryLogicExpression jetBinaryLogicExpression2 = new JetBinaryLogicExpression();
        jetBinaryLogicExpression2.setEditable();
        jetBinaryLogicExpression2.setOperator(n);
        jetBinaryLogicExpression2.setExpression1(jetBinaryLogicExpression);
        jetBinaryLogicExpression2.setExpression2(jetBinaryConditionExpression);
        return jetBinaryLogicExpression2;
    }
}

