/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.util.StringTokenizer;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.controls.JetObject;

public class DbValueComparer {
    public static final String[] opers = new String[]{"Equal,NotEquals,Less,Great,LessEqual,GreatEqual,IN"};
    public static final int EQUALS = 0;
    public static final int NOTEQUALS = 1;
    public static final int LESS = 2;
    public static final int GREAT = 3;
    public static final int LESSEQUALS = 4;
    public static final int GREATEQUALS = 5;
    public static final int IN = 6;
    public static final String[] strOper = new String[]{"=", "<>", "<", ">", "<=", ">=", "IN"};
    public String columnName;
    public DbValue value;
    public int operator;
    private int QOIV = -1;

    public static int getOperatorForName(String string) {
        if (string.equals("=")) {
            return 0;
        }
        if (string.equals("<>")) {
            return 1;
        }
        if (string.equals("<")) {
            return 3;
        }
        if (string.equals(">")) {
            return 2;
        }
        if (string.equals("<=")) {
            return 5;
        }
        if (string.equals(">=")) {
            return 4;
        }
        if (string.equalsIgnoreCase("IN")) {
            return 6;
        }
        throw new RuntimeException();
    }

    public static int getOperatorForNameLeft(String string) {
        if (string.equals("=")) {
            return 0;
        }
        if (string.equals("<>")) {
            return 1;
        }
        if (string.equals(">")) {
            return 3;
        }
        if (string.equals("<")) {
            return 2;
        }
        if (string.equals(">=")) {
            return 5;
        }
        if (string.equals("<=")) {
            return 4;
        }
        if (string.equalsIgnoreCase("IN")) {
            return 6;
        }
        throw new RuntimeException();
    }

    public boolean compare(Record record) {
        boolean bl = false;
        int n = record.indexOfCell(this.columnName);
        if (n == -1) {
            return false;
        }
        DbValue dbValue = record.getCell(n);
        if (this.operator == 6) {
            String string = this.value.toString();
            if (string.startsWith("(")) {
                string = string.substring(1, string.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = dbValue.toString();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.substring(1, string3.length() - 1).equals(string2)) continue;
                    return true;
                }
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(dbValue.toString(), "|");
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equals(string)) continue;
                return true;
            }
            return false;
        }
        int n2 = dbValue instanceof DbNumber ? ((DbNumber)dbValue).compare((DbNumber)this.value) : dbValue.compareTo(this.value);
        switch (this.operator) {
            case 0: {
                bl = n2 == 0;
                break;
            }
            case 1: {
                bl = n2 != 0;
                break;
            }
            case 2: {
                bl = n2 == -1;
                break;
            }
            case 3: {
                bl = n2 == 1;
                break;
            }
            case 4: {
                bl = n2 == 0 || n2 == -1;
                break;
            }
            case 5: {
                bl = n2 == 0 || n2 == 1;
                break;
            }
            default: {
                throw new Error("Unknow operator " + this.operator);
            }
        }
        return bl;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getOperString() {
        return strOper[this.operator];
    }

    public DbValue getValue() {
        return this.value;
    }

    public String getValueString() {
        String string = this.value.toString();
        if (JetObject.isNeedQuotes(this.value.getSqlType())) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = string.indexOf(39);
            int n2 = 0;
            while (n != -1) {
                stringBuffer.insert(n + n2, '\'');
                ++n2;
                ++n;
                n = string.indexOf(39, n);
            }
            string = new String(stringBuffer);
            n = string.indexOf(34);
            n2 = 0;
            while (n != -1) {
                stringBuffer.insert(n + n2, '\"');
                ++n2;
                ++n;
                n = string.indexOf(34, n);
            }
            string = "'" + string + "'";
        }
        return string;
    }

    public static boolean canCompare(int n, int n2) {
        boolean bl = false;
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                if (n2 != 1 && n2 != 12 && n2 != -1) break;
                bl = true;
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (n2 != -5 && n2 != -6 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7 && n2 != 8) break;
                bl = true;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (n2 != 91 && n2 != 92 && n2 != 93) break;
                bl = true;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                break;
            }
            case -7: {
                if (n2 != -7) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String toString() {
        return "dbvaluecom:" + this.columnName + " " + this.getOperString() + " " + this.getValueString();
    }
}

