/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import jet.util.BitmapReader;
import jet.util.ImageCacher;
import jet.util.ImageCacherImpl;
import jet.util.MessageDigestMaker;
import jet.util.PictureFileFormatDetector;

public class ImageLoader {
    static final String QOIV = ".." + File.separator;
    static final String add = File.separator;
    public static final int LOADIMAGE_RETURN_VALUE_IMAGE = 0;
    public static final int LOADIMAGE_RETURN_VALUE_URL = 1;
    private static int addImage = 0;
    private static Canvas append = new Canvas();
    private static Hashtable backupImageType = new Hashtable();
    private static MessageDigestMaker close = new MessageDigestMaker();
    private static Hashtable closeEntry = new Hashtable();
    private String contains;
    private String createImage;
    private String endsWith;
    protected static ImageCacher cacher = null;

    public static Image loadImage(String string, String string2) {
        String string3 = null;
        Image image = null;
        if (ImageLoader.isFileFormat(string2)) {
            string3 = ImageLoader.getFilePath(string, string2);
            File file = new File(string3);
            image = (Image)ImageLoader.loadImageFromFile(file, false)[0];
        } else {
            image = (Image)ImageLoader.QOIV(string2)[0];
        }
        if (image == null || image.getWidth(append) == -1 || image.getHeight(append) == -1) {
            JRLog.error(2, 2200013, new Object[]{string, string2}, null);
            image = null;
        }
        return image;
    }

    public static String getFilePath(String string, String string2) {
        if (!ImageLoader.isFileFormat(string2)) {
            return string2;
        }
        File file = new File(string);
        String string3 = "";
        String string4 = "";
        if (string2.indexOf(":") != -1) {
            return string2;
        }
        if (string2.indexOf("../") == 0 || string2.indexOf(QOIV) == 0) {
            string3 = string2.substring("../".length(), string2.length());
            string3 = file.getParent() + File.separator + string3;
        } else if (string2.indexOf("/") == 0 || string2.indexOf(add) == 0) {
            string3 = string2.substring("/".length(), string2.length());
            string3 = ImageLoader.getRootPath(string) + string3;
        } else {
            string3 = string2;
            string3 = string + File.separator + string3;
        }
        string4 = string3;
        File file2 = new File(string4);
        return file2.getAbsolutePath();
    }

    public static boolean isFileFormat(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        boolean bl = new File(string).isFile();
        if (string.indexOf(":") == -1) {
            bl = true;
        } else if (string.indexOf(":") == 1) {
            bl = true;
        } else if (string.indexOf("root") == 0) {
            bl = true;
        } else if (string.indexOf("ROOT") == 0) {
            bl = true;
        }
        return bl;
    }

    public static String getRootPath(String string) {
        File file = new File(string);
        while (file.exists() && file.getParentFile() != null && file.getParentFile().exists()) {
            file = file.getParentFile();
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static Image loadImage(byte[] byArray) {
        try {
            Object[] objectArray = ImageLoader.cacher(byArray);
            if (objectArray[0] == null || ((Image)objectArray[0]).getWidth(append) == -1 || ((Image)objectArray[0]).getHeight(append) == -1) {
                objectArray[0] = null;
                objectArray[1] = new Integer(-100);
            } else {
                ImageLoader.backupImageType((Image)objectArray[0], (Integer)objectArray[1]);
            }
            return (Image)objectArray[0];
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] QOIV(String string) {
        String string2 = string;
        URL uRL = null;
        Image image = null;
        int n = -100;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null) {
            n = ImageLoader.getImageType(string2, uRL);
            switch (n) {
                case 1: {
                    image = ImageLoader.addImage(uRL);
                    break;
                }
                case 0: 
                case 3: {
                    try {
                        image = ImageIO.read(uRL);
                    }
                    catch (IOException iOException) {}
                    break;
                }
                default: {
                    MediaTracker mediaTracker = new MediaTracker(append);
                    image = Toolkit.getDefaultToolkit().createImage(uRL);
                    int n2 = 0;
                    Canvas canvas = append;
                    synchronized (canvas) {
                        n2 = addImage;
                        addImage = addImage == Integer.MAX_VALUE ? 0 : ++addImage;
                    }
                    mediaTracker.addImage(image, n2);
                    try {
                        try {
                            mediaTracker.waitForID(n2);
                        }
                        catch (InterruptedException interruptedException) {
                            Object var10_13 = null;
                            mediaTracker.removeImage(image, n2);
                            mediaTracker = null;
                            break;
                        }
                        Object var10_12 = null;
                        mediaTracker.removeImage(image, n2);
                        mediaTracker = null;
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        mediaTracker.removeImage(image, n2);
                        mediaTracker = null;
                        throw throwable;
                    }
                }
            }
        }
        return new Object[]{image, new Integer(n)};
    }

    private static Image add(File file) {
        Image image = null;
        FilterInputStream filterInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            filterInputStream = new DataInputStream(fileInputStream);
            image = ImageLoader.append((DataInputStream)filterInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        fileInputStream = null;
        filterInputStream = null;
        return image;
    }

    private static Image addImage(URL uRL) {
        Image image = null;
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(uRL.openStream());
            image = ImageLoader.append(dataInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataInputStream != null) {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        dataInputStream = null;
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image append(DataInputStream dataInputStream) {
        BitmapReader bitmapReader = null;
        Image image = null;
        bitmapReader = BitmapReader.loadFromBMP(dataInputStream);
        if (bitmapReader != null) {
            image = Toolkit.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc());
            MediaTracker mediaTracker = new MediaTracker(append);
            int n = 0;
            Canvas canvas = append;
            synchronized (canvas) {
                n = addImage;
                addImage = addImage == Integer.MAX_VALUE ? 0 : ++addImage;
            }
            mediaTracker.addImage(image, n);
            try {
                try {
                    mediaTracker.waitForID(n);
                }
                catch (InterruptedException interruptedException) {
                    Object var8_9 = null;
                    mediaTracker.removeImage(image, n);
                    mediaTracker = null;
                }
                Object var8_8 = null;
                mediaTracker.removeImage(image, n);
                mediaTracker = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                mediaTracker.removeImage(image, n);
                mediaTracker = null;
                throw throwable;
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image backupImageType(File file, boolean bl) {
        Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
        int n = 0;
        Canvas canvas = append;
        synchronized (canvas) {
            n = addImage;
            addImage = addImage == Integer.MAX_VALUE ? 0 : ++addImage;
        }
        MediaTracker mediaTracker = new MediaTracker(append);
        mediaTracker.addImage(image, n);
        try {
            try {
                mediaTracker.waitForID(n);
                if (bl) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                    }
                }
                Object var8_9 = null;
                mediaTracker.removeImage(image, n);
                mediaTracker = null;
            }
            catch (InterruptedException interruptedException) {
                Object var8_10 = null;
                mediaTracker.removeImage(image, n);
                mediaTracker = null;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            mediaTracker.removeImage(image, n);
            mediaTracker = null;
            throw throwable;
        }
        return image;
    }

    protected static Object[] loadImageFromFile(File file, boolean bl) {
        Image image = null;
        int n = -100;
        if (file.isFile()) {
            n = ImageLoader.getImageType(file);
            switch (n) {
                case 1: {
                    image = ImageLoader.add(file);
                    break;
                }
                case 0: 
                case 3: {
                    try {
                        image = ImageIO.read(file);
                    }
                    catch (IOException iOException) {}
                    break;
                }
                default: {
                    image = ImageLoader.backupImageType(file, bl);
                }
            }
        }
        return new Object[]{image, new Integer(n)};
    }

    public static int getImageType(File file) {
        int n;
        block12: {
            String string = file.getName().toLowerCase();
            n = -100;
            if (string.endsWith(".jpg")) {
                n = 0;
            } else if (string.endsWith(".bmp")) {
                n = 1;
            } else if (string.endsWith(".gif")) {
                n = 4;
            } else if (string.endsWith(".png")) {
                n = 3;
            }
            InputStream inputStream = null;
            try {
                byte[] byArray = new byte[10];
                inputStream = new FileInputStream(file);
                inputStream.read(byArray);
                inputStream.close();
                int n2 = PictureFileFormatDetector.getPictureFileType(byArray);
                if (n2 != 2 && n2 != -100) {
                    n = n2;
                }
            }
            catch (Exception exception) {
                if (inputStream == null) break block12;
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    protected static int getImageType(String string, URL uRL) {
        String string2 = string.toLowerCase();
        int n = -100;
        if (string2.endsWith(".jpg")) {
            n = 0;
        } else if (string2.endsWith(".bmp")) {
            n = 1;
        } else if (string2.endsWith(".gif")) {
            n = 4;
        } else if (string2.endsWith(".png")) {
            n = 3;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            byte[] byArray = new byte[10];
            inputStream.read(byArray);
            inputStream.close();
            int n2 = PictureFileFormatDetector.getPictureFileType(byArray);
            if (n2 != 2 && n2 != -100) {
                n = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] cacher(byte[] byArray) throws IOException {
        int n = PictureFileFormatDetector.getPictureFileType(byArray);
        Image image = null;
        switch (n) {
            case 1: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                image = ImageLoader.append(dataInputStream);
                byteArrayInputStream.close();
                break;
            }
            case 0: 
            case 3: {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    image = ImageIO.read(byteArrayInputStream);
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
                break;
            }
            default: {
                MediaTracker mediaTracker = new MediaTracker(append);
                image = Toolkit.getDefaultToolkit().createImage(byArray);
                int n2 = 0;
                Canvas canvas = append;
                synchronized (canvas) {
                    n2 = addImage;
                    addImage = addImage == Integer.MAX_VALUE ? 0 : ++addImage;
                }
                mediaTracker.addImage(image, n2);
                try {
                    try {
                        mediaTracker.waitForID(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        Object var8_13 = null;
                        mediaTracker.removeImage(image, n2);
                        mediaTracker = null;
                        break;
                    }
                    Object var8_12 = null;
                    mediaTracker.removeImage(image, n2);
                    mediaTracker = null;
                    break;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    mediaTracker.removeImage(image, n2);
                    mediaTracker = null;
                    throw throwable;
                }
            }
        }
        return new Object[]{image, new Integer(n)};
    }

    public static void saveChgByMapping(OutputStream outputStream, String string, List vector) throws IOException {
        Object object;
        Object object2;
        JRLog.trace(5, "Save changeByImageMapping by catalog : " + string + ", fileList:" + vector);
        if (string == null) {
            string = "";
        }
        if (vector == null) {
            vector = new Vector();
        }
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            object2 = (String)vector.get(n);
            if (ImageLoader.isFileFormat((String)object2) && new File((String)(object = ImageLoader.getFilePath(string, (String)object2))).exists() && new File((String)object).isFile()) {
                int n2 = vector2.indexOf(object);
                if (n2 >= 0) {
                    hashtable.put(object2, new Integer(n2));
                } else {
                    hashtable.put(object2, new Integer(vector2.size()));
                    vector2.add(object);
                }
            }
            ++n;
        }
        object2 = new ByteArrayOutputStream();
        object = new ObjectOutputStream((OutputStream)object2);
        ((ObjectOutputStream)object).writeInt(vector2.size());
        ((ObjectOutputStream)object).writeObject(hashtable);
        ((ObjectOutputStream)object).flush();
        ((ObjectOutputStream)object).close();
        byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        zipOutputStream.putNextEntry(new ZipEntry("IMGCHGBY_HEADER"));
        zipOutputStream.write(byArray);
        zipOutputStream.flush();
        zipOutputStream.closeEntry();
        int n3 = 0;
        while (n3 < vector2.size()) {
            String string2 = (String)vector2.get(n3);
            zipOutputStream.putNextEntry(new ZipEntry("IMAGEDATA" + n3));
            try {
                ImageLoader.close(zipOutputStream, new File(string2));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
            ++n3;
        }
        zipOutputStream.finish();
    }

    private static void close(ZipOutputStream zipOutputStream, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) > 0) {
            zipOutputStream.write(byArray, 0, n);
            zipOutputStream.flush();
        }
    }

    private static byte[] closeEntry(ZipInputStream zipInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = zipInputStream.read(byArray, 0, 1024)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static synchronized void loadChgByMapping(InputStream inputStream, String string) throws IOException {
        Object[] objectArray;
        Hashtable hashtable;
        if (inputStream == null || string == null) {
            throw new IllegalArgumentException("Error parameter inputted");
        }
        JRLog.trace(5, "Load changeByImageMapping of " + string);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry.getName().equals("FILEHEADER")) {
            throw new UnsupportedOperationException("Can not open inner-test rsd/rst structure.");
        }
        if (!zipEntry.getName().equals("IMGCHGBY_HEADER")) {
            throw new UnsupportedOperationException("Read ImageCaher error.");
        }
        byte[] byArray = ImageLoader.closeEntry(zipInputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        int n = objectInputStream.readInt();
        try {
            hashtable = (Hashtable)objectInputStream.readObject();
        }
        catch (Exception exception) {
            hashtable = new Hashtable();
        }
        objectInputStream.close();
        byteArrayInputStream.close();
        if (n == 0) {
            return;
        }
        Vector<Object[]> vector = new Vector<Object[]>(n);
        int n2 = 0;
        while (n2 < n) {
            zipEntry = zipInputStream.getNextEntry();
            try {
                byArray = ImageLoader.closeEntry(zipInputStream);
                objectArray = ImageLoader.cacher(byArray);
                vector.add(objectArray);
            }
            catch (IOException iOException) {
                vector.add(new Object[]{null, new Integer(-100)});
            }
            ++n2;
        }
        objectArray = (Object[])backupImageType.get(string);
        if (objectArray == null) {
            objectArray = new Object[]{new Vector(), new Integer(1)};
            backupImageType.put(string, objectArray);
        } else {
            objectArray[1] = new Integer((Integer)objectArray[1] + 1);
        }
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            Vector<Object> vector2;
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            Object[] objectArray2 = (Object[])vector.get((Integer)entry.getValue());
            if (objectArray2[0] == null || ((Image)objectArray2[0]).getWidth(null) == -1 || ((Image)objectArray2[0]).getHeight(null) == -1) continue;
            if (!((Vector)objectArray[0]).contains(string2)) {
                ((Vector)objectArray[0]).add(string2);
            }
            if ((vector2 = (Vector<Object>)backupImageType.get(string2)) == null) {
                vector2 = new Vector<Object>();
                vector2.add(objectArray2[0]);
                vector2.add(objectArray2[1]);
                vector2.add(new Integer(1));
            } else {
                int n3 = (Integer)vector2.get(2);
                vector2 = new Vector();
                vector2.add(objectArray2[0]);
                vector2.add(objectArray2[1]);
                vector2.add(new Integer(n3 + 1));
            }
            backupImageType.put(string2, vector2);
        }
    }

    public static synchronized void releaseChgByMapping(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Error parameter inputted");
        }
        JRLog.trace(5, "release changeByImageMapping of " + string);
        Object[] objectArray = (Object[])backupImageType.get(string);
        if (objectArray == null) {
            return;
        }
        int n = (Integer)objectArray[1];
        if (n == 1) {
            Vector vector = (Vector)objectArray[0];
            backupImageType.remove(string);
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector vector2 = (Vector)backupImageType.get(vector.get(n2));
                int n3 = (Integer)vector2.get(2);
                if (n3 == 1) {
                    backupImageType.remove(vector.get(n2));
                } else {
                    vector2.remove(2);
                    vector2.add(2, new Integer(n3 - 1));
                }
                ++n2;
            }
        } else {
            objectArray[1] = new Integer(n - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getImageType(Image image) {
        int n;
        if (image == null) {
            return -100;
        }
        if (cacher != null && cacher.isEnable() && (n = cacher.getCachedImageType(image)) != -100) {
            return n;
        }
        Integer n2 = close.generate(image);
        Hashtable hashtable = closeEntry;
        synchronized (hashtable) {
            Object[] objectArray;
            block8: {
                objectArray = (Object[])closeEntry.get(n2);
                if (objectArray != null) break block8;
                int n3 = -100;
                return n3;
            }
            Integer n4 = (Integer)objectArray[1];
            Integer n5 = (Integer)objectArray[0];
            if (n4 == 0) {
                closeEntry.remove(n2);
            } else {
                closeEntry.put(n2, new Object[]{n5, new Integer(n4 - 1)});
            }
            int n6 = n5;
            return n6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupImageType(Image image, Integer n) {
        Integer n2 = close.generate(image);
        Hashtable hashtable = closeEntry;
        synchronized (hashtable) {
            Object[] objectArray = (Object[])closeEntry.get(n2);
            if (objectArray == null) {
                objectArray = new Object[]{n, new Integer(0)};
            } else {
                int n3 = (Integer)objectArray[1];
                objectArray = new Object[]{n, new Integer(n3 + 1)};
            }
            closeEntry.put(n2, objectArray);
        }
    }

    public static void setImageCacher(ImageCacher imageCacher) {
        if (cacher != null) {
            cacher.removeAllImages();
        }
        cacher = imageCacher;
    }

    public ImageLoader(String string, String string2) {
        this.createImage = string2;
        File file = new File(string);
        if (file.exists()) {
            if (file.isFile()) {
                this.endsWith = string;
                this.contains = file.getParent();
            } else {
                this.contains = string;
            }
        } else {
            this.contains = file.isDirectory() ? string : file.getParent();
            if (this.contains == null) {
                this.contains = "";
            }
        }
    }

    public Image loadNoCache() {
        Object[] objectArray = this.contains(false);
        if (objectArray == null) {
            return (Image)this.createImage(false)[0];
        }
        return (Image)objectArray[0];
    }

    public Image loadImage() {
        Object[] objectArray = this.contains(false);
        if (objectArray == null) {
            objectArray = this.endsWith(false);
        }
        if (objectArray == null) {
            return null;
        }
        return (Image)objectArray[0];
    }

    private Object[] contains(boolean bl) {
        if (backupImageType.size() == 0) {
            return null;
        }
        if (ImageLoader.isFileFormat(this.createImage)) {
            Vector vector = (Vector)backupImageType.get(this.createImage);
            Object[] objectArray = new Object[]{vector.get(0), vector.get(1)};
            if (objectArray[0] == null || ((Image)objectArray[0]).getWidth(append) == -1 || ((Image)objectArray[0]).getHeight(append) == -1) {
                if (!bl) {
                    JRLog.error(2, 2200013, new Object[]{this.contains, this.createImage}, null);
                }
                objectArray[0] = null;
                objectArray[1] = new Integer(-100);
            } else {
                ImageLoader.backupImageType((Image)objectArray[0], (Integer)objectArray[1]);
            }
            return objectArray;
        }
        return null;
    }

    private Object[] createImage(boolean bl) {
        String string = null;
        Object[] objectArray = null;
        if (ImageLoader.isFileFormat(this.createImage)) {
            string = ImageLoader.getFilePath(this.contains, this.createImage);
            File file = new File(string);
            objectArray = ImageLoader.loadImageFromFile(file, false);
        } else {
            objectArray = ImageLoader.QOIV(this.createImage);
        }
        if (objectArray[0] == null || ((Image)objectArray[0]).getWidth(append) == -1 || ((Image)objectArray[0]).getHeight(append) == -1) {
            if (!bl) {
                JRLog.error(2, 2200013, new Object[]{this.contains, this.createImage}, null);
            }
            objectArray[0] = null;
            objectArray[1] = new Integer(-100);
        } else {
            ImageLoader.backupImageType((Image)objectArray[0], (Integer)objectArray[1]);
        }
        return objectArray;
    }

    private Object[] endsWith(boolean bl) {
        if (cacher == null || !cacher.isEnable()) {
            return this.createImage(bl);
        }
        Object[] objectArray = null;
        if (ImageLoader.isFileFormat(this.createImage)) {
            String string = ImageLoader.getFilePath(this.contains, this.createImage);
            File file = new File(string);
            objectArray = this.endsWith != null ? cacher.loadAnImage(this.endsWith, file) : cacher.loadAnImage(this.contains, file);
            if (objectArray[0] == null || ((Image)objectArray[0]).getWidth(append) == -1 || ((Image)objectArray[0]).getHeight(append) == -1) {
                if (!bl) {
                    JRLog.error(2, 2200013, new Object[]{this.contains, this.createImage}, null);
                }
                objectArray[0] = null;
                objectArray[1] = new Integer(-100);
            }
        } else {
            objectArray = ImageLoader.QOIV(this.createImage);
            if (objectArray[0] == null || ((Image)objectArray[0]).getWidth(append) == -1 || ((Image)objectArray[0]).getHeight(append) == -1) {
                if (!bl) {
                    JRLog.error(2, 2200013, new Object[]{this.contains, this.createImage}, null);
                }
                objectArray[0] = null;
                objectArray[1] = new Integer(-100);
            } else {
                ImageLoader.backupImageType((Image)objectArray[0], (Integer)objectArray[1]);
            }
        }
        return objectArray;
    }

    public Object[] loadImageDesc() {
        Object[] objectArray = this.contains(false);
        if (objectArray != null) {
            return objectArray;
        }
        return this.endsWith(false);
    }

    static {
        cacher = new ImageCacherImpl();
        cacher.setEnableStatus(true);
        cacher.setCacheSize(0x300000L);
    }
}

