/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.query.parser;

import toolkit.db.query.parser.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < this.expectedTokenSequences.length) {
            if (n < this.expectedTokenSequences[n2].length) {
                n = this.expectedTokenSequences[n2].length;
            }
            int n3 = 0;
            while (n3 < this.expectedTokenSequences[n2].length) {
                stringBuffer.append(this.tokenImage[this.expectedTokenSequences[n2][n3]]).append(' ');
                ++n3;
            }
            if (this.expectedTokenSequences[n2][this.expectedTokenSequences[n2].length - 1] != 0) {
                stringBuffer.append("...");
            }
            stringBuffer.append(this.eol).append("    ");
            ++n2;
        }
        String string = "Encountered \"";
        Token token = this.currentToken.next;
        int n4 = 0;
        while (n4 < n) {
            if (n4 != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + this.tokenImage[0];
                break;
            }
            string = string + " " + this.tokenImage[token.kind];
            string = string + " \"";
            string = string + this.add_escapes(token.image);
            string = string + " \"";
            token = token.next;
            ++n4;
        }
        string = string + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        string = string + "." + this.eol;
        string = this.expectedTokenSequences.length == 1 ? string + "Was expecting:" + this.eol + "    " : string + "Was expecting one of:" + this.eol + "    ";
        string = string + stringBuffer.toString();
        return string;
    }

    protected String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    char c = string.charAt(n);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

