/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

public class ChartMatrix {
    float QOIV = 1.0f;
    float abs;
    float asin;
    float atan;
    float cos;
    float pow = 1.0f;
    float rotaionXYZ;
    float round;
    float sin;
    float sqrt;
    float transform3 = 1.0f;
    float I;
    float Z;
    float C;
    float B;
    float D = 1.0f;

    public void setVisualEffect(float f, float f2, float f3) {
        this.Z = f;
        this.C = f2;
        this.B = f3;
    }

    public void shift(float f, float f2, float f3) {
        this.atan += f;
        this.round += f2;
        this.I += f3;
    }

    public void scale(float f, float f2, float f3) {
        this.QOIV *= f;
        this.abs *= f;
        this.asin *= f;
        this.atan *= f;
        this.cos *= f2;
        this.pow *= f2;
        this.rotaionXYZ *= f2;
        this.round *= f2;
        this.sin *= f3;
        this.sqrt *= f3;
        this.transform3 *= f3;
        this.I *= f3;
    }

    public void yrot(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.QOIV * f + this.sin * f2;
        float f4 = this.abs * f + this.sqrt * f2;
        float f5 = this.asin * f + this.transform3 * f2;
        float f6 = this.atan * f + this.I * f2;
        float f7 = this.sin * f - this.QOIV * f2;
        float f8 = this.sqrt * f - this.abs * f2;
        float f9 = this.transform3 * f - this.asin * f2;
        float f10 = this.I * f - this.atan * f2;
        this.atan = f6;
        this.QOIV = f3;
        this.abs = f4;
        this.asin = f5;
        this.I = f10;
        this.sin = f7;
        this.sqrt = f8;
        this.transform3 = f9;
    }

    public void _xrot(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.cos * f - this.sin * f2;
        float f4 = this.pow * f - this.sqrt * f2;
        float f5 = this.rotaionXYZ * f - this.transform3 * f2;
        float f6 = this.round * f - this.I * f2;
        float f7 = this.sin * f + this.cos * f2;
        float f8 = this.sqrt * f + this.pow * f2;
        float f9 = this.transform3 * f + this.rotaionXYZ * f2;
        float f10 = this.I * f + this.round * f2;
        this.round = f6;
        this.cos = f3;
        this.pow = f4;
        this.rotaionXYZ = f5;
        this.I = f10;
        this.sin = f7;
        this.sqrt = f8;
        this.transform3 = f9;
    }

    public void xrot(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.cos * f + this.sin * f2;
        float f4 = this.pow * f + this.sqrt * f2;
        float f5 = this.rotaionXYZ * f + this.transform3 * f2;
        float f6 = this.round * f + this.I * f2;
        float f7 = this.sin * f - this.cos * f2;
        float f8 = this.sqrt * f - this.pow * f2;
        float f9 = this.transform3 * f - this.rotaionXYZ * f2;
        float f10 = this.I * f - this.round * f2;
        this.round = f6;
        this.cos = f3;
        this.pow = f4;
        this.rotaionXYZ = f5;
        this.I = f10;
        this.sin = f7;
        this.sqrt = f8;
        this.transform3 = f9;
    }

    public void zrot(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.cos * f + this.QOIV * f2;
        float f4 = this.pow * f + this.abs * f2;
        float f5 = this.rotaionXYZ * f + this.asin * f2;
        float f6 = this.round * f + this.atan * f2;
        float f7 = this.QOIV * f - this.cos * f2;
        float f8 = this.abs * f - this.pow * f2;
        float f9 = this.asin * f - this.rotaionXYZ * f2;
        float f10 = this.atan * f - this.round * f2;
        this.round = f6;
        this.cos = f3;
        this.pow = f4;
        this.rotaionXYZ = f5;
        this.atan = f10;
        this.QOIV = f7;
        this.abs = f8;
        this.asin = f9;
    }

    public void mul(ChartMatrix chartMatrix) {
        float f = this.QOIV * chartMatrix.QOIV + this.cos * chartMatrix.abs + this.sin * chartMatrix.asin;
        float f2 = this.abs * chartMatrix.QOIV + this.pow * chartMatrix.abs + this.sqrt * chartMatrix.asin;
        float f3 = this.asin * chartMatrix.QOIV + this.rotaionXYZ * chartMatrix.abs + this.transform3 * chartMatrix.asin;
        float f4 = this.atan * chartMatrix.QOIV + this.round * chartMatrix.abs + this.I * chartMatrix.asin + chartMatrix.atan;
        float f5 = this.QOIV * chartMatrix.cos + this.cos * chartMatrix.pow + this.sin * chartMatrix.rotaionXYZ;
        float f6 = this.abs * chartMatrix.cos + this.pow * chartMatrix.pow + this.sqrt * chartMatrix.rotaionXYZ;
        float f7 = this.asin * chartMatrix.cos + this.rotaionXYZ * chartMatrix.pow + this.transform3 * chartMatrix.rotaionXYZ;
        float f8 = this.atan * chartMatrix.cos + this.round * chartMatrix.pow + this.I * chartMatrix.rotaionXYZ + chartMatrix.round;
        float f9 = this.QOIV * chartMatrix.sin + this.cos * chartMatrix.sqrt + this.sin * chartMatrix.transform3;
        float f10 = this.abs * chartMatrix.sin + this.pow * chartMatrix.sqrt + this.sqrt * chartMatrix.transform3;
        float f11 = this.asin * chartMatrix.sin + this.rotaionXYZ * chartMatrix.sqrt + this.transform3 * chartMatrix.transform3;
        float f12 = this.atan * chartMatrix.sin + this.round * chartMatrix.sqrt + this.I * chartMatrix.transform3 + chartMatrix.I;
        this.QOIV = f;
        this.abs = f2;
        this.asin = f3;
        this.atan = f4;
        this.cos = f5;
        this.pow = f6;
        this.rotaionXYZ = f7;
        this.round = f8;
        this.sin = f9;
        this.sqrt = f10;
        this.transform3 = f11;
        this.I = f12;
    }

    public void benchmarkmirror() {
        this.QOIV = 0.0f;
        this.abs = 1.0f;
        this.asin = 0.0f;
        this.atan = 0.0f;
        this.cos = -1.0f;
        this.pow = 0.0f;
        this.rotaionXYZ = 0.0f;
        this.round = 0.0f;
        this.sin = 0.0f;
        this.sqrt = 0.0f;
        this.transform3 = -1.0f;
        this.I = 0.0f;
    }

    public void mirror() {
        this.atan = 0.0f;
        this.QOIV = 1.0f;
        this.abs = 0.0f;
        this.asin = 0.0f;
        this.round = 0.0f;
        this.cos = 0.0f;
        this.pow = -1.0f;
        this.rotaionXYZ = 0.0f;
        this.I = 0.0f;
        this.sin = 0.0f;
        this.sqrt = 0.0f;
        this.transform3 = -1.0f;
    }

    public void unit() {
        this.atan = 0.0f;
        this.QOIV = 1.0f;
        this.abs = 0.0f;
        this.asin = 0.0f;
        this.round = 0.0f;
        this.cos = 0.0f;
        this.pow = 1.0f;
        this.rotaionXYZ = 0.0f;
        this.I = 0.0f;
        this.sin = 0.0f;
        this.sqrt = 0.0f;
        this.transform3 = 1.0f;
    }

    public void transform(float[][] fArray, float[][] fArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2][0] * this.QOIV + fArray[n2][1] * this.abs + fArray[n2][2] * this.asin + this.atan;
            float f2 = fArray[n2][0] * this.cos + fArray[n2][1] * this.pow + fArray[n2][2] * this.rotaionXYZ + this.round;
            float f3 = fArray[n2][0] * this.sin + fArray[n2][1] * this.sqrt + fArray[n2][2] * this.transform3 + this.I;
            fArray2[n2][0] = f;
            fArray2[n2][1] = f2;
            fArray2[n2][0] = Math.round(f - (this.Z - f) * f3 / (this.B - f3));
            fArray2[n2][1] = Math.round(f2 - (this.C - f2) * f3 / (this.B - f3));
            ++n2;
        }
    }

    public void transformNonePerspective(float[][] fArray, float[][] fArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2][0] * this.QOIV + fArray[n2][1] * this.abs + fArray[n2][2] * this.asin + this.atan;
            float f2 = fArray[n2][0] * this.cos + fArray[n2][1] * this.pow + fArray[n2][2] * this.rotaionXYZ + this.round;
            fArray2[n2][0] = f;
            fArray2[n2][1] = f2;
            ++n2;
        }
    }

    public void transform2(float[][] fArray, float[][] fArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2][0] * this.QOIV + fArray[n2][1] * this.abs + fArray[n2][2] * this.asin + this.atan;
            float f2 = fArray[n2][0] * this.cos + fArray[n2][1] * this.pow + fArray[n2][2] * this.rotaionXYZ + this.round;
            float f3 = fArray[n2][0] * this.sin + fArray[n2][1] * this.sqrt + fArray[n2][2] * this.transform3 + this.I;
            fArray2[n2][0] = f;
            fArray2[n2][1] = f2;
            fArray2[n2][2] = f3;
            fArray2[n2][2] = Math.round(f3);
            ++n2;
        }
    }

    public void reset(float[] fArray) {
        this.QOIV = fArray[0];
        this.abs = fArray[1];
        this.asin = fArray[2];
        this.atan = fArray[3];
        this.cos = fArray[4];
        this.pow = fArray[5];
        this.rotaionXYZ = fArray[6];
        this.round = fArray[7];
        this.sin = fArray[8];
        this.sqrt = fArray[9];
        this.transform3 = fArray[10];
        this.I = fArray[11];
    }

    public float[] getMatrix() {
        float[] fArray = new float[]{this.QOIV, this.abs, this.asin, this.atan, this.cos, this.pow, this.rotaionXYZ, this.round, this.sin, this.sqrt, this.transform3, this.I};
        return fArray;
    }

    public static float[] transform3(float[] fArray, ChartMatrix chartMatrix) {
        float f = chartMatrix.QOIV;
        float f2 = chartMatrix.abs;
        float f3 = chartMatrix.asin;
        float f4 = chartMatrix.atan;
        float f5 = chartMatrix.cos;
        float f6 = chartMatrix.pow;
        float f7 = chartMatrix.rotaionXYZ;
        float f8 = chartMatrix.round;
        float f9 = chartMatrix.sin;
        float f10 = chartMatrix.sqrt;
        float f11 = chartMatrix.transform3;
        float f12 = chartMatrix.I;
        float[] fArray2 = new float[3];
        float f13 = fArray[0];
        float f14 = fArray[1];
        float f15 = fArray[2];
        fArray2[0] = f13 * f + f14 * f2 + f15 * f3 + f4;
        fArray2[1] = f13 * f5 + f14 * f6 + f15 * f7 + f8;
        fArray2[2] = f13 * f9 + f14 * f10 + f15 * f11 + f12;
        return fArray2;
    }

    public static float[] rotaionXYZ(double d, double d2, double d3, float[] fArray) {
        float[] fArray2 = new float[3];
        double[] dArray = new double[]{-1.0 * (d *= Math.PI / 180), d2 *= Math.PI / 180, d3 *= Math.PI / 180};
        double d4 = Math.sin(dArray[0]) * Math.sin(dArray[1]) * Math.cos(dArray[2]) - Math.cos(dArray[0]) * Math.sin(dArray[2]);
        double d5 = Math.sin(dArray[0]) * Math.sin(dArray[1]) * Math.sin(dArray[2]) + Math.cos(dArray[0]) * Math.cos(dArray[2]);
        double d6 = Math.cos(dArray[0]) * Math.sin(dArray[1]) * Math.cos(dArray[2]) + Math.sin(dArray[0]) * Math.sin(dArray[2]);
        double d7 = Math.cos(dArray[0]) * Math.sin(dArray[1]) * Math.sin(dArray[2]) - Math.sin(dArray[0]) * Math.cos(dArray[2]);
        double d8 = Math.cos(dArray[1]) * Math.cos(dArray[2]);
        double d9 = Math.cos(dArray[1]) * Math.sin(dArray[2]);
        double d10 = Math.sin(dArray[0]) * Math.cos(dArray[1]);
        double d11 = Math.cos(dArray[0]) * Math.cos(dArray[1]);
        double d12 = -Math.sin(dArray[1]);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = (float)((double)f * d8 + (double)f2 * d4 + (double)f3 * d6);
        fArray2[1] = (float)((double)f * d9 + (double)f2 * d5 + (double)f3 * d7);
        fArray2[2] = (float)((double)f * d12 + (double)f2 * d10 + (double)f3 * d11);
        return fArray2;
    }

    public static double[] getAngle(ChartMatrix chartMatrix) {
        double[] dArray = new double[]{chartMatrix.transform3 != 0.0f ? -Math.atan(chartMatrix.sqrt / chartMatrix.transform3) : -1.5707963267948966, Math.asin(-chartMatrix.sin), chartMatrix.QOIV != 0.0f ? Math.atan(chartMatrix.cos / chartMatrix.QOIV) : 1.5707963267948966};
        float[][] fArrayArray = new float[][]{{1.0f / (float)Math.sqrt(3.0), 1.0f / (float)Math.sqrt(3.0), 1.0f / (float)Math.sqrt(3.0)}, {1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, -1.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}};
        float[][] fArray = new float[fArrayArray.length][3];
        float[][] fArray2 = new float[3][3];
        fArray[0] = ChartMatrix.transform3(fArrayArray[0], chartMatrix);
        double d = dArray[0] * 180.0 / Math.PI;
        double d2 = dArray[1] * 180.0 / Math.PI;
        double d3 = dArray[2] * 180.0 / Math.PI;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                int n3 = 0;
                while (n3 < 3) {
                    int n4 = 0;
                    while (n4 < 2) {
                        int n5 = 0;
                        while (n5 < 2) {
                            int n6 = 0;
                            while (n6 < 2) {
                                fArray3 = ChartMatrix.rotaionXYZ((double)(180 * n) + Math.pow(-1.0, n4) * d, (double)(180 * n2) + Math.pow(-1.0, n5) * d2, (double)(180 * n3) + Math.pow(-1.0, n6) * d3, fArrayArray[0]);
                                if ((double)Math.abs(fArray3[0] - fArray[0][0]) < 0.001 && (double)Math.abs(fArray3[1] - fArray[0][1]) < 0.001 && (double)Math.abs(fArray3[1] - fArray[0][1]) < 0.001 && (double)(180 * n) + Math.pow(-1.0, n4) * d >= 0.0 && (double)(180 * n2) + Math.pow(-1.0, n5) * d >= 0.0 && (double)(180 * n3) + Math.pow(-1.0, n6) * d >= 0.0) {
                                    dArray[0] = 360.0 - ((double)(180 * n) + Math.pow(-1.0, n4) * d) % 360.0;
                                    dArray[1] = ((double)(180 * n2) + Math.pow(-1.0, n5) * d2) % 360.0;
                                    dArray[2] = ((double)(180 * n3) + Math.pow(-1.0, n6) * d3) % 360.0;
                                }
                                ++n6;
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return dArray;
    }
}

