/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;

public class ChartPenStyle
implements Cloneable {
    private static final float[][] QOIV = new float[][]{null, {2.1f, 2.1f}, {6.0f, 6.0f}, {12.0f, 12.0f}, {6.0f, 2.0f}, {4.0f, 4.0f, 4.0f, 4.0f, 12.0f, 4.0f, 12.0f, 4.0f, 12.0f, 4.0f}, {3.0f, 12.0f}, {24.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f}, {2.0f, 2.0f, 2.0f, 2.0f, 12.0f, 2.0f}, null};
    private static final String[] clone = new String[]{"Solid Line", "Dotted", "Dashed", "Long Dashed", "Dash-Dotted", "2Dots,3Dashes", "Fine Dotted", "Line dots", "2Dots,2Dashes", "Invisible"};
    private static final String[] createStroke = new String[]{"BUTT", "ROUND", "SQUARE"};
    private static final String[] createStrokedShape = new String[]{"MITER", "ROUND", "BEVEL"};
    private float draw;
    private int equals;
    private int getBuiltinDashPattern;
    private int getColor;
    private boolean getStroke;
    private boolean isNoColor;
    private ChartColorPattern setColor;
    private BasicStroke setStroke;

    public ChartPenStyle(String string) {
        this(ChartPenStyle.getBuiltinDashPattern(string));
    }

    public ChartPenStyle(int n) {
        this(1.0f, 2, 0, n, false, false, new ChartColorPattern());
    }

    public ChartPenStyle() {
        this(1.0f, 2, 0, 0, false, false, new ChartColorPattern());
    }

    public ChartPenStyle(int n, ChartColorPattern chartColorPattern) {
        this(1.0f, 2, 0, n, false, false, chartColorPattern);
    }

    public ChartPenStyle(ChartColorPattern chartColorPattern) {
        this(1.0f, 2, 0, 0, false, false, chartColorPattern);
    }

    public ChartPenStyle(float f) {
        this(f, 2, 0, 0, false, false, new ChartColorPattern());
    }

    public ChartPenStyle(float f, int n, int n2, int n3, boolean bl, boolean bl2, ChartColorPattern chartColorPattern) {
        this.draw = f;
        this.equals = n;
        this.getBuiltinDashPattern = n2;
        this.getColor = n3;
        this.getStroke = bl;
        this.isNoColor = bl2;
        this.setColor = chartColorPattern;
        this.setStroke = null;
    }

    public Shape getPathOutline(Graphics2D graphics2D, Shape shape) {
        if (this.getColor == clone.length - 1 || this.draw == 0.0f || this.setColor.isNoColor()) {
            return null;
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(0.0f));
        Shape shape2 = this.createStroke().createStrokedShape(shape);
        graphics2D.setStroke(stroke);
        return shape2;
    }

    public void draw(Graphics2D graphics2D, Shape shape) {
        if (this.getColor == clone.length - 1 || this.draw == 0.0f || this.setColor.isNoColor()) {
            return;
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.setColor.getColor());
        if (this.getStroke) {
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.draw(this.createStroke().createStrokedShape(shape));
        } else {
            graphics2D.setStroke(this.createStroke());
            graphics2D.draw(shape);
        }
        graphics2D.setStroke(stroke);
    }

    public BasicStroke createStroke() {
        if (this.getColor == clone.length - 1) {
            return null;
        }
        if (this.draw == 0.0f) {
            return null;
        }
        if (this.setStroke == null) {
            float[] fArray;
            float[] fArray2 = QOIV[this.getColor];
            if (this.isNoColor) {
                if (fArray2 == null) {
                    fArray = null;
                } else {
                    fArray = new float[fArray2.length];
                    int n = 0;
                    while (n < fArray.length) {
                        fArray[n] = this.draw * fArray2[n];
                        ++n;
                    }
                }
            } else {
                fArray = fArray2;
            }
            this.setStroke = new BasicStroke(this.draw, this.equals, this.getBuiltinDashPattern, 100.0f, fArray, 0.0f);
        }
        return this.setStroke;
    }

    public ChartColorPattern getPenColor() {
        return this.setColor;
    }

    public boolean isOutlined() {
        return this.getStroke;
    }

    public boolean isVariabledDash() {
        return this.isNoColor;
    }

    public float getPenWidth() {
        return this.draw;
    }

    public int getEndCaps() {
        return this.equals;
    }

    public int getLineJoints() {
        return this.getBuiltinDashPattern;
    }

    public int getDashPattern() {
        return this.getColor;
    }

    public void setPenColor(ChartColorPattern chartColorPattern) {
        this.setColor = chartColorPattern;
        this.setStroke = null;
    }

    public void setOutlined(boolean bl) {
        this.getStroke = bl;
        this.setStroke = null;
    }

    public void setVariabledDash(boolean bl) {
        this.isNoColor = bl;
        this.setStroke = null;
    }

    public void setPenWidth(float f) {
        this.draw = f < 0.0f ? 0.0f : f;
        this.setStroke = null;
    }

    public void setEndCaps(int n) {
        this.equals = n;
        this.setStroke = null;
    }

    public void setLineJoints(int n) {
        this.getBuiltinDashPattern = n;
        this.setStroke = null;
    }

    public void setDashPattern(int n) {
        this.getColor = n;
        this.setStroke = null;
    }

    public Object clone() {
        return new ChartPenStyle(this.draw, this.equals, this.getBuiltinDashPattern, this.getColor, this.getStroke, this.isNoColor, (ChartColorPattern)this.setColor.clone());
    }

    public static String[] getBuiltinDashNames() {
        return clone;
    }

    public static int getBuiltinDashPattern(String string) {
        int n = 0;
        while (n < clone.length) {
            if (string.equals(clone[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static String[] getBuiltinPenCapNames() {
        return createStroke;
    }

    public static int getBuiltinPenCap(String string) {
        int n = 0;
        while (n < createStroke.length) {
            if (string.equals(createStroke[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static String[] getBuiltinPenJointNames() {
        return createStrokedShape;
    }

    public static int getBuiltinPenJoint(String string) {
        int n = 0;
        while (n < createStrokedShape.length) {
            if (string.equals(createStrokedShape[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean getOutlined() {
        return this.getStroke;
    }
}

