/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.data.Chart2DDataSet;
import chart.data.Chart3DDataSet;
import chart.data.Chart4DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class Graph2DStock
extends Chart2DObject {
    protected int col;
    protected int row;
    protected int stockType;
    protected ChartPenStyle stockLinePen;
    protected float[][] stockLine;
    protected float[][] tStockLine;
    protected GeneralPath stockBarPath;
    protected float[][] stockBar;
    protected float[][] tStockBar;
    protected ChartFillPattern stockUpBarPattern;
    protected ChartFillPattern stockDownBarPattern;
    protected float[][] smallLine;
    protected float[][] tSmallLine;
    protected GeneralPath smallLinePath;
    protected float unitX;
    protected float unitY;
    protected float startX;
    protected float startY;
    protected static final float gap = 5.0f;
    protected Shape[] stockLineShapes;
    protected Shape[][] stockOItemShapes;
    protected Shape[][] stockCItemShapes;
    protected Shape[] smallLineShapes;
    protected Shape[][] stockHItemShapes;
    protected Shape[][] stockLItemShapes;
    protected Shape[] downShapes;
    protected Shape[] upShapes;
    private int append;
    private int black;
    private float[][] closePath;
    private float[][] draw;
    private float[][] drawLine;
    private float[][] fill;
    private Shape[] getAxisY;
    private String[] getCategoryName = null;

    Graph2DStock(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    public void init() {
        super.init();
        this.row = this.dataset.getSeriesSize();
        this.col = this.dataset.getCategorySize();
        this.unitX = this.layer.I();
        this.unitY = this.layer.Z();
        this.stockLine = new float[2 * this.row * this.col][2];
        this.tStockLine = new float[2 * this.row * this.col][2];
        this.stockLinePen = new ChartPenStyle();
        this.stockLinePen.setPenColor(new ChartColorPattern(this.objectProperties.getStockLineColor()));
        this.stockLinePen.setPenWidth(this.objectProperties.getLineThickness());
        this.closePath = new float[2][2];
        this.draw = new float[2][2];
        this.drawLine = new float[this.col][2];
        this.fill = new float[this.col][2];
        float f = this.stockType == 1 ? 0.0f : 0.5f;
        int n = 0;
        while (n < this.col) {
            this.drawLine[n][0] = this.unitX * ((float)n + f);
            ++n;
        }
        this.closePath[0][0] = this.unitX / 10.0f;
        this.closePath[0][1] = (float)(((ChartNumericAxis)this.layer.getAxisY()).getMin() * (double)this.unitY);
        this.closePath[1][0] = (float)(this.col - 1) * this.unitX + 9.0f * this.unitX / 10.0f;
        this.closePath[1][1] = (float)(((ChartNumericAxis)this.layer.getAxisY()).getMax() * (double)this.unitY);
    }

    public void locate() {
        this.layer.I(this.closePath, this.draw);
        this.layer.I(this.drawLine, this.fill);
        this.getAxisY = new Shape[this.col];
        int n = 0;
        while (n < this.col) {
            this.getAxisY[n] = new GeneralPath();
            ((GeneralPath)this.getAxisY[n]).moveTo(this.fill[n][0] - 1.0f, this.draw[1][1]);
            ((GeneralPath)this.getAxisY[n]).lineTo(this.fill[n][0] - 1.0f, this.draw[0][1]);
            ((GeneralPath)this.getAxisY[n]).lineTo(this.fill[n][0] + 1.0f, this.draw[0][1]);
            ((GeneralPath)this.getAxisY[n]).lineTo(this.fill[n][0] + 1.0f, this.draw[1][1]);
            ((GeneralPath)this.getAxisY[n]).closePath();
            ++n;
        }
        if (this.stockType != 1) {
            int n2 = 0;
            while (n2 < this.row) {
                ((GeneralPath)this.stockLineShapes[n2]).reset();
                int n3 = 0;
                while (n3 < this.col) {
                    ((GeneralPath)this.stockOItemShapes[n2][n3]).reset();
                    ((GeneralPath)this.stockCItemShapes[n2][n3]).reset();
                    ++n3;
                }
                ++n2;
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.row) {
            switch (this.stockType) {
                case 0: {
                    this.QOIV(graphics2D, n);
                    break;
                }
                case 1: {
                    this.QOIV(graphics2D, n);
                    this.black(graphics2D, n);
                    break;
                }
                case 2: {
                    this.QOIV(graphics2D, n);
                    this.append(graphics2D, n);
                }
            }
            ++n;
        }
        if (this.paper.getProperties().isInteractive()) {
            this.closePath(graphics2D, this.append, this.black);
        }
    }

    private void QOIV(Graphics2D graphics2D, int n) {
        this.stockLinePen.draw(graphics2D, this.stockLineShapes[n]);
    }

    private void append(Graphics2D graphics2D, int n) {
        this.stockUpBarPattern.fill(graphics2D, this.upShapes[n]);
        this.stockDownBarPattern.fill(graphics2D, this.downShapes[n]);
        if (this.objectProperties.isContour()) {
            this.objectProperties.getContourPen().draw(graphics2D, this.upShapes[n]);
            this.objectProperties.getContourPen().draw(graphics2D, this.downShapes[n]);
        }
    }

    private void black(Graphics2D graphics2D, int n) {
        this.stockLinePen.draw(graphics2D, this.smallLineShapes[n]);
    }

    private void closePath(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(Color.black);
        if ((float)n > this.draw[0][0] && (float)n < this.draw[1][0] && (float)n2 > this.draw[1][1] && (float)n2 < this.draw[0][1]) {
            graphics2D.drawLine(n, (int)this.draw[0][1], n, (int)this.draw[1][1]);
        }
    }

    private String[] col(int n, int n2) {
        Number number = null;
        Number number2 = null;
        Number number3 = null;
        Number number4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        this.getCategoryName = null;
        int n3 = 0;
        while (n3 < this.row) {
            int n4 = 0;
            while (n4 < this.col) {
                if ((float)n < this.fill[n4][0] + 1.0f && (float)n > this.fill[n4][0] - 1.0f && (float)n2 > this.draw[1][1] && (float)n2 < this.draw[0][1]) {
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                    stringBuffer3.setLength(0);
                    stringBuffer4.setLength(0);
                    switch (this.stockType) {
                        case 0: {
                            this.intHintString(4, n3, n4);
                            number2 = ((Chart2DDataSet)this.dataset).getX(n3, n4);
                            number3 = ((Chart2DDataSet)this.dataset).getY(n3, n4);
                            break;
                        }
                        case 1: {
                            this.intHintString(5, n3, n4);
                            number2 = ((Chart3DDataSet)this.dataset).getX(n3, n4);
                            number3 = ((Chart3DDataSet)this.dataset).getY(n3, n4);
                            number4 = ((Chart3DDataSet)this.dataset).getZ(n3, n4);
                            break;
                        }
                        case 2: {
                            this.intHintString(6, n3, n4);
                            number = ((Chart4DDataSet)this.dataset).getV1(n3, n4);
                            number2 = ((Chart4DDataSet)this.dataset).getV2(n3, n4);
                            number3 = ((Chart4DDataSet)this.dataset).getV3(n3, n4);
                            number4 = ((Chart4DDataSet)this.dataset).getV4(n3, n4);
                            break;
                        }
                    }
                    if (this.stockType != 0) {
                        if (number4 == null) {
                            stringBuffer4.append(" Close:").append("");
                        } else {
                            stringBuffer4.append(" Close: ").append(this.dataset.getFormatedHintValue(number4));
                        }
                        if (this.stockType == 2) {
                            if (number == null) {
                                stringBuffer.append(" Open: ").append("");
                            } else {
                                stringBuffer.append(" Open: ").append(this.dataset.getFormatedHintValue(number));
                            }
                        }
                    }
                    if (number2 == null) {
                        stringBuffer2.append(" High:  ").append("");
                    } else {
                        stringBuffer2.append(" High:  ").append(this.dataset.getFormatedHintValue(number2));
                    }
                    if (number3 == null) {
                        stringBuffer3.append(" Low:  ").append("");
                    } else {
                        stringBuffer3.append(" Low:   ").append(this.dataset.getFormatedHintValue(number3));
                    }
                    int n5 = 0;
                    if (!this.layer.isShowCategoryAndSeries()) {
                        n5 = 2;
                    }
                    switch (this.stockType) {
                        case 0: {
                            this.getCategoryName[2 - n5] = stringBuffer2.toString();
                            this.getCategoryName[3 - n5] = stringBuffer3.toString();
                            break;
                        }
                        case 1: {
                            this.getCategoryName[2 - n5] = stringBuffer2.toString();
                            this.getCategoryName[3 - n5] = stringBuffer3.toString();
                            this.getCategoryName[4 - n5] = stringBuffer4.toString();
                            break;
                        }
                        case 2: {
                            this.getCategoryName[2 - n5] = stringBuffer.toString();
                            this.getCategoryName[3 - n5] = stringBuffer2.toString();
                            this.getCategoryName[4 - n5] = stringBuffer3.toString();
                            this.getCategoryName[5 - n5] = stringBuffer4.toString();
                            break;
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
        return this.getCategoryName;
    }

    public float[][] getStaticHintLocation() {
        return null;
    }

    public Shape getShapeBySeries(int n) {
        return this.getAxisY[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    public Shape[][] getItemShapes() {
        return null;
    }

    public String[] search(int n, int n2) {
        this.append = n;
        this.black = n2;
        return this.col(n, n2);
    }

    public Shape getStockLineShapes(int n) {
        return this.stockLineShapes[n];
    }

    public Shape getStockOItemShapes(int n, int n2) {
        return this.stockOItemShapes[n][n2];
    }

    public Shape getStockCItemShapes(int n, int n2) {
        return this.stockCItemShapes[n][n2];
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.col) {
            if (this.getAxisY[n3].intersects(n - 2, n2 - 2, 5.0, 5.0)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void intHintString(int n, int n2, int n3) {
        if (this.layer.isShowCategoryAndSeries()) {
            this.getCategoryName = new String[n];
            this.getCategoryName[0] = this.getCategoryString(n3);
            this.getCategoryName[1] = this.getSerieString(n2);
        } else {
            this.getCategoryName = new String[n - 2];
        }
    }

    public String getCategoryString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.paper.model.getCategoryNmae() != null) {
            stringBuffer.append(" " + this.paper.model.getCategoryNmae() + ": ");
            stringBuffer.append(this.dataset.getFormatedHintCategoryValue(this.paper.model.getCategoryName(n), n));
            return stringBuffer.toString();
        }
        return "";
    }

    public String getSerieString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.paper.model.getSeriesN() != null) {
            stringBuffer.append(this.paper.model.getSeriesN() + ": ");
            stringBuffer.append(" " + this.dataset.getFormatedHintSeriesValue(this.paper.model.getSeriesName(n % this.paper.model.getSeriesNames().size()), n % this.paper.model.getSeriesNames().size()));
            return stringBuffer.toString();
        }
        return "";
    }
}

