/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbInteger;
import jet.connect.DbValue;

public class DbIntegerColumnBuffer
extends DbColumnBuffer {
    int[] QOIV;

    public int[] getBuffer() {
        return this.QOIV;
    }

    public DbIntegerColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.QOIV = new int[n];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.QOIV[n] = ((DbInteger)dbValue).get();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbInteger)dbValue).set(this.QOIV[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            dataOutput.writeInt(this.QOIV[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = dataInput.readInt();
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
    }
}

