/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbParallelBuffer;
import jet.connect.DbRecord;
import jet.connect.DbValue;
import jet.connect.Groupable;
import jet.connect.Record;
import jet.datasource.JRHierarchicalDataset;
import jet.exception.EndOfRecordsException;
import jet.exception.NoRecordsFoundException;

public class DbRecordModel {
    protected DbColDesc[] colDescs;
    private Hashtable QOIV = new Hashtable();
    private ResultSet addElement;
    private int append = 0;
    public Record currentRecord;
    public Record totalRecord;
    protected Groupable groupable;
    DbBuffer I;
    private int[] arraycopy;
    private int booleanValue;
    public static final String PATH_DELIMITER = ".";
    protected Hashtable groupables;
    private JRHierarchicalDataset cells;
    Hashtable clear = new Hashtable();
    Hashtable clone = new Hashtable();
    Vector close;
    Hashtable colName;
    String compareTo;
    Hashtable contains;
    protected Hashtable children;
    protected boolean bParallel = false;
    Hashtable countTokens;
    String createRecord = null;
    Stack currentTimeMillis = new Stack();
    boolean elementAt = false;
    private boolean equals = true;
    private boolean equalsIgnoreCase = false;
    private int get = 0;
    private String getColIndex = null;
    private Vector getDbBuffer = null;
    private Hashtable getValueArray;

    public DbRecordModel(DbColDesc[] dbColDescArray, Groupable groupable) {
        int n;
        this.colDescs = dbColDescArray;
        this.groupable = groupable;
        if (groupable != null) {
            DbColDesc[] dbColDescArray2 = new DbColDesc[dbColDescArray.length + 1];
            dbColDescArray2[0] = new DbColDesc(null, 4, 0, 0, 2);
            System.arraycopy(dbColDescArray, 0, dbColDescArray2, 1, dbColDescArray.length);
            dbColDescArray2[0].I = 0;
            this.colDescs = dbColDescArray2;
        }
        int n2 = n = groupable != null ? 1 : 0;
        while (n2 < this.colDescs.length) {
            this.colDescs[n2].I = n2;
            this.QOIV.put(this.colDescs[n2].colName, new Integer(n2));
            ++n2;
        }
        this.currentRecord = this.createRecord();
    }

    public Hashtable getGroupables() {
        return this.groupables;
    }

    public void setGroupables(Hashtable hashtable) {
        this.groupables = hashtable;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Groupable groupable = (Groupable)hashtable.get(string);
            if (string == null || string.length() < 1) {
                string = (String)this.close.elementAt(0);
            }
            DbRecordModel dbRecordModel = (DbRecordModel)this.children.get(string);
            while (dbRecordModel == null) {
                string = string.substring(0, string.lastIndexOf(PATH_DELIMITER));
                dbRecordModel = (DbRecordModel)this.children.get(string);
            }
            dbRecordModel.setGroupable(groupable);
        }
    }

    public DbRecordModel(DbColDesc[] dbColDescArray, Hashtable hashtable) {
        this.colDescs = dbColDescArray;
        this.groupables = hashtable;
        if (hashtable != null) {
            DbColDesc[] dbColDescArray2 = new DbColDesc[dbColDescArray.length + 1];
            dbColDescArray2[0] = new DbColDesc(null, 4, 0, 0, 2);
            System.arraycopy(dbColDescArray, 0, dbColDescArray2, 1, dbColDescArray.length);
            dbColDescArray2[0].I = 0;
            this.colDescs = dbColDescArray2;
        }
        if (hashtable.size() == 1) {
            int n;
            int n2 = n = hashtable != null ? 1 : 0;
            while (n2 < this.colDescs.length) {
                this.colDescs[n2].I = n2;
                this.QOIV.put(this.colDescs[n2].colName, new Integer(n2));
                ++n2;
            }
        }
        this.currentRecord = this.createRecord();
    }

    public void setDbBuffer(DbBuffer dbBuffer) {
        this.I = dbBuffer;
        if (this.bParallel) {
            DbParallelBuffer dbParallelBuffer = (DbParallelBuffer)dbBuffer;
            Enumeration enumeration = this.children.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ((DbRecordModel)this.children.get(string)).setDbBuffer(dbParallelBuffer.getDbBuffer(string));
            }
        }
    }

    public DbBuffer getDbBuffer() {
        return this.I;
    }

    public void setColumnMap(int[] nArray) {
        this.arraycopy = nArray;
    }

    public void setResultSet(ResultSet resultSet) throws SQLException {
        this.booleanValue = 0;
        this.addElement = resultSet;
        this.append = 0;
    }

    public DbColDesc getColDesc(int n) {
        return this.colDescs[n];
    }

    public DbColDesc[] getColDescs() {
        return this.colDescs;
    }

    public int indexOfCell(String string) {
        try {
            return (Integer)this.QOIV.get(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("Error Column Name: " + string);
        }
    }

    public boolean addAlias(String string, String string2) {
        boolean bl = false;
        Integer n = (Integer)this.QOIV.get(string.toUpperCase());
        if (n != null) {
            this.QOIV.put(string2, n);
            bl = true;
        }
        return bl;
    }

    public void fetch() throws SQLException {
        if (this.addElement == null && this.cells == null) {
            this.currentRecord = this.createRecord();
            throw new NoRecordsFoundException();
        }
        long l = System.currentTimeMillis();
        boolean bl = this.addElement != null ? this.addElement.next() : this.nextHDS();
        this.booleanValue += (int)(System.currentTimeMillis() - l);
        if (bl) {
            if (this.addElement != null) {
                DbValue[] dbValueArray = this.currentRecord.getValueArray();
                int n = 1;
                while (n < this.arraycopy.length) {
                    if (this.arraycopy[n] != -1) {
                        dbValueArray[this.arraycopy[n]].set(this.addElement, n);
                    }
                    ++n;
                }
            }
            ++this.append;
        } else {
            if (this.append == 0) {
                this.currentRecord = this.createRecord();
                throw new NoRecordsFoundException();
            }
            throw new EndOfRecordsException();
        }
    }

    public Record createRecord() {
        DbRecord dbRecord = new DbRecord(this);
        dbRecord.cells = new DbValue[this.colDescs.length];
        int n = 0;
        while (n < this.colDescs.length) {
            dbRecord.cells[n] = DbValue.makeDbValue(this.colDescs[n]);
            ++n;
        }
        return dbRecord;
    }

    public boolean hasGroupColumn() {
        return this.groupable != null;
    }

    public boolean hasName(String string) {
        return this.QOIV.get(string) != null;
    }

    public boolean hasName(DbColDesc dbColDesc) {
        int n = dbColDesc.getColIndex();
        return this.colDescs.length > n && this.colDescs[n].colName.equalsIgnoreCase(dbColDesc.colName);
    }

    public Object clone() {
        DbRecordModel dbRecordModel;
        DbColDesc[] dbColDescArray = new DbColDesc[this.colDescs.length - 1];
        if (dbColDescArray.length != 0) {
            System.arraycopy(this.colDescs, 1, dbColDescArray, 0, dbColDescArray.length);
        }
        if (this.bParallel) {
            dbRecordModel = new DbRecordModel(dbColDescArray, this.groupables);
            dbRecordModel.bParallel = this.bParallel;
            dbRecordModel.groupables = this.groupables;
            dbRecordModel.children = new Hashtable();
            Enumeration enumeration = this.children.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                dbRecordModel.children.put(string, (DbRecordModel)((DbRecordModel)this.children.get(string)).clone());
            }
        } else {
            dbRecordModel = new DbRecordModel(dbColDescArray, this.groupable);
        }
        return dbRecordModel;
    }

    public Groupable getGroupable() {
        return this.groupable;
    }

    public void setGroupable(Groupable groupable) {
        this.groupable = groupable;
    }

    public void clear() {
        this.colDescs = null;
    }

    public ResultSet getResultSet() {
        return this.addElement;
    }

    public void close() throws SQLException {
        if (this.addElement != null) {
            this.addElement.close();
        }
        if (this.cells != null) {
            this.cells.close();
        }
    }

    public void setFetchTime(int n) {
        this.booleanValue = n;
    }

    public int getFetchTime() {
        return this.booleanValue;
    }

    public boolean isParallel() {
        return this.bParallel;
    }

    public Hashtable getFormulaToBranch() {
        return this.countTokens;
    }

    public Vector getDetails() {
        return this.close;
    }

    public int getBranchNum() {
        return this.children == null ? 1 : this.children.size();
    }

    public void setColumnMap(int[] nArray, Hashtable hashtable, Hashtable hashtable2, Vector vector, Hashtable hashtable3, String string, Hashtable hashtable4) {
        this.setColumnMap(nArray);
        this.clear = hashtable;
        this.clone = hashtable2;
        this.close = vector;
        this.colName = hashtable3;
        this.compareTo = string;
        this.countTokens = hashtable4;
        int n = vector.size();
        boolean bl = this.bParallel = n > 1;
        if (this.bParallel) {
            String string2 = null;
            Vector<DbColDesc> vector2 = new Vector<DbColDesc>();
            Enumeration enumeration = this.groupables.keys();
            while (enumeration.hasMoreElements()) {
                int n2;
                int n3;
                int n4;
                Object object;
                String string3 = (String)enumeration.nextElement();
                Groupable groupable = (Groupable)this.groupables.get(string3);
                vector2.clear();
                if (string3 == null || string3.length() < 1) {
                    string3 = (String)vector.elementAt(0);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string3, PATH_DELIMITER);
                int n5 = stringTokenizer.countTokens();
                int[] nArray2 = new int[n5];
                int[] nArray3 = new int[n5];
                n5 = 0;
                string2 = stringTokenizer.nextToken();
                while (true) {
                    if ((object = (Integer)hashtable.get(string2)) != null) {
                        n4 = (Integer)hashtable.get(string2);
                        n3 = (Integer)hashtable2.get(string2);
                        if (n4 > 0) {
                            string3 = string2;
                            nArray2[n5] = n3;
                            nArray3[n5] = n4;
                            ++n5;
                        }
                        n2 = 0;
                        while (n2 < n4) {
                            vector2.addElement(new DbColDesc(this.colDescs[n3 + n2 + 1]));
                            ++n2;
                        }
                    }
                    if (!stringTokenizer.hasMoreTokens()) break;
                    string2 = string2 + PATH_DELIMITER + stringTokenizer.nextToken();
                }
                object = new int[vector2.size() + 1];
                n4 = 1;
                n3 = 0;
                while (n3 < n5) {
                    n2 = 0;
                    while (n2 < nArray3[n3]) {
                        object[n4++] = nArray2[n3] + n2 + 1;
                        ++n2;
                    }
                    ++n3;
                }
                n2 = nArray.length;
                while (n2 < this.colDescs.length) {
                    String string4 = (String)hashtable4.get(this.colDescs[n2].colName);
                    if (string4 == null || string4.trim() == "" || string3.equals(string4) || string3.startsWith(string4 + PATH_DELIMITER) || string4.startsWith(string3 + PATH_DELIMITER)) {
                        vector2.addElement(new DbColDesc(this.colDescs[n2]));
                    }
                    ++n2;
                }
                int n6 = vector2.size();
                DbColDesc[] dbColDescArray = new DbColDesc[n6];
                int n7 = 0;
                while (n7 < n6) {
                    dbColDescArray[n7] = (DbColDesc)vector2.elementAt(n7);
                    ++n7;
                }
                DbRecordModel dbRecordModel = new DbRecordModel(dbColDescArray, groupable);
                dbRecordModel.setColumnMap((int[])object);
                if (this.children == null) {
                    this.children = new Hashtable();
                }
                this.children.put(string3, dbRecordModel);
            }
        } else {
            Enumeration enumeration = this.groupables.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                this.groupable = (Groupable)this.groupables.get(string5);
            }
        }
    }

    public void setGroupDetail(Hashtable hashtable) {
        this.contains = hashtable;
    }

    public void setHDS(JRHierarchicalDataset jRHierarchicalDataset) throws SQLException {
        this.booleanValue = 0;
        this.cells = jRHierarchicalDataset;
        this.append = 0;
    }

    public JRHierarchicalDataset getHDS() {
        return this.cells;
    }

    public String getCurrentBranch() {
        if (this.getColIndex == null) {
            return this.createRecord;
        }
        return this.getColIndex;
    }

    public int getReadGroup() {
        return this.get;
    }

    public boolean isBreakInMid() {
        return this.elementAt;
    }

    public void setSatisfy(boolean bl) {
        this.equals = bl;
    }

    public void setHasLocal(boolean bl) {
        this.equalsIgnoreCase = bl;
    }

    public boolean nextHDS() throws SQLException {
        boolean bl;
        block27: {
            this.getColIndex = null;
            if (this.totalRecord != null) {
                this.currentRecord = this.totalRecord;
            }
            DbValue[] dbValueArray = this.currentRecord.getValueArray();
            boolean bl2 = false;
            if (!this.equals) {
                if (this.elementAt) {
                    --this.get;
                }
                bl2 = true;
                this.equals = true;
            } else {
                this.get = 0;
            }
            this.elementAt = false;
            if (this.createRecord == null) {
                this.createRecord = this.compareTo;
            }
            block0: while (true) {
                int n;
                int n2;
                if (bl = this.cells.next(this.createRecord)) {
                    if (this.currentTimeMillis.size() == 0 || ((String)this.currentTimeMillis.peek()).compareTo(this.createRecord) != 0) {
                        this.currentTimeMillis.push(this.createRecord);
                    }
                    int n3 = (Integer)this.clear.get(this.createRecord);
                    n2 = (Integer)this.clone.get(this.createRecord);
                    n = 1;
                    while (n <= n3) {
                        if (this.arraycopy[n + n2] != -1) {
                            dbValueArray[this.arraycopy[n + n2]].set(this.cells, n);
                        }
                        ++n;
                    }
                    if (this.close.contains(this.createRecord)) {
                        if (((Boolean)this.contains.get(this.createRecord)).booleanValue()) {
                            ++this.get;
                        }
                        if (this.bParallel) {
                            this.totalRecord = this.currentRecord;
                            this.currentRecord = this.setValuetoBranch(this.createRecord);
                        }
                        break block27;
                    }
                    if ((Integer)this.clear.get(this.createRecord) > 0) {
                        ++this.get;
                    }
                    if (this.getDbBuffer != null && this.getDbBuffer.contains(this.createRecord)) {
                        this.elementAt = true;
                        break block27;
                    }
                    Vector vector = (Vector)this.colName.get(this.createRecord);
                    this.createRecord = (String)vector.elementAt(0);
                    int n4 = vector.size();
                    int n5 = n4 - 1;
                    while (true) {
                        if (n5 <= 0) continue block0;
                        this.currentTimeMillis.push(vector.elementAt(n5));
                        --n5;
                    }
                }
                if (this.get > 0 && !this.equalsIgnoreCase) {
                    String string = this.createRecord;
                    while (true) {
                        n2 = (Integer)this.clear.get(string);
                        n = (Integer)this.clone.get(string);
                        int n6 = 1;
                        while (n6 <= n2) {
                            if (this.arraycopy[n6 + n] != -1) {
                                dbValueArray[this.arraycopy[n6 + n]].setNull();
                            }
                            ++n6;
                        }
                        if (this.close.contains(string)) {
                            if (((Boolean)this.contains.get(string)).booleanValue()) {
                                ++this.get;
                            }
                            if (!this.bParallel) break;
                            this.totalRecord = this.currentRecord;
                            this.currentRecord = this.setValuetoBranch(string);
                            break;
                        }
                        if ((Integer)this.clear.get(string) > 0) {
                            ++this.get;
                        }
                        string = (String)((Vector)this.colName.get(string)).elementAt(0);
                    }
                    this.getColIndex = string;
                    this.createRecord = (String)this.currentTimeMillis.peek();
                    bl = true;
                    break block27;
                }
                if (this.currentTimeMillis.size() == 0) break;
                if (((String)this.currentTimeMillis.peek()).equals(this.createRecord)) {
                    this.currentTimeMillis.pop();
                }
                if (this.currentTimeMillis.size() == 0) {
                    throw new EndOfRecordsException();
                }
                this.createRecord = (String)this.currentTimeMillis.peek();
                if (!bl2 || this.get <= 0) continue;
                --this.get;
            }
            if (this.append == 0) {
                this.currentRecord = this.createRecord();
                throw new NoRecordsFoundException();
            }
            throw new EndOfRecordsException();
        }
        if (!this.elementAt) {
            ++this.append;
        }
        return bl;
    }

    public boolean continueRead() throws SQLException {
        boolean bl;
        block20: {
            block21: {
                this.getColIndex = null;
                DbValue[] dbValueArray = this.currentRecord.getValueArray();
                Vector vector = (Vector)this.colName.get(this.createRecord);
                this.createRecord = (String)vector.elementAt(0);
                int n = vector.size();
                int n2 = n - 1;
                while (n2 > 0) {
                    this.currentTimeMillis.push(vector.elementAt(n2));
                    --n2;
                }
                block1: while (true) {
                    int n3;
                    int n4;
                    int n5;
                    if (bl = this.cells.next(this.createRecord)) {
                        if (this.currentTimeMillis.size() == 0 || ((String)this.currentTimeMillis.peek()).compareTo(this.createRecord) != 0) {
                            this.currentTimeMillis.push(this.createRecord);
                        }
                        int n6 = (Integer)this.clear.get(this.createRecord);
                        n5 = (Integer)this.clone.get(this.createRecord);
                        n4 = 1;
                        while (n4 <= n6) {
                            if (this.arraycopy[n4 + n5] != -1) {
                                dbValueArray[this.arraycopy[n4 + n5]].set(this.cells, n4);
                            }
                            ++n4;
                        }
                        if (this.close.contains(this.createRecord)) {
                            if (((Boolean)this.contains.get(this.createRecord)).booleanValue()) {
                                ++this.get;
                            }
                            if (this.bParallel) {
                                this.totalRecord = this.currentRecord;
                                this.currentRecord = this.setValuetoBranch(this.createRecord);
                            }
                            break block20;
                        }
                        if ((Integer)this.clear.get(this.createRecord) > 0) {
                            ++this.get;
                        }
                        vector = (Vector)this.colName.get(this.createRecord);
                        this.createRecord = (String)vector.elementAt(0);
                        n = vector.size();
                        n3 = n - 1;
                        while (true) {
                            if (n3 <= 0) continue block1;
                            this.currentTimeMillis.push(vector.elementAt(n3));
                            --n3;
                        }
                    }
                    if (this.get > 0) {
                        String string = this.createRecord;
                        while (true) {
                            n5 = (Integer)this.clear.get(string);
                            n4 = (Integer)this.clone.get(string);
                            n3 = 1;
                            while (n3 <= n5) {
                                if (this.arraycopy[n3 + n4] != -1) {
                                    dbValueArray[this.arraycopy[n3 + n4]].setNull();
                                }
                                ++n3;
                            }
                            if (this.close.contains(string)) {
                                if (((Boolean)this.contains.get(string)).booleanValue()) {
                                    ++this.get;
                                }
                                if (!this.bParallel) break;
                                this.totalRecord = this.currentRecord;
                                this.currentRecord = this.setValuetoBranch(string);
                                break;
                            }
                            if ((Integer)this.clear.get(string) > 0) {
                                ++this.get;
                            }
                            string = (String)((Vector)this.colName.get(string)).elementAt(0);
                        }
                        this.getColIndex = string;
                        this.createRecord = (String)this.currentTimeMillis.peek();
                        bl = true;
                        break block20;
                    }
                    if (this.currentTimeMillis.size() == 0) break block21;
                    if (((String)this.currentTimeMillis.peek()).equals(this.createRecord)) {
                        this.currentTimeMillis.pop();
                    }
                    if (this.currentTimeMillis.size() == 0) break;
                    this.createRecord = (String)this.currentTimeMillis.peek();
                }
                throw new EndOfRecordsException();
            }
            if (this.append == 0) {
                this.currentRecord = this.createRecord();
                throw new NoRecordsFoundException();
            }
            throw new EndOfRecordsException();
        }
        ++this.append;
        return bl;
    }

    public Record setValuetoBranch(String string) {
        DbRecordModel dbRecordModel = (DbRecordModel)this.children.get(string);
        DbRecord dbRecord = (DbRecord)dbRecordModel.currentRecord;
        int n = dbRecordModel.arraycopy.length;
        int n2 = 0;
        while (n2 < n) {
            dbRecord.cells[n2].set(((DbRecord)this.currentRecord).cells[dbRecordModel.arraycopy[n2]]);
            ++n2;
        }
        return dbRecord;
    }

    public Hashtable getAllRM() {
        return this.children;
    }

    public DbRecordModel get(String string) {
        DbRecordModel dbRecordModel = null;
        if (this.bParallel) {
            dbRecordModel = (DbRecordModel)this.children.get(string);
        }
        if (dbRecordModel == null) {
            return this;
        }
        return dbRecordModel;
    }

    public void setBreakBranch(Vector vector, Hashtable hashtable) {
        if (this.getDbBuffer != null && this.getDbBuffer.size() > 0) {
            this.getDbBuffer = vector;
        }
        this.getValueArray = hashtable;
    }

    public Vector getBreakBranch() {
        return this.getDbBuffer;
    }

    public Vector getBreakFormulaW() {
        return (Vector)this.getValueArray.get(this.createRecord);
    }

    public Hashtable getBreakToFormulas() {
        return this.getValueArray;
    }
}

