/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util.dataswap;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.dataservice.util.Bits;
import com.jinfonet.datatypes.JinfonetArrayBaseObject;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;

public class ArrayTool {
    public static byte[] array2Bytes(Array array) throws DSException {
        int n = array.getBaseType();
        Object object = array.getArray();
        byte[] byArray = null;
        int n2 = 0;
        switch (n) {
            case 5: {
                short[] sArray = (short[])object;
                n2 = (sArray.length << 1) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n3 = 0;
                while (n3 < sArray.length) {
                    short s = sArray[n3];
                    Bits.putShort(byArray, 4 + (n3 << 1), s);
                    ++n3;
                }
                break;
            }
            case -6: {
                byte[] byArray2 = (byte[])object;
                n2 = (byArray2.length << 0) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n4 = 0;
                while (n4 < byArray2.length) {
                    byte by;
                    byArray[4 + n4] = by = byArray2[n4];
                    ++n4;
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])object;
                n2 = (nArray.length << 2) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n5 = 0;
                while (n5 < nArray.length) {
                    int n6 = nArray[n5];
                    Bits.putInt(byArray, 4 + (n5 << 2), n6);
                    ++n5;
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])object;
                n2 = (lArray.length << 3) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n7 = 0;
                while (n7 < lArray.length) {
                    long l = lArray[n7];
                    Bits.putLong(byArray, 4 + (n7 << 3), l);
                    ++n7;
                }
                break;
            }
            case 6: 
            case 7: {
                float[] fArray2 = (float[])object;
                n2 = (fArray2.length << 2) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n8 = 0;
                while (n8 < fArray2.length) {
                    float f = fArray2[n8];
                    Bits.putFloat(byArray, 4 + (n8 << 2), f);
                    ++n8;
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                int n9 = 8;
                int n10 = 0;
                while (n10 < bigDecimalArray.length) {
                    byte[] byArray3 = bigDecimalArray[n10].unscaledValue().toByteArray();
                    n9 = n9 + byArray3.length + 8;
                    ++n10;
                }
                byArray = new byte[n9];
                Bits.putInt(byArray, 0, n);
                Bits.putInt(byArray, 4, bigDecimalArray.length);
                int n11 = 8;
                int n12 = 0;
                while (n12 < bigDecimalArray.length) {
                    byte[] byArray4 = bigDecimalArray[n12].unscaledValue().toByteArray();
                    Bits.putInt(byArray, n11, byArray4.length);
                    Bits.putInt(byArray, n11 += 4, bigDecimalArray[n12].scale());
                    Bits.putBytes(byArray, n11 += 4, byArray4);
                    n11 += byArray4.length;
                    ++n12;
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])object;
                long[] lArray = new long[dArray.length];
                int n13 = 0;
                while (n13 < lArray.length) {
                    lArray[n13] = Double.doubleToRawLongBits(dArray[n13]);
                    ++n13;
                }
                n2 = (lArray.length << 3) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n14 = 0;
                while (n14 < lArray.length) {
                    long l = lArray[n14];
                    Bits.putLong(byArray, 4 + (n14 << 3), l);
                    ++n14;
                }
                break;
            }
            case -7: {
                boolean[] blArray = (boolean[])object;
                byte[] byArray5 = new byte[blArray.length];
                int n15 = 0;
                while (n15 < blArray.length) {
                    byArray5[n15] = blArray[n15] ? (byte)1 : 0;
                    ++n15;
                }
                n2 = (byArray5.length << 0) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n16 = 0;
                while (n16 < byArray5.length) {
                    byte by;
                    byArray[4 + n16] = by = byArray5[n16];
                    ++n16;
                }
                break;
            }
            case 91: {
                JinfonetDate[] jinfonetDateArray = (JinfonetDate[])object;
                long[] lArray = new long[jinfonetDateArray.length];
                int n17 = 0;
                while (n17 < lArray.length) {
                    lArray[n17] = jinfonetDateArray[n17].getTime();
                    ++n17;
                }
                n2 = (lArray.length << 3) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n18 = 0;
                while (n18 < lArray.length) {
                    long l = lArray[n18];
                    Bits.putLong(byArray, 4 + (n18 << 3), l);
                    ++n18;
                }
                break;
            }
            case 92: {
                JinfonetTime[] jinfonetTimeArray = (JinfonetTime[])object;
                long[] lArray = new long[jinfonetTimeArray.length];
                int n19 = 0;
                while (n19 < lArray.length) {
                    lArray[n19] = jinfonetTimeArray[n19].getTime();
                    ++n19;
                }
                n2 = (lArray.length << 3) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n20 = 0;
                while (n20 < lArray.length) {
                    long l = lArray[n20];
                    Bits.putLong(byArray, 4 + (n20 << 3), l);
                    ++n20;
                }
                break;
            }
            case 93: {
                JinfonetTimeStamp[] jinfonetTimeStampArray = (JinfonetTimeStamp[])object;
                long[] lArray = new long[jinfonetTimeStampArray.length];
                int[] nArray = new int[jinfonetTimeStampArray.length];
                int n21 = 0;
                while (n21 < lArray.length) {
                    lArray[n21] = jinfonetTimeStampArray[n21].getTime();
                    nArray[n21] = jinfonetTimeStampArray[n21].getNanos();
                    ++n21;
                }
                n2 = lArray.length * 12 + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                int n22 = 0;
                while (n22 < lArray.length) {
                    long l = lArray[n22];
                    Bits.putLong(byArray, 4 + n22 * 12, l);
                    int n23 = nArray[n22];
                    Bits.putInt(byArray, 4 + (n22 * 12 + 8), n23);
                    ++n22;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                int n24 = 0;
                int n25 = 0;
                int n26 = 4;
                int n27 = 2;
                String[] stringArray = (String[])object;
                n2 += 4;
                n2 += n26;
                n2 += stringArray.length * n26;
                int n28 = 0;
                while (n28 < stringArray.length) {
                    n2 += stringArray[n28].length() * n27;
                    n24 = Math.max(n24, stringArray[n28].length());
                    ++n28;
                }
                char[] cArray = new char[n24];
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                Bits.putInt(byArray, n25 += n26, stringArray.length);
                n25 += n26;
                int n29 = 0;
                while (n29 < stringArray.length) {
                    Bits.putInt(byArray, n25, stringArray[n29].length());
                    n25 += n26;
                    ++n29;
                }
                int n30 = 0;
                while (n30 < stringArray.length) {
                    stringArray[n30].getChars(0, stringArray[n30].length(), cArray, 0);
                    int n31 = 0;
                    while (n31 < stringArray[n30].length()) {
                        Bits.putChar(byArray, n25, cArray[n31]);
                        n25 += n27;
                        ++n31;
                    }
                    ++n30;
                }
                break;
            }
            case -4: 
            case -2: 
            case 2004: {
                throw new UnsupportedOperationException("unSupported Array's base-dataType:" + n);
            }
            default: {
                throw new UnsupportedOperationException("unSupported Array's base-dataType:" + n);
            }
        }
        return byArray;
    }

    public static Array bytes2Array(byte[] byArray) {
        int n = Bits.getInt(byArray, 0);
        switch (n) {
            case 5: {
                short[] sArray = new short[byArray.length - 4 >> 1];
                int n2 = 0;
                while (n2 < sArray.length) {
                    sArray[n2] = Bits.getShort(byArray, 4 + (n2 << 1));
                    ++n2;
                }
                return new JinfonetArrayBaseObject(n, sArray);
            }
            case -6: {
                byte[] byArray2 = new byte[byArray.length - 4 >> 0];
                int n3 = 0;
                while (n3 < byArray2.length) {
                    byArray2[n3] = byArray[4 + n3];
                    ++n3;
                }
                return new JinfonetArrayBaseObject(n, byArray2);
            }
            case 4: {
                int[] nArray = new int[byArray.length - 4 >> 2];
                int n4 = 0;
                while (n4 < nArray.length) {
                    nArray[n4] = Bits.getInt(byArray, 4 + (n4 << 2));
                    ++n4;
                }
                return new JinfonetArrayBaseObject(n, nArray);
            }
            case -5: {
                long[] lArray = new long[byArray.length - 4 >> 3];
                int n5 = 0;
                while (n5 < lArray.length) {
                    lArray[n5] = Bits.getLong(byArray, 4 + (n5 << 3));
                    ++n5;
                }
                return new JinfonetArrayBaseObject(n, lArray);
            }
            case 6: {
                float[] fArray2 = new float[byArray.length - 4 >> 2];
                int n6 = 0;
                while (n6 < fArray2.length) {
                    fArray2[n6] = Bits.getFloat(byArray, 4 + (n6 << 2));
                    ++n6;
                }
                return new JinfonetArrayBaseObject(n, fArray2);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                int n7 = 4;
                int n8 = 2;
                int n9 = Bits.getInt(byArray, 4);
                String[] stringArray = new String[n9];
                int n10 = 0;
                n10 += 4 + n7;
                int[] nArray = new int[n9];
                int n11 = 0;
                while (n11 < stringArray.length) {
                    nArray[n11] = Bits.getInt(byArray, n10);
                    n10 += n7;
                    ++n11;
                }
                int n12 = 0;
                while (n12 < stringArray.length) {
                    char[] cArray = new char[nArray[n12]];
                    int n13 = 0;
                    while (n13 < nArray[n12]) {
                        cArray[n13] = Bits.getChar(byArray, n10);
                        n10 += n8;
                        ++n13;
                    }
                    stringArray[n12] = new String(cArray);
                    ++n12;
                }
                return new JinfonetArrayBaseObject(n, stringArray);
            }
            case 2: 
            case 3: {
                int n14 = Bits.getInt(byArray, 4);
                BigDecimal[] bigDecimalArray = new BigDecimal[n14];
                int n15 = 8;
                int n16 = 0;
                while (n16 < bigDecimalArray.length) {
                    int n17 = Bits.getInt(byArray, n15);
                    int n18 = Bits.getInt(byArray, n15 += 4);
                    byte[] byArray3 = new byte[n17];
                    System.arraycopy(byArray, n15 += 4, byArray3, 0, n17);
                    n15 += n17;
                    bigDecimalArray[n16] = new BigDecimal(new BigInteger(byArray3), n18);
                    ++n16;
                }
                return new JinfonetArrayBaseObject(n, bigDecimalArray);
            }
            case 8: {
                long[] lArray = new long[byArray.length - 4 >> 3];
                int n19 = 0;
                while (n19 < lArray.length) {
                    lArray[n19] = Bits.getLong(byArray, 4 + (n19 << 3));
                    ++n19;
                }
                double[] dArray = new double[lArray.length];
                int n20 = 0;
                while (n20 < dArray.length) {
                    dArray[n20] = Double.longBitsToDouble(lArray[n20]);
                    ++n20;
                }
                return new JinfonetArrayBaseObject(n, dArray);
            }
            case -7: {
                byte[] byArray4 = new byte[byArray.length - 4 >> 0];
                int n21 = 0;
                while (n21 < byArray4.length) {
                    byArray4[n21] = byArray[4 + n21];
                    ++n21;
                }
                boolean[] blArray = new boolean[byArray4.length];
                int n22 = 0;
                while (n22 < blArray.length) {
                    blArray[n22] = byArray4[n22] == 1;
                    ++n22;
                }
                return new JinfonetArrayBaseObject(n, blArray);
            }
            case 91: {
                long[] lArray = new long[byArray.length - 4 >> 3];
                int n23 = 0;
                while (n23 < lArray.length) {
                    lArray[n23] = Bits.getLong(byArray, 4 + (n23 << 3));
                    ++n23;
                }
                JinfonetDate[] jinfonetDateArray = new JinfonetDate[lArray.length];
                int n24 = 0;
                while (n24 < jinfonetDateArray.length) {
                    jinfonetDateArray[n24] = new JinfonetDate(lArray[n24]);
                    ++n24;
                }
                return new JinfonetArrayBaseObject(n, jinfonetDateArray);
            }
            case 92: {
                long[] lArray = new long[byArray.length - 4 >> 3];
                int n25 = 0;
                while (n25 < lArray.length) {
                    lArray[n25] = Bits.getLong(byArray, 4 + (n25 << 3));
                    ++n25;
                }
                JinfonetTime[] jinfonetTimeArray = new JinfonetTime[lArray.length];
                int n26 = 0;
                while (n26 < jinfonetTimeArray.length) {
                    jinfonetTimeArray[n26] = new JinfonetTime(lArray[n26]);
                    ++n26;
                }
                return new JinfonetArrayBaseObject(n, jinfonetTimeArray);
            }
            case 93: {
                long[] lArray = new long[(byArray.length - 4) / 12];
                int[] nArray = new int[lArray.length];
                int n27 = 0;
                while (n27 < lArray.length) {
                    lArray[n27] = Bits.getLong(byArray, 4 + n27 * 12);
                    nArray[n27] = Bits.getInt(byArray, 4 + (n27 * 12 + 8));
                    ++n27;
                }
                JinfonetTimeStamp[] jinfonetTimeStampArray = new JinfonetTimeStamp[lArray.length];
                int n28 = 0;
                while (n28 < jinfonetTimeStampArray.length) {
                    jinfonetTimeStampArray[n28] = new JinfonetTimeStamp(lArray[n28]);
                    jinfonetTimeStampArray[n28].setNanos(nArray[n28]);
                    ++n28;
                }
                return new JinfonetArrayBaseObject(n, jinfonetTimeStampArray);
            }
        }
        throw new UnsupportedOperationException("unSupported Array's base-dataType:" + n);
    }

    public static void main(String[] stringArray) throws DSException {
        String[] stringArray2 = new String[9];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = "testStringArray" + n;
            ++n;
        }
        stringArray2[5] = "";
        stringArray2[6] = "tjkerlktjertlkjejkwrtkjlert0-3457890235-";
        JinfonetArrayBaseObject jinfonetArrayBaseObject = new JinfonetArrayBaseObject(1, stringArray2);
        byte[] byArray = ArrayTool.array2Bytes(jinfonetArrayBaseObject);
        System.out.println(byArray);
        Array array = ArrayTool.bytes2Array(byArray);
        System.out.println(array);
    }
}

