/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.Env;
import jet.datastream.DSField;
import jet.datastream.DSTemplatible;
import jet.datastream.render.Render;
import jet.export.util.Cache;

public class ExportCache
implements Cache {
    private Map add = new HashMap();
    private int canBeCatch = 110;
    private String createTempFile;
    private File delete;
    private List exists = new ArrayList();

    public ExportCache(File file, String string) {
        String string2 = Env.temporaryPath;
        if (string2 == null || string2.trim().length() == 0) {
            if (file != null) {
                this.delete = file;
            } else {
                string2 = System.getProperty("java.io.tmpdir");
                this.delete = new File(string2);
            }
        } else {
            this.delete = new File(string2);
        }
        this.createTempFile = string == null || string.trim().length() == 0 ? "export" : string;
    }

    public void setMaxCacheSizeOfRender(int n) {
        this.canBeCatch = n < 20 ? 20 : n;
    }

    public int getCachedRenderNumber() {
        return this.add.size();
    }

    public Render getRender(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Render render = (Render)this.add.get(dSTemplatible);
        if (render == null) {
            render = dSField.getRender();
            if (this.add.size() < this.canBeCatch && render.canBeCatch()) {
                this.add.put(dSTemplatible, render);
            }
        } else {
            render.updateRender(dSField);
        }
        return render;
    }

    public void clear() {
        if (this.add != null) {
            this.add.clear();
            this.add = null;
        }
        if (this.exists != null) {
            int n = 0;
            while (n < this.exists.size()) {
                File file = (File)this.exists.get(n);
                if (file.exists()) {
                    file.delete();
                }
                ++n;
            }
            this.exists.clear();
            this.exists = null;
        }
    }

    public File getTemporaryPath() {
        return this.delete;
    }

    public File getNextTemporaryFile() throws IOException {
        File file = File.createTempFile(this.createTempFile, "", this.delete);
        this.exists.add(file);
        return file;
    }
}

