/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.properties.ChartWallProperties;
import jet.controls.JetObject;
import jet.report.chart.JetChartFillPattern;
import jet.report.chart.JetChartGroupedProperties;
import jet.report.chart.JetChartPenStyle;

public class JetChartWallProperties
extends JetChartGroupedProperties {
    public JetChartPenStyle borderPen;
    public JetChartFillPattern fillPattern;
    public JetChartFillPattern boundFillPattern;

    JetChartWallProperties(JetObject jetObject, String string) {
        super(jetObject, string);
        this.borderPen = new JetChartPenStyle(jetObject, this.prefix + "Border");
        this.fillPattern = new JetChartFillPattern(jetObject, this.prefix + "Fill");
        this.boundFillPattern = new JetChartFillPattern(jetObject, this.prefix + "BoundFill", false);
    }

    public void addToGroup(String string) {
        if (string != null) {
            this.borderPen.addToGroup(string);
            this.fillPattern.addToGroup(string);
            if (!string.equalsIgnoreCase("Floor")) {
                this.boundFillPattern.addToGroupExceptImage(string);
            }
        }
    }

    public String getGroupName() {
        return "Wall";
    }

    public ChartWallProperties getWallProperties() {
        ChartWallProperties chartWallProperties = new ChartWallProperties();
        chartWallProperties.setBorder(this.borderPen.getChartPenStyle());
        chartWallProperties.setPattern1(this.fillPattern.getChartFillPattern());
        chartWallProperties.setPattern2(this.boundFillPattern.getChartFillPattern());
        return chartWallProperties;
    }

    public void setWallProperties(ChartWallProperties chartWallProperties) {
        this.borderPen.setChartPenStyle(chartWallProperties.getBorder());
        this.fillPattern.setChartFillPattern(chartWallProperties.getPattern1());
        this.boundFillPattern.setChartFillPattern(chartWallProperties.getPattern2());
    }
}

