/*
 * Decompiled with CFR 0.152.
 */
package jet.report.specialFuncImpl.grpByRange;

import java.util.HashMap;
import java.util.TimeZone;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.dataengine.api.DSException;
import jet.dataengine.api.SumrySpecKeyTool;
import jet.report.specialFunc.grpByRange.DateTimeIntervalGrpBy;
import jet.report.specialFunc.grpByRange.GroupByRange;
import jet.report.specialFuncImpl.grpByRange.JetRptGrpByRangeFunc;

public class JetRptDateInterval
extends JetRptGrpByRangeFunc
implements DateTimeIntervalGrpBy {
    private JetNumber QOIV = new JetNumber(this, "DateUnit", 13);
    private JetNumber equals = new JetNumber(this, "FirstDayOfWeek", 1);
    private JetNumber get = new JetNumber(this, "TimeZoneOffset", 0);
    private JetBoolean getDateDesc = new JetBoolean(this, "UseRuntimeTimeZone", false);
    private static final HashMap getDefault = new HashMap(9);

    public JetRptDateInterval() {
        this.QOIV.setCanChangeByOthers(false);
        this.equals.setCanChangeByOthers(false);
        this.get.setCanChangeByOthers(false);
        this.getDateDesc.setCanChangeByOthers(false);
        this.grpStart.set("0");
    }

    public int getIntervalUnit() {
        return this.QOIV.intValue();
    }

    public int getGroupByRangeType() {
        return 3;
    }

    public String getInstancePrefix() {
        return "DateTimeIntervalGBR";
    }

    public void setDateUnit(int n) {
        this.QOIV.set(n);
    }

    public int getFirstDayOfWeek() {
        return this.equals.intValue();
    }

    public int getTimeZoneOffset() {
        if (this.getDateDesc.get()) {
            return TimeZone.getDefault().getRawOffset() / 60000;
        }
        return this.get.intValue();
    }

    public boolean isRuntimeTimezoneUsed() {
        return this.getDateDesc.get();
    }

    public void setFirstDayOfWeek(int n) {
        this.equals.set(n);
    }

    public void setTimeZone(int n) {
        this.get.set(n);
    }

    public void setRuntimeTimezoneUsed(boolean bl) {
        this.getDateDesc.set(bl);
    }

    protected boolean isEquals(GroupByRange groupByRange) {
        boolean bl = super.isEquals(groupByRange);
        if (bl) {
            DateTimeIntervalGrpBy dateTimeIntervalGrpBy = (DateTimeIntervalGrpBy)groupByRange;
            bl = bl && dateTimeIntervalGrpBy.getStartLine().equals(this.getStartLine());
            bl = bl && dateTimeIntervalGrpBy.getInterval().equals(this.getInterval());
            bl = bl && dateTimeIntervalGrpBy.getIntervalUnit() == this.getIntervalUnit();
            bl = bl && dateTimeIntervalGrpBy.getFirstDayOfWeek() == this.getFirstDayOfWeek();
            bl = bl && dateTimeIntervalGrpBy.getTimeZoneOffset() == this.getTimeZoneOffset();
            boolean bl2 = bl = bl && dateTimeIntervalGrpBy.isGroupingToOthers() == this.isGroupingToOthers();
            if (bl && dateTimeIntervalGrpBy.isGroupingToOthers()) {
                bl = dateTimeIntervalGrpBy.getOthersGroupingName().equals(this.getOthersGroupingName());
            }
        }
        return bl;
    }

    public String toString() {
        return this.getSimpleDescription();
    }

    public String stringOfDateUnit(int n) {
        switch (n) {
            case 13: {
                return "second(s)".intern();
            }
            case 12: {
                return "minute(s)".intern();
            }
            case 22: {
                return "quarter(s)".intern();
            }
            case 10: {
                return "hour(s)".intern();
            }
            case 5: {
                return "day(s)".intern();
            }
            case 24: {
                return "week(s)".intern();
            }
            case 23: {
                return "bi-week(s)".intern();
            }
            case 21: {
                return "half-month(s)".intern();
            }
            case 2: {
                return "month(s)".intern();
            }
            case 20: {
                return "half-year(s)".intern();
            }
            case 1: {
                return "year(s)".intern();
            }
        }
        return "<UNKOWN UNIT>".intern();
    }

    public String getSimpleDescription() {
        try {
            return SumrySpecKeyTool.getDateDesc(this.QOIV.intValue(), this.interval.get());
        }
        catch (DSException dSException) {
            throw new RuntimeException(dSException);
        }
    }

    public HashMap getIndecialMap() {
        return getDefault;
    }

    static {
        int n = 0;
        getDefault.put("TimeZoneOffset", new Integer(n++));
        getDefault.put("GroupStart", new Integer(n++));
        getDefault.put("FirstDayOfWeek", new Integer(n++));
        getDefault.put("IsGroupingOther", new Integer(n++));
        getDefault.put("Interval", new Integer(n++));
        getDefault.put("UseRuntimeTimeZone", new Integer(n++));
        getDefault.put("DateUnit", new Integer(n++));
        getDefault.put("IntervalType", new Integer(n++));
        getDefault.put("OtherGrpName", new Integer(n++));
    }
}

