/*
 * Decompiled with CFR 0.152.
 */
package jet.security;

import java.awt.Rectangle;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DataStream;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.ZipToolkit;
import jet.ie.io.PJFDataOutput;

public class DataStreamFilter
extends DataStream {
    private DataStream GZip;
    private int[] QOIV;

    public DataStreamFilter(Communicator communicator, DataStream dataStream, int[] nArray) {
        super(communicator);
        this.GZip = dataStream;
        this.QOIV = nArray;
    }

    public DSPage getPage(int n) throws IOException, JRStopEngineException {
        if (n > 0 && n <= this.QOIV.length) {
            return this.GZip.getPage(this.QOIV[n - 1]);
        }
        return null;
    }

    public long[] saveTo(PJFDataOutput pJFDataOutput, Communicator communicator) throws JRStopEngineException, IOException {
        return this.saveTo(pJFDataOutput, communicator, false);
    }

    public long[] saveTo(PJFDataOutput pJFDataOutput, Communicator communicator, boolean bl) throws JRStopEngineException, IOException {
        int n = communicator.getPageNum();
        long[] lArray = new long[n];
        if (lArray.length > 0) {
            lArray[0] = pJFDataOutput.getPosition();
        }
        int n2 = 1;
        while (n2 <= n) {
            DSPage dSPage = communicator.getPage(n2);
            RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage.length());
            dSPage.write(new PJFDataOutput(randomByteArrayOutputStream));
            byte[] byArray = randomByteArrayOutputStream.toByteArray();
            if (bl) {
                byArray = ZipToolkit.GZip(byArray);
            }
            pJFDataOutput.write(byArray);
            if (n2 != n) {
                lArray[n2] = lArray[n2 - 1] + (long)byArray.length;
            }
            randomByteArrayOutputStream.close();
            ++n2;
        }
        return lArray;
    }

    public boolean isEngineFinished() {
        return this.GZip.isEngineFinished();
    }

    public Rectangle getPageArea() {
        return this.GZip.getPageArea();
    }

    public Rectangle getPrintableArea() {
        return this.GZip.getPrintableArea();
    }

    public int ie() {
        return this.GZip.ie();
    }

    public Long getPageEntry(int n) {
        return this.GZip.getPageEntry(this.QOIV[n - 1]);
    }

    public void clearMem() {
        this.GZip.clearMem();
    }

    public void sort(DSSection dSSection, DbValue dbValue, boolean bl) throws JRStopEngineException {
        this.GZip.sort(dSSection, dbValue, bl);
    }
}

