/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.Env;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.datasource.hds.ArrayImpl;
import jet.util.DbValueFormat;

public class AllNumberFormat
extends DecimalFormat
implements DbValueFormat {
    String QOIV = "JRD";

    public AllNumberFormat() {
    }

    public AllNumberFormat(String string) {
        super(string);
    }

    public AllNumberFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        super(string, decimalFormatSymbols);
    }

    public synchronized String format(DbValue dbValue) {
        int n = dbValue.getSqlType();
        boolean bl = this.getPattern().startsWith(this.QOIV) || dbValue.isCurrency();
        boolean bl2 = false;
        String string = this.getPattern();
        if (bl && dbValue instanceof DbDecimal) {
            BigDecimal bigDecimal = ((DbDecimal)dbValue).get();
            return this.formatBig(bigDecimal);
        }
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                long l = ((DbNumber)dbValue).longValue();
                return this.format(l);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                double d = ((DbNumber)dbValue).doubleValue();
                if (Double.isNaN(d)) {
                    return "NaN";
                }
                return this.format(d);
            }
        }
        return null;
    }

    public synchronized String format(DbValue dbValue, String string) {
        int n = dbValue.getSqlType();
        String string2 = null;
        switch (n) {
            case -6: {
                byte[] byArray = (byte[])((DbArray)dbValue).getValue();
                int n2 = 0;
                while (n2 < byArray.length) {
                    string2 = n2 == 0 ? this.format(byArray[n2]) : string2 + string + this.format(byArray[n2]);
                    ++n2;
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])((DbArray)dbValue).getValue();
                int n3 = 0;
                while (n3 < sArray.length) {
                    string2 = n3 == 0 ? this.format(sArray[n3]) : string2 + string + this.format(sArray[n3]);
                    ++n3;
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])((DbArray)dbValue).getValue();
                int n4 = 0;
                while (n4 < nArray.length) {
                    string2 = n4 == 0 ? this.format(nArray[n4]) : string2 + string + this.format(nArray[n4]);
                    ++n4;
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int n5 = 0;
                while (n5 < lArray.length) {
                    string2 = n5 == 0 ? this.format(lArray[n5]) : string2 + string + this.format(lArray[n5]);
                    ++n5;
                }
                break;
            }
            case 6: 
            case 7: {
                float[] fArray2 = (float[])((DbArray)dbValue).getValue();
                int n6 = 0;
                while (n6 < fArray2.length) {
                    string2 = n6 == 0 ? this.format(fArray2[n6]) : string2 + string + this.format(fArray2[n6]);
                    ++n6;
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])((DbArray)dbValue).getValue();
                int n7 = 0;
                while (n7 < dArray.length) {
                    string2 = n7 == 0 ? this.format(dArray[n7]) : string2 + string + this.format(dArray[n7]);
                    ++n7;
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])((DbArray)dbValue).getValue();
                int n8 = 0;
                while (n8 < bigDecimalArray.length) {
                    string2 = n8 == 0 ? this.format(bigDecimalArray[n8].doubleValue()) : string2 + string + this.format(bigDecimalArray[n8].doubleValue());
                    ++n8;
                }
                break;
            }
        }
        return string2;
    }

    public String getPattern() {
        return this.toPattern();
    }

    public String getLocalizedPattern() {
        return this.toLocalizedPattern();
    }

    public void applyPattern(String string) {
        super.applyPattern(string);
    }

    public void applyLocalizedPattern(String string) {
        super.applyLocalizedPattern(string);
    }

    private String QOIV(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            string = string.substring(0, n) + string.substring(n + string2.length());
        }
        return string;
    }

    public String formatBig(BigDecimal bigDecimal) {
        if (Env.ifHighJVM5) {
            return this.QOIV(this.format(bigDecimal), this.QOIV);
        }
        return this.jrFormatBig(bigDecimal);
    }

    public String jrFormatBig(BigDecimal bigDecimal) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getLocalizedPattern();
        this.applyLocalizedPattern(string);
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        boolean bl = bigDecimal != null ? bigDecimal.doubleValue() < 0.0 : false;
        int n = this.getGroupingSize();
        char c = decimalFormatSymbols.getGroupingSeparator();
        String string2 = this.getNegativeSuffix();
        String string3 = this.getNegativePrefix();
        String string4 = this.getPositivePrefix();
        String string5 = this.getPositiveSuffix();
        int n2 = this.getMaximumFractionDigits();
        char c2 = decimalFormatSymbols.getDecimalSeparator();
        char[] cArray = new char[50];
        cArray[0] = 46;
        int n3 = 1;
        while (n3 < 50) {
            cArray[n3] = 48;
            ++n3;
        }
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.abs().setScale(n2, 4);
        }
        String string6 = bigDecimal != null ? bigDecimal.toString() : "";
        StringBuffer stringBuffer2 = new StringBuffer(string6);
        int n4 = string6.indexOf(46);
        int n5 = n2 - (string6.length() - n4 - 1);
        if (n4 >= 0 || n2 > 0) {
            if (n4 < 0 && n2 > 0) {
                this.append(stringBuffer2, cArray, 0, n2 + 1);
            } else if (n5 > 0) {
                this.append(stringBuffer2, cArray, 1, n5);
            } else if (n5 < 0) {
                stringBuffer2.setLength(stringBuffer2.length() - n5 * -1);
            }
        }
        string6 = stringBuffer2.toString();
        int n6 = string6.length();
        stringBuffer.append(bl ? string2 : string5);
        if (n2 > 0) {
            string6.getChars(n6 - n2, n6, cArray, 0);
            this.insert(stringBuffer, 0, cArray, 0, n2);
            stringBuffer.insert(0, c2);
            n6 = n6 - n2 - 1;
        }
        if (n > 0) {
            while (n6 > n) {
                string6.getChars(n6 - n, n6, cArray, 0);
                this.insert(stringBuffer, 0, cArray, 0, n);
                stringBuffer.insert(0, c);
                n6 -= n;
            }
        }
        string6.getChars(0, n6, cArray, 0);
        this.insert(stringBuffer, 0, cArray, 0, n6);
        stringBuffer.insert(0, bl ? string3 : string4);
        String string7 = stringBuffer.toString();
        int n7 = string7.indexOf(this.QOIV);
        if (n7 != -1) {
            string7 = string7.substring(0, n7) + string7.substring(n7 + this.QOIV.length());
        }
        return string7;
    }

    public void insert(StringBuffer stringBuffer, int n, char[] cArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.insert(n + n4, cArray[n4 + n2]);
            ++n4;
        }
    }

    public void append(StringBuffer stringBuffer, char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(cArray[n3 + n]);
            ++n3;
        }
    }

    public void parse(DbValue dbValue, String string) throws ParseException {
        Number number = (Number)this.parseObject(string);
        switch (dbValue.getSqlType()) {
            case -5: {
                ((DbBigInt)dbValue).set(number.longValue());
                break;
            }
            case 5: {
                ((DbSmallInt)dbValue).set(number.shortValue());
                break;
            }
            case -6: {
                ((DbTinyInt)dbValue).set(number.byteValue());
                break;
            }
            case 4: {
                ((DbInteger)dbValue).set(number.intValue());
                break;
            }
            case 6: 
            case 7: {
                ((DbReal)dbValue).set(number.floatValue());
                break;
            }
            case 8: {
                ((DbDouble)dbValue).set(number.doubleValue());
                break;
            }
            case 2: 
            case 3: {
                ((DbDecimal)dbValue).set(new BigDecimal(number.doubleValue()));
            }
        }
    }

    public void parse(DbValue dbValue, String string, String string2) throws ParseException, SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        ArrayImpl arrayImpl = new ArrayImpl(dbValue.getSqlType(), this);
        arrayImpl.setValue(vector);
        ((DbArray)dbValue).set(arrayImpl);
    }
}

