/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.export.xml.FormatInfoToXML;
import jet.export.xml.LoadXSDException;
import jet.export.xml.XMLToFormatInfo;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.naming.EnumerationConstant;
import jet.naming.PropertyNameConstant;
import jet.report.JetRptArea;
import jet.report.JetRptAreaDBText;
import jet.report.JetRptAreaText;
import jet.report.JetRptMap;
import jet.reportLogic.objectInfo.AreaInfo;
import jet.reportLogic.objectInfo.AreaTextInfo;
import jet.reportLogic.objectInfo.GeometryObjInfo;
import jet.reportLogic.objectInfo.MapInfo;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.MapLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.SimpleComponentLogic;
import jet.util.ValueToUnit;

public class MapUtil {
    public static final int AREA_IMPORT_LIST = 0;
    public static final int AREA_IMPORT_MAXWIDTH = 1;
    public static final int AREA_IMPORT_MAXHEIGHT = 2;
    private static Font ALIGNMENT_HOR_STR_NAMES = null;

    public static boolean saveMapObjToXML(JetRptMap jetRptMap, File file) throws WriteFailureException, LoadXSDException {
        MapInfo mapInfo = ObjectLogicFactory.getMapLogic().getMapInfo(jetRptMap);
        return MapUtil.saveMapInfosToXML(mapInfo, file);
    }

    public static boolean saveAreaObjsToXML(List list, File file) throws WriteFailureException, LoadXSDException {
        MapUtil.saveAreaObjsToXML(list, true, file);
        return true;
    }

    public static JetRptMap loadMapObjFromXML(File file) throws ReadFailureException, LoadXSDException {
        XMLToFormatInfo xMLToFormatInfo = new XMLToFormatInfo();
        MapInfo mapInfo = (MapInfo)xMLToFormatInfo.loadFrom(file.getAbsolutePath());
        return ObjectLogicFactory.getMapLogic().createMapObject(mapInfo);
    }

    public static List loadAreaObjsFromXML(File file) throws ReadFailureException, LoadXSDException {
        return (List)MapUtil.loadAreaObjsFromXML(file, false, null)[0];
    }

    public static List LoadAreaObjsFromSHP() throws IOException {
        throw new UnsupportedOperationException("Right now");
    }

    public static boolean saveMapInfosToXML(MapInfo mapInfo, File file) throws WriteFailureException, LoadXSDException {
        FormatInfoToXML formatInfoToXML = new FormatInfoToXML();
        if (Boolean.valueOf(mapInfo.getPropertyVal("FromDatabase")).booleanValue()) {
            return false;
        }
        formatInfoToXML.storeTo(mapInfo, file.getAbsolutePath());
        return true;
    }

    public static boolean saveAreaInfosToXML(List list, File file) throws WriteFailureException, LoadXSDException {
        MapUtil.saveAreaInfosToXML(list, true, file);
        return true;
    }

    public static MapInfo loadMapInfosFromXML(File file) throws ReadFailureException, LoadXSDException {
        XMLToFormatInfo xMLToFormatInfo = new XMLToFormatInfo();
        return (MapInfo)xMLToFormatInfo.loadFrom(file.getAbsolutePath());
    }

    public static List loadAreaInfosFromXML(File file) throws ReadFailureException, LoadXSDException {
        return (List)MapUtil.loadAreaInfosFromXML(file, false, null)[0];
    }

    public static List LoadAreaInfosFromSHP() throws IOException {
        throw new UnsupportedOperationException("Right now");
    }

    public static void saveAreaObjsToXML(List list, boolean bl, File file) throws WriteFailureException, LoadXSDException {
        Vector<AreaInfo> vector = new Vector<AreaInfo>(list.size());
        MapLogic mapLogic = ObjectLogicFactory.getMapLogic();
        int n = 0;
        while (n < list.size()) {
            AreaInfo areaInfo = mapLogic.getAreaInfo((JetRptArea)list.get(n));
            if (!bl || !areaInfo.isDefaultArea()) {
                vector.add(areaInfo);
            }
            ++n;
        }
        MapUtil.saveAreaInfosToXML(vector, false, file);
    }

    public static void saveAreaInfosToXML(List list, boolean bl, File file) throws WriteFailureException, LoadXSDException {
        int n = list.size();
        int[] nArray = new int[]{0, 0};
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                AreaInfo areaInfo = (AreaInfo)list.get(n2);
                if (!areaInfo.isDefaultArea()) {
                    int[] nArray2 = MapUtil.ALIGNMENT_HOR_STR_NAMES(areaInfo);
                    if (nArray2[0] > nArray[0]) {
                        nArray[0] = nArray2[0];
                    }
                    if (nArray2[1] > nArray[1]) {
                        nArray[1] = nArray2[1];
                    }
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                AreaInfo areaInfo = (AreaInfo)list.get(n3);
                if (!areaInfo.isDefaultArea()) {
                    int[] nArray3 = MapUtil.ALIGNMENT_HOR_STR_NAMES(areaInfo);
                    if (nArray3[0] > nArray[0]) {
                        nArray[0] = nArray3[0];
                    }
                    if (nArray3[1] > nArray[1]) {
                        nArray[1] = nArray3[1];
                    }
                }
                ++n3;
            }
        }
        MapUtil.saveAreaInfosToXML(list, bl, nArray[0], nArray[1], file);
    }

    public static void saveAreaObjsToXML(List list, boolean bl, int n, int n2, File file) throws WriteFailureException, LoadXSDException {
        Vector<AreaInfo> vector = new Vector<AreaInfo>(list.size());
        MapLogic mapLogic = ObjectLogicFactory.getMapLogic();
        int n3 = 0;
        while (n3 < list.size()) {
            AreaInfo areaInfo = mapLogic.getAreaInfo((JetRptArea)list.get(n3));
            if (!bl || !areaInfo.isDefaultArea()) {
                vector.add(areaInfo);
            }
            ++n3;
        }
        MapUtil.saveAreaInfosToXML(vector, false, n, n2, file);
    }

    public static void saveAreaInfosToXML(List list, boolean bl, int n, int n2, File file) throws WriteFailureException, LoadXSDException {
        Vector<AreaInfo> vector = new Vector<AreaInfo>(list.size());
        if (bl) {
            int n3 = list.size();
            int n4 = 0;
            while (n4 < n3) {
                AreaInfo areaInfo = (AreaInfo)list.get(n4);
                if (!areaInfo.isDefaultArea()) {
                    vector.add(areaInfo);
                }
                ++n4;
            }
        } else {
            vector.addAll(list);
        }
        MapInfo mapInfo = new MapInfo();
        mapInfo.setActualSize(n, n2);
        mapInfo.resetAreaInfos(vector);
        FormatInfoToXML formatInfoToXML = new FormatInfoToXML();
        formatInfoToXML.storeTo(mapInfo, file.getAbsolutePath());
    }

    public static Object[] loadAreaInfosFromXML(File file, boolean bl, List list) throws ReadFailureException, LoadXSDException {
        Object object;
        XMLToFormatInfo xMLToFormatInfo = new XMLToFormatInfo();
        MapInfo mapInfo = (MapInfo)xMLToFormatInfo.loadFrom(file.getAbsolutePath());
        List list2 = mapInfo.getAreaInfos();
        boolean bl2 = false;
        int n = 0;
        while (n < list2.size()) {
            object = (AreaInfo)list2.get(n);
            ((AreaInfo)object).setProperty("UseDefault", "false", false);
            MapUtil.correctEmptyAreaInfo((AreaInfo)object, list);
            bl2 = bl2 || ((AreaInfo)object).isDefaultArea();
            ++n;
        }
        if (bl && !bl2) {
            list2.add(0, new AreaInfo(AreaInfo.AREATYPE_DEFAULT, null));
        }
        object = mapInfo.getActualSize();
        return new Object[]{list2, new Integer((int)object[0]), new Integer((int)object[1])};
    }

    public static Object[] loadAreaObjsFromXML(File file, boolean bl, List list) throws ReadFailureException, LoadXSDException {
        Object[] objectArray = MapUtil.loadAreaInfosFromXML(file, bl, list);
        List list2 = (List)objectArray[0];
        MapLogic mapLogic = ObjectLogicFactory.getMapLogic();
        int n = 0;
        while (n < list2.size()) {
            AreaInfo areaInfo = (AreaInfo)list2.get(n);
            list2.set(n, mapLogic.createAreaObject(areaInfo));
            ++n;
        }
        return objectArray;
    }

    private static int[] ALIGNMENT_HOR_STR_NAMES(AreaInfo areaInfo) {
        if (areaInfo.isDefaultArea() || areaInfo.isFromDataBase()) {
            return new int[]{0, 0};
        }
        int[] nArray = AreaInfo.parseAreaShapeCoordinate(areaInfo.getCoordinates());
        switch (areaInfo.getAreaType()) {
            case 2: {
                return new int[]{nArray[0] + nArray[2], nArray[1] + nArray[2]};
            }
            case 3: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (n < nArray[n3]) {
                        n = nArray[n3];
                    }
                    if (n2 < nArray[n3 + 1]) {
                        n2 = nArray[n3 + 1];
                    }
                    n3 += 2;
                }
                return new int[]{n, n2};
            }
            case 1: {
                return new int[]{nArray[0] + nArray[2], nArray[1] + nArray[3]};
            }
        }
        throw new IllegalArgumentException();
    }

    public static final int correctEmptyAreaObj(JetRptArea jetRptArea, List list) {
        Object object;
        int n;
        int n2;
        int n3;
        int[] nArray;
        if (jetRptArea.isDefaultTypeArea()) {
            return 0;
        }
        JetRptAreaDBText[] jetRptAreaDBTextArray = jetRptArea.getAllAreaDBTexts();
        JetRptAreaText jetRptAreaText = jetRptArea.getAreaText();
        if (jetRptAreaDBTextArray.length > 0 || jetRptAreaText != null) {
            return -1;
        }
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        SimpleComponentLogic simpleComponentLogic = ObjectLogicFactory.getSimpleComponentLogic();
        if (jetRptArea.coords.isChangeByOther()) {
            AreaTextInfo areaTextInfo = MapUtil.add(320, jetRptArea.name.get(), jetRptArea.name.isChangeByOther(), 0, 0, 6000, 1037, -1, -1, -1, -1);
            basicComponentLogic.add(jetRptArea, simpleComponentLogic.createAreaText(areaTextInfo));
            if (list != null) {
                int n4 = 0;
                while (n4 < list.size()) {
                    areaTextInfo = MapUtil.add(321, (String)list.get(n4), false, 0, 0, 6000, 1037, -1, -1, -1, -1);
                    basicComponentLogic.add(jetRptArea, simpleComponentLogic.createAreaDBText(areaTextInfo));
                    ++n4;
                }
            }
            return 1 + list.size();
        }
        int n5 = jetRptArea.type.intValue();
        double[] dArray = MapUtil.ALIGNMENT_VER_STR_NAMES(n5, nArray = jetRptArea.parseShapeInUnit());
        if (dArray[2] > 0.0) {
            n3 = (int)dArray[0];
            n2 = (int)dArray[1];
        } else {
            double d = Double.MAX_VALUE;
            double[] dArray2 = new double[2];
            n = 0;
            while (n < nArray.length) {
                double[] dArray3 = new double[]{nArray[n++], nArray[n++]};
                object = dArray3;
                double d2 = MapUtil.abs(object, dArray);
                if (!(d2 < d)) continue;
                dArray2 = object;
                d = d2;
            }
            n3 = (int)dArray2[0];
            n2 = (int)dArray2[1];
        }
        jetRptArea.forbidenEditOnProps();
        int n6 = -1;
        n6 = jetRptArea.name.isChangeByOther() ? MapUtil.addAll((String)jetRptArea.name.getChangeByObject()) : MapUtil.addAll(jetRptArea.name.get());
        int n7 = (int)(dArray[0] - (double)(n6 / 2));
        int n8 = (int)(dArray[1] - 518.0);
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        n = 0;
        object = null;
        object = jetRptArea.name.isChangeByOther() ? (Object)MapUtil.add(320, (String)jetRptArea.name.getChangeByObject(), true, n7, n8, n6, 1037, n3, n2, n7 + n6 / 2, n8) : (Object)MapUtil.add(320, jetRptArea.name.get(), false, n7, n8, n6, 1037, n3, n2, n7 + n6 / 2, n8);
        JetRptAreaText jetRptAreaText2 = simpleComponentLogic.createAreaText((AreaTextInfo)object);
        jetRptAreaText2.forbidenEditFlagOnProps();
        basicComponentLogic.add(jetRptArea, jetRptAreaText2);
        ++n;
        n7 = (int)(dArray[0] - 3000.0);
        if (list != null) {
            int n9 = 0;
            while (n9 < list.size()) {
                object = MapUtil.add(321, (String)list.get(n9), false, n7, n8 += 1037, 6000, 1037, n3, n2, n7 + 3000, n8);
                JetRptAreaDBText jetRptAreaDBText = simpleComponentLogic.createAreaDBText((AreaTextInfo)object);
                jetRptAreaDBText.forbidenEditOnProps();
                basicComponentLogic.add(jetRptArea, jetRptAreaDBText);
                ++n;
                ++n9;
            }
        }
        return n;
    }

    protected static final int correctEmptyAreaInfo(AreaInfo areaInfo, List list) {
        List list2;
        block11: {
            int n;
            int n2;
            int n3;
            int[] nArray;
            block10: {
                if (areaInfo.isDefaultArea()) {
                    return 0;
                }
                list2 = areaInfo.getAreaTextInfos();
                if (list2.size() > 0) {
                    return -1;
                }
                if (!areaInfo.isFromDataBase()) break block10;
                list2.add(MapUtil.add(320, areaInfo.getPropertyVal("Name"), areaInfo.isPropertyChangeBy("Name"), 0, 0, 6000, 1037, -1, -1, -1, -1));
                if (list == null) break block11;
                int n4 = 0;
                while (n4 < list.size()) {
                    list2.add(MapUtil.add(321, (String)list.get(n4), false, 0, 0, 6000, 1037, -1, -1, -1, -1));
                    ++n4;
                }
                break block11;
            }
            int n5 = areaInfo.getAreaType();
            double[] dArray = MapUtil.ALIGNMENT_VER_STR_NAMES(n5, nArray = AreaInfo.parseAreaShapeCoordinate(areaInfo.getCoordinates()));
            if (dArray[2] > 0.0) {
                n3 = (int)dArray[0];
                n2 = (int)dArray[1];
            } else {
                double d = Double.MAX_VALUE;
                double[] dArray2 = new double[2];
                n = 0;
                while (n < nArray.length) {
                    double[] dArray3 = new double[]{nArray[n++], nArray[n++]};
                    double[] dArray4 = dArray3;
                    double d2 = MapUtil.abs(dArray4, dArray);
                    if (!(d2 < d)) continue;
                    dArray2 = dArray4;
                    d = d2;
                }
                n3 = (int)dArray2[0];
                n2 = (int)dArray2[1];
            }
            int n6 = MapUtil.addAll(areaInfo.getPropertyVal("Name"));
            int n7 = (int)(dArray[0] - (double)(n6 / 2));
            int n8 = (int)(dArray[1] - 518.0);
            if (n7 < 0) {
                n7 = 0;
            }
            if (n8 < 0) {
                n8 = 0;
            }
            list2.add(MapUtil.add(320, areaInfo.getPropertyVal("Name"), areaInfo.isPropertyChangeBy("Name"), n7, n8, n6, 1037, n3, n2, n7 + n6 / 2, n8));
            n7 = (int)(dArray[0] - 3000.0);
            if (list != null) {
                n = 0;
                while (n < list.size()) {
                    list2.add(MapUtil.add(321, (String)list.get(n), false, n7, n8 += 1037, 6000, 1037, n3, n2, n7 + 3000, n8));
                    ++n;
                }
            }
        }
        return list2.size();
    }

    public static int[] parseAreaShapeCoordinate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, new String(","));
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                nArray[n2] = new Integer(string2.trim());
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JRLog.error(3, numberFormatException);
        }
        return nArray;
    }

    private static double[] ALIGNMENT_VER_STR_NAMES(int n, int[] nArray) {
        double[] dArray = null;
        switch (n) {
            case 2: {
                dArray = new double[]{nArray[0], nArray[1], 1.0};
                break;
            }
            case 3: {
                double[][] dArray2 = new double[nArray.length / 2][2];
                int n2 = 0;
                int n3 = 0;
                while (n2 < nArray.length) {
                    dArray2[n3][0] = nArray[n2++];
                    dArray2[n3][1] = nArray[n2++];
                    ++n3;
                }
                dArray = MapUtil.AREATYPE_DEFAULT(dArray2);
                break;
            }
            case 1: {
                double[][] dArray3 = new double[4][2];
                dArray3[0][0] = nArray[0];
                dArray3[0][1] = nArray[1];
                dArray3[1][0] = nArray[0] + nArray[2];
                dArray3[1][1] = nArray[1];
                dArray3[2][0] = nArray[0] + nArray[2];
                dArray3[2][1] = nArray[1] + nArray[3];
                dArray3[3][0] = nArray[0];
                dArray3[3][1] = nArray[1] + nArray[3];
                dArray = MapUtil.AREATYPE_DEFAULT(dArray3);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return dArray;
    }

    private static double[] AREATYPE_DEFAULT(double[][] dArray) {
        int n = dArray.length - 1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2][0] * dArray[n2 + 1][1] - dArray[n2 + 1][0] * dArray[n2][1];
            d4 = dArray[n2][0] * dArray[n2 + 1][1] - dArray[n2 + 1][0] * dArray[n2][1];
            d2 += (dArray[n2][0] + dArray[n2 + 1][0]) * d4;
            d3 += (dArray[n2][1] + dArray[n2 + 1][1]) * d4;
            ++n2;
        }
        d = d + dArray[n][0] * dArray[0][1] - dArray[0][0] * dArray[n][1];
        d4 = dArray[n][0] * dArray[0][1] - dArray[0][0] * dArray[n][1];
        double[] dArray2 = new double[]{Math.abs((d2 += (dArray[n][0] + dArray[0][0]) * d4) / (3.0 * d)), Math.abs((d3 += (dArray[n][1] + dArray[0][1]) * d4) / (3.0 * d))};
        boolean bl = MapUtil.QOIV(dArray, dArray2);
        return new double[]{dArray2[0], dArray2[1], bl ? 1.0 : 0.0};
    }

    /*
     * Unable to fully structure code
     */
    private static boolean QOIV(double[][] var0, double[] var1_1) {
        var2_2 = 0;
        var3_3 = var0.length;
        var4_4 = var0[var3_3 - 1][0];
        var6_5 = var0[var3_3 - 1][1];
        var12_6 = 0;
        while (var12_6 < var3_3) {
            block7: {
                block10: {
                    block11: {
                        block9: {
                            block8: {
                                var8_8 = var0[var12_6][0];
                                var10_9 = var0[var12_6][1];
                                if (var10_9 == var6_5) break block7;
                                if (!(var8_8 < var4_4)) break block8;
                                if (var1_1[0] >= var4_4) break block7;
                                var13_10 = var8_8;
                                break block9;
                            }
                            if (var1_1[0] >= var8_8) break block7;
                            var13_10 = var4_4;
                        }
                        if (!(var10_9 < var6_5)) break block10;
                        if (var1_1[1] < var10_9 || var1_1[1] >= var6_5) break block7;
                        if (!(var1_1[0] < var13_10)) break block11;
                        ++var2_2;
                        break block7;
                    }
                    var15_11 = var1_1[0] - var8_8;
                    var17_7 = var1_1[1] - var10_9;
                    ** GOTO lbl34
                }
                if (var1_1[1] < var6_5 || var1_1[1] >= var10_9) break block7;
                if (var1_1[0] < var13_10) {
                    ++var2_2;
                } else {
                    var15_11 = var1_1[0] - var4_4;
                    var17_7 = var1_1[0] - var6_5;
lbl34:
                    // 2 sources

                    if (var15_11 < var17_7 / (var6_5 - var10_9) * (var4_4 - var8_8)) {
                        ++var2_2;
                    }
                }
            }
            var4_4 = var8_8;
            var6_5 = var10_9;
            ++var12_6;
        }
        return (var2_2 & true) != false;
    }

    private static double abs(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        double d2 = dArray[1] - dArray2[1];
        double d3 = d * d + d2 * d2;
        return Math.sqrt(d3);
    }

    private static AreaTextInfo add(int n, String string, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        AreaTextInfo areaTextInfo = null;
        if (n == 320) {
            areaTextInfo = new AreaTextInfo(n, null);
            areaTextInfo.setTexture(string, bl);
        } else {
            areaTextInfo = new AreaTextInfo(n, string);
        }
        areaTextInfo.setLocation(n2, n3);
        areaTextInfo.setSize(n4, n5);
        areaTextInfo.setProperty("UseDefault", "false", false);
        areaTextInfo.setProperty(PropertyNameConstant.getNameByID(979), EnumerationConstant.ALIGNMENT_HOR_STR_NAMES[2], false);
        areaTextInfo.setProperty(PropertyNameConstant.getNameByID(1760), EnumerationConstant.ALIGNMENT_VER_STR_NAMES[0], false);
        GeometryObjInfo geometryObjInfo = new GeometryObjInfo(322);
        geometryObjInfo.appendAttachPos(null, n6, n7);
        geometryObjInfo.appendAttachPos(null, n8, n9);
        Vector<GeometryObjInfo> vector = new Vector<GeometryObjInfo>();
        vector.add(geometryObjInfo);
        areaTextInfo.setGeometryInfos(vector);
        return areaTextInfo;
    }

    private static int addAll(String string) {
        if (ALIGNMENT_HOR_STR_NAMES == null) {
            ALIGNMENT_HOR_STR_NAMES = new Font(null, 0, ValueToUnit.convertInchToPixel(0.125));
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(ALIGNMENT_HOR_STR_NAMES);
        return ValueToUnit.convertPixelToUnit(fontMetrics.stringWidth(string));
    }
}

