/*
 * Decompiled with CFR 0.152.
 */
package chart.axis;

import chart.ChartLabelBase;
import chart.ChartObject;
import chart.axis.ChartAxisArrowStyle;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.data.ChartDataFilter;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartAxisProperties;
import chart.properties.ChartNumericAxisProperties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class ChartAxis
extends ChartObject {
    public static final int TICK_TYPE_NONE = 0;
    public static final int TICK_TYPE_OUTSIDE = 1;
    public static final int TICK_TYPE_INSIDE = 2;
    public static final int TICK_TYPE_CROSS = 3;
    public static final int POSITION_NONE = 0;
    public static final int POSITION_TOP = 1;
    public static final int POSITION_LEFT = 2;
    public static final int POSITION_BOTTOM = 3;
    public static final int POSITION_RIGHT = 4;
    public static final int POSITION_3D_AUTO = 5;
    public static final int LABEL_TYPE_OUTSIDE = 0;
    public static final int LABEL_TYPE_INSIDE = 1;
    public static final int AXIS_UNIT_DATE = 1;
    public static final int AXIS_UNIT_NUMBER = 2;
    public static final int AXIS_DATE_UNIT_YEAR = 0;
    public static final int AXIS_DATE_UNIT_QUARTER = 1;
    public static final int AXIS_DATE_UNIT_MONTH = 2;
    public static final int AXIS_DATE_UNIT_WEEK = 3;
    public static final int AXIS_DATE_UNIT_DAY = 4;
    public static final int AXIS_DATE_UNIT_HOUR = 5;
    public static final int AXIS_DATE_UNIT_MINUTE = 6;
    public static final int AXIS_DATE_UNIT_SECOND = 7;
    protected float[][] axisPoint;
    protected float[][] majorTickMarkPoint;
    protected float[][] minorTickMarkPoint;
    protected float[][] labelPoint;
    private int[][] IsLabelFontAutomaticOrientation;
    private int IsShowLabelTips;
    private int SEDU = -1;
    private double abs;
    protected int position;
    private Line2D.Float add;
    private float atan;
    protected ChartAxisProperties properties;
    protected ChartDataFilter filter;
    protected ChartLabelBase[] paintingLabels;
    protected ChartTextStyle textStyle;
    private boolean bestLabelPostion;
    private Point2D.Double[][] bottomToTop;
    private int calBaseUnit;
    protected int paintLabelLength;
    protected int numOfTicks;
    protected int paintingLabelsLength;
    private float calculateAxisOffset;
    private float calculateCategoryRotateLabelOffset;
    protected boolean isDepth = false;
    protected double orignRotate = 0.0;
    protected int minorTickNumber = 0;
    protected ChartTextStyle majorTextStyle;
    protected ChartTextStyle minorTextStyle;
    protected boolean correlatedMajorTickMark;
    protected boolean correlatedMinorTickMark;
    protected boolean correlatedMinorLabel;
    protected boolean initedLabelStyle = false;
    public static final int POSITION_AXIS_BETWEEN_TICKMARKS = 1;
    public static final int POSITION_AXIS_ON_TICKMARKS = 0;
    protected boolean labelAutoRotate = false;
    protected double rotation = 0.0;
    protected double monirrotation = 0.0;
    public double[] tickmarkValue;
    public int scrollTickmarkIdx = 0;
    public boolean unScroll = true;
    boolean calculateLabelsDimension = false;
    float ceil = 200.0f;
    int[] clearLabelBaseDimension = null;
    public int labN = -1;
    boolean I = true;
    protected Dimension rect;
    protected boolean firstIni = true;
    protected int firstSkip = -1;
    private float clone = -1.0f;
    int Z = -1;
    float C = 0.0f;
    float B = 60.0f;

    ChartAxis(ChartAxisProperties chartAxisProperties) {
        this.properties = chartAxisProperties;
    }

    @Override
    public void init() {
        this.paintingLabelsLength = this.paintingLabels.length;
        this.IsShowLabelTips = 0;
        this.textStyle = (ChartTextStyle)this.properties.getLabelTextStyle().clone();
        this.add = new Line2D.Float();
        this.axisPoint = new float[2][2];
        this.calculateAxisOffset = 0.0f;
        this.calculateCategoryRotateLabelOffset = 0.0f;
        if (this.properties.isShowTickMarkLabels()) {
            this.IsLabelFontAutomaticOrientation = new int[this.paintingLabelsLength][2];
            this.bottomToTop = new Point2D.Double[this.paintingLabelsLength][4];
            this.calBaseUnit = this.properties.getLabelEveryNTickMarks();
            this.calBaseUnit = this.calBaseUnit > 1 ? this.calBaseUnit : 1;
            this.orignRotate = this.textStyle.getRotation();
            double d = this.formatAngle(this.textStyle.getRotation());
            this.textStyle.setRotation(d);
            if (d != 0.0 && this.textStyle.getWordWrapper()) {
                this.textStyle.setWordWrapper(false);
                this.properties.getLabelTextStyle().setWordWrapper(false);
            }
        }
    }

    @Override
    public void locate() {
        this.setWrapWidth();
        if (this.properties.isShowTickMarkLabels() && this.position != 0) {
            if (this.labelAutoRotate && this.properties.IsLabelFontAutomaticOrientation() && this.textStyle != null) {
                this.textStyle.setRotation(-0.5235987755982988);
            }
            this.labelsLocate();
        }
        this.calculateLabelsDimension = true;
    }

    public void setWrapWidth() {
        if (!this.custommerConstant()) {
            if (this.textStyle.getWordWrapper() && this.SEDU > 0) {
                this.textStyle.setWordWrap(this.calBaseUnit > 1 ? (float)(this.calBaseUnit * this.SEDU) : (float)this.SEDU);
            }
        } else {
            if (this.majorTextStyle != null && this.majorTextStyle.getWordWrapper() && this.SEDU > 0) {
                this.majorTextStyle.setWordWrap(this.SEDU);
            }
            if (this.minorTextStyle != null && this.minorTextStyle.getWordWrapper() && this.SEDU > 0) {
                this.minorTextStyle.setWordWrap(this.SEDU);
            }
            if (this.textStyle.getWordWrapper() && this.SEDU > 0) {
                this.textStyle.setWordWrap(this.SEDU);
            }
            if (this.isScroll() && this instanceof ChartCategoryAxis) {
                int n = this.paintingLabelsLength;
                int n2 = n = n == 0 ? 1 : n;
                if (this.majorTextStyle != null && this.majorTextStyle.getWordWrapper() && this.SEDU > 0) {
                    this.majorTextStyle.setWordWrap(this.SEDU / n);
                }
                if (this.textStyle.getWordWrapper() && this.SEDU > 0) {
                    this.textStyle.setWordWrap(this.SEDU / n);
                }
                if (this.minorTextStyle != null && this.minorTextStyle.getWordWrapper() && this.SEDU > 0) {
                    this.minorTextStyle.setWordWrap(this.SEDU / n);
                }
            }
        }
    }

    public Dimension getMaxDimensionOfLabelsFor3D() {
        this.resetTextStyle();
        if (!this.initedLabelStyle) {
            this.setPaintingLabelTextStyle(this.textStyle);
        }
        Dimension dimension = new Dimension();
        if (this.paintingLabels != null) {
            if (this.textStyle.getWordWrapper() && this.SEDU > 0) {
                this.textStyle.setWordWrap(this.SEDU);
            }
            float[] fArray = this.calculateLabelsDimension();
            dimension.width = (int)fArray[0];
            dimension.height = (int)fArray[1];
        }
        return dimension;
    }

    public Dimension getMaxDimensionOfLabels() {
        this.resetTextStyle();
        if (!this.initedLabelStyle) {
            this.setPaintingLabelTextStyle(this.textStyle);
        }
        Dimension dimension = new Dimension();
        if (this.paintingLabels != null) {
            if (this.textStyle.getWordWrapper() && this.SEDU > 0) {
                this.textStyle.setWordWrap(this.SEDU);
            }
            if (this.properties.getLabelPosition() == 1) {
                dimension.width = 0;
                dimension.height = 0;
                return dimension;
            }
            float[] fArray = this.calculateLabelsDimension();
            dimension.width = (int)fArray[0];
            dimension.height = (int)fArray[1];
        }
        return dimension;
    }

    public double getAxisFristLabelWidht() {
        if (this.paintingLabels == null) {
            return 0.0;
        }
        if (this.paintingLabels.length == 0) {
            return 0.0;
        }
        double d = this.textStyle.getDimension(this.paintingLabels[0].getLabelText()).getWidth();
        return d;
    }

    public double getBottomAxisFristLabelWidht() {
        if (this.paintingLabels == null) {
            return 0.0;
        }
        if (this.paintingLabels.length == 0) {
            return 0.0;
        }
        double d = 0.0;
        d = !this.initedLabelStyle ? this.textStyle.getDimension(this.paintingLabels[0].getLabelText()).getWidth() : this.paintingLabels[0].getChartTextStyle().getDimension(this.paintingLabels[0].getLabelText()).getWidth();
        double d2 = this.formatAngle(this.textStyle.getRotation());
        if (d2 != 0.0) {
            if (d2 > 0.0 && d2 <= 1.5707963267948966 || d2 >= Math.PI && d2 < 4.71238898038469) {
                return 0.0;
            }
            return d * 2.0;
        }
        this.getAxisLength();
        return d;
    }

    public double getAxisLastLabelWidht() {
        if (this.paintingLabels == null) {
            return 0.0;
        }
        if (this.paintingLabels.length == 0 || this.paintingLabels.length == 1) {
            return 0.0;
        }
        double d = this.textStyle.getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getWidth();
        return d;
    }

    public double getBottomAxisLastLabelWidht() {
        if (this.paintingLabels == null) {
            return 0.0;
        }
        if (this.paintingLabels.length == 0 || this.paintingLabels.length == 1) {
            return 0.0;
        }
        double d = 0.0;
        d = !this.initedLabelStyle ? this.textStyle.getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getWidth() : this.paintingLabels[this.paintingLabels.length - 1].getChartTextStyle().getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getWidth();
        double d2 = this.formatAngle(this.textStyle.getRotation());
        if (d2 != 0.0) {
            if (d2 >= 1.5707963267948966 && d2 < Math.PI || d2 >= 4.71238898038469 && d2 < Math.PI * 2) {
                return 0.0;
            }
            return d * 2.0;
        }
        return d;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.position == 0) {
            return;
        }
        this.locate();
        this.drawAxis(graphics2D, this.axisPoint);
        if (this.properties.isShowTickMarkLabels()) {
            this.drawLabels(graphics2D);
        }
        if (this.properties.getTickMarkType() != 0) {
            this.drawTickMark(graphics2D, this.properties.getTickMarkPen(), this.majorTickMarkPoint, this.properties.getTickMarkLength(), this.properties.getTickMarkType(), this.numOfTicks);
        }
        if (this.properties.getMinorTickMarkType() != 0) {
            this.drawTickMark(graphics2D, this.properties.getMinorTickMarkProperties().getTickMarkPen(), this.minorTickMarkPoint, this.properties.getMinorTickMarkLength(), this.properties.getMinorTickMarkType(), this.numOfTicks - 1);
        }
    }

    protected void drawAxis(Graphics2D graphics2D, float[][] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        generalPath.lineTo(fArray[1][0], fArray[1][1]);
        this.properties.getAxisPen().draw(graphics2D, generalPath);
        this.add.setLine(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
        if (!(this instanceof ChartCategoryAxis) && this.IsShowLabelTips != 0) {
            double d = this.atan(fArray[1][1] - fArray[0][1], fArray[1][0] - fArray[0][0]);
            ChartAxisArrowStyle chartAxisArrowStyle = new ChartAxisArrowStyle(this.IsShowLabelTips);
            chartAxisArrowStyle.draw(graphics2D, (int)fArray[1][0], (int)fArray[1][1], d -= 1.5707963267948966);
        }
    }

    protected void drawTickMark(Graphics2D graphics2D, ChartPenStyle chartPenStyle, float[][] fArray, float f, int n, int n2) {
        ChartPenStyle chartPenStyle2;
        if (fArray == null || fArray.length == 0) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float[] fArray2 = new float[2];
        float f6 = this.getAxisAngle();
        f6 = (float)((double)f6 + 1.5707963267948966);
        f6 = (float)((double)f6 - ((double)f6 > Math.PI * 2 ? Math.PI * 2 : 0.0));
        float f7 = (float)Math.cos(f6);
        float f8 = (float)Math.sin(f6);
        ChartPenStyle chartPenStyle3 = null;
        chartPenStyle3 = chartPenStyle2 = (ChartPenStyle)chartPenStyle.clone();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            float f9 = f;
            fArray2[0] = fArray[i][0];
            fArray2[1] = fArray[i][1];
            generalPath.reset();
            switch (n) {
                case 1: {
                    f2 = fArray2[0] + (float)Math.round(f7 * f9);
                    f3 = fArray2[1] - (float)Math.round(f8 * f9);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(fArray2[0], fArray2[1]);
                    break;
                }
                case 2: {
                    f2 = fArray2[0] - (float)Math.round(f7 * f9);
                    f3 = fArray2[1] + (float)Math.round(f8 * f9);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(fArray2[0], fArray2[1]);
                    break;
                }
                case 3: {
                    f2 = fArray2[0] - (float)Math.round(f7 * (f9 + 1.0f) / 2.0f);
                    f3 = fArray2[1] + (float)Math.round(f8 * (f9 + 1.0f) / 2.0f);
                    f4 = fArray2[0] + (float)Math.round(f7 * (f9 + 1.0f) / 2.0f);
                    f5 = fArray2[1] - (float)Math.round(f8 * (f9 + 1.0f) / 2.0f);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(f4, f5);
                    break;
                }
                case 0: {
                    break;
                }
            }
            chartPenStyle3.draw(graphics2D, generalPath);
        }
    }

    protected boolean bestLabelPostion(int n, int n2, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2) {
        int n3;
        Point2D.Double[] doubleArray3 = new Point2D.Double[]{new Point2D.Double(doubleArray[0].x, doubleArray[0].y), new Point2D.Double(doubleArray[1].x, doubleArray[1].y), new Point2D.Double(doubleArray[2].x, doubleArray[2].y), new Point2D.Double(doubleArray[3].x, doubleArray[3].y), new Point2D.Double((doubleArray[0].x + doubleArray[2].x) / 2.0, (doubleArray[0].y + doubleArray[2].y) / 2.0)};
        Point2D.Double[] doubleArray4 = new Point2D.Double[]{new Point2D.Double(doubleArray2[0].x, doubleArray2[0].y), new Point2D.Double(doubleArray2[1].x, doubleArray2[1].y), new Point2D.Double(doubleArray2[2].x, doubleArray2[2].y), new Point2D.Double(doubleArray2[3].x, doubleArray2[3].y), new Point2D.Double((doubleArray2[0].x + doubleArray2[2].x) / 2.0, (doubleArray2[0].y + doubleArray2[2].y) / 2.0)};
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.bottomToTop[n2][0].x, (float)this.bottomToTop[n2][0].y);
        generalPath.lineTo((float)this.bottomToTop[n2][1].x, (float)this.bottomToTop[n2][1].y);
        generalPath.lineTo((float)this.bottomToTop[n2][2].x, (float)this.bottomToTop[n2][2].y);
        generalPath.lineTo((float)this.bottomToTop[n2][3].x, (float)this.bottomToTop[n2][3].y);
        generalPath.closePath();
        for (n3 = 0; n3 < doubleArray3.length; ++n3) {
            if (!generalPath.contains(doubleArray3[n3])) continue;
            return true;
        }
        generalPath.reset();
        generalPath.moveTo((float)this.bottomToTop[n][0].x, (float)this.bottomToTop[n][0].y);
        generalPath.lineTo((float)this.bottomToTop[n][1].x, (float)this.bottomToTop[n][1].y);
        generalPath.lineTo((float)this.bottomToTop[n][2].x, (float)this.bottomToTop[n][2].y);
        generalPath.lineTo((float)this.bottomToTop[n][3].x, (float)this.bottomToTop[n][3].y);
        generalPath.closePath();
        for (n3 = 0; n3 < doubleArray4.length; ++n3) {
            if (!generalPath.contains(doubleArray4[n3])) continue;
            return true;
        }
        Line2D.Double double_ = new Line2D.Double(doubleArray3[0], doubleArray3[2]);
        Line2D.Double double_2 = new Line2D.Double(doubleArray4[0], doubleArray4[2]);
        return double_.intersectsLine(double_2);
    }

    protected void drawLabels(Graphics2D graphics2D) {
        block14: {
            int n;
            block15: {
                block13: {
                    if (!this.isScroll() || !this.custommerConstant() || this.minorTickNumber <= 0) break block13;
                    int n2 = 0;
                    int n3 = this.calBaseUnit;
                    n3 = n3 <= 0 ? 1 : n3;
                    int n4 = this.properties.getMinorTickMarkProperties().getLabelEveryTickMark();
                    n4 = n4 <= 0 ? 1 : n4;
                    int n5 = 0;
                    for (int i = 0; i < this.paintLabelLength; ++i) {
                        if (this.paintingLabels[i] == null) continue;
                        if ((i + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) == 0) {
                            n5 = (i + this.scrollTickmarkIdx) / (this.minorTickNumber + 1);
                            if (n3 > 1 && n5 > 0 && n5 % n3 != 0) {
                                continue;
                            }
                        } else {
                            if (!this.properties.getMinorTickMarkProperties().getShowMarkLabels()) continue;
                            n5 = (i + this.scrollTickmarkIdx) % (this.minorTickNumber + 1);
                            if (n4 > 1 && (n5 - 1) % n4 != 0 && n5 > 1) continue;
                        }
                        if (this.properties.isBestEffort()) {
                            boolean bl = false;
                            boolean bl2 = bl = i > 0 && this.bestLabelPostion(n2, i, this.bottomToTop[n2], this.bottomToTop[i]);
                            if (bl) continue;
                            n2 = i;
                            this.drawLabel(graphics2D, this.paintingLabels[i], this.IsLabelFontAutomaticOrientation[i]);
                            continue;
                        }
                        this.drawLabel(graphics2D, this.paintingLabels[i], this.IsLabelFontAutomaticOrientation[i]);
                    }
                    break block14;
                }
                if (!this.custommerConstant() || this.minorTickNumber <= 0) break block15;
                int n6 = 0;
                int n7 = 0;
                int n8 = this.calBaseUnit;
                n8 = n8 <= 0 ? 1 : n8;
                int n9 = this.properties.getMinorTickMarkProperties().getLabelEveryTickMark();
                n9 = n9 <= 0 ? 1 : n9;
                for (int i = 0; i < this.paintLabelLength; ++i) {
                    if (this.paintingLabels[i] == null) continue;
                    if (i % (this.minorTickNumber + 1) == 0) {
                        n6 = i / (this.minorTickNumber + 1);
                        if (n8 > 1 && n6 > 0 && n6 % n8 != 0) {
                            continue;
                        }
                    } else {
                        if (!this.properties.getMinorTickMarkProperties().getShowMarkLabels()) continue;
                        n6 = i % (this.minorTickNumber + 1);
                        if (n9 > 1 && (n6 - 1) % n9 != 0 && n6 > 1) continue;
                    }
                    if (this.properties.isBestEffort()) {
                        boolean bl = false;
                        boolean bl3 = bl = i > 0 && this.bestLabelPostion(n7, i, this.bottomToTop[n7], this.bottomToTop[i]);
                        if (bl) continue;
                        n7 = i;
                        this.drawLabel(graphics2D, i);
                        continue;
                    }
                    this.drawLabel(graphics2D, i);
                }
                break block14;
            }
            int n10 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < this.paintLabelLength; n += this.calBaseUnit) {
                if (this.paintingLabels[n] == null) continue;
                if (this.properties.isBestEffort()) {
                    boolean bl = false;
                    boolean bl4 = bl = n > 0 && this.bestLabelPostion(n10, n, this.bottomToTop[n10], this.bottomToTop[n]);
                    if (bl) continue;
                    n10 = n;
                    this.drawLabel(graphics2D, n);
                    arrayList.add(new Integer(n));
                    continue;
                }
                this.drawLabel(graphics2D, n);
            }
            if (arrayList == null || arrayList.size() <= 0 || this.clearLabelBaseDimension != null) break block14;
            this.clearLabelBaseDimension = new int[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.clearLabelBaseDimension[n] = (Integer)arrayList.get(n);
            }
        }
    }

    protected void drawLabel(Graphics2D graphics2D, ChartLabelBase chartLabelBase, int[] nArray) {
        if (chartLabelBase.getChartTextStyle() == null || nArray == null) {
            return;
        }
        chartLabelBase.locate();
        double d = chartLabelBase.getChartTextStyle().getRotation();
        if (d % Math.PI * 2.0 == 0.0 && !this.properties.getLabelTextStyle().getWordWrapper()) {
            chartLabelBase.paintTextNoRotation(graphics2D, nArray[0], nArray[1]);
        } else {
            chartLabelBase.paint(graphics2D, nArray[0], nArray[1]);
        }
        chartLabelBase.clearLabelBaseDimension();
    }

    protected void drawLabel(Graphics2D graphics2D, int n) {
        this.paintingLabels[n].locate();
        double d = this.properties.getLabelTextStyle().getRotation();
        if (this.properties.IsLabelFontAutomaticOrientation() && this.textStyle != null) {
            d = this.textStyle.getRotation();
        }
        if (this.minorTextStyle != null && this.initedLabelStyle && this.minorTickNumber > 0 && n % (this.minorTickNumber + 1) != 0) {
            d = this.minorTextStyle.getRotation();
        }
        if (d % Math.PI * 2.0 == 0.0 && !this.properties.getLabelTextStyle().getWordWrapper()) {
            this.paintingLabels[n].paintTextNoRotation(graphics2D, this.IsLabelFontAutomaticOrientation[n][0], this.IsLabelFontAutomaticOrientation[n][1]);
        } else {
            this.paintingLabels[n].paint(graphics2D, this.IsLabelFontAutomaticOrientation[n][0], this.IsLabelFontAutomaticOrientation[n][1]);
        }
        this.paintingLabels[n].clearLabelBaseDimension();
    }

    protected void labelsLocate() {
        int n;
        ChartNumericAxisProperties chartNumericAxisProperties;
        float f = this.getAxisAngle();
        this.abs = f;
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        int n2 = this.properties.getNumOfLabels();
        if (this.custommerConstant() && this.minorTickNumber > 0 && !this.properties.getMajorTickMarkProperties().getAutoLabelNumber()) {
            int n3 = this.properties.getMajorTickMarkProperties().getLabelEveryTickMark();
            int n4 = this.properties.getMajorTickMarkProperties().getLabelNumber();
            if ((n4 = n4 * n3 * (this.minorTickNumber + 1)) > n2) {
                n2 = n4;
            }
        }
        this.paintLabelLength = this.paintingLabelsLength;
        int n5 = n2 = n2 > this.paintLabelLength ? this.paintLabelLength : n2;
        if (!(this instanceof ChartNumericAxis)) {
            this.paintLabelLength = this.properties.getMajorTickMarkProperties().getAutoLabelNumber() ? this.paintingLabelsLength : (n2 < 0 ? 0 : n2);
        } else if (this.properties.getMajorTickMarkProperties().getAutoLabelNumber()) {
            this.paintLabelLength = this.paintingLabelsLength;
        } else {
            int n6 = this.paintLabelLength = n2 < 0 ? 0 : n2;
        }
        if (this instanceof ChartNumericAxis && (chartNumericAxisProperties = (ChartNumericAxisProperties)this.properties).getNumOfTickMarks() > 0) {
            this.numOfTicks = chartNumericAxisProperties.getNumOfTickMarks() + 1;
            this.numOfTicks = this.numOfTicks > this.paintingLabelsLength ? this.paintingLabelsLength : this.numOfTicks;
            this.paintLabelLength = this.paintLabelLength > this.numOfTicks ? this.numOfTicks : this.paintLabelLength;
        }
        this.paintLabelLength = this.paintLabelLength > this.paintingLabelsLength ? this.paintingLabelsLength : this.paintLabelLength;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.paintingLabels != null && this.paintingLabels.length > 0) {
            for (n = 0; n < this.paintingLabelsLength; n += this.calBaseUnit) {
                if (this.paintingLabels[n] == null) continue;
                n8 = this.paintingLabels[n].getLabelText().length();
                n9 = n7 > n8 ? n9 : n;
                n7 = n7 > n8 ? n7 : n8;
            }
            f4 = (float)this.textStyle.getDimension(this.paintingLabels[n9].getLabelText()).getHeight();
        }
        f5 = f4;
        n = this.calBaseUnit;
        if (this.custommerConstant() && this.minorTickNumber > 0) {
            n = 1;
        }
        for (int i = 0; i < this.paintLabelLength; i += n) {
            if (this.paintingLabels[i] == null) continue;
            if (this.custommerConstant() && this.paintingLabels[i].getChartTextStyle() != null) {
                f5 = (float)this.paintingLabels[i].getChartTextStyle().getDimension(this.paintingLabels[n9].getLabelText()).getHeight();
            }
            this.labelLocate(this.paintingLabels[i], this.labelPoint[i], f2, f3, i, f5);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void labelLocate(ChartLabelBase chartLabelBase, float[] fArray, float f, float f2, int n, float f3) {
        Rectangle2D.Float float_;
        double d;
        float[] fArray2;
        float f4;
        float f5;
        block33: {
            float f6;
            float f7 = 0.0f;
            f5 = 0.0f;
            f4 = 0.0f;
            fArray2 = new float[2];
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (this.correlatedMajorTickMark && n % (this.minorTickNumber + 1) == 0) {
                switch (this.getProperties().getMajorTickMarkProperties().getTickMarkType()) {
                    case 1: {
                        f8 = this.getProperties().getMajorTickMarkProperties().getTickMarkLength();
                        break;
                    }
                    case 2: {
                        f8 = 0.0f;
                        break;
                    }
                    case 3: {
                        f8 = this.getProperties().getMajorTickMarkProperties().getTickMarkLength() / 2.0f;
                        break;
                    }
                }
                f9 = f9 < f8 ? f8 : f9;
            } else if (this.correlatedMinorTickMark && n % (this.minorTickNumber + 1) != 0) {
                switch (this.getProperties().getMinorTickMarkProperties().getTickMarkType()) {
                    case 1: {
                        f8 = this.getProperties().getMinorTickMarkProperties().getTickMarkLength();
                        break;
                    }
                    case 2: {
                        f8 = 0.0f;
                        break;
                    }
                    case 3: {
                        f8 = this.getProperties().getMinorTickMarkProperties().getTickMarkLength() / 2.0f;
                        break;
                    }
                }
                f9 = f9 < f8 ? f8 : f9;
            } else {
                switch (this.properties.getTickMarkType()) {
                    case 1: {
                        f9 = this.properties.getTickMarkLength();
                        break;
                    }
                    case 2: {
                        f9 = 0.0f;
                        break;
                    }
                    case 3: {
                        f9 = this.properties.getTickMarkLength() / 2.0f;
                        break;
                    }
                }
            }
            float f10 = this.properties.getLabelAxisGap();
            d = this.textStyle.getRotation();
            if (this.initedLabelStyle && this.minorTickNumber > 0 && (n + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) != 0) {
                d = chartLabelBase.getChartTextStyle().getRotation();
            }
            d = this.formatAngle(d);
            float_ = !this.initedLabelStyle ? (Rectangle2D.Float)this.textStyle.getDimension(chartLabelBase.getLabelText()) : (Rectangle2D.Float)chartLabelBase.getChartTextStyle().getDimension(chartLabelBase.getLabelText());
            float f11 = this.textStyle.getShearing();
            if (f11 != 0.0f) {
                this.textStyle.setRotation(0.0);
                f6 = float_.width;
                this.textStyle.setShearing(0.0f);
                if (chartLabelBase.getChartTextStyle() == null) {
                    chartLabelBase.setChartTextStyle(this.textStyle);
                }
                this.atan = f6 - (float)this.textStyle.getDimension(chartLabelBase.getLabelText()).getWidth();
                this.textStyle.setShearing(f11);
                if (d != 0.0 && d % 1.5707963267948966 == 0.0) {
                    d -= Math.PI / 360;
                }
                this.textStyle.setRotation(d);
                if (chartLabelBase.getChartTextStyle() == null) {
                    chartLabelBase.setChartTextStyle(this.textStyle);
                }
            }
            switch (this.properties.getLabelPosition()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.isDepth || this.majorTickMarkPoint == null || this.majorTickMarkPoint.length != this.paintLabelLength) break;
                    this.calculateAxisOffset(chartLabelBase);
                    break;
                }
            }
            if (d != 0.0 && this.majorTickMarkPoint != null) {
                if (this.majorTickMarkPoint.length == this.paintLabelLength || this.position == 5) {
                    fArray2 = this.rotateLabel(fArray, f5, f4, f7, d, f2, f, f9, chartLabelBase.getLabelText(), float_);
                    f5 = fArray2[0] + this.calculateAxisOffset;
                    f4 = fArray2[1] - this.calculateCategoryRotateLabelOffset;
                    break block33;
                } else {
                    f6 = this.properties.getTickMarkType() != 3 ? this.properties.getTickMarkLength() : this.properties.getTickMarkLength() / 2.0f;
                    fArray2 = this.calculateCategoryRotateLabelOffset(this.majorTickMarkPoint[n], float_.width, float_.height, f6, f10, this.orignRotate, this.properties.getLabelPosition(), Math.sin(d));
                    f5 = fArray2[0];
                    f4 = fArray2[1];
                    this.IsShowLabelTips(n, f5 += this.calculateAxisOffset, f4 -= this.calculateCategoryRotateLabelOffset, chartLabelBase, float_);
                    this.IsLabelFontAutomaticOrientation[n][0] = (int)f5;
                    this.IsLabelFontAutomaticOrientation[n][1] = (int)f4;
                    return;
                }
            }
            f7 = (f2 + 1.0f) / 2.0f * float_.width + f2 * f9;
            f5 = fArray[0] - (float)Math.round(f2 * f10) - f7 + this.calculateAxisOffset;
            f4 = fArray[1] - f * f10 - f * f9 - this.calculateCategoryRotateLabelOffset;
            f4 = !this.properties.getLabelTextStyle().getWordWrapper() ? (f4 -= (f - 1.0f) / 2.0f * f3) : (f4 -= (f + 1.0f) / 2.0f * float_.height);
            if (this.majorTickMarkPoint != null && this.majorTickMarkPoint.length != this.paintLabelLength && this.properties.getLabelPosition() != 0) {
                f6 = this.properties.getTickMarkType() != 3 ? this.properties.getTickMarkLength() : this.properties.getTickMarkLength() / 2.0f;
                float[] fArray3 = this.IsLabelFontAutomaticOrientation(float_.width, float_.height, f10, f6);
                f5 += fArray3[0];
                f4 += fArray3[1];
            }
        }
        if (d > 0.0) {
            fArray2 = this.labelPositionTransform(d, f5, f4, float_.width, float_.height);
            f5 = fArray2[0];
            f4 = fArray2[1];
        }
        this.IsShowLabelTips(n, f5, f4, chartLabelBase, float_);
        this.IsLabelFontAutomaticOrientation[n][0] = (int)f5;
        this.IsLabelFontAutomaticOrientation[n][1] = (int)f4;
    }

    float[] IsLabelFontAutomaticOrientation(float f, float f2, float f3, float f4) {
        float[] fArray = new float[]{0.0f, 0.0f};
        switch (this.position) {
            case 3: {
                fArray[1] = fArray[1] - (f2 + 2.0f * f4 + 2.0f * f3);
                break;
            }
            case 1: {
                fArray[1] = fArray[1] + (f2 + 2.0f * f4 + 2.0f * f3);
                break;
            }
            case 2: {
                fArray[0] = fArray[0] + (f + 2.0f * f4 + 2.0f * f3);
                break;
            }
            case 4: {
                fArray[0] = fArray[0] - (f + 2.0f * f4 + 2.0f * f3);
                break;
            }
        }
        return fArray;
    }

    protected float[] rotateLabel(float[] fArray, float f, float f2, float f3, double d, float f4, float f5, float f6, String string, Rectangle2D.Float float_) {
        float f7 = this.properties.getLabelAxisGap();
        float[] fArray2 = new float[2];
        boolean bl = false;
        boolean bl2 = false;
        double d2 = Math.PI;
        float f8 = Math.cos(d) == 0.0 ? 0.0f : (float)(Math.cos(d) / Math.abs(Math.cos(d)));
        float f9 = Math.sin(d) == 0.0 ? 0.0f : (float)(Math.sin(d) / Math.abs(Math.sin(d)));
        boolean bl3 = bl = d % d2 == 0.0;
        boolean bl4 = bl ? false : (bl2 = d % (d2 / 2.0) == 0.0);
        if (bl) {
            f3 = (f4 - 1.0f) * (float_.width / 2.0f) + f4 * f6;
            f2 = fArray[1] - (float)Math.round(f5 * (f7 + f6)) + float_.height * (f5 - 1.0f) / 2.0f;
        } else if (bl2) {
            f3 = f4 * f6 + f9 * (f4 * f9 + 1.0f) / 4.0f * float_.width;
            f2 = fArray[1] - (float)Math.round(f5 * (f7 + f6)) + f9 * float_.height * (f5 - 1.0f) / 2.0f - f5 * (f9 + 1.0f) / 2.0f * float_.height;
        } else {
            f3 = f4 * f6;
            f2 = fArray[1] - (float)Math.round(f5 * (f7 + f6));
        }
        d += this.abs;
        d = this.formatAngle(d);
        f = fArray[0] - (float)Math.round(f4 * f7) - f3;
        if (d < d2) {
            if (!bl && !bl2) {
                f -= f8 * float_.width;
                f2 -= f9 * float_.height;
            }
            if (this.textStyle.getShearing() != 0.0f) {
                float[] fArray3 = this.shearing(f, f2, float_.width, float_.height, d, this.abs);
                f = fArray3[0];
                f2 = fArray3[1];
            }
        }
        fArray2[0] = f;
        fArray2[1] = f2;
        return fArray2;
    }

    protected boolean bottomToTop() {
        if (this.axisPoint != null && this.axisPoint.length == 2) {
            return this.axisPoint[1][1] < this.axisPoint[0][1];
        }
        return false;
    }

    protected boolean rightToLeft() {
        if (this.axisPoint != null && this.axisPoint.length == 2) {
            return this.axisPoint[1][0] < this.axisPoint[0][0];
        }
        return false;
    }

    protected float calBaseUnit() {
        if (this.majorTickMarkPoint != null && this.majorTickMarkPoint.length > 1) {
            float f = 0.0f;
            this.clone = f = (float)Math.sqrt((this.majorTickMarkPoint[0][0] - this.majorTickMarkPoint[1][0]) * (this.majorTickMarkPoint[0][0] - this.majorTickMarkPoint[1][0]) + (this.majorTickMarkPoint[0][1] - this.majorTickMarkPoint[1][1]) * (this.majorTickMarkPoint[0][1] - this.majorTickMarkPoint[1][1]));
            return f;
        }
        if (this.axisPoint != null) {
            float f = 0.0f;
            this.clone = f = this.axisPoint[0][0] - this.axisPoint[1][0] != 0.0f ? Math.abs(this.axisPoint[0][0] - this.axisPoint[1][0]) : Math.abs(this.axisPoint[0][1] - this.axisPoint[1][1]);
            return f;
        }
        return 0.0f;
    }

    protected float[] calculateCategoryRotateLabelOffset(float[] fArray, float f, float f2, float f3, float f4, double d, int n, double d2) {
        float[] fArray2 = new float[]{fArray[0], fArray[1]};
        float f5 = this.clone < 0.0f ? this.calBaseUnit() : this.clone;
        f5 = this.Z > 0 ? f5 / (float)(1 + this.Z) : f5;
        switch (this.position) {
            case 1: {
                fArray2[0] = fArray2[0] + (f5 - f) / 2.0f;
                if (n == 0) {
                    fArray2[1] = fArray2[1] - (f2 + f3 + f4);
                    break;
                }
                fArray2[1] = fArray2[1] + (f3 + f4);
                break;
            }
            case 3: {
                if (this.rightToLeft()) {
                    fArray2[0] = fArray2[0] - f5;
                }
                if (n == 0) {
                    fArray2[1] = fArray2[1] + (f3 + f4);
                    fArray2[0] = fArray2[0] + f5 / 2.0f;
                    if (!(d2 < 0.0)) break;
                    fArray2[0] = fArray2[0] - f;
                    break;
                }
                fArray2[1] = fArray2[1] - (f2 + f3 + f4);
                fArray2[0] = fArray2[0] + f5 / 2.0f;
                break;
            }
            case 4: {
                if (n == 0) {
                    if (this.bottomToTop()) {
                        fArray2[1] = fArray2[1] - f2;
                    }
                    fArray2[0] = fArray2[0] + (f3 + f4);
                    break;
                }
                fArray2[0] = fArray2[0] - (f + f3 + f4);
                if (!this.bottomToTop()) break;
                fArray2[1] = fArray2[1] - f5;
                break;
            }
            case 2: {
                if (n == 0) {
                    fArray2[0] = fArray2[0] - (f + f3 + f4);
                    fArray2[1] = d2 < 0.0 ? fArray2[1] - f5 : fArray2[1] - f2;
                    if (this.bottomToTop()) break;
                    fArray2[1] = fArray2[1] + f5;
                    break;
                }
                fArray2[0] = fArray2[0] + (f3 + f4);
                fArray2[1] = d2 < 0.0 ? fArray2[1] - f2 : fArray2[1] - f5;
                if (this.bottomToTop()) break;
                fArray2[1] = fArray2[1] + f5;
            }
        }
        return fArray2;
    }

    protected float[] rotateLabel(float[] fArray, float f, float f2, float f3, double d, float f4, float f5, float f6, String string) {
        float f7 = this.properties.getLabelAxisGap();
        float[] fArray2 = new float[2];
        boolean bl = false;
        boolean bl2 = false;
        double d2 = Math.PI;
        Rectangle2D.Float float_ = (Rectangle2D.Float)this.textStyle.getDimension(string);
        float f8 = Math.cos(d) == 0.0 ? 0.0f : (float)(Math.cos(d) / Math.abs(Math.cos(d)));
        float f9 = Math.sin(d) == 0.0 ? 0.0f : (float)(Math.sin(d) / Math.abs(Math.sin(d)));
        boolean bl3 = bl = d % d2 == 0.0;
        boolean bl4 = bl ? false : (bl2 = d % (d2 / 2.0) == 0.0);
        if (bl) {
            f3 = (f4 - 1.0f) * (float_.width / 2.0f) + f4 * f6;
            f2 = fArray[1] - (float)Math.round(f5 * (f7 + f6)) + float_.height * (f5 - 1.0f) / 2.0f;
        } else if (bl2) {
            f3 = f4 * f6 + f9 * (f4 * f9 + 1.0f) / 4.0f * float_.width;
            f2 = fArray[1] - (float)Math.round(f5 * (f7 + f6)) + f9 * float_.height * (f5 - 1.0f) / 2.0f - f5 * (f9 + 1.0f) / 2.0f * float_.height;
        } else {
            f3 = f4 * f6;
            f2 = fArray[1] - (float)Math.round(f5 * (f7 + f6));
        }
        d += this.abs;
        d = this.formatAngle(d);
        f = fArray[0] - (float)Math.round(f4 * f7) - f3;
        if (d < d2) {
            if (!bl && !bl2) {
                f -= f8 * float_.width;
                f2 -= f9 * float_.height;
            }
            if (this.textStyle.getShearing() != 0.0f) {
                float[] fArray3 = this.shearing(f, f2, float_.width, float_.height, d, this.abs);
                f = fArray3[0];
                f2 = fArray3[1];
            }
        }
        fArray2[0] = f;
        fArray2[1] = f2;
        return fArray2;
    }

    protected float[] shearing(float f, float f2, float f3, float f4, double d, double d2) {
        float[] fArray = new float[2];
        double d3 = Math.PI;
        float f5 = (float)Math.cos(d2);
        float f6 = (float)Math.sin(d2);
        float f7 = this.textStyle.getShearing();
        if (d <= 0.5 * d3) {
            f = f7 > 0.0f ? (f -= (f5 + 1.0f - f6 * 2.0f) * f3 - f5 * this.atan / 2.0f) : (f += (f5 - 1.0f + f6) * f3 - f5 * this.atan / 2.0f);
        } else if (f7 > 0.0f) {
            f -= (f5 - 1.0f + f6) * f3 - f5 * this.atan / 2.0f;
            f2 += f6 * f4;
        } else {
            f -= (f5 + 1.0f - f6 * 2.0f) * f3 - f5 * this.atan / 2.0f;
            f2 += f6 * f4;
        }
        fArray[0] = f;
        fArray[1] = f2;
        return fArray;
    }

    public double formatAngle(double d) {
        d = d < 0.0 ? Math.PI * 2 + d % (Math.PI * 2) : d % (Math.PI * 2);
        return d;
    }

    protected float atan(double d, double d2) {
        float f = 0.0f;
        float f2 = (float)Math.PI;
        d *= -1.0;
        if (d2 == 0.0) {
            f = d > 0.0 ? f2 / 2.0f : f2 * 3.0f / 2.0f;
        } else {
            f = (float)Math.atan(d / d2);
            f = d2 > 0.0 ? (d >= 0.0 ? f : f2 * 2.0f + f) : (f += f2);
        }
        return f;
    }

    protected float[] calculateLabelsDimension() {
        Rectangle2D.Float float_;
        if (this.paintingLabels == null) {
            return new float[]{0.0f, 0.0f};
        }
        if (this.paintingLabels.length == 0) {
            return new float[]{0.0f, 0.0f};
        }
        float[] fArray = new float[3];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.paintingLabelsLength; ++i) {
            n2 = this.paintingLabels[i].getLabelText().length();
            if (n2 <= n) continue;
            n3 = i;
            n = n2;
        }
        ChartTextStyle chartTextStyle = null;
        if (!this.initedLabelStyle && (chartTextStyle = (ChartTextStyle)this.textStyle.clone()).getWordWrapper()) {
            chartTextStyle.setWordWrap(this.textStyle.getWordWrapWidth());
        }
        if (!this.initedLabelStyle) {
            if (this.rotation != 0.0) {
                chartTextStyle.setRotation(this.rotation);
            }
            float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.paintingLabels[n3].getLabelText());
        } else {
            chartTextStyle = (ChartTextStyle)this.paintingLabels[n3].getChartTextStyle().clone();
            if (chartTextStyle.getWordWrapper()) {
                chartTextStyle.setWordWrapWidth(this.paintingLabels[n3].getChartTextStyle().getWordWrapWidth());
            }
            if (this.rotation != 0.0) {
                chartTextStyle.setRotation(this.rotation);
            }
            float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.paintingLabels[n3].getLabelText());
            if (this.minorTickNumber > 0 && this.minorTextStyle != null) {
                Rectangle2D.Float float_2 = (Rectangle2D.Float)this.minorTextStyle.getDimension(this.paintingLabels[n3].getLabelText());
                float_.width = float_2.width > float_.width ? float_2.width : float_.width;
                float_.height = float_2.height > float_.height ? float_2.height : float_.height;
            }
        }
        fArray[0] = float_.width;
        fArray[1] = float_.height;
        fArray[2] = n3;
        return fArray;
    }

    protected void setPaintingLabelTextStyle(ChartTextStyle chartTextStyle) {
        for (int i = 0; i < this.paintingLabelsLength; ++i) {
            this.paintingLabels[i].setChartTextStyle(chartTextStyle);
        }
    }

    protected float getAxisAngle() {
        float f = this.atan(this.axisPoint[1][1] - this.axisPoint[0][1], this.axisPoint[1][0] - this.axisPoint[0][0]);
        if (this.position != 0) {
            switch (this.position) {
                case 1: {
                    f = 0.0f;
                    break;
                }
                case 2: {
                    f = 1.5707964f;
                    break;
                }
                case 3: {
                    f = (float)Math.PI;
                    break;
                }
                case 4: {
                    f = 4.712389f;
                    break;
                }
            }
        }
        return f;
    }

    protected float[] labelPositionTransform(double d, float f, float f2, float f3, float f4) {
        double d2 = Math.PI;
        if (d > d2 / 2.0 && d <= d2) {
            f -= f3;
        } else if (d > d2 && d <= d2 * 1.5) {
            f -= f3;
            f2 -= f4;
        } else if (d > d2 * 1.5 && d < d2 * 2.0) {
            f2 -= f4;
        }
        float[] fArray = new float[]{f, f2};
        return fArray;
    }

    void IsShowLabelTips(int n, float f, float f2, ChartLabelBase chartLabelBase, Rectangle2D.Float float_) {
        double d = 0.0;
        d = !this.initedLabelStyle ? this.textStyle.getRotation() : chartLabelBase.getChartTextStyle().getRotation();
        ChartTextStyle chartTextStyle = chartLabelBase.getChartTextStyle();
        if (chartTextStyle.getWordWrapper()) {
            double d2 = chartTextStyle.getWordWrapFristLineHeight();
            this.bottomToTop[n][0] = new Point2D.Double(f, (double)(f2 + float_.height) - d2);
            this.bottomToTop[n][1] = new Point2D.Double(f + float_.width, (double)(f2 + float_.height) - d2);
            this.bottomToTop[n][2] = new Point2D.Double(f + float_.width, (double)f2 - d2);
            this.bottomToTop[n][3] = new Point2D.Double(f, (double)f2 - d2);
        } else if (d == 0.0) {
            this.bottomToTop[n][0] = new Point2D.Double(f, f2);
            this.bottomToTop[n][1] = new Point2D.Double(f + float_.width, f2);
            this.bottomToTop[n][2] = new Point2D.Double(f + float_.width, f2 - float_.height);
            this.bottomToTop[n][3] = new Point2D.Double(f, f2 - float_.height);
        } else if (d == 1.5707963267948966) {
            this.bottomToTop[n][0] = new Point2D.Double(f, f2);
            this.bottomToTop[n][1] = new Point2D.Double(f + float_.width, f2);
            this.bottomToTop[n][2] = new Point2D.Double(f + float_.width, f2 + float_.height);
            this.bottomToTop[n][3] = new Point2D.Double(f, f2 + float_.height);
        } else if (d == Math.PI) {
            this.bottomToTop[n][0] = new Point2D.Double(f, f2);
            this.bottomToTop[n][1] = new Point2D.Double(f + float_.width, f2);
            this.bottomToTop[n][2] = new Point2D.Double(f + float_.width, f2 + float_.height);
            this.bottomToTop[n][3] = new Point2D.Double(f, f2 + float_.height);
        } else {
            chartTextStyle.setRotation(0.0);
            Rectangle2D.Float float_2 = (Rectangle2D.Float)chartTextStyle.getDimension(chartLabelBase.getLabelText());
            float f3 = float_2.height;
            float f4 = float_2.width;
            double d3 = Math.cos(d);
            double d4 = Math.sin(d);
            double d5 = Math.abs(Math.tan(d));
            d = d < 0.0 ? Math.PI * 2 + d % (Math.PI * 2) : d % (Math.PI * 2);
            double d6 = d / Math.PI * 180.0;
            if (d6 <= 90.0) {
                f2 = (float)((double)f2 + (double)f3 * d3);
            } else if (d6 > 90.0 && d6 <= 180.0) {
                f += float_.width;
                f2 += (float)((double)(-f3) * d3);
            } else if (d6 > 180.0 && d6 <= 270.0) {
                f += float_.width;
                f2 += float_.height - (float)Math.ceil((double)(-f3) * d3);
            } else if (d6 > 270.0) {
                f += (float)((double)(-f3) * d4);
                f2 += float_.height;
            }
            this.bottomToTop[n][0] = new Point2D.Double(f, f2);
            this.bottomToTop[n][1] = new Point2D.Double((double)f + (double)f4 * d3, (double)f2 + (double)f4 * d4);
            this.bottomToTop[n][2] = new Point2D.Double((double)f + (double)f4 * d3 + (double)f3 * d4, (double)f2 + (double)f4 * d4 - (double)f3 * d3);
            this.bottomToTop[n][3] = new Point2D.Double((double)f + (double)f3 * d4, (double)f2 - (double)f3 * d3);
            chartTextStyle.setRotation(d);
        }
    }

    public String[] getLabels() {
        if (this.paintingLabels == null) {
            return null;
        }
        String[] stringArray = new String[this.paintingLabelsLength];
        for (int i = 0; i < this.paintingLabelsLength; ++i) {
            stringArray[i] = this.paintingLabels[i].getLabelText();
        }
        return stringArray;
    }

    protected void resetTextStyle() {
        this.textStyle = this.properties.getLabelTextStyle();
        if (this.paintingLabels != null) {
            for (int i = 0; i < this.paintingLabelsLength; ++i) {
                this.paintingLabels[i].setChartTextStyle(this.textStyle);
            }
        }
    }

    public float getAxisLength() {
        float f = 0.0f;
        if (this.axisPoint != null) {
            f = Math.abs((this.axisPoint[0][0] - this.axisPoint[1][0]) * (this.axisPoint[0][0] - this.axisPoint[1][0]));
            f += Math.abs((this.axisPoint[0][1] - this.axisPoint[1][1]) * (this.axisPoint[0][1] - this.axisPoint[1][1]));
            f = (float)Math.sqrt(f);
        } else if (this.rect != null) {
            return this.rect.width;
        }
        return f;
    }

    public int getAixsLabelStep() {
        int n = 1;
        float f = this.getAxisLength();
        if (f <= 1.0f) {
            return n;
        }
        if ((f /= (float)this.paintingLabelsLength) < 1.0f) {
            n = (int)(1.0f / f);
        }
        return n;
    }

    public ChartAxisProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ChartAxisProperties chartAxisProperties) {
        this.properties = chartAxisProperties;
    }

    public ChartDataFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ChartDataFilter chartDataFilter) {
        this.filter = chartDataFilter;
    }

    public ChartDataFilter getMajorFilter() {
        return null;
    }

    public void setMajorFilter(ChartDataFilter chartDataFilter) {
    }

    public ChartDataFilter getMinorFilter() {
        return null;
    }

    public void setMinorFilter(ChartDataFilter chartDataFilter) {
    }

    public void setAxisPoint(float[][] fArray) {
        this.axisPoint = fArray;
    }

    public void setMajorTickMarkPoint(float[][] fArray) {
        this.majorTickMarkPoint = fArray;
        if (fArray != null) {
            this.numOfTicks = this.majorTickMarkPoint.length;
        }
    }

    public void setMinorTickMarkPoint(float[][] fArray) {
        this.minorTickMarkPoint = fArray;
    }

    public void setLabelPoint(float[][] fArray) {
        this.labelPoint = fArray;
    }

    public void setAxisPosition(int n) {
        this.position = n;
    }

    public int getAxisPosition() {
        return this.position;
    }

    public Shape[] getAxisShapes() {
        Shape[] shapeArray = new GeneralPath[this.paintingLabelsLength];
        int n = this.getAixsLabelStep();
        n = n < 1 ? 1 : n;
        for (int i = 0; i < this.paintingLabelsLength; i += n) {
            if (this.bottomToTop == null) {
                return null;
            }
            if (this.bottomToTop[i] == null) {
                shapeArray[i] = new GeneralPath();
                continue;
            }
            if (this.bottomToTop[i][0] == null) {
                shapeArray[i] = new GeneralPath();
                continue;
            }
            shapeArray[i] = new GeneralPath();
            ((Path2D)shapeArray[i]).reset();
            ((Path2D.Float)shapeArray[i]).moveTo((float)this.bottomToTop[i][0].x, (float)this.bottomToTop[i][0].y);
            ((Path2D.Float)shapeArray[i]).lineTo((float)this.bottomToTop[i][1].x, (float)this.bottomToTop[i][1].y);
            ((Path2D.Float)shapeArray[i]).lineTo((float)this.bottomToTop[i][2].x, (float)this.bottomToTop[i][2].y);
            ((Path2D.Float)shapeArray[i]).lineTo((float)this.bottomToTop[i][3].x, (float)this.bottomToTop[i][3].y);
            ((Path2D)shapeArray[i]).closePath();
        }
        return shapeArray;
    }

    public String searchAxisLabel(int n, int n2) {
        GeneralPath generalPath = new GeneralPath();
        if (this.bottomToTop != null) {
            for (int i = 0; i < this.bottomToTop.length; ++i) {
                generalPath.reset();
                if (this.bottomToTop[i] == null || this.bottomToTop[i][0] == null) continue;
                generalPath.moveTo((float)this.bottomToTop[i][0].x, (float)this.bottomToTop[i][0].y);
                generalPath.lineTo((float)this.bottomToTop[i][1].x, (float)this.bottomToTop[i][1].y);
                generalPath.lineTo((float)this.bottomToTop[i][2].x, (float)this.bottomToTop[i][2].y);
                generalPath.lineTo((float)this.bottomToTop[i][3].x, (float)this.bottomToTop[i][3].y);
                generalPath.lineTo((float)this.bottomToTop[i][0].x, (float)this.bottomToTop[i][0].y);
                generalPath.closePath();
                if (!generalPath.contains(n, n2) || this.paintingLabels[i] == null) continue;
                return this.paintingLabels[i].getLabelText();
            }
        }
        return null;
    }

    public void setRadarArrowStyle(int n) {
        this.IsShowLabelTips = n;
    }

    public void setUnitWidth(int n) {
        this.SEDU = n = n > 2 ? n - 2 : n;
    }

    public Shape getShapeBySeries(int n) {
        return null;
    }

    public int[] search(int n, int n2) {
        return null;
    }

    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    public int getAxisWithTickLength() {
        float f = this.properties.getTickMarkType() != 0 ? this.properties.getTickMarkLength() : 0.0f;
        float f2 = this.properties.getMinorTickMarkType() != 0 ? this.properties.getMinorTickMarkLength() : 0.0f;
        float f3 = f > f2 ? f : f2;
        f3 = f3 > 0.0f ? f3 : 0.0f;
        return (int)(this.properties.getLabelAxisGap() + f3);
    }

    public float[][] getLabelsPosition() {
        return null;
    }

    public float getZeroPosition(float f) {
        return 0.0f;
    }

    public float getUnit(float f) {
        return 0.0f;
    }

    public Line2D getAxisAreaPath() {
        return this.add;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public boolean searchSelectedAxis(int n, int n2) {
        if (this.add != null) {
            return this.add.intersects(n - 5, n2 - 5, 10.0, 10.0);
        }
        return false;
    }

    public boolean isShow() {
        return this.bestLabelPostion;
    }

    public void setShow(boolean bl) {
        this.bestLabelPostion = bl;
    }

    public ChartTextStyle getLabelsTextStyle() {
        return this.textStyle;
    }

    public boolean getAutoOritention(float f) {
        if (this.properties.IsLabelFontAutomaticOrientation()) {
            boolean bl = false;
            float[] fArray = new float[this.paintingLabelsLength];
            for (int i = 0; i < this.paintingLabelsLength; ++i) {
                Rectangle2D.Float float_ = !this.initedLabelStyle ? (Rectangle2D.Float)this.textStyle.getZeroRotationDimension(this.paintingLabels[i].getLabelText()) : (Rectangle2D.Float)this.paintingLabels[i].getChartTextStyle().getZeroRotationDimension(this.paintingLabels[i].getLabelText());
                fArray[i] = float_.width;
                if (!(fArray[i] > f)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return false;
    }

    public boolean getYAutoOritention(float f) {
        if (this.properties.IsLabelFontAutomaticOrientation()) {
            boolean bl = false;
            float[] fArray = new float[this.paintingLabelsLength];
            for (int i = 0; i < this.paintingLabelsLength; ++i) {
                Rectangle2D.Float float_ = (Rectangle2D.Float)this.textStyle.getZeroRotationDimension(this.paintingLabels[i].getLabelText());
                fArray[i] = float_.height;
                if (!(fArray[i] > f)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return false;
    }

    public boolean isShowLabelTips() {
        return this.properties.IsShowLabelTips();
    }

    public void calculateAxisOffset(ChartLabelBase chartLabelBase) {
        int n = 0;
        if (this.orignRotate > 0.0) {
            n = 1;
        } else if (n < 0) {
            n = -1;
        }
        float f = this.properties.getLabelAxisGap();
        float f2 = this.properties.getTickMarkLength();
        Rectangle2D.Float float_ = (Rectangle2D.Float)this.textStyle.getDimension(chartLabelBase.getLabelText());
        boolean bl = false;
        if (this instanceof ChartCategoryAxis) {
            bl = ((ChartCategoryAxis)this).isLineUnit();
        }
        switch (this.position) {
            case 3: {
                this.calculateCategoryRotateLabelOffset = float_.height + f2 + f;
                if (n < 0) {
                    this.calculateAxisOffset = !bl ? float_.width / 2.0f : float_.width;
                    break;
                }
                if (n <= 0) break;
                this.calculateAxisOffset = !bl ? -float_.width / 2.0f : -float_.width;
                break;
            }
            case 1: {
                this.calculateCategoryRotateLabelOffset = -float_.height - f2 - f;
                if (n < 0) {
                    this.calculateAxisOffset = -float_.width / 2.0f;
                    break;
                }
                if (n <= 0) break;
                this.calculateAxisOffset = float_.width / 2.0f;
                break;
            }
            case 2: {
                this.calculateAxisOffset = float_.width + f2 + f;
                if (n < 0) {
                    this.calculateCategoryRotateLabelOffset = float_.height / 2.0f;
                    break;
                }
                if (n <= 0) break;
                this.calculateCategoryRotateLabelOffset = -float_.height / 2.0f;
                break;
            }
            case 4: {
                this.calculateAxisOffset = -float_.width - f2 - f;
                if (n < 0) {
                    this.calculateCategoryRotateLabelOffset = -float_.height / 2.0f;
                    break;
                }
                if (n <= 0) break;
                this.calculateCategoryRotateLabelOffset = float_.height / 2.0f;
                break;
            }
        }
    }

    public boolean isDepth() {
        return this.isDepth;
    }

    public void setDepth(boolean bl) {
        this.isDepth = bl;
    }

    public String[] getLabelsForHtml() {
        return null;
    }

    public float getLabelUnit(float f) {
        return f;
    }

    public void setSubFilter(ChartDataFilter chartDataFilter) {
    }

    public ChartDataFilter getSubFilter() {
        return null;
    }

    public boolean custommerConstant() {
        return false;
    }

    public void setUseCustommerConstant(boolean bl) {
    }

    public float getMinUnit(float f) {
        return 1.0f;
    }

    public float getX(Object object, float f) {
        return 0.0f;
    }

    public float getLineX(Object object, float f) {
        return 0.0f;
    }

    public void setRotation(double d) {
        if (this.textStyle != null) {
            this.textStyle.setRotation(d);
        }
    }

    public boolean lessMin(Object object) {
        return false;
    }

    public boolean largeMax(Object object) {
        return false;
    }

    public int getTimeBaseUnit() {
        return 0;
    }

    public int getTimeUnit() {
        return 1;
    }

    public void setLabelAutoRotate(boolean bl) {
        this.labelAutoRotate = bl;
        if (!bl) {
            double d = this.formatAngle(this.getProperties().getMajorTickMarkProperties().getTickMarkLabel().getRotation());
            if (this.majorTextStyle != null) {
                if (!this.getProperties().IsLabelFontAutomaticOrientation()) {
                    this.majorTextStyle.setRotation(d);
                } else {
                    this.majorTextStyle.setRotation(0.0);
                }
            }
            if (this.textStyle != null) {
                if (!this.getProperties().IsLabelFontAutomaticOrientation()) {
                    this.textStyle.setRotation(d);
                } else {
                    this.textStyle.setRotation(0.0);
                }
            }
            this.rotation = !this.getProperties().IsLabelFontAutomaticOrientation() ? d : 0.0;
            return;
        }
        if (this.labelAutoRotate && this.properties.IsLabelFontAutomaticOrientation() && this.textStyle != null) {
            this.textStyle.setRotation(-0.5235987755982988);
            this.properties.getLabelTextStyle().setRotation(-0.5235987755982988);
        }
    }

    public Object[] getConstantStartEnd() {
        return null;
    }

    public void setIsLineUnit(boolean bl) {
    }

    public void setScrollInfo(float[] fArray) {
    }

    public float[] getScrollInfo() {
        return null;
    }

    public boolean isScroll() {
        return false;
    }

    public boolean isLocated() {
        return this.calculateLabelsDimension;
    }

    public void setLayerLength(float f) {
        this.ceil = f;
    }

    public void setLength(float f) {
        this.C = f;
    }

    public float getLength() {
        return this.C;
    }

    public void setTickSkipNum() {
    }

    public float getTickmarkUnit(float f) {
        return this.getUnit(f);
    }

    public int getTickSkipNum() {
        return 0;
    }

    public void setMinTickmarkDis(int n) {
        this.B = n;
    }

    public void setLabelN(int n) {
        this.calBaseUnit = n;
    }

    public int getLabelN() {
        int n = this.properties.getLabelEveryNTickMarks();
        n = n > 1 ? n : 1;
        return n;
    }

    public float getAxisTopMargin() {
        return 0.0f;
    }

    public float getAxisBottomMargin() {
        return 0.0f;
    }

    public void setMaxRange(Rectangle rectangle) {
        if (rectangle != null) {
            this.rect = new Dimension(rectangle.width, rectangle.height);
        }
    }

    public int searchAxisLabelIndex(int n, int n2) {
        GeneralPath generalPath = new GeneralPath();
        if (this.bottomToTop != null) {
            for (int i = 0; i < this.bottomToTop.length; ++i) {
                generalPath.reset();
                if (this.bottomToTop[i] == null || this.bottomToTop[i][0] == null) continue;
                generalPath.moveTo((float)this.bottomToTop[i][0].x, (float)this.bottomToTop[i][0].y);
                generalPath.lineTo((float)this.bottomToTop[i][1].x, (float)this.bottomToTop[i][1].y);
                generalPath.lineTo((float)this.bottomToTop[i][2].x, (float)this.bottomToTop[i][2].y);
                generalPath.lineTo((float)this.bottomToTop[i][3].x, (float)this.bottomToTop[i][3].y);
                generalPath.lineTo((float)this.bottomToTop[i][0].x, (float)this.bottomToTop[i][0].y);
                generalPath.closePath();
                if (!generalPath.contains(n, n2)) continue;
                return i;
            }
        }
        return -1;
    }
}

