/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DBarSi;
import chart.chart2d.Graph2DLineA;
import chart.data.ChartDataSet;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartFillPattern;
import chart.properties.ChartGraphProperties;
import java.awt.Shape;

public abstract class Chart2DObject
extends ChartDataObject {
    protected ChartDataSet dataset;
    protected Chart2DPaper paper;
    protected Chart2DLayer layer;
    protected ChartGraphProperties objectProperties;
    protected ChartFillPattern[] seriesPattern;
    protected ChartFillPattern[] lineAreaPattern;
    protected int valueLabelPosition;
    protected int scrollLabelCount;
    protected int valueLabelSmartPos;

    Chart2DObject(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        this.dataset = chartDataSet;
        this.paper = chart2DPaper;
        this.layer = chart2DLayer;
    }

    @Override
    public void init() {
        this.objectProperties = this.paper.getProperties().getGraphProperties();
    }

    public void setChartFillPatters(ChartFillPattern[] chartFillPatternArray) {
        this.seriesPattern = chartFillPatternArray;
    }

    abstract float[][] getStaticHintLocation();

    abstract Shape[][] getItemShapes();

    public int getValueLabelPosition() {
        return this.valueLabelPosition;
    }

    public void setValueLabelPosition(int n) {
        this.valueLabelPosition = n;
    }

    public ChartFillPattern[] getSeriesPattern() {
        return this.seriesPattern;
    }

    @Override
    public ChartDataSet getChartDataSet() {
        return this.dataset;
    }

    public ChartFillPattern[] getLineAreaPattern() {
        return this.lineAreaPattern;
    }

    public void setLineAreaPattern(ChartFillPattern[] chartFillPatternArray) {
        this.lineAreaPattern = chartFillPatternArray;
    }

    public int getScrollLabelCount() {
        return this.scrollLabelCount;
    }

    public void setScrollLabelCount(int n) {
        this.scrollLabelCount = n;
    }

    public boolean isConditionFill(int n, int n2) {
        boolean bl = false;
        if (this.dataset != null) {
            ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n, n2);
            boolean bl2 = bl = chartShowValueCondition != null && chartShowValueCondition.getConditionType() != 0;
            if (bl) {
                int n3 = ChartTypeInfo.getPrimType(this.dataset.getChartDataSetInfo().getChartType());
                switch (n3) {
                    case 0: 
                    case 1: {
                        if (!(this instanceof Graph2DBarSi)) break;
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (!chartShowValueCondition.singleFillType()) break;
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (chartShowValueCondition.getConditionType() != 2 || !(this instanceof Graph2DLineA)) break;
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public int getValueLabelSmartPosition() {
        return this.valueLabelSmartPos;
    }

    public void setValueLabelSmartPosition(int n) {
        this.valueLabelSmartPos = n;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        return null;
    }
}

