/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartCoordinatePaper;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.GridLine;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart3d.Chart3DAxes;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DWalls;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.chart3d.Graph3DAreaA;
import chart.chart3d.Graph3DAreaP;
import chart.chart3d.Graph3DAreaSt;
import chart.chart3d.Graph3DBarA;
import chart.chart3d.Graph3DBarP;
import chart.chart3d.Graph3DBarSi;
import chart.chart3d.Graph3DBarSt;
import chart.chart3d.Graph3DLineA;
import chart.chart3d.Graph3DSurface;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartDataUsedInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartGraphicsUtil;
import chart.properties.ChartCoordinatePaperProperties;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class Chart3DPaper
extends ChartCoordinatePaper {
    public static final int ROTATION = 0;
    public static final int RESIZING = 1;
    private int IsLabelFontAutomaticOrientation = 0;
    ChartPlatform I;
    public ChartDataSetModel model;
    List SEDU;
    ChartAxis Z;
    ChartAxis C;
    ChartAxis B;
    GridLine abs;
    GridLine add;
    GridLine adjustDistance;
    int after;
    int before;
    int benchmarkmirror;
    int calculateGraphArea;
    private Chart3DWalls calculatePercentMinMaxPercentOfCategory;
    private Chart3DAxes contains;
    private Chart3DObject[] custommerConstant;
    private ChartCompass drawSelectedShape;
    public ChartMatrix m1 = new ChartMatrix();
    public ChartMatrix m2 = new ChartMatrix();
    public ChartMatrix rm = new ChartMatrix();
    float[] floatValue = new float[3];
    float[] get = new float[3];
    int getAixsLabelStep;
    private boolean getAutoOritention = false;
    private boolean getAxisAreaPath = true;
    float[] D = new float[3];
    private float[] getAxisInfo = new float[3];
    private float[] getAxisShapes = new float[3];
    private int getAxisWithTickLength = 10;
    private float getAxisXProperties;
    private float getAxisYProperties;
    private float getAxisZProperties;
    private int[] getBackground = new int[2];
    private int getBounds;
    private int getCategoryFilter = -1;
    private int getCategoryName = -1;
    private String getCategoryNames;
    private String getChartDataSetInfo;
    private int[] getChartDataSets;
    private Rectangle getChartLinkInfo;
    int[] getChartPlatform;

    public Chart3DPaper(ChartPlatform chartPlatform) {
        this.I = chartPlatform;
    }

    public Chart3DPaper(ChartPlatform chartPlatform, ChartCoordinatePaperProperties chartCoordinatePaperProperties) {
        this.I = chartPlatform;
        this.properties = chartCoordinatePaperProperties;
    }

    @Override
    public void init() {
        this.setBackground(this.properties.getBackground());
        this.model = this.I.getDataSetModel();
        this.SEDU = this.model.getChartDataSets();
        if (this.SEDU.size() > 1) {
            // empty if block
        }
        ChartDataSet chartDataSet = (ChartDataSet)this.SEDU.get(0);
        this.getBounds = chartDataSet.getChartDataSetInfo().getChartType();
        this.getBackground[0] = ChartTypeInfo.getPrimType(this.getBounds);
        this.getBackground[1] = ChartTypeInfo.getSubType(this.getBounds);
        this.IsLabelFontAutomaticOrientation();
        if (this.getBackground[0] != 4) {
            this.getAxisYProperties = (float)((ChartNumericAxis)this.C).getMin();
            this.getAxisZProperties = (float)((ChartNumericAxis)this.C).getMax();
        }
        this.custommerConstant = new Chart3DObject[1];
        this.custommerConstant[0] = this.abs(chartDataSet);
        this.after();
    }

    public void doLayout() {
        this.locate();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.background = this.properties.getBackground();
        super.paint(graphics2D);
        this.transform();
        if (this.calculatePercentMinMaxPercentOfCategory != null) {
            this.calculatePercentMinMaxPercentOfCategory.paint(graphics2D);
            this.contains.paintGridLines(graphics2D);
        }
        for (int i = 0; i < this.custommerConstant.length; ++i) {
            this.custommerConstant[i].paint(graphics2D);
        }
        if (this.getBackground[0] != 4) {
            this.contains.paint(graphics2D);
        }
        this.adjustDistance(graphics2D);
        super.paintBorder(graphics2D);
    }

    private void IsLabelFontAutomaticOrientation() {
        Vector<Object[]> vector;
        Object object;
        ChartDataSet chartDataSet = (ChartDataSet)this.SEDU.get(0);
        int n = chartDataSet.getChartDataSetInfo().getChartType();
        boolean bl = false;
        switch (ChartTypeInfo.getPrimType(n)) {
            case 4: {
                this.Z = null;
                this.C = null;
                this.B = null;
                this.calculatePercentMinMaxPercentOfCategory = null;
                break;
            }
            default: {
                if (!(!this.model.isOneGroup() || this.getBackground[0] != 0 && this.getBackground[0] != 1 && this.getBackground[0] != 3 || this.getBackground[1] != 0 && this.getBackground[1] != 256 && this.getBackground[1] != 512)) {
                    object = this.model.getCategoryNames();
                    vector = null;
                } else if (this.getBackground[1] == 0 || this.getBackground[1] == 256 || this.getBackground[1] == 512) {
                    object = this.model.getCategoryNames();
                    vector = this.model.getSeriesNames();
                } else {
                    object = this.model.getCategoryNames();
                    vector = this.model.getSeriesNames();
                }
                this.Z = new ChartCategoryAxis(this.properties.getAxisXProperties(), (List)object);
                this.Z.setType("x1");
                this.Z.setAxisPosition(5);
                this.abs = new GridLine();
                this.abs.setType("x1");
                this.abs.setAxis(this.Z);
                bl = this.properties.getAxisYProperties().getIsShowPercent();
                if (this.getBackground[0] == 7) {
                    bl = false;
                }
                if (!bl) {
                    this.C = new ChartNumericAxis(this.properties.getAxisYProperties(), chartDataSet.getMin(), chartDataSet.getMax());
                } else {
                    double d = ((Chart1DDataSet)chartDataSet).calculatePercentMinMaxPercentOfCategory()[0];
                    double d2 = ((Chart1DDataSet)chartDataSet).calculatePercentMinMaxPercentOfCategory()[1];
                    this.C = new ChartNumericAxis(this.properties.getAxisYProperties(), d, d2);
                }
                this.C.setType("y1");
                this.C.setAxisPosition(5);
                this.add = new GridLine();
                this.add.setType("y1");
                this.add.setAxis(this.C);
                if (ChartTypeInfo.getSubType(n) != 256 && !bl) {
                    ((ChartNumericAxis)this.C).setAutoExpand(true);
                    ((ChartNumericAxis)this.C).setIntegerIncrement(chartDataSet.isIntegerData());
                }
                this.B = new ChartCategoryAxis(this.properties.getAxisZProperties(), vector);
                this.B.setType("z");
                this.adjustDistance = new GridLine();
                this.adjustDistance.setType("z");
                this.B.setAxisPosition(5);
                this.adjustDistance.setAxis(this.B);
                this.Z.setShow(this.properties.isShowAxisX());
                this.C.setShow(this.properties.isShowAxisY());
                this.B.setShow(this.properties.isShowAxisZ());
                this.calculatePercentMinMaxPercentOfCategory = new Chart3DWalls(this);
                this.calculatePercentMinMaxPercentOfCategory.init();
                this.contains = new Chart3DAxes(this);
                this.contains.init();
            }
        }
        if (this.Z != null) {
            this.Z.setFilter(this.model.getCategoryFilter());
            this.Z.setUseCustommerConstant(this.isCustommerConstantAxis(true));
            object = new float[2];
            object[0] = 0.0f;
            object[1] = 1.0f;
            this.Z.setScrollInfo((float[])object);
            this.Z.init();
        }
        if (this.B != null) {
            this.B.setFilter(this.model.getSeriesFilter());
            this.B.init();
        }
        if (this.C != null) {
            boolean bl2 = false;
            if (chartDataSet.getDataFilter() != null && chartDataSet.getDataFilter().usedFormat()) {
                bl2 = true;
            }
            if (!bl2 && bl) {
                vector = new Vector<Object[]>();
                String string = "10.00%";
                ChartDataFilter chartDataFilter = new ChartDataFilter();
                Object[] objectArray = new Object[]{new Integer(Integer.valueOf(string.substring(0, 1))), string.substring(1)};
                vector.add(objectArray);
                chartDataFilter.setFilters(vector);
                this.C.setFilter(chartDataFilter);
            } else {
                this.C.setFilter(chartDataSet.getDataFilter());
            }
            this.C.init();
        }
        if (this.getBackground[0] == 2 || this.getBackground[0] == 3 || this.getBackground[0] == 7) {
            ((ChartCategoryAxis)this.Z).setIsLineUnit(true);
        }
        if (ChartTypeInfo.getPrimType(n) == 7) {
            ((ChartCategoryAxis)this.B).setIsLineUnit(true);
        }
    }

    public void calculateGraphArea() {
        ChartAxis chartAxis = null;
        ChartAxis chartAxis2 = null;
        Rectangle rectangle = super.getBounds();
        Rectangle rectangle2 = super.getCoreArea();
        this.after = rectangle2.y;
        this.before = rectangle2.x;
        this.benchmarkmirror = rectangle.width - rectangle2.x - rectangle2.width;
        this.calculateGraphArea = rectangle.height - rectangle2.y - rectangle2.height;
        ChartDataSet chartDataSet = (ChartDataSet)this.SEDU.get(0);
        int n = chartDataSet.getChartDataSetInfo().getChartType();
        if (ChartTypeInfo.getPrimType(n) == 1) {
            chartAxis = this.C;
            chartAxis2 = this.Z;
        } else {
            chartAxis = this.Z;
            chartAxis2 = this.C;
        }
        if (chartAxis2 != null && chartAxis2.isShow()) {
            this.before += chartAxis2.getAxisWithTickLength();
            this.before += chartAxis2.getMaxDimensionOfLabelsFor3D().width;
        }
        if (chartAxis != null && chartAxis.isShow()) {
            this.calculateGraphArea += chartAxis.getAxisWithTickLength();
            this.calculateGraphArea += chartAxis.getMaxDimensionOfLabelsFor3D().height;
        }
        this.calculateGraphArea = this.calculateGraphArea < rectangle.height - 10 ? this.calculateGraphArea : rectangle.height - 10;
        this.before = this.before < rectangle.width / 2 ? this.before : rectangle.width / 2;
        this.after += 10;
        this.benchmarkmirror += this.before;
        this.getChartLinkInfo = new Rectangle(this.before, this.after, rectangle.width - this.before - this.benchmarkmirror, rectangle.height - this.after - this.calculateGraphArea);
    }

    @Override
    public void locate() {
        this.calculateGraphArea();
        this.rm.reset(this.properties.getRotationMatrix());
        this.getAxisShapes[0] = this.properties.getScaleX() * 0.86f;
        this.getAxisShapes[1] = this.properties.getScaleY() * 0.86f;
        this.getAxisShapes[2] = this.properties.getScaleZ() * 0.86f;
        this.getAxisWithTickLength = this.properties.getPerspective();
        float f = super.getBounds().width;
        float f2 = super.getBounds().height;
        if (this.getBackground[0] == 1) {
            this.getAxisAreaPath = false;
            this.get[0] = (int)(f2 - (float)(2 * this.calculateGraphArea));
            this.get[1] = (int)(f - (float)this.before);
        } else {
            this.getAxisAreaPath = true;
            this.get[0] = (int)(f - (float)(2 * this.before));
            this.get[1] = (int)(f2 - (float)this.calculateGraphArea);
        }
        if (this.get[0] < 0.0f) {
            this.get[0] = 0.0f;
        }
        if (this.get[1] < 0.0f) {
            this.get[1] = 0.0f;
        }
        if (this.getBackground[0] != 4 && !this.Z.custommerConstant()) {
            this.floatValue[0] = this.Z.getUnit(this.get[0]);
        } else if (this.Z.custommerConstant()) {
            float[] fArray = new float[]{0.0f, 1.0f};
            this.Z.setScrollInfo(fArray);
            this.floatValue[0] = this.Z.getTickmarkUnit(this.get[0]);
        }
        if (this.Z.getProperties().IsLabelFontAutomaticOrientation()) {
            if (this.Z.getAutoOritention(this.floatValue[0])) {
                this.Z.setLabelAutoRotate(true);
            } else {
                this.Z.getProperties().getLabelTextStyle().setRotation(0.0);
            }
            this.calculateGraphArea();
            if (this.getBackground[0] == 1) {
                this.get[0] = (int)(f2 - (float)(2 * this.calculateGraphArea));
                this.get[1] = (int)(f - (float)this.before);
            } else {
                this.get[0] = (int)(f - (float)(2 * this.before));
                this.get[1] = (int)(f2 - (float)this.calculateGraphArea);
            }
        } else {
            this.calculateGraphArea();
            if (this.getBackground[0] == 1) {
                this.get[0] = (int)(f2 - (float)(2 * this.calculateGraphArea));
                this.get[1] = (int)(f - (float)this.before);
            } else {
                this.get[0] = (int)(f - (float)(2 * this.before));
                this.get[1] = (int)(f2 - (float)this.calculateGraphArea);
            }
        }
        if (this.getBackground[0] != 4 && this.Z.custommerConstant()) {
            this.Z.setLength(this.get[0]);
            this.Z.setTickSkipNum();
        }
        this.get[2] = this.getBackground[1] == 768 && !this.model.isOneGroup() ? (this.get[1] < this.get[0] ? (this.get[1] * 1.5f > this.get[0] ? this.get[0] : this.get[1] * 1.5f) : (this.get[0] * 1.5f > this.get[1] ? this.get[1] : this.get[0] * 1.5f)) : this.get[0] * 2.0f / 5.0f;
        if (this.getBackground[0] != 4) {
            this.floatValue[2] = this.B.getUnit(this.get[2]);
        }
        if (this.Z.getProperties().getLabelTextStyle().getWordWrapper() || this.B.getProperties().getLabelTextStyle().getWordWrapper()) {
            if (this.getBackground[0] != 1) {
                this.Z.setUnitWidth((int)((double)this.floatValue[0] * 0.8));
                this.B.setUnitWidth((int)((double)this.floatValue[2] * 0.8));
            }
            this.calculateGraphArea();
        }
        this.getAxisInfo[0] = this.get[0] / 2.0f;
        this.getAxisInfo[2] = this.get[2] / 2.0f;
        this.getAxisInfo[1] = (this.get[1] - (float)this.calculateGraphArea) / 2.0f;
        this.D[0] = f / 2.0f;
        this.D[1] = f2 / 2.0f;
        if (this.getBackground[0] != 4) {
            this.floatValue[1] = this.C.getUnit(this.get[1]);
            this.getAxisXProperties = -((float)((ChartNumericAxis)this.C).getMin() * this.floatValue[1]);
        }
        if (this.calculatePercentMinMaxPercentOfCategory != null) {
            this.SEDU();
            this.calculatePercentMinMaxPercentOfCategory.locate();
            this.contains.locate();
            this.getAutoOritention = false;
        }
        for (int i = 0; i < this.custommerConstant.length; ++i) {
            this.custommerConstant[i].init();
            this.custommerConstant[i].locate();
        }
    }

    private void SEDU() {
        this.drawSelectedShape = new ChartCompass(this.getAxisInfo[0], this.getAxisInfo[1], this.getAxisInfo[2], this.getBounds);
    }

    public void transform() {
        if (this.getAutoOritention || this.drawSelectedShape == null) {
            return;
        }
        if (this.getBackground[0] != 4) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (this.getBackground[0] == 2) {
                f4 = this.D[0] + this.getAxisInfo[0];
                f3 = this.D[0] - this.getAxisInfo[0];
                f2 = this.D[1] + this.getAxisInfo[1];
                f = this.D[1] - this.getAxisInfo[1];
                this.getAxisWithTickLength = this.getAxisWithTickLength < 1 ? 9 : this.getAxisWithTickLength;
            } else {
                f4 = this.D[0] + this.getAxisInfo[1];
                f3 = this.D[0] - this.getAxisInfo[1];
                f2 = this.D[1] + this.getAxisInfo[0];
                f = this.D[1] - this.getAxisInfo[0];
                this.getAxisWithTickLength = this.getAxisWithTickLength < 1 ? 9 : this.getAxisWithTickLength;
            }
            do {
                this.m2.unit();
                this.m2.setVisualEffect(this.D[0], this.D[1], Math.min(this.D[0], this.D[1]) * (float)this.getAxisWithTickLength);
                this.m2.shift(-this.getAxisInfo[0], -this.getAxisInfo[1], -this.getAxisInfo[2]);
                this.m2.mul(this.rm);
                this.m2.scale(this.getAxisShapes[0], this.getAxisShapes[1], this.getAxisShapes[2]);
                if (this.getAxisAreaPath) {
                    this.m1.mirror();
                } else {
                    this.m1.benchmarkmirror();
                }
                this.m1.shift(this.D[0], this.D[1], this.D[2] - f5);
                this.m2.mul(this.m1);
                this.drawSelectedShape.transform(this.m2);
                f6 = this.drawSelectedShape.adjustDistance(f4, f3, f2, f);
                f5 += f6;
            } while (f6 > 1.0f);
            if (this.calculatePercentMinMaxPercentOfCategory != null) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 3;
                this.calculatePercentMinMaxPercentOfCategory.transform(this.m2);
                n3 = this.drawSelectedShape.shownFace(this.calculatePercentMinMaxPercentOfCategory.getWalls().tVertex, 0);
                for (int i = 0; i < 3; ++i) {
                    if ((n3 >> i * 2 & 1) != 1) {
                        n2 = i * 2;
                    }
                    if ((n3 >> i * 2 + 1 & 1) != 1) {
                        n2 = i * 2 + 1;
                    } else if (i * 2 + 1 == n4) continue;
                    n |= 1 << n2;
                }
                this.getAixsLabelStep = n;
            }
            if (this.contains != null) {
                this.contains.transform(this.m2);
            }
            if (this.custommerConstant != null && this.custommerConstant[0] != null) {
                this.custommerConstant[0].transform(this.m2);
            }
        }
        this.getAutoOritention = true;
    }

    private Chart3DObject abs(ChartDataSet chartDataSet) {
        Chart3DObject chart3DObject = null;
        switch (this.getBackground[0]) {
            case 0: {
                switch (this.getBackground[1]) {
                    case 0: {
                        chart3DObject = new Graph3DBarSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DBarP(chartDataSet, this);
                        break;
                    }
                    case 512: {
                        chart3DObject = new Graph3DBarSi(chartDataSet, this);
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DBarA(chartDataSet, this);
                    }
                }
                break;
            }
            case 1: {
                switch (this.getBackground[1]) {
                    case 0: {
                        chart3DObject = new Graph3DBarSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DBarP(chartDataSet, this);
                        break;
                    }
                    case 512: {
                        chart3DObject = new Graph3DBarSi(chartDataSet, this);
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DBarA(chartDataSet, this);
                    }
                }
                break;
            }
            case 2: {
                switch (this.getBackground[1]) {
                    case 0: {
                        break;
                    }
                    case 256: {
                        break;
                    }
                    case 512: {
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DLineA(chartDataSet, this);
                    }
                }
                break;
            }
            case 3: {
                switch (this.getBackground[1]) {
                    case 768: {
                        chart3DObject = new Graph3DAreaA(chartDataSet, this);
                        break;
                    }
                    case 0: {
                        chart3DObject = new Graph3DAreaSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DAreaP(chartDataSet, this);
                    }
                }
                break;
            }
            case 7: {
                chart3DObject = new Graph3DSurface(chartDataSet, this);
            }
        }
        return chart3DObject;
    }

    public ChartCompass getCompass() {
        return this.drawSelectedShape;
    }

    public float availableLength(float f) {
        if (f < this.getAxisYProperties * this.floatValue[1]) {
            return 0.0f;
        }
        if (f > this.getAxisZProperties * this.floatValue[1]) {
            return this.get[1];
        }
        return f + this.getAxisXProperties;
    }

    public float availableOriginY(float f) {
        if (f < this.getAxisYProperties * this.floatValue[1]) {
            return 0.0f;
        }
        if (f > (this.getAxisZProperties - this.getAxisYProperties) * this.floatValue[1]) {
            return this.get[1];
        }
        return f;
    }

    public float availableValue(float f) {
        f = f < this.getAxisYProperties ? this.getAxisYProperties : (f > this.getAxisZProperties ? this.getAxisZProperties : f);
        return f;
    }

    public float[] getUnit() {
        return this.floatValue;
    }

    public float[] getLength() {
        return this.get;
    }

    public int getShownFace() {
        return this.getAixsLabelStep;
    }

    public float[] getOrigin() {
        return this.D;
    }

    public void setOriginY(float f) {
        this.getAxisXProperties = f;
    }

    public float getOriginY() {
        return this.getAxisXProperties;
    }

    public void setMode(int n) {
        this.IsLabelFontAutomaticOrientation = n;
    }

    public int getMode() {
        return this.IsLabelFontAutomaticOrientation;
    }

    public int[] getIntType() {
        return this.getBackground;
    }

    public int getChartType() {
        return this.getBounds;
    }

    public void setYUnit(float f) {
        this.floatValue[1] = f;
    }

    public Chart3DWalls getWalls() {
        return this.calculatePercentMinMaxPercentOfCategory;
    }

    public ChartPlatform getChartPlatform() {
        return this.I;
    }

    public ChartDataSetInfo[] getDataSetInfos() {
        return this.model.getDatasetInfos();
    }

    @Override
    public ChartNumericAxis getAxisY1() {
        return (ChartNumericAxis)this.C;
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        return this.custommerConstant[n].getItemShapes(n);
    }

    @Override
    public void setXDimValue(Vector vector) {
        ((ChartCategoryAxis)this.Z).setDimValue(vector);
    }

    @Override
    public void setZDimValue(Vector vector) {
        ((ChartCategoryAxis)this.B).setDimValue(vector);
    }

    @Override
    public String[] getXLabels() {
        return ((ChartCategoryAxis)this.Z).getLabelsForHtml();
    }

    @Override
    public String[] getZLabels() {
        return ((ChartCategoryAxis)this.B).getLabelsForHtml();
    }

    @Override
    public Shape[] getAxisXShapes() {
        return this.Z.getAxisShapes();
    }

    @Override
    public int getAxisXLabelStep() {
        if (this.Z == null) {
            return 1;
        }
        return this.Z.getAixsLabelStep();
    }

    @Override
    public Shape[] getAxisZShapes() {
        return this.B.getAxisShapes();
    }

    @Override
    public String[] getHintValue(int n, int n2) {
        this.getCategoryFilter = n;
        this.getCategoryName = n2;
        String[] stringArray = null;
        this.getChartDataSets = null;
        if (this.custommerConstant != null && this.custommerConstant[0] != null && this.properties.isShowTips()) {
            stringArray = this.custommerConstant[0].search(n, n2);
            this.getChartDataSets = this.custommerConstant[0].drilldown;
            if (stringArray != null) {
                return stringArray;
            }
        }
        stringArray = new String[]{this.add(n, n2)};
        return stringArray;
    }

    private String add(int n, int n2) {
        String string;
        if (this.Z != null) {
            string = this.Z.searchAxisLabel(n, n2);
            if (string != null) {
                this.getCategoryNames = string;
                if (this.Z.isShowLabelTips()) {
                    return string;
                }
            } else {
                this.getCategoryNames = null;
            }
        }
        if (this.B != null) {
            string = this.B.searchAxisLabel(n, n2);
            if (string != null) {
                this.getChartDataSetInfo = string;
                if (this.B.isShowLabelTips()) {
                    return string;
                }
            } else {
                this.getChartDataSetInfo = null;
            }
        }
        if (this.C != null && (string = this.C.searchAxisLabel(n, n2)) != null && this.C.isShowLabelTips()) {
            return string;
        }
        return null;
    }

    @Override
    public String getXDim() {
        return this.getCategoryNames;
    }

    @Override
    public String getZDim() {
        return this.getChartDataSetInfo;
    }

    @Override
    public int[] getDrilldown() {
        return this.getChartDataSets;
    }

    @Override
    public String[] getDrilldownGroup() {
        String[] stringArray = new String[2];
        if (this.getChartDataSets != null) {
            if (this.model.isTurnedXZ()) {
                stringArray[0] = null;
                stringArray[1] = this.model.getSeriesName(this.getChartDataSets[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.getChartDataSets[0] % this.model.getSeriesCount()).toString());
            } else {
                stringArray[0] = this.model.getSeriesName(this.getChartDataSets[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.getChartDataSets[0] % this.model.getSeriesCount()).toString());
                stringArray[1] = this.model.getCategoryName(this.getChartDataSets[1]) == null ? null : this.model.getCategoryName(this.getChartDataSets[1]).toString();
            }
        }
        return stringArray;
    }

    protected Chart3DAxes getAxes() {
        return this.contains;
    }

    public float[] getWordWrapUnit() {
        float[] fArray = new float[]{Math.abs(this.floatValue[0] * 0.8f), Math.abs(this.floatValue[2] * 0.8f)};
        return fArray;
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        this.selectedSeriesIndex = -1;
        if (this.getBounds().contains(n, n2)) {
            this.searchSelectedSeriesIndex(n -= this.getBounds().x, n2 -= this.getBounds().y);
            if (this.Z != null && this.Z.searchSelectedAxis(n, n2)) {
                return this.Z;
            }
            if (this.C != null && this.C.searchSelectedAxis(n, n2)) {
                return this.C;
            }
            if (this.B != null && this.B.searchSelectedAxis(n, n2)) {
                return this.B;
            }
            if (this.selectedSeriesIndex != -1) {
                return this.custommerConstant[0];
            }
            if (this.contains != null && this.contains.searchSelectedGridX(n, n2)) {
                return this.abs;
            }
            if (this.contains != null && this.contains.searchSelectedGridY(n, n2)) {
                return this.add;
            }
            if (this.contains != null && this.contains.searchSelectedGridZ(n, n2)) {
                return this.adjustDistance;
            }
            if (this.calculatePercentMinMaxPercentOfCategory != null && this.calculatePercentMinMaxPercentOfCategory.searchSelectedWallXY(n, n2)) {
                this.calculatePercentMinMaxPercentOfCategory.getWallXY().setType("xy");
                return this.calculatePercentMinMaxPercentOfCategory.getWallXY();
            }
            if (this.calculatePercentMinMaxPercentOfCategory != null && this.calculatePercentMinMaxPercentOfCategory.searchSelectedWallYZ(n, n2)) {
                this.calculatePercentMinMaxPercentOfCategory.getWallYZ().setType("yz");
                return this.calculatePercentMinMaxPercentOfCategory.getWallYZ();
            }
            if (this.calculatePercentMinMaxPercentOfCategory != null && this.calculatePercentMinMaxPercentOfCategory.searchSelectedWallFloor(n, n2)) {
                this.calculatePercentMinMaxPercentOfCategory.getWallFloor().setType("floor");
                return this.calculatePercentMinMaxPercentOfCategory.getWallFloor();
            }
            return this;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public void searchSelectedSeriesIndex(int n, int n2) {
        this.selectedSeriesIndex = -1;
        if (this.custommerConstant[0] != null) {
            this.custommerConstant[0].search(n, n2);
            this.selectedSeriesIndex = this.custommerConstant[0].selectedSeriesIndex;
        }
    }

    public String getSelectShowValue(int n, int n2) {
        if (this.selectedSeriesIndex == -1) {
            this.searchSelectedSeriesIndex(n, n2);
        }
        if (this.model.getValuesName() != null && this.selectedSeriesIndex != -1) {
            return this.model.getValuesName()[0];
        }
        return null;
    }

    public String[] getSelectOrignShowValue(int n, int n2) {
        if (this.selectedSeriesIndex == -1) {
            this.searchSelectedSeriesIndex(n, n2);
        }
        if (this.model.getValuesName() != null && this.selectedSeriesIndex != -1) {
            return this.model.getOrignValuesName(0);
        }
        return null;
    }

    public void seTransformed(boolean bl) {
        this.getAutoOritention = bl;
    }

    private void adjustDistance(Graphics2D graphics2D) {
        if (this.Z != null && this.Z.getStatus() == 1) {
            Line2D line2D = this.Z.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.C != null && this.C.getStatus() == 1) {
            Line2D line2D = this.C.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.B != null && this.B.getStatus() == 1) {
            Line2D line2D = this.B.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.abs != null && this.selectedSeriesIndex != -1 && this.abs.getStatus() == 1) {
            GeneralPath generalPath = this.contains.getGridXAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.add != null && this.selectedSeriesIndex == -1 && this.add.getStatus() == 1) {
            GeneralPath generalPath = this.contains.getGridYAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.adjustDistance != null && this.selectedSeriesIndex == -1 && this.adjustDistance.getStatus() == 1) {
            GeneralPath generalPath = this.contains.getGridZAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.calculatePercentMinMaxPercentOfCategory.getWallXY() != null && this.calculatePercentMinMaxPercentOfCategory.getWallXY().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.calculatePercentMinMaxPercentOfCategory.getWallXYAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.calculatePercentMinMaxPercentOfCategory.getWallYZ() != null && this.calculatePercentMinMaxPercentOfCategory.getWallYZ().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.calculatePercentMinMaxPercentOfCategory.getWallYZAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.calculatePercentMinMaxPercentOfCategory.getWallFloor() != null && this.calculatePercentMinMaxPercentOfCategory.getWallFloor().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.calculatePercentMinMaxPercentOfCategory.getWallFloorAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
    }

    @Override
    public Vector getChartObjects() {
        Vector<ChartObject> vector = new Vector<ChartObject>();
        vector.add(this);
        if (this.Z != null) {
            this.Z.setType("x1");
            vector.add(this.Z);
        }
        if (this.C != null) {
            this.C.setType("y1");
            vector.add(this.C);
        }
        if (this.B != null && this.getBackground[1] == 768) {
            this.B.setType("z");
            vector.add(this.B);
        }
        if (this.Z != null && this.abs != null) {
            this.abs.setType("x1");
            this.abs.setAxis(this.Z);
            vector.add(this.abs);
        }
        if (this.C != null && this.add != null) {
            this.add.setType("y1");
            this.add.setAxis(this.C);
            vector.add(this.add);
        }
        if (this.B != null && this.adjustDistance != null && this.getBackground[1] == 768) {
            this.adjustDistance.setType("z");
            this.adjustDistance.setAxis(this.B);
            vector.add(this.adjustDistance);
        }
        if (this.calculatePercentMinMaxPercentOfCategory != null && this.calculatePercentMinMaxPercentOfCategory.getWallXY() != null) {
            this.calculatePercentMinMaxPercentOfCategory.getWallXY().setType("xy");
            vector.add(this.calculatePercentMinMaxPercentOfCategory.getWallXY());
        }
        if (this.calculatePercentMinMaxPercentOfCategory != null && this.calculatePercentMinMaxPercentOfCategory.getWallFloor() != null) {
            this.calculatePercentMinMaxPercentOfCategory.getWallFloor().setType("floor");
            vector.add(this.calculatePercentMinMaxPercentOfCategory.getWallFloor());
        }
        if (this.calculatePercentMinMaxPercentOfCategory != null && this.calculatePercentMinMaxPercentOfCategory.getWallYZ() != null) {
            this.calculatePercentMinMaxPercentOfCategory.getWallYZ().setType("yz");
            vector.add(this.calculatePercentMinMaxPercentOfCategory.getWallYZ());
        }
        return vector;
    }

    @Override
    public Rectangle getGraphArea() {
        return this.getChartLinkInfo;
    }

    @Override
    public Shape[] getAxisY2Shapes() {
        return null;
    }

    @Override
    public Shape[] getAxisYShapes() {
        if (this.C == null) {
            return null;
        }
        return this.C.getAxisShapes();
    }

    @Override
    public String[] getY2Labels() {
        return null;
    }

    @Override
    public String[] getYLabels() {
        if (this.C == null) {
            return null;
        }
        return ((ChartNumericAxis)this.C).getLabelsForHtml();
    }

    public float getMaxAxisValue() {
        return this.getAxisZProperties;
    }

    public float getMinAxisValue() {
        return this.getAxisYProperties;
    }

    @Override
    public ChartAxis getAxisX1() {
        return this.Z;
    }

    protected boolean isCustommerConstantAxis(boolean bl) {
        boolean bl2 = false;
        if (this.SEDU != null && this.SEDU.size() >= 1) {
            for (int i = 0; i < this.SEDU.size(); ++i) {
                ChartDataSet chartDataSet = (ChartDataSet)this.SEDU.get(i);
                if (bl && chartDataSet.getChartDataSetInfo().getAxisInfo() != 0 || !bl && chartDataSet.getChartDataSetInfo().getAxisInfo() != 1) continue;
                int n = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
                int n2 = ChartTypeInfo.getSubType(chartDataSet.getChartDataSetInfo().getChartType());
                int n3 = ChartTypeInfo.getEffect(chartDataSet.getChartDataSetInfo().getChartType());
                if ((n == 0 || n == 1 || n == 2 || n == 3) && n3 == 4096) {
                    if (n == 0 || n == 1) {
                        bl2 = true;
                        continue;
                    }
                    if (n == 2 && n2 == 768) {
                        bl2 = true;
                        continue;
                    }
                    if (n != 3) continue;
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    void after() {
        if (this.Z != null && this.Z.getConstantStartEnd() != null) {
            Object[] objectArray = this.Z.getConstantStartEnd();
            List list = this.getChartPlatform().getDataSetModel().getCategoryNames();
            int n = list.size();
            if (objectArray[0] instanceof Number) {
                Object e;
                int n2;
                this.getChartPlatform = new int[]{-1, -1};
                for (n2 = 0; n2 < list.size(); ++n2) {
                    e = list.get(n2);
                    if (!(e instanceof Number) || !(((Number)e).floatValue() >= ((Number)objectArray[0]).floatValue())) continue;
                    this.getChartPlatform[0] = n2;
                    break;
                }
                this.getChartPlatform[1] = this.getChartPlatform[0];
                for (n2 = n - 1; n2 >= 0; --n2) {
                    e = list.get(n2);
                    if (!(e instanceof Number) || !(((Number)e).floatValue() <= ((Number)objectArray[1]).floatValue())) continue;
                    this.getChartPlatform[1] = n2;
                    break;
                }
            } else if (objectArray[0] instanceof Date) {
                Object e;
                int n3;
                this.getChartPlatform = new int[]{-1, -1};
                for (n3 = 0; n3 < list.size(); ++n3) {
                    e = list.get(n3);
                    if (!(e instanceof Date) || ((Date)e).before((Date)objectArray[0])) continue;
                    this.getChartPlatform[0] = n3;
                    break;
                }
                this.getChartPlatform[1] = this.getChartPlatform[0];
                for (n3 = n - 1; n3 >= 0; --n3) {
                    e = list.get(n3);
                    if (!(e instanceof Date) || ((Date)e).after((Date)objectArray[1])) continue;
                    this.getChartPlatform[1] = n3;
                    break;
                }
            }
            if (this.getChartPlatform != null && (this.getChartPlatform[0] == -1 || this.getChartPlatform[1] == -1)) {
                this.getChartPlatform = null;
            }
        }
    }

    @Override
    public int[] getFilterConstant() {
        return this.getChartPlatform;
    }

    public ChartAxis getAxisZ() {
        return this.B;
    }

    @Override
    public int[] getLinkInfo(int n, int n2) {
        this.getCategoryFilter = n;
        this.getCategoryName = n2;
        int[] nArray = null;
        if (this.custommerConstant != null && this.custommerConstant[0] != null && this.properties.isShowTips() && (nArray = this.custommerConstant[0].searchLinkInfo(n, n2)) != null) {
            return nArray;
        }
        int n3 = -1;
        n3 = this.background(true, n, n2);
        if (n3 != -1 && this.I.getShowValueConditions() != null && this.I.getShowValueConditions().getXLink() != null) {
            nArray = ((ChartDataUsedInfo)this.I.getShowValueConditions().getXLink().get(n3)).getChartLinkInfo();
            return nArray;
        }
        n3 = this.background(false, n, n2);
        if (n3 != -1 && this.I.getShowValueConditions() != null && this.I.getShowValueConditions().getZLink() != null) {
            nArray = ((ChartDataUsedInfo)this.I.getShowValueConditions().getZLink().get(n3)).getChartLinkInfo();
            return nArray;
        }
        return nArray;
    }

    private int background(boolean bl, int n, int n2) {
        int n3 = -1;
        if (bl) {
            if (this.Z != null) {
                n3 = this.Z.searchAxisLabelIndex(n, n2);
            }
        } else if (this.B != null) {
            n3 = this.B.searchAxisLabelIndex(n, n2);
        }
        return n3;
    }
}

