/*
 * Decompiled with CFR 0.152.
 */
package chart.data;

import chart.ChartLegendLabel;
import chart.ChartPlatform;
import chart.ChartShowValueCondition;
import chart.ChartShowValueInfo;
import chart.ChartShowValueSubCondition;
import chart.data.Chart1DDataSeries;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.data.ChartValueMap;
import chart.util.ChartMath;
import chart.util.ChartRenderTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class Chart1DDataSet
extends ChartDataSet {
    static final float[][] SEDU = new float[][]{{0.54f, 0.75f, 0.85f, 0.75f}, {0.92f, 0.6f, 0.7f, 0.6f}, {0.68f, 0.87f, 0.37f, 0.67f}, {0.38f, 0.77f, 0.27f, 0.87f}};
    double abs;
    double add;
    Number[][] addValue;
    Number[][] canSwitchGroup;
    ChartShowValueCondition[] clone;
    private Vector constructPercentFilter;
    public boolean filterNullValue = false;
    ChartShowValueSubCondition[][] doubleValue;
    ChartShowValueSubCondition[][] floatValue;
    String[][] formatValues;
    int get;

    public Chart1DDataSet(ChartDataSetModel chartDataSetModel, ChartDataSetInfo chartDataSetInfo) {
        super(chartDataSetModel, chartDataSetInfo);
    }

    public Chart1DDataSet(ChartDataSetModel chartDataSetModel, List list, ChartDataSetInfo chartDataSetInfo) {
        super(chartDataSetModel, chartDataSetInfo);
        this.C = list;
    }

    @Override
    public void initDataSeries() {
        this.Z = new ArrayList();
        ChartValueMap chartValueMap = this.B.getValueMap();
        int n = this.B.getCategoryCount();
        int n2 = this.B.getSeriesCount();
        this.get = this.B.getValueSqlType();
        for (int i = 0; i < this.C.size(); ++i) {
            List list = (List)this.C.get(i);
            for (int j = 0; j < n2; ++j) {
                Chart1DDataSeries chart1DDataSeries = new Chart1DDataSeries();
                List list2 = (List)list.get(j);
                for (int k = 0; k < n; ++k) {
                    if (this.get == 0) {
                        Number number = chartValueMap.getValue(list2.get(k));
                        chart1DDataSeries.addValue(number);
                        continue;
                    }
                    String string = chartValueMap.getValueForString(list2.get(k));
                    chart1DDataSeries.addValue(string);
                }
                this.Z.add(chart1DDataSeries);
            }
        }
        if (this.get == 0) {
            this.addValue = this.formatValues();
        } else {
            this.formatValues = this.SEDU();
        }
    }

    private String[][] SEDU() {
        int n = this.getCategorySize();
        int n2 = this.getSeriesSize();
        String[][] stringArray = null;
        if (n2 > 0) {
            stringArray = new String[n2][n];
            for (int i = 0; i < n2; ++i) {
                Chart1DDataSeries chart1DDataSeries = (Chart1DDataSeries)this.Z.get(i);
                for (int j = 0; j < n; ++j) {
                    stringArray[i][j] = chart1DDataSeries.getStringVaule(j);
                }
            }
        }
        return stringArray;
    }

    static List I(int n, int n2, int n3, double d, double d2, boolean bl, int[] nArray) {
        int n4;
        int n5;
        ArrayList arrayList = new ArrayList();
        Random random = new Random();
        int[][][] nArray2 = new int[n2][n][n3];
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                int n6;
                double d3 = 0.0;
                d3 = random.nextDouble() * (d2 - d);
                for (n6 = 0; n6 < nArray[0]; ++n6) {
                    nArray2[n5][n4][n6] = (int)d3;
                    if (n6 <= 0) continue;
                    nArray2[n5][n4][n6] = (int)((double)nArray2[n5][n4][n6 - 1] * (1.0 + random.nextDouble() + 0.2));
                }
                if (nArray[0] >= 1) {
                    for (n6 = 0; n6 < nArray[1]; ++n6) {
                        nArray2[n5][n4][n6 + nArray[0]] = (int)((double)nArray2[n5][n4][n6 - 1 + nArray[0]] * (1.0 - random.nextDouble()));
                    }
                    for (n6 = 0; n6 < nArray[2]; ++n6) {
                        int n7 = (int)(random.nextDouble() * 10.0);
                        nArray2[n5][n4][n6 + nArray[0] + nArray[1]] = (int)((double)nArray2[n5][n4][n7 % nArray[0]] * (1.0 - random.nextDouble()));
                    }
                    continue;
                }
                for (n6 = 0; n6 < nArray[1]; ++n6) {
                    nArray2[n5][n4][n6] = (int)d3;
                    if (n6 <= 0) continue;
                    nArray2[n5][n4][n6] = (int)((double)nArray2[n5][n4][n6 - 1] * (1.0 + random.nextDouble()));
                }
                for (n6 = 0; n6 < nArray[2]; ++n6) {
                    nArray2[n5][n4][n6 + nArray[0] + nArray[1]] = (int)(d3 * (d2 + d2));
                }
            }
        }
        for (n5 = 0; n5 < n3; ++n5) {
            ArrayList arrayList2 = new ArrayList();
            for (n4 = 0; n4 < n2; ++n4) {
                ArrayList<Number> arrayList3 = new ArrayList<Number>();
                for (int i = 0; i < n; ++i) {
                    double d4 = 0.0;
                    d4 = bl ? d + (double)nArray2[n4][i][n5] : d + (double)SEDU[n4][i] * (d2 - d);
                    if (d2 - d > 5.0) {
                        arrayList3.add(new Integer((int)d4));
                        continue;
                    }
                    arrayList3.add(new Double(d4));
                }
                arrayList2.add(arrayList3);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    static List I(int n, int n2, int n3, double d, double d2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Random random = new Random();
        for (int i = 0; i < n3; ++i) {
            ArrayList arrayList2 = new ArrayList();
            for (int j = 0; j < n2; ++j) {
                ArrayList<Number> arrayList3 = new ArrayList<Number>();
                for (int k = 0; k < n; ++k) {
                    double d3 = 0.0;
                    d3 = bl ? d + random.nextDouble() * (d2 - d) : d + (double)SEDU[j][k] * (d2 - d);
                    if (d2 - d > 5.0) {
                        arrayList3.add(new Integer((int)d3));
                        continue;
                    }
                    arrayList3.add(new Double(d3));
                }
                arrayList2.add(arrayList3);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public double[] calculatePercentMinMaxPercentOfCategory() {
        double[] dArray = new double[2];
        if (this.B.Z && this.getSeriesSize() == 1) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.getCategorySize(); ++n) {
                d += this.getAbsoluteValueSumOfCategory(n);
            }
            for (n = 0; n < this.getSeriesSize(); ++n) {
                for (int i = 0; i < this.getCategorySize(); ++i) {
                    if (!this.getCategoryName(i)) continue;
                    Number number = this.addValue[n][i];
                    double d2 = d = d < Double.MIN_VALUE ? 1.0 : d;
                    if (number == null) continue;
                    double d3 = number.doubleValue() / d;
                    dArray[0] = dArray[0] < d3 ? dArray[0] : d3;
                    dArray[1] = dArray[1] > d3 ? dArray[1] : d3;
                }
            }
        } else {
            for (int i = 0; i < this.getSeriesSize(); ++i) {
                for (int j = 0; j < this.getCategorySize(); ++j) {
                    if (!this.getCategoryName(j)) continue;
                    Number number = this.addValue[i][j];
                    double d = this.getAbsoluteValueSumOfCategory(j);
                    double d4 = d = d < Double.MIN_VALUE ? 1.0 : d;
                    if (number == null) continue;
                    double d5 = number.doubleValue() / d;
                    dArray[0] = dArray[0] < d5 ? dArray[0] : d5;
                    dArray[1] = dArray[1] > d5 ? dArray[1] : d5;
                }
            }
        }
        return dArray;
    }

    @Override
    public void calculateMinMax() {
        this.abs = 0.0;
        this.add = 0.0;
        boolean bl = true;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            for (int j = 0; j < this.getCategorySize(); ++j) {
                if (!this.getCategoryName(j)) continue;
                Number number = this.addValue[i][j];
                double d = this.getAbsoluteValueSumOfCategory(j);
                double d2 = d = d < Double.MIN_VALUE ? 1.0 : d;
                if (number == null) continue;
                bl = false;
                double d3 = this.D.Z == 2 ? number.doubleValue() / d : number.doubleValue();
                this.abs = this.abs < d3 ? this.abs : d3;
                this.add = this.add > d3 ? this.add : d3;
            }
        }
        this.A = bl;
    }

    @Override
    public double getMin() {
        return this.abs;
    }

    @Override
    public double getMax() {
        return this.add;
    }

    public Number getValue(int n, int n2) {
        return this.addValue[n][n2];
    }

    public Number[][] getValues() {
        return this.addValue;
    }

    public Number[][] getOriginValues() {
        return this.canSwitchGroup;
    }

    public String[][] getStringValues() {
        return this.formatValues;
    }

    public Number getOriginValue(int n, int n2) {
        if (this.getSeriesSize() <= 0) {
            return null;
        }
        Chart1DDataSeries chart1DDataSeries = (Chart1DDataSeries)this.Z.get(n);
        Number number = chart1DDataSeries.getValue(n2);
        return number;
    }

    public Number[][] formatValues() {
        boolean bl = false;
        if (this.D.Z == 2) {
            this.F = ChartRenderTools.constructPercentFilter(this.F, false);
            this.F.setLogScale(false);
            if (this.D.getAxisInfo() == 0) {
                this.B.setPrimFilter(this.F);
            } else {
                this.B.setSecFilter(this.F);
            }
        }
        if (this.F != null) {
            this.F.init();
            bl = this.F.isLogScale();
        }
        boolean bl2 = this.D.B == 2;
        boolean bl3 = this.D.Z != 0;
        int n = this.getCategorySize();
        int n2 = this.getSeriesSize();
        Number[][] numberArray = null;
        if (n2 > 0) {
            numberArray = new Number[n2][n];
            for (int i = 0; i < n2; ++i) {
                Chart1DDataSeries chart1DDataSeries = (Chart1DDataSeries)this.Z.get(i);
                for (int j = 0; j < n; ++j) {
                    numberArray[i][j] = chart1DDataSeries.getValue(j);
                }
            }
            this.canSwitchGroup = (Number[][])numberArray.clone();
            if (bl) {
                if (bl2) {
                    if (bl3) {
                        boolean[][] blArray = new boolean[n2][n];
                        this.canSwitchGroup(numberArray, blArray);
                        this.doubleValue(numberArray);
                        this.filterNullValue(numberArray);
                        this.clone(numberArray, blArray);
                        this.constructPercentFilter(numberArray);
                    } else {
                        this.addValue(numberArray);
                        this.filterNullValue(numberArray);
                        this.constructPercentFilter(numberArray);
                    }
                } else if (bl3) {
                    boolean[][] blArray = new boolean[n2][n];
                    this.canSwitchGroup(numberArray, blArray);
                    this.doubleValue(numberArray);
                    this.filterNullValue(numberArray);
                    this.clone(numberArray, blArray);
                } else {
                    this.addValue(numberArray);
                    this.filterNullValue(numberArray);
                }
            } else if (bl2) {
                this.constructPercentFilter(numberArray);
                if (bl3) {
                    this.doubleValue(numberArray);
                }
            } else if (bl3) {
                Number[][] numberArray2 = new Number[n2][n];
                Number[][] numberArray3 = new Number[n2][n];
                boolean[][] blArray = new boolean[n2][n];
                this.add(numberArray, numberArray2, numberArray3, blArray);
                this.doubleValue(numberArray2);
                this.doubleValue(numberArray3);
                this.clone(numberArray2, blArray);
                numberArray = this.abs(numberArray2, numberArray3, blArray);
            }
        }
        return numberArray;
    }

    private Number[][] abs(Number[][] numberArray, Number[][] numberArray2, boolean[][] blArray) {
        int n = blArray.length;
        int n2 = blArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (numberArray[i][j] != null || !blArray[i][j]) continue;
                numberArray[i][j] = numberArray2[i][j];
            }
        }
        return numberArray;
    }

    private void add(Number[][] numberArray, Number[][] numberArray2, Number[][] numberArray3, boolean[][] blArray) {
        int n = numberArray.length;
        int n2 = numberArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (numberArray[i][j] == null) continue;
                if (numberArray[i][j].doubleValue() < 0.0) {
                    numberArray3[i][j] = numberArray[i][j];
                    blArray[i][j] = true;
                    continue;
                }
                numberArray2[i][j] = numberArray[i][j];
            }
        }
    }

    private void addValue(Number[][] numberArray) {
        int n = numberArray.length;
        int n2 = numberArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (numberArray[i][j] == null || !(numberArray[i][j].doubleValue() <= 0.0)) continue;
                numberArray[i][j] = null;
            }
        }
    }

    private void canSwitchGroup(Number[][] numberArray, boolean[][] blArray) {
        int n = numberArray.length;
        int n2 = numberArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (numberArray[i][j] == null || !(numberArray[i][j].doubleValue() <= 0.0)) continue;
                numberArray[i][j] = null;
                blArray[i][j] = true;
            }
        }
    }

    private void clone(Number[][] numberArray, boolean[][] blArray) {
        int n = numberArray.length;
        int n2 = numberArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!blArray[i][j]) continue;
                numberArray[i][j] = null;
            }
        }
    }

    private void constructPercentFilter(Number[][] numberArray) {
        int n = numberArray.length;
        int n2 = numberArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (numberArray[i][j] == null || !(numberArray[i][j].doubleValue() < 0.0)) continue;
                numberArray[i][j] = new Double(numberArray[i][j].doubleValue());
            }
        }
    }

    private void doubleValue(Number[][] numberArray) {
        int n = numberArray.length;
        int n2 = numberArray[0].length;
        for (int i = 0; i < n2; ++i) {
            Number number = numberArray[0][i];
            for (int j = 1; j < n; ++j) {
                if (number != null) {
                    if (numberArray[j][i] != null) {
                        numberArray[j][i] = new Double(numberArray[j][i].doubleValue() + number.doubleValue());
                        number = numberArray[j][i];
                        continue;
                    }
                    numberArray[j][i] = number;
                    continue;
                }
                if (numberArray[j][i] == null) continue;
                number = numberArray[j][i];
            }
        }
    }

    private void filterNullValue(Number[][] numberArray) {
        int n = numberArray.length;
        int n2 = numberArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (numberArray[i][j] == null) continue;
                numberArray[i][j] = new Double(ChartMath.log10(numberArray[i][j]).doubleValue());
            }
        }
    }

    public double getSumOfCategory(int n) {
        double d = 0.0;
        for (int i = 0; i < this.Z.size(); ++i) {
            Number number = ((Chart1DDataSeries)this.Z.get(i)).getValue(n);
            if (number == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public double getAbsoluteValueSumOfCategory(int n) {
        double d = 0.0;
        for (int i = 0; i < this.Z.size(); ++i) {
            Number number = ((Chart1DDataSeries)this.Z.get(i)).getValue(n);
            if (number == null) continue;
            d += Math.abs(number.doubleValue());
        }
        return d;
    }

    public double getAbsoluteValueSum() {
        double d = 0.0;
        for (int i = 0; i < this.Z.size(); ++i) {
            for (int j = 0; j < this.getCategorySize(); ++j) {
                Number number = ((Chart1DDataSeries)this.Z.get(i)).getValue(j);
                if (number == null) continue;
                d += Math.abs(number.doubleValue());
            }
        }
        return d;
    }

    public double getSumOfSeries(int n) {
        return ((Chart1DDataSeries)this.Z.get(n)).getSum();
    }

    public double getAbsoluteValueSumOfSeries(int n) {
        return ((Chart1DDataSeries)this.Z.get(n)).getAbsoluteValueSum();
    }

    @Override
    public List getLegendSeriesLabels() {
        ArrayList<Object> arrayList;
        block25: {
            int n;
            block26: {
                boolean bl;
                block24: {
                    arrayList = new ArrayList<Object>();
                    n = ChartTypeInfo.getPrimType(this.D.getChartType());
                    bl = this.B.Z;
                    if (!this.B.isOneGroupForBar() || this.B.isTurnedXZ() || this.B.I.size() != 1) break block24;
                    for (int i = 0; i < this.getCategorySize(); ++i) {
                        arrayList.add(this.B.getCategoryName(i));
                    }
                    break block25;
                }
                if (!bl || n != 2 && n != 3 && n != 5 && n != 6 && this.B.I.size() <= 1 && (n != 0 && n != 1 || this.B.getYcnt() <= 1)) break block26;
                if (this.J == null) break block25;
                int n2 = ChartTypeInfo.getSubType(this.D.getChartType());
                int n3 = ChartTypeInfo.getEffect(this.D.getChartType());
                if (n == 0 && n2 == 0 && n3 == 0) {
                    if (this.constructPercentFilter != null) {
                        this.constructPercentFilter = null;
                    }
                    for (int i = 0; i < this.J.length; ++i) {
                        if (!this.floatValue(i)) {
                            arrayList.add(this.J[i]);
                            continue;
                        }
                        if (this.constructPercentFilter == null) {
                            this.constructPercentFilter = new Vector();
                        }
                        this.constructPercentFilter.add(new Integer(i));
                    }
                } else {
                    for (int i = 0; i < this.J.length; ++i) {
                        arrayList.add(this.J[i]);
                    }
                }
                break block25;
            }
            switch (n) {
                case 7: {
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.getCategorySize(); ++i) {
                        arrayList.add(this.B.getCategoryName(i));
                    }
                    break;
                }
                case 0: {
                    int n4 = ChartTypeInfo.getSubType(this.D.getChartType());
                    int n5 = ChartTypeInfo.getEffect(this.D.getChartType());
                    if (n4 == 0 && n5 == 0) {
                        if (this.constructPercentFilter != null) {
                            this.constructPercentFilter = null;
                        }
                        for (int i = 0; i < this.Z.size(); ++i) {
                            if (!this.floatValue(i)) {
                                arrayList.add(this.B.getSeriesName(i % this.B.getSeriesCount()));
                                continue;
                            }
                            if (this.constructPercentFilter == null) {
                                this.constructPercentFilter = new Vector();
                            }
                            this.constructPercentFilter.add(new Integer(i));
                        }
                    } else {
                        for (int i = 0; i < this.Z.size(); ++i) {
                            arrayList.add(this.B.getSeriesName(i % this.B.getSeriesCount()));
                        }
                    }
                    break;
                }
                case 11: {
                    for (int i = 0; i < this.getCategorySize(); ++i) {
                        arrayList.add(this.B.getCategoryName(i));
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < this.Z.size(); ++i) {
                        arrayList.add(this.B.getSeriesName(i % this.B.getSeriesCount()));
                    }
                    break;
                }
            }
        }
        return arrayList;
    }

    @Override
    public List getFilterLegendSeriesLabels() {
        ArrayList<String> arrayList;
        block25: {
            int n;
            block26: {
                boolean bl;
                block24: {
                    arrayList = new ArrayList<String>();
                    n = ChartTypeInfo.getPrimType(this.D.getChartType());
                    bl = this.B.Z;
                    if (!this.B.isOneGroupForBar() || this.B.isTurnedXZ() || this.B.I.size() != 1) break block24;
                    for (int i = 0; i < this.getCategorySize(); ++i) {
                        arrayList.add(this.B.getFilteredCategoryName(i));
                    }
                    break block25;
                }
                if (!bl || n != 2 && n != 3 && n != 5 && n != 6 && this.B.I.size() <= 1 && (n != 0 && n != 1 || this.B.getYcnt() <= 1)) break block26;
                if (this.J == null) break block25;
                int n2 = ChartTypeInfo.getSubType(this.D.getChartType());
                int n3 = ChartTypeInfo.getEffect(this.D.getChartType());
                if (n == 0 && n2 == 0 && n3 == 0) {
                    if (this.constructPercentFilter != null) {
                        this.constructPercentFilter = null;
                    }
                    for (int i = 0; i < this.J.length; ++i) {
                        if (!this.floatValue(i)) {
                            arrayList.add(this.J[i]);
                            continue;
                        }
                        if (this.constructPercentFilter == null) {
                            this.constructPercentFilter = new Vector();
                        }
                        this.constructPercentFilter.add(new Integer(i));
                    }
                } else {
                    for (int i = 0; i < this.J.length; ++i) {
                        arrayList.add(this.J[i]);
                    }
                }
                break block25;
            }
            switch (n) {
                case 7: {
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.getCategorySize(); ++i) {
                        arrayList.add(this.B.getFilteredCategoryName(i));
                    }
                    break;
                }
                case 0: {
                    int n4 = ChartTypeInfo.getSubType(this.D.getChartType());
                    int n5 = ChartTypeInfo.getEffect(this.D.getChartType());
                    if (n4 == 0 && n5 == 0) {
                        if (this.constructPercentFilter != null) {
                            this.constructPercentFilter = null;
                        }
                        for (int i = 0; i < this.Z.size(); ++i) {
                            if (!this.floatValue(i)) {
                                arrayList.add(this.B.getFilteredSeriesName(i % this.B.getSeriesCount()));
                                continue;
                            }
                            if (this.constructPercentFilter == null) {
                                this.constructPercentFilter = new Vector();
                            }
                            this.constructPercentFilter.add(new Integer(i));
                        }
                    } else {
                        for (int i = 0; i < this.Z.size(); ++i) {
                            arrayList.add(this.B.getFilteredSeriesName(i % this.B.getSeriesCount()));
                        }
                    }
                    break;
                }
                case 11: {
                    for (int i = 0; i < this.getCategorySize(); ++i) {
                        arrayList.add(this.B.getFilteredCategoryName(i));
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < this.Z.size(); ++i) {
                        arrayList.add(this.B.getFilteredSeriesName(i % this.B.getSeriesCount()));
                    }
                    break;
                }
            }
        }
        return arrayList;
    }

    private boolean floatValue(int n) {
        boolean bl = false;
        if (this.filterNullValue) {
            int n2 = this.getCategorySize();
            for (int i = 0; i < n2; ++i) {
                Number number = this.getOriginValue(n, i);
                if (number != null && number.floatValue() != 0.0f) {
                    bl = false;
                    break;
                }
                bl = true;
            }
        }
        return bl;
    }

    public double[][] getPercentOfGroup() {
        int n = this.Z.size();
        int n2 = this.B.getCategoryCount();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            double d = this.getAbsoluteValueSumOfSeries(i);
            for (int j = 0; j < n2; ++j) {
                if (this.getValue(i, j) == null) continue;
                dArray[i][j] = this.getValue(i, j).doubleValue() / d;
            }
        }
        return dArray;
    }

    public String getFormatedHintValue(int n, int n2) {
        Number number = ((Chart1DDataSeries)this.Z.get(n)).getValue(n2);
        return this.B.getFormatedHintValue(number);
    }

    public boolean[][] isNullValue() {
        int n = this.getSeriesSize();
        int n2 = this.getCategorySize();
        boolean[][] blArray = new boolean[n][n2];
        for (int i = 0; i < n; ++i) {
            Chart1DDataSeries chart1DDataSeries = (Chart1DDataSeries)this.Z.get(i);
            for (int j = 0; j < n2; ++j) {
                if (this.get == 0) {
                    if (chart1DDataSeries.getValue(j) == null) {
                        blArray[i][j] = true;
                        continue;
                    }
                    blArray[i][j] = false;
                    continue;
                }
                blArray[i][j] = chart1DDataSeries.getStringVaule(j) == null;
            }
        }
        return blArray;
    }

    public double[] getMeanValue() {
        int n = this.getSeriesSize();
        int n2 = this.getCategorySize();
        double[] dArray = new double[n2];
        boolean bl = false;
        if (this.F != null) {
            bl = this.F.isLogScale();
        }
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                Chart1DDataSeries chart1DDataSeries = (Chart1DDataSeries)this.Z.get(j);
                if (chart1DDataSeries.getValue(i) == null) continue;
                d += chart1DDataSeries.getValue(i).doubleValue();
            }
            if (n > 0) {
                dArray[i] = d / (double)n;
            }
            if (!bl) continue;
            dArray[i] = ChartMath.log10(dArray[i]);
        }
        return dArray;
    }

    @Override
    public void setValuesName(String[] stringArray, int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (stringArray != null) {
            int n3 = n2 - n;
            this.J = new String[n3];
            for (int i = 0; i < n3; ++i) {
                this.J[i] = stringArray[i + n];
            }
        }
    }

    public String getValuesName(int n) {
        if (this.J.length == 1) {
            return this.J[0];
        }
        int n2 = this.getSeriesSize() / this.J.length;
        return this.J[n / n2];
    }

    public List getLegendSeriesAllLabels() {
        ArrayList<Object> arrayList;
        block9: {
            int n;
            block10: {
                boolean bl;
                block8: {
                    arrayList = new ArrayList<Object>();
                    n = ChartTypeInfo.getPrimType(this.D.getChartType());
                    bl = this.B.Z;
                    if (!this.B.isOneGroupForBar() || this.B.isTurnedXZ() || this.B.I.size() != 1) break block8;
                    for (int i = 0; i < this.getCategorySize(); ++i) {
                        arrayList.add(this.B.getCategoryName(i));
                    }
                    break block9;
                }
                if (!bl || n != 2 && n != 3 && n != 5 && n != 6 && this.B.I.size() <= 1 && (n != 0 && n != 1 || this.B.getYcnt() <= 1)) break block10;
                if (this.J == null) break block9;
                for (int i = 0; i < this.J.length; ++i) {
                    arrayList.add(this.J[i]);
                }
                break block9;
            }
            switch (n) {
                case 7: {
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.getCategorySize(); ++i) {
                        arrayList.add(this.B.getCategoryName(i));
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < this.Z.size(); ++i) {
                        arrayList.add(this.B.getSeriesName(i % this.B.getSeriesCount()));
                    }
                    break;
                }
            }
        }
        return arrayList;
    }

    public Vector getDispleyLabelIndex() {
        return this.constructPercentFilter;
    }

    @Override
    public boolean isChartConditionalDataSet() {
        return true;
    }

    @Override
    public void setChartConditions(ChartPlatform chartPlatform) {
        if (chartPlatform.getShowValueConditions() != null) {
            int n = this.getShowValueBeginIndex();
            int n2 = this.getShowValueEndIndex();
            this.clone = new ChartShowValueCondition[n2 - n];
            int n3 = this.getChartDataSetInfo().getChartType();
            int n4 = this.getChartDataSetInfo().getAxisInfo();
            String[][] stringArray = this.B.getAllShowValue();
            int n5 = n;
            int n6 = 0;
            while (n5 < n2) {
                int n7 = Integer.parseInt(stringArray[n5][0]);
                String string = stringArray[n5][1];
                String string2 = stringArray[n5][2];
                ChartShowValueInfo chartShowValueInfo = new ChartShowValueInfo(n7, n3, n4, string2, string);
                ChartShowValueCondition chartShowValueCondition = chartPlatform.getShowValueConditions().getShowValueCondition(chartShowValueInfo);
                this.clone[n6] = chartShowValueCondition != null && chartShowValueCondition.getConditionType() != 0 ? chartPlatform.getShowValueConditions().getShowValueCondition(chartShowValueInfo) : chartPlatform.getShowValueConditions().getShowValueCondition(chartShowValueInfo);
                ++n5;
                ++n6;
            }
        }
    }

    protected void isSwapedGroup() {
        this.getSeriesSize();
    }

    @Override
    public void initCondition() {
        block9: {
            int n;
            if (this.clone == null) break block9;
            boolean bl = true;
            for (n = 0; n < this.clone.length; ++n) {
                if (this.clone[n] == null) continue;
                bl = false;
                break;
            }
            if (bl) {
                return;
            }
            n = this.getSeriesSize();
            int n2 = this.getCategorySize();
            if (this.B.canSwitchGroup() && this.B.getCategoryNmae() == null && this.clone.length > 1) {
                this.doubleValue = new ChartShowValueSubCondition[n][n2];
                this.floatValue = new ChartShowValueSubCondition[n][n2];
                for (int i = 0; i < this.clone.length && i < n2; ++i) {
                    int n3;
                    List list;
                    if (this.clone[i] == null || (list = this.clone[i].getConditionIndexList()) == null) continue;
                    for (n3 = 0; n3 < n; ++n3) {
                        this.doubleValue[n3][i] = this.clone[i].getSubCondition((Integer)((List)list.get(n3)).get(0));
                    }
                    list = this.clone[i].getLineConditionIndexList();
                    if (list == null) continue;
                    for (n3 = 0; n3 < n; ++n3) {
                        this.floatValue[n3][i] = this.clone[i].getLineSubCondition((Integer)((List)list.get(n3)).get(0));
                    }
                }
            } else {
                this.doubleValue = new ChartShowValueSubCondition[n][n2];
                this.floatValue = new ChartShowValueSubCondition[n][n2];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        this.formatValues(i, j);
                    }
                }
            }
        }
    }

    void formatValues(int n, int n2) {
        List list;
        List list2;
        int n3;
        int n4 = this.B.getSeriesNames() == null ? 0 : this.B.getSeriesNames().size();
        int n5 = n3 = n4 <= 1 ? n : n / n4;
        if (n3 < 0 || n3 >= this.clone.length) {
            return;
        }
        int n6 = n % n4;
        int n7 = n2;
        ChartShowValueCondition chartShowValueCondition = this.clone[n3];
        if (chartShowValueCondition == null) {
            return;
        }
        if (chartShowValueCondition.getConditionIndexList() != null && (list2 = (List)(list = chartShowValueCondition.getConditionIndexList()).get(n6)).size() > n2) {
            this.doubleValue[n][n2] = chartShowValueCondition.getSubCondition((Integer)list2.get(n2));
        }
        if (chartShowValueCondition.getLineConditionIndexList() != null && (list2 = (List)(list = chartShowValueCondition.getLineConditionIndexList()).get(n6)).size() > n2) {
            this.floatValue[n][n2] = chartShowValueCondition.getLineSubCondition((Integer)list2.get(n2));
        }
    }

    @Override
    public ChartShowValueCondition getCondition(int n, int n2) {
        int n3;
        int n4;
        if (this.clone != null && (n4 = n / (n3 = this.B.getSeriesCount() == 0 ? 1 : this.B.getSeriesCount())) >= 0 && n4 < this.clone.length) {
            return this.clone[n4];
        }
        return null;
    }

    @Override
    public ChartShowValueSubCondition getSubCondition(int n, int n2) {
        try {
            return this.doubleValue == null ? null : this.doubleValue[n][n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public ChartShowValueSubCondition getLineSubCondition(int n, int n2) {
        try {
            return this.floatValue == null ? null : this.floatValue[n][n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public List getLegnedLabels() {
        if (this.S) {
            return this.getAbsoluteValueSumOfCategory();
        }
        int n = ChartTypeInfo.getPrimType(this.D.getChartType());
        boolean bl = this.B.Z;
        if (n == 4 && this.B.getYcnt() <= 1 || this.B.isOneGroupForBar() && !this.B.isTurnedXZ() && this.B.I.size() == 1) {
            return this.get();
        }
        if (bl && (n == 2 || n == 3 || n == 5 || n == 6 || this.B.I.size() > 1 || (n == 0 || n == 1) && this.B.getYcnt() > 1)) {
            return this.getAbsoluteValueSumOfCategory();
        }
        return this.getAbsoluteValueSumOfSeries();
    }

    List get() {
        ArrayList<ChartLegendLabel> arrayList = new ArrayList<ChartLegendLabel>();
        int n = ChartTypeInfo.getPrimType(this.getChartDataSetInfo().getChartType());
        int n2 = ChartTypeInfo.getSubType(this.getChartDataSetInfo().getChartType());
        if (this.clone != null && this.clone[0] != null && this.getAllShowValue(n, n2, this.clone[0])) {
            this.getAxisInfo(arrayList, this.clone[0], 0);
            return arrayList;
        }
        for (int i = 0; i < this.getCategorySize(); ++i) {
            ChartLegendLabel chartLegendLabel = new ChartLegendLabel(this.B.getCategoryName(i), false);
            arrayList.add(chartLegendLabel);
        }
        return arrayList;
    }

    List getAbsoluteValueSumOfCategory() {
        ArrayList<ChartLegendLabel> arrayList = new ArrayList<ChartLegendLabel>();
        if (this.J != null) {
            int n;
            int n2 = ChartTypeInfo.getSubType(this.D.getChartType());
            int n3 = ChartTypeInfo.getEffect(this.D.getChartType());
            int n4 = ChartTypeInfo.getPrimType(this.D.getChartType());
            if (n4 == 0 && n2 == 0 && n3 == 0) {
                if (this.constructPercentFilter != null) {
                    this.constructPercentFilter = null;
                }
                for (n = 0; n < this.J.length; ++n) {
                    if (!this.floatValue(n)) continue;
                    if (this.constructPercentFilter == null) {
                        this.constructPercentFilter = new Vector();
                    }
                    this.constructPercentFilter.add(new Integer(n));
                }
            }
            for (n = 0; n < this.J.length; ++n) {
                if (this.clone != null && this.clone[n] != null && this.getAllShowValue(n4, n2, this.clone[n])) {
                    this.getAxisInfo(arrayList, this.clone[n], n);
                    continue;
                }
                ChartLegendLabel chartLegendLabel = new ChartLegendLabel(this.J[n], false);
                arrayList.add(chartLegendLabel);
            }
        }
        return arrayList;
    }

    List getAbsoluteValueSumOfSeries() {
        ArrayList<ChartLegendLabel> arrayList = new ArrayList<ChartLegendLabel>();
        int n = ChartTypeInfo.getPrimType(this.D.getChartType());
        int n2 = ChartTypeInfo.getSubType(this.getChartDataSetInfo().getChartType());
        switch (n) {
            case 7: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int n3;
                int n4 = ChartTypeInfo.getEffect(this.D.getChartType());
                if (n2 == 0 && n4 == 0) {
                    if (this.constructPercentFilter != null) {
                        this.constructPercentFilter = null;
                    }
                    for (n3 = 0; n3 < this.Z.size(); ++n3) {
                        if (!this.floatValue(n3)) continue;
                        if (this.constructPercentFilter == null) {
                            this.constructPercentFilter = new Vector();
                        }
                        this.constructPercentFilter.add(new Integer(n3));
                    }
                }
                n3 = 0;
                for (int i = 0; i < this.J.length; ++i) {
                    ChartLegendLabel chartLegendLabel;
                    int n5;
                    if (this.clone != null && this.clone[i] != null && this.getAllShowValue(n, n2, this.clone[i])) {
                        this.getAxisInfo(arrayList, this.clone[i], i);
                        continue;
                    }
                    if (n == 4) {
                        if (n3 != 0) continue;
                        for (n5 = 0; n5 < this.B.getCategoryNames().size(); ++n5) {
                            chartLegendLabel = new ChartLegendLabel(this.B.getCategoryNames().get(n5), false);
                            arrayList.add(chartLegendLabel);
                        }
                        n3 = 1;
                        continue;
                    }
                    for (n5 = 0; n5 < this.B.getSeriesNames().size(); ++n5) {
                        chartLegendLabel = new ChartLegendLabel(this.B.getSeriesNames().get(n5), false);
                        arrayList.add(chartLegendLabel);
                    }
                }
                break;
            }
            case 11: {
                return this.get();
            }
            default: {
                for (int i = 0; i < this.J.length; ++i) {
                    ChartLegendLabel chartLegendLabel;
                    if (this.clone != null && this.clone[i] != null && this.clone[i].getConditionType() != 0) {
                        List list = this.clone[i].getSubConditons();
                        for (int j = 0; j < list.size(); ++j) {
                            chartLegendLabel = new ChartLegendLabel(((ChartShowValueSubCondition)list.get(j)).getLegendText(), true);
                            chartLegendLabel.setFillPattern(((ChartShowValueSubCondition)list.get(j)).getFillColor());
                            arrayList.add(chartLegendLabel);
                        }
                        continue;
                    }
                    for (int j = 0; j < this.B.getSeriesNames().size(); ++j) {
                        chartLegendLabel = new ChartLegendLabel(this.B.getSeriesNames().get(j), false);
                        arrayList.add(chartLegendLabel);
                    }
                }
            }
        }
        return arrayList;
    }

    public int getModleSeriesCount() {
        return this.B.getSeriesCount();
    }

    public ChartDataSetModel getModle() {
        return this.B;
    }

    boolean getAllShowValue(int n, int n2, ChartShowValueCondition chartShowValueCondition) {
        boolean bl = false;
        if (chartShowValueCondition != null) {
            int n3 = chartShowValueCondition.getConditionType();
            switch (n3) {
                case 1: 
                case 4: 
                case 5: {
                    if (n != 0 && n != 1 && n != 4 && n != 2) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (n != 0 && n != 1 && n != 3 || n2 != 512 && n2 != 768) break;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    void getAxisInfo(List list, ChartShowValueCondition chartShowValueCondition, int n) {
        int n2 = chartShowValueCondition.getConditionType();
        switch (n2) {
            case 1: {
                List list2 = this.getRangeFillConditions(n, chartShowValueCondition);
                for (int i = 0; list2 != null && i < list2.size(); ++i) {
                    ChartLegendLabel chartLegendLabel = new ChartLegendLabel(((ChartShowValueSubCondition)list2.get(i)).getLegendText(), true);
                    chartLegendLabel.setFillPattern(((ChartShowValueSubCondition)list2.get(i)).getFillColor());
                    if (i == list2.size() - 1) {
                        chartLegendLabel.setLastFlag(true);
                    }
                    list.add(chartLegendLabel);
                }
                break;
            }
            case 4: 
            case 5: {
                List list3 = chartShowValueCondition.getSubConditons();
                ChartLegendLabel chartLegendLabel = null;
                String string = null;
                for (int i = 0; list3 != null && i < list3.size(); ++i) {
                    if (((ChartShowValueSubCondition)list3.get(i)).getExpressionIndex() == -2) {
                        string = ((ChartShowValueSubCondition)list3.get(i)).getLegendText();
                        continue;
                    }
                    if (((ChartShowValueSubCondition)list3.get(i)).getExpressionIndex() < 0) continue;
                    ChartLegendLabel chartLegendLabel2 = new ChartLegendLabel(((ChartShowValueSubCondition)list3.get(i)).getLegendText(), true);
                    chartLegendLabel2.setFillPattern(((ChartShowValueSubCondition)list3.get(i)).getFillColor());
                    if (((ChartShowValueSubCondition)list3.get(i)).getIsCustomLabel()) {
                        chartLegendLabel2.setLabel(string);
                    }
                    if (i == list3.size() - 1) {
                        chartLegendLabel2.setLastFlag(true);
                    }
                    list.add(chartLegendLabel2);
                }
                if (chartLegendLabel != null) break;
                chartLegendLabel = new ChartLegendLabel(chartShowValueCondition.getOtherCusLabel(), true);
                chartLegendLabel.setFillPattern(chartShowValueCondition.getOtherColor());
                list.add(chartLegendLabel);
                break;
            }
            default: {
                Vector vector = new Vector();
                int n3 = this.B.getSeriesNames() == null ? 1 : this.B.getSeriesNames().size();
                this.getCategoryCount(n3 * n, chartShowValueCondition, vector);
                for (int i = 0; i < vector.size(); ++i) {
                    ChartLegendLabel chartLegendLabel = new ChartLegendLabel(((ChartShowValueSubCondition)vector.get(i)).getLegendText(), true);
                    chartLegendLabel.setFillPattern(((ChartShowValueSubCondition)vector.get(i)).getFillColor());
                    list.add(chartLegendLabel);
                }
            }
        }
    }

    void getCategoryCount(int n, ChartShowValueCondition chartShowValueCondition, List list) {
        List list2 = chartShowValueCondition.getSubConditons();
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            if (list2.get(i) == null) continue;
            list.add(list2.get(i));
        }
        ChartShowValueSubCondition chartShowValueSubCondition = new ChartShowValueSubCondition();
        chartShowValueSubCondition.setFillColor(chartShowValueCondition.getOtherColor());
        chartShowValueSubCondition.setExpressionIndex(-1);
        chartShowValueSubCondition.setLegendText(chartShowValueCondition.getOtherCusLabel());
        list.add(chartShowValueSubCondition);
    }

    protected List getRangeFillConditions(int n, ChartShowValueCondition chartShowValueCondition) {
        if (chartShowValueCondition == null) {
            return null;
        }
        if (chartShowValueCondition.getConditionIndexList() == null) {
            return null;
        }
        Vector vector = new Vector();
        List list = chartShowValueCondition.getSubConditons();
        for (int i = 0; i < list.size(); ++i) {
            vector.add(list.get(i));
        }
        ChartShowValueSubCondition chartShowValueSubCondition = new ChartShowValueSubCondition();
        chartShowValueSubCondition.setFillColor(chartShowValueCondition.getOtherColor());
        chartShowValueSubCondition.setExpressionIndex(-1);
        chartShowValueSubCondition.setLegendText(chartShowValueCondition.getOtherCusLabel() == null ? "" : chartShowValueCondition.getOtherCusLabel());
        vector.add(chartShowValueSubCondition);
        return vector;
    }

    public String getStringValues(int n, int n2) {
        return this.formatValues[n][n2];
    }

    public int[] getNotNullBeforeAndAfterIndex(int n, int n2) {
        int n3;
        int[] nArray = new int[]{-1, -1};
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            if (this.getOriginValue(n, n3) == null) continue;
            nArray[0] = n3;
            break;
        }
        for (n3 = n2 + 1; n3 < this.getCategorySize(); ++n3) {
            if (this.getOriginValue(n, n3) == null) continue;
            nArray[1] = n3;
            break;
        }
        return nArray;
    }

    public boolean haveNextNotNullValue(int n, int n2) {
        boolean bl = false;
        for (int i = n2 + 1; i < this.getCategorySize(); ++i) {
            if (this.getOriginValue(n, i) == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    boolean getCategoryName(int n) {
        if (this.scrollIndex == null) {
            return n >= 0 && n < this.getCategorySize();
        }
        return this.scrollIndex.length == 2 && n >= this.scrollIndex[0] && n < this.scrollIndex[1];
    }
}

