/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.chart2d.Graph2DBasicGraph;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class ChartBackground
implements Cloneable {
    private static final ChartColorPattern SEDU = new ChartColorPattern(new Color(128, 128, 128));
    private static final String[] clone = new String[]{"None", "Raised", "Recess", "Shadow", "Solid"};
    private ChartPenStyle draw;
    private ChartFillPattern fill;
    private ChartFillPattern[] getColor = new ChartFillPattern[2];
    private boolean getDashPattern = false;
    private int getFillBounds;
    private float getJointRadiusPixel;
    private float getLineJoints;
    private float getPenColor;
    private float getPenWidth;
    private ChartFillPattern getRoundBorder;
    private ChartFillPattern getShape;
    private float height = -1.0f;
    private boolean highlight = false;
    private int lineTo = 6;

    public ChartBackground() {
        this(0, new ChartPenStyle(new ChartColorPattern("SlateGray")), new ChartColorPattern("Grey"), false, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ChartBackground(Color color) {
        this(0, new ChartPenStyle(new ChartColorPattern("SlateGray")), new ChartColorPattern(color), true, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ChartBackground(int n, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern, boolean bl, float f, float f2, float f3, float f4) {
        this.getFillBounds = n;
        this.draw = chartPenStyle;
        this.fill = chartFillPattern;
        this.getColor[0] = chartFillPattern;
        this.getDashPattern = bl;
        this.getJointRadiusPixel = f;
        this.getLineJoints = f2;
        this.getPenColor = f3;
        this.getPenWidth = f4;
    }

    public float getLeft() {
        return this.getJointRadiusPixel;
    }

    public float getBottom() {
        return this.getLineJoints;
    }

    public float getRight() {
        return this.getPenColor;
    }

    public float getTop() {
        return this.getPenWidth;
    }

    public Rectangle2D.Float getCoreArea(Rectangle rectangle) {
        float f = this.draw.getPenWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        if (this.getFillBounds == 3) {
            float_.width = (float)rectangle.width - f;
            float_.height = (float)rectangle.height - f;
            float f2 = float_.width * this.getJointRadiusPixel;
            float f3 = float_.height * this.getLineJoints;
            float f4 = float_.width * this.getPenColor;
            float f5 = float_.height * this.getPenWidth;
            float_.x = (float)rectangle.x + f2;
            float_.y = (float)rectangle.y + f5;
            float_.width -= f2 + f4;
            float_.height -= f5 + f3;
        } else {
            float_.width = (float)rectangle.width - f * 2.0f;
            float_.height = (float)rectangle.height - f * 2.0f;
            float f6 = float_.width * this.getJointRadiusPixel;
            float f7 = float_.height * this.getLineJoints;
            float f8 = float_.width * this.getPenColor;
            float f9 = float_.height * this.getPenWidth;
            float_.x = (float)rectangle.x + f + f6;
            float_.y = (float)rectangle.y + f + f9;
            float_.width -= f6 + f8;
            float_.height -= f9 + f7;
        }
        return float_;
    }

    public Rectangle getBounds(Rectangle2D.Float float_) {
        Rectangle rectangle = new Rectangle();
        float f = this.draw.getPenWidth();
        if (this.getFillBounds == 3) {
            rectangle.width = (int)(float_.width / (1.0f - this.getJointRadiusPixel - this.getPenColor) + f);
            rectangle.height = (int)(float_.height / (1.0f - this.getLineJoints - this.getPenWidth) + f);
            rectangle.x = (int)(float_.x - ((float)rectangle.width - f - float_.width) / 2.0f);
            rectangle.y = (int)(float_.y - ((float)rectangle.height - f - float_.height) / 2.0f);
        } else {
            rectangle.width = (int)(float_.width / (1.0f - this.getJointRadiusPixel - this.getPenColor) + f * 2.0f);
            rectangle.height = (int)(float_.height / (1.0f - this.getLineJoints - this.getPenWidth) + f * 2.0f);
            rectangle.x = (int)(float_.x - ((float)rectangle.width - float_.width) / 2.0f);
            rectangle.y = (int)(float_.y - ((float)rectangle.height - float_.height) / 2.0f);
        }
        return rectangle;
    }

    public int getBorderStyle() {
        return this.getFillBounds;
    }

    public boolean isOpaque() {
        return this.getDashPattern;
    }

    public ChartPenStyle getPen() {
        return this.draw;
    }

    public ChartColorPattern getBorderColor() {
        return this.draw.getPenColor();
    }

    public ChartFillPattern getPattern() {
        return this.fill;
    }

    public void setLeft(float f) {
        this.getJointRadiusPixel = f;
    }

    public void setBottom(float f) {
        this.getLineJoints = f;
    }

    public void setRight(float f) {
        this.getPenColor = f;
    }

    public void setTop(float f) {
        this.getPenWidth = f;
    }

    public void setBorderStyle(int n) {
        this.getFillBounds = n;
    }

    public void setOpaque(boolean bl) {
        this.getDashPattern = bl;
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.draw = chartPenStyle;
    }

    public void setBorderColor(ChartColorPattern chartColorPattern) {
        this.draw.setPenColor(chartColorPattern);
    }

    public void setPattern(ChartFillPattern chartFillPattern) {
        this.fill = chartFillPattern;
    }

    public void setLinePattern(ChartFillPattern chartFillPattern) {
        this.getColor[0] = chartFillPattern;
    }

    public void setAreaPattern(ChartFillPattern chartFillPattern) {
        this.getColor[1] = chartFillPattern;
    }

    public Rectangle getFillBounds(Rectangle2D.Float float_) {
        Rectangle rectangle = new Rectangle();
        float f = this.draw.getPenWidth();
        if (this.getFillBounds == 3) {
            rectangle.width = (int)(float_.width * (1.0f - this.getJointRadiusPixel - this.getPenColor) + f);
            rectangle.height = (int)(float_.height * (1.0f - this.getLineJoints - this.getPenWidth) + f);
            rectangle.x = (int)(float_.width * this.getJointRadiusPixel + float_.x);
            rectangle.y = (int)(float_.height * this.getPenWidth + float_.y);
        } else {
            rectangle.width = (int)(float_.width * (1.0f - this.getJointRadiusPixel - this.getPenColor));
            rectangle.height = (int)(float_.height * (1.0f - this.getLineJoints - this.getPenWidth));
            rectangle.x = (int)(float_.width * this.getJointRadiusPixel + float_.x);
            rectangle.y = (int)(float_.height * this.getPenWidth + float_.y);
        }
        return rectangle;
    }

    public void paintBackground(Graphics2D graphics2D, Rectangle rectangle) {
        Cloneable cloneable;
        float f = this.draw.getPenWidth();
        if (this.draw.getDashPattern() == 9) {
            f = 0.0f;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        boolean bl = false;
        if (this.getRoundBorder != null || this.getShape != null) {
            bl = true;
        }
        boolean bl2 = false;
        if (this.draw.getLineJoints() == 3) {
            bl2 = true;
        }
        if (bl2) {
            float f2 = this.height = this.height != -1.0f ? this.height : this.draw.getJointRadiusPixel();
            if (this.height == 0.0f) {
                bl2 = false;
            }
        }
        if (this.highlight) {
            this.clone(graphics2D, rectangle);
            return;
        }
        if (bl) {
            if (this.getRoundBorder != null) {
                float_.x = rectangle.x;
                float_.y = rectangle.y + rectangle.height * 1 / 3;
                float_.width = rectangle.width / 2;
                float_.height = rectangle.height / 3;
                this.getRoundBorder.fill(graphics2D, this.getFillBounds(float_));
                switch (this.getFillBounds) {
                    case 4: {
                        float_.x = (float)rectangle.x + f / 2.0f;
                        float_.y = (float)(rectangle.y + rectangle.height * 1 / 3) + f / 2.0f;
                        float_.width = (float)(rectangle.width / 2) - f - 1.0f;
                        float_.height = (float)(rectangle.height / 3) - f - 1.0f;
                        this.draw.draw(graphics2D, float_);
                    }
                }
            }
            if (this.getShape != null) {
                float_.x = rectangle.x + rectangle.width * 2 / 3;
                float_.y = rectangle.y + rectangle.height / 3;
                float_.width = rectangle.width / 60;
                float_.height = rectangle.height / 3;
                this.getShape.fill(graphics2D, this.getFillBounds(float_));
            }
            if (this.fill != null) {
                float_.x = rectangle.x;
                float_.y = rectangle.y + rectangle.height * 7 / 16;
                float_.width = rectangle.width * 4 / 5;
                float_.height = rectangle.height / 8;
                this.fill.fill(graphics2D, this.getFillBounds(float_));
            }
        }
        if (this.fill != null && !bl) {
            if (this.getFillBounds == 3) {
                float_.x = rectangle.x;
                float_.y = rectangle.y;
                float_.width = (float)rectangle.width - f * 2.0f;
                float_.height = ((float)rectangle.height - f * 2.0f) / 20.0f;
            } else {
                float_.x = (float)rectangle.x + f;
                float_.y = (float)rectangle.y + f;
                float_.width = (float)rectangle.width - f * 2.0f;
                float_.height = ((float)rectangle.height - f * 2.0f) / 20.0f;
            }
            if (this.getColor[1] != null) {
                cloneable = new Rectangle2D.Float();
                ((Rectangle2D.Float)cloneable).x = (float)rectangle.x + f;
                ((Rectangle2D.Float)cloneable).y = (float)rectangle.y + f;
                ((Rectangle2D.Float)cloneable).width = (float)rectangle.width - f * 2.0f;
                ((Rectangle2D.Float)cloneable).height = (float)rectangle.height - f * 2.0f;
                this.getColor[1].fill(graphics2D, this.getFillBounds((Rectangle2D.Float)cloneable));
                if (this.getColor[0] != null) {
                    this.getColor[0].fill(graphics2D, this.getFillBounds(float_));
                }
            } else {
                float_.x = (float)rectangle.x + f;
                float_.y = (float)rectangle.y + f;
                float_.width = (float)rectangle.width - f * 2.0f;
                float_.height = (float)rectangle.height - f * 2.0f;
                if (!bl2) {
                    this.fill.fill(graphics2D, this.getFillBounds(float_));
                } else {
                    if (this.getFillBounds != 3) {
                        float_.x = (float)rectangle.x + f / 2.0f;
                        float_.y = (float)rectangle.y + f / 2.0f;
                        float_.width = (float)rectangle.width - f;
                        float_.height = (float)rectangle.height - f;
                    }
                    this.height = this.height != -1.0f ? this.height : this.draw.getJointRadiusPixel();
                    this.fill.fill(graphics2D, this.getRoundBorder(this.getFillBounds(float_), this.height));
                }
            }
        }
        switch (this.getFillBounds) {
            case 4: {
                if (bl) break;
                float_.x = (float)rectangle.x + f / 2.0f;
                float_.y = (float)rectangle.y + f / 2.0f;
                float_.width = (float)rectangle.width - f - 1.0f;
                float_.height = (float)rectangle.height - f - 1.0f;
                if (!bl2) {
                    this.draw.draw(graphics2D, float_);
                    break;
                }
                this.height = this.height != -1.0f ? this.height : this.draw.getJointRadiusPixel();
                this.draw.draw(graphics2D, this.getRoundBorder(this.getFillBounds(float_), this.height));
                break;
            }
            case 1: {
                this.SEDU(graphics2D, rectangle, 50, -30);
                break;
            }
            case 2: {
                this.SEDU(graphics2D, rectangle, -30, 50);
                break;
            }
            case 3: {
                if (this.draw.getLineJoints() == 3) {
                    bl2 = true;
                }
                if (!bl2) {
                    cloneable = new ChartPenStyle(SEDU);
                    ((ChartPenStyle)cloneable).setPenWidth(f);
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo((float)(rectangle.x + rectangle.width) - f / 2.0f, (float)rectangle.y + f);
                    generalPath.lineTo((float)(rectangle.x + rectangle.width) - f / 2.0f, (float)(rectangle.y + rectangle.height) - f / 2.0f);
                    generalPath.lineTo((float)rectangle.x + f, (float)(rectangle.y + rectangle.height) - f / 2.0f);
                    ((ChartPenStyle)cloneable).draw(graphics2D, generalPath);
                    break;
                }
                cloneable = new ChartPenStyle(SEDU);
                ((ChartPenStyle)cloneable).setPenWidth(f);
                float f3 = f;
                float f4 = this.draw.getJointRadiusPixel();
                Line2D.Float float_2 = new Line2D.Float();
                ((ChartPenStyle)cloneable).draw(graphics2D, new Arc2D.Double((float)rectangle.x + f3 / 2.0f, (float)(rectangle.y + rectangle.height) - f4 - f3 / 2.0f, f4, f4, 225.0, 45.0, 0));
                float_2.setLine((float)rectangle.x + f4 / 2.0f + f3, (float)(rectangle.y + rectangle.height) - f3 / 2.0f, (float)(rectangle.x + rectangle.width) - f4 / 2.0f, (float)(rectangle.y + rectangle.height) - f3 / 2.0f);
                ((ChartPenStyle)cloneable).draw(graphics2D, float_2);
                ((ChartPenStyle)cloneable).draw(graphics2D, new Arc2D.Double((float)(rectangle.x + rectangle.width) - f4 - f3 / 2.0f, (float)(rectangle.y + rectangle.height) - f4 - f3 / 2.0f, f4, f4, 270.0, 90.0, 0));
                float_2.setLine((float)(rectangle.x + rectangle.width) - f3 / 2.0f, (float)rectangle.y + f4 / 2.0f + f3, (float)(rectangle.x + rectangle.width) - f3 / 2.0f, (float)(rectangle.y + rectangle.height) - f4 / 2.0f);
                ((ChartPenStyle)cloneable).draw(graphics2D, float_2);
                ((ChartPenStyle)cloneable).draw(graphics2D, new Arc2D.Double((float)(rectangle.x + rectangle.width) - f4 - f3 / 2.0f, (float)rectangle.y + f3 / 2.0f, f4, f4, 0.0, 45.0, 0));
                break;
            }
        }
    }

    public RoundRectangle2D getRoundBorder(Rectangle rectangle, float f) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, f, f);
        return float_;
    }

    private void SEDU(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
        Color color = this.draw.getPenColor().getColor();
        boolean bl = false;
        if (this.draw.getLineJoints() == 3) {
            bl = true;
        }
        if (!bl) {
            int n3;
            int n4 = (int)this.draw.getPenWidth();
            Line2D.Float float_ = new Line2D.Float();
            this.draw.setPenWidth(1.0f);
            this.draw.getPenColor().setColor(ChartGraphicsUtil.highlight(color, n));
            for (n3 = 0; n3 < n4; ++n3) {
                float_.setLine(rectangle.x + n3, rectangle.y + n3, rectangle.x + rectangle.width - 1 - n3, rectangle.y + n3);
                this.draw.draw(graphics2D, float_);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                float_.setLine(rectangle.x + n3, rectangle.y + n3, rectangle.x + n3, rectangle.y + rectangle.height - 1 - n3);
                this.draw.draw(graphics2D, float_);
            }
            this.draw.getPenColor().setColor(ChartGraphicsUtil.highlight(color, n2));
            for (n3 = 0; n3 < n4; ++n3) {
                float_.setLine(rectangle.x + n3, rectangle.y + rectangle.height - 1 - n3, rectangle.x + rectangle.width - 1 - n3, rectangle.y + rectangle.height - 1 - n3);
                this.draw.draw(graphics2D, float_);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                float_.setLine(rectangle.x + rectangle.width - 1 - n3, rectangle.y + n3, rectangle.x + rectangle.width - 1 - n3, rectangle.y + rectangle.height - 1 - n3);
                this.draw.draw(graphics2D, float_);
            }
            this.draw.setPenWidth(n4);
            this.draw.getPenColor().setColor(color);
        } else {
            float f = this.height != -1.0f ? this.height : this.draw.getJointRadiusPixel();
            Line2D.Float float_ = new Line2D.Float();
            int n5 = (int)this.draw.getPenWidth();
            this.draw.getPenColor().setColor(ChartGraphicsUtil.highlight(color, n));
            this.draw.draw(graphics2D, new Arc2D.Double(rectangle.x + n5 / 2, rectangle.y, f - (float)n5, f - (float)n5, 90.0, 45.0, 0));
            float_.setLine((float)rectangle.x + f / 2.0f + (float)(n5 / 2), rectangle.y, (float)(rectangle.x + rectangle.width - 1) - f / 2.0f - (float)(n5 / 2), rectangle.y);
            this.draw.draw(graphics2D, float_);
            this.draw.draw(graphics2D, new Arc2D.Double((float)(rectangle.x + rectangle.width - 1) - f + (float)(n5 / 2), rectangle.y, f - (float)n5, f - (float)n5, 45.0, 45.0, 0));
            this.draw.draw(graphics2D, new Arc2D.Double(rectangle.x, rectangle.y + n5 / 2, f - (float)n5, f - (float)n5, 135.0, 45.0, 0));
            float_.setLine(rectangle.x, (float)rectangle.y + f / 2.0f + (float)(n5 / 2), rectangle.x, (float)(rectangle.y + rectangle.height - 1) - f / 2.0f - (float)(n5 / 2));
            this.draw.draw(graphics2D, float_);
            this.draw.draw(graphics2D, new Arc2D.Double(rectangle.x, (float)(rectangle.y + rectangle.height - 1) - f + (float)(n5 / 2), f - (float)n5, f - (float)n5, 180.0, 45.0, 0));
            this.draw.getPenColor().setColor(ChartGraphicsUtil.highlight(color, n2));
            this.draw.draw(graphics2D, new Arc2D.Double(rectangle.x + n5 / 2, (float)(rectangle.y + rectangle.height - 1) - f + (float)n5, f - (float)n5, f - (float)n5, 225.0, 45.0, 0));
            float_.setLine((float)rectangle.x + f / 2.0f + (float)(n5 / 2), rectangle.y + rectangle.height - 1, (float)(rectangle.x + rectangle.width - 1) - f / 2.0f - (float)(n5 / 2), rectangle.y + rectangle.height - 1);
            this.draw.draw(graphics2D, float_);
            this.draw.draw(graphics2D, new Arc2D.Double((float)(rectangle.x + rectangle.width - 1) - f + (float)(n5 / 2), (float)(rectangle.y + rectangle.height - 1) - f + (float)n5, f - (float)n5, f - (float)n5, 270.0, 45.0, 0));
            this.draw.draw(graphics2D, new Arc2D.Double((float)(rectangle.x + rectangle.width - 1) - f + (float)n5, (float)(rectangle.y + rectangle.height - 1) - f + (float)(n5 / 2), f - (float)n5, f - (float)n5, 315.0, 45.0, 0));
            float_.setLine(rectangle.x + rectangle.width - 1, (float)rectangle.y + f / 2.0f + (float)(n5 / 2), rectangle.x + rectangle.width - 1, (float)(rectangle.y + rectangle.height - 1) - f / 2.0f - (float)(n5 / 2));
            this.draw.draw(graphics2D, float_);
            this.draw.draw(graphics2D, new Arc2D.Double((float)(rectangle.x + rectangle.width - 1) - f + (float)n5, rectangle.y + n5 / 2, f - (float)n5, f - (float)n5, 0.0, 45.0, 0));
            this.draw.getPenColor().setColor(color);
        }
    }

    public Object clone() {
        ChartFillPattern chartFillPattern = null;
        if (this.fill != null) {
            chartFillPattern = (ChartFillPattern)this.fill.clone();
        }
        return new ChartBackground(this.getFillBounds, (ChartPenStyle)this.draw.clone(), chartFillPattern, this.getDashPattern, this.getJointRadiusPixel, this.getLineJoints, this.getPenColor, this.getPenWidth);
    }

    public static String[] getBuiltinBorderStyles() {
        return clone;
    }

    public ChartFillPattern[] getLinePattern() {
        return this.getColor;
    }

    public void setBulletQualitativeRangesPattern(ChartFillPattern chartFillPattern) {
        this.getRoundBorder = chartFillPattern;
    }

    public void setBulletComparativeMeasurePattern(ChartFillPattern chartFillPattern) {
        this.getShape = chartFillPattern;
    }

    public ChartFillPattern getBulletComparativeMeasurePattern() {
        return this.getShape;
    }

    public ChartFillPattern getBulletQualitativeRangesPattern() {
        return this.getRoundBorder;
    }

    public void setRadiusPixel(float f) {
        this.height = f;
    }

    public float getRadiusPixel() {
        return this.height;
    }

    private void clone(Graphics2D graphics2D, Rectangle rectangle) {
        Graph2DBasicGraph graph2DBasicGraph = new Graph2DBasicGraph(this.lineTo);
        graph2DBasicGraph.setXYWH(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, rectangle.width, rectangle.height);
        this.draw.draw(graphics2D, graph2DBasicGraph.getShape());
    }

    public void setIsLEDChart(boolean bl) {
        this.highlight = bl;
    }

    public void setLEDStyle(int n) {
        this.lineTo = n;
    }
}

