/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import chart.graphics.RoundGradientPaint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ChartIcon
implements Cloneable {
    public static final String[] BUILTINICON = new String[]{"Rectangle", "Diamond", "Triangle Up", "Triangle Down", "Triangle Left", "Triangle Right", "Circle", "Cross1", "Cross2", "None", "Star1", "Star2"};
    private static final String[] SEDU = new String[]{"Top", "Center", "Bottom"};
    private static final String[] blue = new String[]{"Left", "Center", "Right"};
    public static final int NUMBUILTINICON = BUILTINICON.length;
    private ChartFillPattern clone;
    private ChartPenStyle closePath;
    private boolean copyImage = false;
    private Dimension draw;
    private int drawImage;
    private String drawShape;
    private BufferedImage equals;
    private boolean fill;
    private ChartPenStyle getColorPattern;
    private ChartFillPattern getDashPattern;
    private boolean getForeground;
    boolean getHeight;
    boolean getIconHeight;

    public ChartIcon() {
        this.drawImage = BUILTINICON.length;
        this.draw = new Dimension(12, 12);
    }

    public ChartIcon(int n) {
        this.drawImage = n;
        this.draw = new Dimension(12, 12);
    }

    public ChartIcon(int n, int n2, int n3) {
        this.drawImage = n;
        this.draw = new Dimension(n2, n3);
    }

    public ChartIcon(String string) {
        this.equals = ChartGraphicsUtil.copyImage(string);
        if (this.equals == null) {
            return;
        }
        this.drawShape = string;
        this.draw = new Dimension(this.equals.getWidth(), this.equals.getHeight());
        this.drawImage = BUILTINICON.length;
    }

    protected ChartIcon(int n, Dimension dimension, String string, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern, boolean bl) {
        this.equals = ChartGraphicsUtil.copyImage(string);
        if (this.equals == null) {
            return;
        }
        this.drawImage = n;
        this.draw = dimension;
        this.drawShape = string;
        this.closePath = chartPenStyle;
        this.clone = chartFillPattern;
        this.copyImage = bl;
    }

    public Object clone() {
        ChartPenStyle chartPenStyle = null;
        ChartFillPattern chartFillPattern = null;
        if (this.closePath != null) {
            chartPenStyle = (ChartPenStyle)this.closePath.clone();
        }
        if (this.clone != null) {
            chartFillPattern = (ChartFillPattern)this.clone.clone();
        }
        ChartIcon chartIcon = new ChartIcon();
        chartIcon.setColor(chartFillPattern);
        chartIcon.setPen(chartPenStyle);
        chartIcon.setIconWidth(this.getIconWidth());
        chartIcon.setIconHeight(this.getIconHeight());
        chartIcon.setStrikethrough(this.getStrikethrough());
        chartIcon.setIconStyle(this.getIconStyle());
        chartIcon.setIsLineIcon(this.fill);
        chartIcon.setLineStylePen(this.getColorPattern);
        return chartIcon;
    }

    public boolean isNoIcon() {
        return this.drawImage == BUILTINICON.length && this.drawShape == null;
    }

    public int getIconStyle() {
        return this.drawImage;
    }

    public void setIconStyle(int n) {
        this.drawImage = n;
    }

    public void setStrikethrough(boolean bl) {
        if (bl && !this.copyImage) {
            this.draw.width *= 3;
        }
        if (!bl && this.copyImage) {
            this.draw.width /= 3;
        }
        this.copyImage = bl;
    }

    public boolean getStrikethrough() {
        return this.copyImage;
    }

    public void setColor(ChartFillPattern chartFillPattern) {
        this.clone = chartFillPattern;
    }

    public ChartFillPattern getColor() {
        return this.clone;
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.closePath = chartPenStyle;
    }

    public ChartPenStyle getPen() {
        return this.closePath;
    }

    public String getIconFileName() {
        return this.drawShape;
    }

    public void setIconFileName(String string) {
        this.drawShape = string;
        this.drawImage = BUILTINICON.length;
    }

    public int getIconType() {
        return this.drawImage;
    }

    public void setIconType(int n) {
        this.drawImage = n;
    }

    public int getIconHeight() {
        return this.draw.height;
    }

    public void setIconHeight(int n) {
        this.draw.height = n;
    }

    public int getIconWidth() {
        return this.draw.width;
    }

    public void setIconWidth(int n) {
        this.draw.width = n;
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
        Cloneable cloneable;
        if (this.closePath == null) {
            this.closePath = new ChartPenStyle(new ChartColorPattern(Color.blue));
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        GeneralPath generalPath = new GeneralPath();
        float f = (int)this.closePath.getPenWidth();
        if (this.closePath.getDashPattern() == 9) {
            f = 0.0f;
        }
        RectangularShape rectangularShape = null;
        int n3 = this.draw.width;
        int n4 = this.draw.height;
        if (this.fill) {
            generalPath.moveTo(n, n2 + n4 / 2);
            generalPath.lineTo(n + n3, n2 + n4 / 2);
            cloneable = new ChartPenStyle();
            ((ChartPenStyle)cloneable).setPenWidth(2.0f);
            ChartColorPattern chartColorPattern = this.getColorPattern(this.getDashPattern);
            if (chartColorPattern != null) {
                ((ChartPenStyle)cloneable).setPenColor(this.getColorPattern(this.getDashPattern));
                ((ChartPenStyle)cloneable).draw(graphics2D, generalPath);
            }
            generalPath = new GeneralPath();
        }
        if (this.copyImage) {
            generalPath.moveTo(n, n2 + n4 / 2 - 1);
            generalPath.lineTo(n + n3 - 1, n2 + n4 / 2 - 1);
            this.closePath.draw(graphics2D, generalPath);
            generalPath = new GeneralPath();
            n += (n3 /= 3);
        }
        switch (this.drawImage) {
            case 0: {
                rectangularShape = !this.fill ? new Rectangle(n, n2, n3 - 1, n4 - 1) : new Rectangle(n + n3 / 4, n2 + n4 / 4, n3 / 2, n4 / 2);
                if (this.clone != null) {
                    this.clone.fill(graphics2D, rectangularShape);
                }
                if (this.copyImage) break;
                cloneable = f > 1.0f ? new Rectangle2D.Float((float)n + f / 2.0f, (float)n2 + f / 2.0f, (float)n3 - f, (float)n4 - f) : rectangularShape;
                this.closePath.draw(graphics2D, (Shape)((Object)cloneable));
                break;
            }
            case 1: {
                if (!this.fill) {
                    generalPath.moveTo(n + n3 / 2, n2);
                    generalPath.lineTo(n + n3, n2 + n4 / 2);
                    generalPath.lineTo(n + n3 / 2, n2 + n4);
                    generalPath.lineTo(n, n2 + n4 / 2);
                } else {
                    generalPath.moveTo(n + n3 / 2, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 / 2);
                    generalPath.lineTo(n + n3 / 2, n2 + n4 * 3 / 4);
                    generalPath.lineTo(n + n3 / 4, n2 + n4 / 2);
                }
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 2: {
                if (!this.fill) {
                    generalPath.moveTo(n + n3 / 2 - 1, n2);
                    generalPath.lineTo(n + n3 - 1, n2 + n4 - 1);
                    generalPath.lineTo(n, n2 + n4 - 1);
                } else {
                    generalPath.moveTo(n + n3 / 2, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 * 3 / 4);
                    generalPath.lineTo(n + n3 / 4, n2 + n4 * 3 / 4);
                }
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 3: {
                if (!this.fill) {
                    generalPath.moveTo(n + n3 / 2 - 1, n2 + n4 - 1);
                    generalPath.lineTo(n + n3 - 1, n2);
                    generalPath.lineTo(n, n2);
                } else {
                    generalPath.moveTo(n + n3 / 2, n2 + n4 * 3 / 4);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 / 4, n2 + n4 / 4);
                }
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 4: {
                if (!this.fill) {
                    generalPath.moveTo(n, n2 + n4 / 2 - 1);
                    generalPath.lineTo(n + n3 - 1, n2);
                    generalPath.lineTo(n + n3 - 1, n2 + n4 - 1);
                } else {
                    generalPath.moveTo(n + n3 / 4, n2 + n4 / 2);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 * 3 / 4);
                }
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 5: {
                if (!this.fill) {
                    generalPath.moveTo(n, n2);
                    generalPath.lineTo(n, n2 + n4 - 1);
                    generalPath.lineTo(n + n3 - 1, n2 + n4 / 2 - 1);
                } else {
                    generalPath.moveTo(n + n3 / 4, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 / 4, n2 + n4 * 3 / 4);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 / 2);
                }
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 6: {
                rectangularShape = !this.fill ? new Ellipse2D.Float(n, n2, n3, n4) : new Ellipse2D.Float(n + n3 / 4, n2 + n4 / 4, n3 / 2, n4 / 2);
                if (this.clone != null) {
                    this.clone.fill(graphics2D, rectangularShape);
                }
                if (this.copyImage) break;
                cloneable = f > 1.0f ? new Ellipse2D.Float((float)n + f / 2.0f, (float)n2 + f / 2.0f, (float)n3 - f, (float)n4 - f) : rectangularShape;
                this.closePath.draw(graphics2D, (Shape)((Object)cloneable));
                break;
            }
            case 7: {
                if (this.fill) {
                    generalPath.moveTo(n + n3 / 2 - 1, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 / 2 - 1, n2 + 3 * n4 / 4);
                    generalPath.moveTo(n + n3 / 4, n2 + n4 / 2 - 1);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 / 2 - 1);
                } else {
                    generalPath.moveTo(n + n3 / 2 - 1, n2);
                    generalPath.lineTo(n + n3 / 2 - 1, n2 + n4 - 1);
                    generalPath.moveTo(n, n2 + n4 / 2 - 1);
                    generalPath.lineTo(n + n3 - 1, n2 + n4 / 2 - 1);
                }
                if (this.clone == null) {
                    this.closePath.draw(graphics2D, generalPath);
                    break;
                }
                this.drawShape(graphics2D, this.closePath, this.getColorPattern(), generalPath);
                break;
            }
            case 8: {
                if (!this.fill) {
                    generalPath.moveTo(n, n2);
                    generalPath.lineTo(n + n3 - 1, n2 + n4 - 1);
                    generalPath.moveTo(n + n3 - 1, n2);
                    generalPath.lineTo(n, n2 + n4 - 1);
                } else {
                    generalPath.moveTo(n + n3 / 4, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 * 3 / 4);
                    generalPath.moveTo(n + n3 * 3 / 4, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 / 4, n2 + n4 * 3 / 4);
                }
                if (this.clone == null) {
                    this.closePath.draw(graphics2D, generalPath);
                    break;
                }
                this.drawShape(graphics2D, this.closePath, this.getColorPattern(), generalPath);
                break;
            }
            case 10: {
                if (!this.fill) {
                    generalPath.moveTo(n, n2);
                    generalPath.lineTo(n + n3, n2 + n4);
                    generalPath.moveTo(n + n3 / 2, n2);
                    generalPath.lineTo(n + n3 / 2, n2 + n4);
                    generalPath.moveTo(n + n3, n2);
                    generalPath.lineTo(n, n2 + n4);
                } else {
                    generalPath.moveTo(n + n3 / 4, n2 + n3 / 4);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 * 3 / 4);
                    generalPath.moveTo(n + n3 / 2, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 / 2, n2 + n4 * 3 / 4);
                    generalPath.moveTo(n + n3 * 3 / 4, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 / 4, n2 + n4 * 3 / 4);
                }
                if (this.clone == null) {
                    this.closePath.draw(graphics2D, generalPath);
                    break;
                }
                this.drawShape(graphics2D, this.closePath, this.getColorPattern(), generalPath);
                break;
            }
            case 11: {
                if (!this.fill) {
                    generalPath.moveTo(n, n2);
                    generalPath.lineTo(n + n3, n2 + n4);
                    generalPath.moveTo(n + n3, n2);
                    generalPath.lineTo(n, n2 + n4);
                    generalPath.moveTo(n + n3 / 2, n2);
                    generalPath.lineTo(n + n3 / 2, n2 + n4);
                    generalPath.moveTo(n, n2 + n4 / 2);
                    generalPath.lineTo(n + n3, n2 + n4 / 2);
                } else {
                    generalPath.moveTo(n + n3 / 4, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 * 3 / 4);
                    generalPath.moveTo(n + n3 * 3 / 4, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 / 4, n2 + n4 * 3 / 4);
                    generalPath.moveTo(n + n3 / 2, n2 + n4 / 4);
                    generalPath.lineTo(n + n3 / 2, n2 + n4 * 3 / 4);
                    generalPath.moveTo(n + n3 / 4, n2 + n4 / 2);
                    generalPath.lineTo(n + n3 * 3 / 4, n2 + n4 / 2);
                }
                if (this.clone == null) {
                    this.closePath.draw(graphics2D, generalPath);
                } else {
                    this.drawShape(graphics2D, this.closePath, this.getColorPattern(), generalPath);
                }
            }
            default: {
                if (this.drawShape == null || this.drawShape.length() == 0) {
                    return;
                }
                if (this.equals == null) {
                    this.equals = ChartGraphicsUtil.copyImage(this.drawShape);
                    if (this.equals == null) {
                        return;
                    }
                }
                graphics.drawImage(this.equals, n, n2, n3, n4, null);
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, new Rectangle(n, n2, n3, n4));
            }
        }
    }

    public static String[] getBuiltinIcons() {
        return BUILTINICON;
    }

    public static String[] getVAlignment() {
        return SEDU;
    }

    public static String[] getHAlignment() {
        return blue;
    }

    public static ChartIcon getBuiltinIcon(String string) {
        for (int i = 0; i < BUILTINICON.length; ++i) {
            if (!string.equals(BUILTINICON[i])) continue;
            return new ChartIcon(i);
        }
        return null;
    }

    public Icon getPaintedIcon() {
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                ChartIcon.this.paintIcon(graphics, n, n2);
            }

            @Override
            public int getIconWidth() {
                return ChartIcon.this.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return ChartIcon.this.getIconHeight();
            }
        };
    }

    public void drawShape(Graphics2D graphics2D, ChartPenStyle chartPenStyle, ChartColorPattern chartColorPattern, Shape shape) {
        if (chartPenStyle == null || shape == null || chartPenStyle == null) {
            return;
        }
        ChartPenStyle chartPenStyle2 = (ChartPenStyle)chartPenStyle.clone();
        chartPenStyle2.setPenColor(chartColorPattern);
        chartPenStyle2.draw(graphics2D, shape);
    }

    public void setIsLineIcon(boolean bl) {
        this.fill = bl;
    }

    public boolean getIsLineIcon() {
        return this.fill;
    }

    public void setLineStylePen(ChartPenStyle chartPenStyle) {
        this.getColorPattern = chartPenStyle;
    }

    public ChartPenStyle getLineStylePen() {
        return this.getColorPattern;
    }

    public ChartColorPattern getColorPattern() {
        if (this.clone == null) {
            return null;
        }
        if (this.clone instanceof ChartGradientPattern) {
            return ((ChartGradientPattern)this.clone).getStartColor();
        }
        if (this.clone instanceof ChartTexturePattern) {
            return ((ChartTexturePattern)this.clone).getForeground();
        }
        if (this.clone instanceof ChartColorPattern) {
            return (ChartColorPattern)this.clone;
        }
        if (this.clone instanceof RoundGradientPaint) {
            return ((RoundGradientPaint)((Object)this.clone)).getPointColor();
        }
        return new ChartColorPattern();
    }

    public void setLineColor(ChartFillPattern chartFillPattern) {
        this.getDashPattern = chartFillPattern;
    }

    public ChartFillPattern getLineColor() {
        return this.getDashPattern;
    }

    public ChartColorPattern getColorPattern(ChartFillPattern chartFillPattern) {
        if (chartFillPattern == null) {
            return null;
        }
        if (chartFillPattern instanceof ChartGradientPattern) {
            return ((ChartGradientPattern)chartFillPattern).getStartColor();
        }
        if (chartFillPattern instanceof ChartTexturePattern) {
            return ((ChartTexturePattern)chartFillPattern).getForeground();
        }
        if (chartFillPattern instanceof ChartColorPattern) {
            return (ChartColorPattern)chartFillPattern;
        }
        if (chartFillPattern instanceof RoundGradientPaint) {
            return ((RoundGradientPaint)((Object)chartFillPattern)).getPointColor();
        }
        return new ChartColorPattern();
    }

    public boolean getIsNodeMark() {
        return this.getForeground;
    }

    public void setIsNodeMark(boolean bl) {
        this.getForeground = bl;
    }

    public void setUseCondition(boolean bl) {
        this.getHeight = bl;
    }

    public boolean getUseCondition() {
        return this.getHeight;
    }

    public void setIsLineSeriesIcon(boolean bl) {
        this.getIconHeight = bl;
    }

    public boolean getIsLineSeriesIcon() {
        return this.getIconHeight;
    }
}

