/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ChartTexturePattern
implements ChartFillPattern {
    private static final String[] SEDU = new String[]{"Small Dot", "Big Dot", "Horizontal Line", "Vertical Line", "Grid", "Diagonal Up", "Diagonal Down", "Diamond Grid", "Triangle", "Raised Rectangle", "Blurred Diamond"};
    private int clearRect;
    private ChartColorPattern clone;
    private ChartColorPattern closePath;
    private BufferedImage createGraphics;

    public ChartTexturePattern(int n, ChartColorPattern chartColorPattern, ChartColorPattern chartColorPattern2) {
        this.clearRect = n;
        this.clone = chartColorPattern;
        this.closePath = chartColorPattern2;
        this.createGraphics = null;
    }

    public ChartTexturePattern(int n) {
        this(n, new ChartColorPattern("Black"), new ChartColorPattern("White"));
    }

    public ChartTexturePattern(String string) {
        this(ChartTexturePattern.getBuiltinTexture(string));
    }

    public int getPattern() {
        return this.clearRect;
    }

    public ChartColorPattern getForeground() {
        return this.clone;
    }

    public ChartColorPattern getBackground() {
        return this.closePath;
    }

    @Override
    public void setAlpha(float f) {
        this.clone.setAlpha(f);
        this.closePath.setAlpha(f);
        this.createGraphics = null;
    }

    @Override
    public float getAlpha() {
        return this.clone.getAlpha();
    }

    public void setPattern(int n) {
        this.clearRect = n;
        this.createGraphics = null;
    }

    public void setForeground(ChartColorPattern chartColorPattern) {
        this.clone = chartColorPattern;
        this.createGraphics = null;
    }

    public void setBackground(ChartColorPattern chartColorPattern) {
        this.closePath = chartColorPattern;
        this.createGraphics = null;
    }

    @Override
    public Paint getPaint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.SEDU();
        if (this.createGraphics == null) {
            return null;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.createGraphics.getWidth(), this.createGraphics.getHeight());
        TexturePaint texturePaint = new TexturePaint(this.createGraphics, float_);
        return texturePaint;
    }

    @Override
    public void fill(Graphics2D graphics2D, Shape shape) {
        Paint paint = this.getPaint(graphics2D, null);
        if (paint == null) {
            return;
        }
        Paint paint2 = graphics2D.getPaint();
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
        graphics2D.setPaint(paint2);
    }

    @Override
    public void highLightFill(Graphics2D graphics2D, Shape shape, int n) {
    }

    private void SEDU() {
        if (this.createGraphics == null) {
            switch (this.clearRect) {
                case 0: {
                    this.clearRect();
                    break;
                }
                case 1: {
                    this.closePath();
                    break;
                }
                case 2: {
                    this.createGraphics();
                    break;
                }
                case 3: {
                    this.darker();
                    break;
                }
                case 4: {
                    this.draw();
                    break;
                }
                case 5: {
                    this.equals();
                    break;
                }
                case 6: {
                    this.fill();
                    break;
                }
                case 7: {
                    this.fill3DRect();
                    break;
                }
                case 8: {
                    this.fillRect();
                    break;
                }
                case 9: {
                    this.getBuiltinTexture();
                    break;
                }
                case 10: {
                    this.getColor();
                    break;
                }
                default: {
                    this.createGraphics = null;
                }
            }
        }
    }

    private void clearRect() {
        Graphics2D graphics2D = this.getHeight(2, 2);
        if (graphics2D == null) {
            return;
        }
        Color color = this.clone.getColor();
        this.createGraphics.setRGB(1, 1, color.getRGB());
    }

    private void closePath() {
        Graphics2D graphics2D = this.getHeight(5, 5);
        if (graphics2D == null) {
            return;
        }
        Color color = this.clone.getColor();
        int n = color.getRGB();
        for (int i = 2; i < 5; ++i) {
            for (int j = 2; j < 5; ++j) {
                this.createGraphics.setRGB(i, j, n);
            }
        }
    }

    private void createGraphics() {
        Graphics2D graphics2D = this.getHeight(16, 6);
        if (graphics2D == null) {
            return;
        }
        graphics2D.draw(new Line2D.Float(0.0f, 5.0f, 15.0f, 5.0f));
    }

    private void darker() {
        Graphics2D graphics2D = this.getHeight(6, 16);
        if (graphics2D == null) {
            return;
        }
        graphics2D.draw(new Line2D.Float(5.0f, 0.0f, 5.0f, 15.0f));
    }

    private void draw() {
        Graphics2D graphics2D = this.getHeight(6, 6);
        if (graphics2D == null) {
            return;
        }
        graphics2D.draw(new Line2D.Float(5.0f, 0.0f, 5.0f, 5.0f));
        graphics2D.draw(new Line2D.Float(0.0f, 5.0f, 5.0f, 5.0f));
    }

    private void equals() {
        Graphics2D graphics2D = this.getHeight(5, 5);
        if (graphics2D == null) {
            return;
        }
        graphics2D.draw(new Line2D.Float(0.0f, 4.0f, 4.0f, 0.0f));
    }

    private void fill() {
        Graphics2D graphics2D = this.getHeight(5, 5);
        if (graphics2D == null) {
            return;
        }
        graphics2D.draw(new Line2D.Float(0.0f, 0.0f, 4.0f, 4.0f));
    }

    private void fill3DRect() {
        Graphics2D graphics2D = this.getHeight(5, 5);
        if (graphics2D == null) {
            return;
        }
        graphics2D.draw(new Line2D.Float(0.0f, 4.0f, 4.0f, 0.0f));
        graphics2D.draw(new Line2D.Float(0.0f, 0.0f, 4.0f, 4.0f));
    }

    private void fillRect() {
        Graphics2D graphics2D = this.getHeight(10, 10);
        if (graphics2D == null) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(5.0f, 10.0f);
        generalPath.lineTo(10.0f, 0.0f);
        generalPath.closePath();
        graphics2D.fill(generalPath);
    }

    private void getBuiltinTexture() {
        Graphics2D graphics2D = this.getHeight(10, 10);
        if (graphics2D == null) {
            return;
        }
        graphics2D.fill3DRect(3, 3, 6, 6, true);
    }

    private void getColor() {
        int n = 30;
        int n2 = 30;
        Graphics2D graphics2D = this.getHeight(n, n2);
        if (graphics2D == null) {
            return;
        }
        Color color = graphics2D.getColor();
        Color color2 = graphics2D.getBackground();
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, (float)n * 0.35f, (float)n2 * 0.35f, color));
        graphics2D.fillRect(0, 0, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(n, 0.0f, color2, (float)n * 0.65f, (float)n2 * 0.35f, color));
        graphics2D.fillRect(n / 2, 0, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(0.0f, n2, color2, (float)n * 0.35f, (float)n2 * 0.65f, color));
        graphics2D.fillRect(0, n2 / 2, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(n, n2, color2, (float)n * 0.65f, (float)n2 * 0.65f, color));
        graphics2D.fillRect(n / 2, n2 / 2, n / 2, n2 / 2);
    }

    private Graphics2D getHeight(int n, int n2) {
        Color color = this.closePath.getColor();
        Color color2 = this.clone.getColor();
        if (color2 == null) {
            return null;
        }
        if (color == null) {
            color = ChartColorPattern.transparent(color2.darker(), this.getAlpha());
        }
        this.createGraphics = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = this.createGraphics.createGraphics();
        graphics2D.setBackground(color);
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.setColor(color2);
        return graphics2D;
    }

    @Override
    public Object clone() {
        if (this == null) {
            return null;
        }
        return new ChartTexturePattern(this.clearRect, (ChartColorPattern)this.clone.clone(), (ChartColorPattern)this.closePath.clone());
    }

    public static String[] getBuiltinTextureNames() {
        return SEDU;
    }

    public static int getBuiltinTexture(String string) {
        for (int i = 0; i < SEDU.length; ++i) {
            if (!string.equals(SEDU[i])) continue;
            return i;
        }
        return -1;
    }
}

