/*
 * Decompiled with CFR 0.152.
 */
package chart.properties;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class ChartAxisUnitProperties {
    boolean SEDU;
    int getDefault = -1;
    int getTime;
    protected int majorUnitDateType = 0;
    protected int minorUnitDateType = 2;
    protected String majorUnit;
    protected String minorUnit;
    protected String cusStart;
    protected String cusEnd;
    protected boolean autoStart;
    protected boolean autoEnd;
    protected boolean autoMajorUnit;
    protected boolean autoMinorUnit;

    public void setMajorUnit(boolean bl, String string) {
        this.autoMajorUnit = bl;
        this.majorUnit = string;
    }

    public void setMajorUnit(boolean bl, String string, int n) {
        this.autoMajorUnit = bl;
        this.majorUnit = string;
        this.majorUnitDateType = n;
    }

    public boolean getAutoMajorUnit() {
        return this.autoMajorUnit;
    }

    public int getMajorUnitDateType() {
        return this.majorUnitDateType;
    }

    public void setMajorUnitDateType(int n) {
        this.majorUnitDateType = n;
    }

    public String getMajorUnit() {
        return this.majorUnit;
    }

    public float getMajorUnitFloat() {
        if (this.majorUnit == null) {
            return 1.0f;
        }
        float f = 1.0f;
        try {
            f = Float.parseFloat(this.majorUnit);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
        return f < 0.0f ? 1.0f : f;
    }

    public int getMajorUnitInt() {
        if (this.majorUnit == null) {
            return 1;
        }
        int n = 1;
        try {
            n = (int)Float.parseFloat(this.majorUnit);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n < 0 ? 1 : n;
    }

    public void setMinorUnit(boolean bl, String string) {
        this.autoMinorUnit = bl;
        this.minorUnit = string;
    }

    public void setMinorUnit(boolean bl, String string, int n) {
        this.autoMinorUnit = bl;
        this.minorUnit = string;
        this.minorUnitDateType = n;
    }

    public boolean getAutoMinorUnit() {
        return this.autoMinorUnit;
    }

    public int getMinorUnitDateType() {
        return this.minorUnitDateType;
    }

    public void setMinorUnitDateType(int n) {
        this.minorUnitDateType = n;
    }

    public String getMinorUnit() {
        return this.minorUnit;
    }

    public float getMinorUnitFloat() {
        if (this.minorUnit == null) {
            return 1.0f;
        }
        float f = 1.0f;
        try {
            f = Float.parseFloat(this.minorUnit);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
        return f < 0.0f ? 1.0f : f;
    }

    public int getMinorUnitInt() {
        if (this.minorUnit == null) {
            return 0;
        }
        int n = 1;
        try {
            n = (int)Float.parseFloat(this.minorUnit);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n < 0 ? 1 : n;
    }

    public void setStart(boolean bl, String string) {
        this.autoStart = bl;
        this.cusStart = string;
    }

    public String getStart() {
        return this.cusStart;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public float getStartFloat() {
        if (this.cusStart == null) {
            return 0.0f;
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(this.cusStart);
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
        return f;
    }

    public double getStartValue() {
        if (this.cusStart == null) {
            return 0.0;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(this.cusStart);
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
        return d;
    }

    public long getStartTime() {
        if (this.cusStart == null) {
            return 0L;
        }
        if (this.cusStart.matches("\\d+?-\\d+?-\\d+?")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            try {
                return simpleDateFormat.parse(this.cusStart).getTime();
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
        if (this.cusStart.matches("\\d+?:\\d+?:\\d+?")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
            try {
                return simpleDateFormat.parse(this.cusStart).getTime();
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
        if (this.cusStart.matches("\\d+?-\\d+?-\\d+?\\s+?\\d+?:\\d+?:\\d+?")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            try {
                return simpleDateFormat.parse(this.cusStart).getTime();
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
        return 0L;
    }

    public void setEnd(boolean bl, String string) {
        this.autoEnd = bl;
        this.cusEnd = string;
    }

    public String getEnd() {
        return this.cusEnd;
    }

    public boolean getAutoEnd() {
        return this.autoEnd;
    }

    public float getEndFloat() {
        if (this.cusEnd == null) {
            return 0.0f;
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(this.cusEnd);
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
        return f;
    }

    public double getEndValue() {
        if (this.cusEnd == null) {
            return 0.0;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(this.cusEnd);
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
        return d;
    }

    public long getEndTime() {
        if (this.cusEnd == null) {
            return 0L;
        }
        if (this.cusEnd.matches("\\d+?-\\d+?-\\d+?")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            try {
                return simpleDateFormat.parse(this.cusEnd).getTime();
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
        if (this.cusEnd.matches("\\d+?:\\d+?:\\d+?")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
            try {
                return simpleDateFormat.parse(this.cusEnd).getTime();
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
        if (this.cusEnd.matches("\\d+?-\\d+?-\\d+?\\s+?\\d+?:\\d+?:\\d+?")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            try {
                return simpleDateFormat.parse(this.cusEnd).getTime();
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
        return 0L;
    }

    public void setDataType(int n) {
        this.getDefault = n;
    }

    public int getDataType() {
        return this.getDefault;
    }

    public void setUseConstantInterval(boolean bl) {
        this.SEDU = bl;
    }

    public boolean getUseConstantInterva() {
        return this.SEDU;
    }

    public ChartAxisUnitProperties dup() {
        ChartAxisUnitProperties chartAxisUnitProperties = new ChartAxisUnitProperties();
        chartAxisUnitProperties.autoEnd = this.autoEnd;
        chartAxisUnitProperties.autoMajorUnit = this.autoMajorUnit;
        chartAxisUnitProperties.autoMinorUnit = this.autoMinorUnit;
        chartAxisUnitProperties.autoStart = this.autoStart;
        chartAxisUnitProperties.cusEnd = new String(this.cusEnd);
        chartAxisUnitProperties.cusStart = new String(this.cusStart);
        chartAxisUnitProperties.getDefault = this.getDefault;
        chartAxisUnitProperties.getTime = this.getTime;
        chartAxisUnitProperties.majorUnit = new String(this.majorUnit);
        chartAxisUnitProperties.majorUnitDateType = this.majorUnitDateType;
        chartAxisUnitProperties.minorUnit = new String(this.minorUnit);
        chartAxisUnitProperties.minorUnitDateType = this.minorUnitDateType;
        chartAxisUnitProperties.SEDU = this.SEDU;
        return chartAxisUnitProperties;
    }
}

