/*
 * Decompiled with CFR 0.152.
 */
package chart.axis;

import chart.ChartLabelBase;
import chart.axis.ChartAxis;
import chart.axis.ChartNumericRadarAxis;
import chart.properties.ChartAxisProperties;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartMath;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class ChartNumericAxis
extends ChartAxis {
    private double F;
    private double IsLabelFontAutomaticOrientation;
    private double SEDU;
    private int abs;
    private float floor;
    private boolean format;
    private double getAxisIncrement;
    private double getChartTextStyle;
    private boolean getFilters;
    private boolean getLabelStartValue;
    private boolean getLabelText = false;
    private boolean getLabelTextStyle = false;
    private boolean getMax = false;
    private boolean[] getMaxValue;
    private float getMin;
    private boolean getMinValue = false;
    private boolean getNumOfTickMarks = false;
    double getUnit = 0.0;
    double getWidth = 0.0;
    int getZeroRotationDimension = 0;

    public ChartNumericAxis(ChartAxisProperties chartAxisProperties, double d, double d2) {
        super(chartAxisProperties);
        this.F = d;
        this.IsLabelFontAutomaticOrientation = d2;
    }

    @Override
    public void init() {
        this.ceil();
        if (this.Z >= 1) {
            int n = this.Z;
            this.getWidth = this.IsLabelFontAutomaticOrientation;
            this.getUnit = this.F;
            this.getZeroRotationDimension = this.abs;
        }
        this.F();
        this.Z();
        super.init();
    }

    private void F() {
        ChartNumericAxisProperties chartNumericAxisProperties = (ChartNumericAxisProperties)this.properties;
        this.floor = (float)chartNumericAxisProperties.getLabelStartValue();
        this.format = chartNumericAxisProperties.isUseLabelStartValue();
        this.getAxisIncrement = chartNumericAxisProperties.getMinValue();
        this.getChartTextStyle = chartNumericAxisProperties.getMaxValue();
        if (this.getAxisIncrement > this.getChartTextStyle) {
            this.getChartTextStyle = chartNumericAxisProperties.getMinValue();
            this.getAxisIncrement = chartNumericAxisProperties.getMaxValue();
        }
        this.getFilters = this.getAxisIncrement == 0.0;
        this.getLabelStartValue = this.getChartTextStyle == 0.0;
        this.SEDU = chartNumericAxisProperties.getAxisIncrement();
        this.abs = chartNumericAxisProperties.getNumOfTickMarks();
        if (this.filter != null && this.filter.isLogScale()) {
            this.SEDU = 1.0;
            this.abs = -1;
            this.getAxisIncrement = this.getAxisIncrement > 0.0 ? ChartMath.log10(this.getAxisIncrement) : 0.0;
            double d = this.getChartTextStyle = this.getChartTextStyle > 0.0 ? ChartMath.log10(this.getChartTextStyle) : 0.0;
        }
        this.IsLabelFontAutomaticOrientation = this.getLabelStartValue ? (this.IsLabelFontAutomaticOrientation < 0.0 ? 0.0 : this.IsLabelFontAutomaticOrientation) : this.getChartTextStyle;
        this.F = this.getFilters ? (this.F > 0.0 ? 0.0 : this.F) : this.getAxisIncrement;
        if (Math.abs(this.IsLabelFontAutomaticOrientation - this.F) < Double.MIN_VALUE) {
            if (Math.abs(this.F) < Double.MIN_VALUE) {
                this.IsLabelFontAutomaticOrientation = this.F + 100.0;
            } else {
                this.IsLabelFontAutomaticOrientation = Math.max(0.0, this.F);
                this.F = Math.min(0.0, this.F);
            }
            this.getLabelStartValue = true;
            this.getFilters = true;
        }
        if (this.Z >= 1) {
            int n = this.Z;
            this.abs = this.getZeroRotationDimension;
            this.IsLabelFontAutomaticOrientation = this.getWidth;
            this.F = this.getUnit;
            this.SEDU = (this.IsLabelFontAutomaticOrientation - this.F) / (double)this.abs;
            this.SEDU *= (double)n;
            this.abs = (int)Math.ceil((this.IsLabelFontAutomaticOrientation - this.F) / this.SEDU);
            return;
        }
        if (this.abs <= 0) {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            if (this.SEDU <= 0.0 || this.SEDU > this.IsLabelFontAutomaticOrientation - this.F) {
                this.SEDU = this.IsLabelFontAutomaticOrientation(this.F, this.IsLabelFontAutomaticOrientation);
                bl = true;
            }
            if (this.F < 0.0 && this.IsLabelFontAutomaticOrientation > 0.0) {
                double d;
                if (this.getFilters) {
                    n = (int)Math.ceil(-this.F / this.SEDU);
                    if (this.getLabelText && ((d = -this.F % this.SEDU) > this.SEDU * 9.0 / 10.0 || d == 0.0)) {
                        ++n;
                    }
                } else {
                    n = (int)Math.floor(-this.F / this.SEDU);
                    if (-this.F / this.SEDU % 1.0 > 0.99999) {
                        ++n;
                    }
                }
                this.F = -this.SEDU * (double)n;
                if (this.getLabelStartValue) {
                    n2 = (int)Math.ceil(this.IsLabelFontAutomaticOrientation / this.SEDU);
                    if (this.getLabelText && ((d = this.IsLabelFontAutomaticOrientation % this.SEDU) > this.SEDU * 9.0 / 10.0 || d == 0.0)) {
                        ++n2;
                    }
                } else {
                    n2 = (int)Math.floor(this.IsLabelFontAutomaticOrientation / this.SEDU);
                    if (this.IsLabelFontAutomaticOrientation / this.SEDU % 1.0 > 0.99999) {
                        ++n2;
                    }
                }
                this.IsLabelFontAutomaticOrientation = this.SEDU * (double)n2;
                this.abs = n + n2;
            } else if (this.IsLabelFontAutomaticOrientation <= 0.0) {
                if (this.getFilters) {
                    double d;
                    this.abs = (int)Math.ceil((this.IsLabelFontAutomaticOrientation - this.F) / this.SEDU);
                    if (this.getLabelText && ((d = (this.IsLabelFontAutomaticOrientation - this.F) % this.SEDU) > this.SEDU * 9.0 / 10.0 || d == 0.0) && this.abs < Integer.MAX_VALUE && !this.getLabelTextStyle) {
                        ++this.abs;
                    }
                } else {
                    this.abs = (int)Math.floor((this.IsLabelFontAutomaticOrientation - this.F) / this.SEDU);
                    if ((this.IsLabelFontAutomaticOrientation - this.F) / this.SEDU % 1.0 > 0.99999 && this.abs < Integer.MAX_VALUE) {
                        ++this.abs;
                    }
                }
                if (this instanceof ChartNumericRadarAxis) {
                    this.abs -= this.abs / 2;
                }
                this.F = this.IsLabelFontAutomaticOrientation - this.SEDU * (double)this.abs;
                if (this.getFilters) {
                    this.IsLabelFontAutomaticOrientation += this.SEDU;
                    if (this.abs < Integer.MAX_VALUE) {
                        ++this.abs;
                    }
                }
            } else if (this.F >= 0.0) {
                if (this.getLabelStartValue) {
                    double d;
                    this.abs = (int)Math.ceil((this.IsLabelFontAutomaticOrientation - this.F) / this.SEDU);
                    if (this.getLabelText && ((d = (this.IsLabelFontAutomaticOrientation - this.F) % this.SEDU) > this.SEDU * 9.0 / 10.0 || d == 0.0) && this.abs < Integer.MAX_VALUE && !this.getLabelTextStyle) {
                        ++this.abs;
                    }
                    this.IsLabelFontAutomaticOrientation = this.F + this.SEDU * (double)this.abs;
                    if (this instanceof ChartNumericRadarAxis) {
                        if (this.abs % 2 == 0) {
                            this.abs -= this.abs / 2;
                            this.SEDU *= 2.0;
                        } else {
                            this.IsLabelFontAutomaticOrientation += this.SEDU;
                            this.abs = (this.abs + 1) / 2;
                            this.SEDU = (this.IsLabelFontAutomaticOrientation - this.F) / (double)this.abs;
                        }
                    }
                } else {
                    this.abs = (int)Math.floor((this.IsLabelFontAutomaticOrientation - this.F) / this.SEDU);
                    if (this.abs == 0) {
                        this.abs = 2;
                        this.SEDU = this.IsLabelFontAutomaticOrientation;
                    }
                    if ((this.IsLabelFontAutomaticOrientation - this.F) / this.SEDU % 1.0 > 0.99999 && this.abs < Integer.MAX_VALUE) {
                        ++this.abs;
                    }
                    this.IsLabelFontAutomaticOrientation = this.F + this.SEDU * (double)this.abs;
                }
            }
            if (this.getMax && this.IsLabelFontAutomaticOrientation - this.F < 4.0 && this.SEDU - 1.0 < Double.MIN_VALUE && bl) {
                if (this.getFilters && this.getLabelStartValue) {
                    this.abs = 4;
                    this.IsLabelFontAutomaticOrientation = Math.ceil(this.F) + (double)this.abs;
                } else if (this.IsLabelFontAutomaticOrientation - this.F > 2.0) {
                    this.abs = (int)Math.floor(this.IsLabelFontAutomaticOrientation - this.F);
                    this.F = Math.ceil(this.F);
                }
            }
        } else {
            if (this.F < 0.0 && this.IsLabelFontAutomaticOrientation > 0.0) {
                this.IsLabelFontAutomaticOrientation = this.getLabelStartValue ? this.SEDU(this.IsLabelFontAutomaticOrientation, true) : this.IsLabelFontAutomaticOrientation;
                this.F = this.getFilters ? this.SEDU(this.F, true) : this.F;
            } else if (this.F >= 0.0) {
                this.IsLabelFontAutomaticOrientation = this.getLabelStartValue ? this.SEDU(this.IsLabelFontAutomaticOrientation, true) : this.IsLabelFontAutomaticOrientation;
                this.F = this.getFilters ? this.SEDU(this.F, false) : this.F;
            } else if (this.IsLabelFontAutomaticOrientation <= 0.0) {
                this.IsLabelFontAutomaticOrientation = this.getLabelStartValue ? this.SEDU(this.IsLabelFontAutomaticOrientation, false) : this.IsLabelFontAutomaticOrientation;
                this.F = this.getFilters ? this.SEDU(this.F, true) : this.F;
            }
            this.SEDU = (this.IsLabelFontAutomaticOrientation - this.F) / (double)this.abs;
        }
        this.ceil();
        if (this.getNumOfTickMarks || this.getMinValue) {
            this.I();
            return;
        }
    }

    private void I() {
        this.F = -3.4028234663852886E38;
        this.IsLabelFontAutomaticOrientation = 3.4028234663852886E38;
        this.abs = 3;
        this.SEDU = 3.4028234663852886E38;
    }

    private double IsLabelFontAutomaticOrientation(double d, double d2) {
        double d3;
        double d4 = 1.0;
        double d5 = 2.0;
        double d6 = 5.0;
        double d7 = d2 - d;
        if (Math.abs(d7) < Double.MIN_VALUE) {
            d7 = 100.0;
        }
        if (d7 > Double.MAX_VALUE) {
            d7 = Double.MAX_VALUE;
        }
        if (d7 > 5.0) {
            while (d7 >= d4 * 8.0) {
                d4 *= 10.0;
            }
            while (d7 >= d5 * 8.0) {
                d5 *= 10.0;
            }
            while (d7 >= d6 * 8.0) {
                d6 *= 10.0;
            }
            d3 = d4;
            d3 = d3 < d5 ? d3 : d5;
            d3 = d3 < d6 ? d3 : d6;
        } else {
            while (d7 <= d4 * 3.99999) {
                d4 /= 10.0;
            }
            while (d7 <= d5 * 3.99999) {
                d5 /= 10.0;
            }
            while (d7 <= d6 * 3.99999) {
                d6 /= 10.0;
            }
            d3 = d4;
            d3 = d3 > d5 ? d3 : d5;
            double d8 = d3 = d3 > d6 ? d3 : d6;
        }
        if (this.getMax && d2 - d < 4.0) {
            if (this.getFilters || this.getLabelStartValue) {
                d3 = 1.0;
            } else if (d2 - d > 2.0) {
                d3 = 1.0;
            }
        }
        return d3;
    }

    private double SEDU(double d, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        if (d < 0.0) {
            d = Math.abs(d);
            bl3 = true;
        }
        boolean bl4 = bl2 = d >= 1.0;
        if (d != 0.0) {
            int n = 0;
            while (bl2 ? d >= 10.0 : d < 1.0) {
                d *= bl2 ? (double)0.1f : 10.0;
                ++n;
            }
            int n2 = (int)Math.round(d);
            if (d > (double)n2) {
                d = bl ? (double)((float)n2 + 1.0f) : (double)n2;
            } else if (d < (double)n2) {
                d = bl ? (double)n2 : (double)((float)n2 - 1.0f);
            }
            d *= Math.pow(bl2 ? 10.0f : 0.1f, n);
        }
        return bl3 ? -d : d;
    }

    private void Z() {
        if (this.abs >= 100) {
            this.abs = 100;
            this.SEDU = (this.IsLabelFontAutomaticOrientation - this.F) / (double)this.abs;
        }
        if (this.abs == 0) {
            this.paintingLabels = null;
            return;
        }
        ChartNumericAxisProperties chartNumericAxisProperties = (ChartNumericAxisProperties)this.properties;
        this.paintingLabels = new ChartLabelBase[this.abs + 1];
        double d = 0.0;
        this.getMaxValue = new boolean[2];
        DecimalFormat decimalFormat = new DecimalFormat();
        if (this.getMinValue || this.getNumOfTickMarks) {
            this.paintingLabels = new ChartLabelBase[this.abs + 1];
            for (int i = 0; i <= this.abs; ++i) {
                String string;
                if (i == 0) {
                    this.getMin = (float)d;
                    string = "-Infinity";
                } else {
                    string = i == 1 ? (this.filter != null && this.filter.getFilters().size() != 0 ? this.filter.filter(new Double(0.0), i) : String.valueOf(decimalFormat.format(0L))) : "Infinity";
                }
                this.paintingLabels[i] = new ChartLabelBase(string);
                this.paintingLabels[i].setChartTextStyle(chartNumericAxisProperties.getLabelTextStyle());
                if (this.getFilters && this.getLabelStartValue) continue;
                if (i == 0) {
                    boolean bl = this.getMaxValue[0] = d != this.getAxisIncrement;
                }
                if (i != this.abs) continue;
                this.getMaxValue[1] = d != this.getChartTextStyle;
            }
        } else {
            for (int i = 0; i <= this.abs; ++i) {
                String string;
                d = this.F + (double)i * this.SEDU;
                if (this.filter != null && this.filter.getFilters().size() != 0) {
                    string = this.filter.filter(new Double(d), i);
                } else {
                    decimalFormat.setMinimumFractionDigits(this.abs(d));
                    string = String.valueOf(decimalFormat.format(d));
                }
                this.paintingLabels[i] = new ChartLabelBase(string);
                this.paintingLabels[i].setChartTextStyle(chartNumericAxisProperties.getLabelTextStyle());
                if (this.format && (float)d < this.floor) {
                    this.paintingLabels[i].setLabelText("");
                }
                if (i == 0) {
                    this.getMin = (float)d;
                }
                if (this.getFilters && this.getLabelStartValue) continue;
                if (i == 0) {
                    this.getMaxValue[0] = ChartMath.isEquals(d, this.getAxisIncrement);
                }
                if (i != this.abs) continue;
                this.getMaxValue[1] = ChartMath.isEquals(d, this.getChartTextStyle);
            }
        }
    }

    int abs(double d) {
        int n;
        double d2 = d - (double)((long)d);
        if (d2 == 0.0) {
            return 0;
        }
        d2 = Math.round(d2 * 1000000.0);
        for (n = 7; n >= 0 && ChartMath.isEquals(d2, (double)((long)d2)) && !ChartMath.isEquals(0.0, d2); --n) {
            d2 /= 10.0;
        }
        return n;
    }

    void ceil() {
        this.getMinValue = this.F <= -3.4028234663852886E38;
        this.getNumOfTickMarks = this.IsLabelFontAutomaticOrientation >= 3.4028234663852886E38;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
    }

    public double getMax() {
        return this.getLabelStartValue ? this.IsLabelFontAutomaticOrientation : this.getChartTextStyle;
    }

    public double getMin() {
        return this.getFilters ? this.F : this.getAxisIncrement;
    }

    public double getLabelStartValue() {
        return this.F;
    }

    public double getLabelEndValue() {
        return this.IsLabelFontAutomaticOrientation;
    }

    public double getTickPace() {
        return this.SEDU;
    }

    public int getNumOfTick() {
        return this.abs;
    }

    @Override
    public float getZeroPosition(float f) {
        float f2 = this.getUnit(f);
        double d = this.getMin() * (double)f2;
        return -((float)d);
    }

    @Override
    public float getUnit(float f) {
        double d = (double)f / (this.getMax() - this.getMin());
        return (float)Math.abs(d);
    }

    public boolean isAutoExpand() {
        return this.getLabelText;
    }

    public void setAutoExpand(boolean bl) {
        this.getLabelText = bl;
    }

    @Override
    public float[][] getLabelsPosition() {
        return null;
    }

    public void setIsBubble(boolean bl) {
        this.getLabelTextStyle = bl;
    }

    public boolean[] surfacePatternIncrea() {
        return this.getMaxValue;
    }

    public float getFristLabel() {
        return this.getMin;
    }

    public void setIntegerIncrement(boolean bl) {
        this.getMax = bl;
    }

    public boolean isIntegerIncrement() {
        return this.getMax;
    }

    @Override
    public void locate() {
        super.locate();
    }

    @Override
    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public String[] getLabelsForHtml() {
        String[] stringArray = null;
        if (this.paintingLabels != null && this.paintingLabels.length > 0) {
            int n = this.paintingLabels.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.paintingLabels[i].getLabelText();
            }
        }
        return stringArray;
    }

    @Override
    public float getLabelUnit(float f) {
        float f2 = f;
        if (this.abs > 0) {
            if (this.abs == 1) {
                return f2;
            }
            f2 /= (float)(this.abs - 1);
        }
        return f2;
    }

    @Override
    public boolean getAutoOritention(float f) {
        if (this.properties.IsLabelFontAutomaticOrientation()) {
            boolean bl = false;
            float f2 = 0.0f;
            for (int i = 0; i < this.paintingLabelsLength; ++i) {
                Rectangle2D rectangle2D = !this.initedLabelStyle ? this.textStyle.getZeroRotationDimension(this.paintingLabels[i].getLabelText()) : this.paintingLabels[i].getChartTextStyle().getZeroRotationDimension(this.paintingLabels[i].getLabelText());
                f2 = (float)rectangle2D.getWidth();
                if (!(f2 > f)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return false;
    }

    @Override
    public void setTickSkipNum() {
        float f = 0.0f;
        if (this.Z >= 1) {
            return;
        }
        if (this.abs >= 2) {
            f = this.C / (float)(this.abs - 1);
            if (f < this.B) {
                int n = this.Z = this.B / f > (float)((int)(this.B / f)) ? (int)(this.B / f) + 1 : (int)(this.B / f);
            }
            if (this.Z < 1) {
                return;
            }
            this.init();
        }
    }

    @Override
    public int getTickSkipNum() {
        return this.Z;
    }
}

