/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartCategoryAxis;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.Chart3DStrip;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.List;

public class Graph3DAreaP
extends Chart3DObject {
    int[] abs;
    boolean[][] areaSurface;
    protected Chart3DStrip[][] strip;
    protected Chart3DStrip[][] bottom;
    protected Chart3DStrip[][] areas;
    protected ChartFillPattern[] pattern;
    protected ChartCompass compass;
    int availableLength;
    int availableOriginY;
    boolean custommerConstant;
    private ChartPenStyle draw;
    GeneralPath drawArea;
    protected boolean outerAscending;
    protected boolean innerAscending;
    protected boolean toUpAscending;
    float[] drawAreaSurface;
    Rectangle drawSelectedOutLine = new Rectangle();
    float[][] drawSelectedShape;
    int fill = 2;
    float[] floatValue;
    Color[] get;
    float getAbsoluteValueSumOfCategory;
    protected Chart3DStrip[][] sideArea;

    Graph3DAreaP(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.dataset = chartDataSet;
        this.abs = chart3DPaper.getIntType();
        this.paper = chart3DPaper;
        this.availableLength = chartDataSet.getCategorySize();
        this.availableOriginY = chartDataSet.getSeriesSize();
        this.pattern = chart3DPaper.getChartPlatform().getFillPatternByArarry(0);
        this.getAbsoluteValueSumOfCategory = chart3DPaper.getProperties().getGraphProperties().getThresholdFillTransparency();
    }

    @Override
    public void locate() {
    }

    @Override
    void transform(ChartMatrix chartMatrix) {
        int n;
        int n2;
        if (this.availableLength < 2) {
            return;
        }
        for (n2 = 0; n2 < this.availableOriginY; ++n2) {
            if (this.strip[n2] == null) continue;
            for (n = 0; n < this.strip[n2].length; ++n) {
                this.strip[n2][n].transform(chartMatrix);
                this.bottom[n2][n].transform(chartMatrix);
            }
        }
        for (n2 = 0; n2 < this.fill; ++n2) {
            for (n = 0; n < this.areas[n2].length; ++n) {
                this.areas[n2][n].transform(chartMatrix);
            }
        }
        if (this.sideArea != null && this.sideArea.length > 0) {
            for (n2 = 0; n2 < this.fill; ++n2) {
                for (n = 0; n < this.sideArea[n2].length; ++n) {
                    this.sideArea[n2][n].transform(chartMatrix);
                }
            }
        }
        this.SEDU();
    }

    @Override
    public void init() {
        float f;
        float f2;
        int n;
        int n2;
        int n3;
        this.drawArea = new GeneralPath();
        this.custommerConstant = this.paper.getProperties().getGraphProperties().isContour();
        this.draw = this.properties.getGraphProperties().getContourPen();
        if (this.availableLength < 2) {
            return;
        }
        this.setCompass(this.paper.getCompass());
        this.strip = new Chart3DStrip[this.availableOriginY][this.availableLength - 1];
        this.bottom = new Chart3DStrip[this.availableOriginY][this.availableLength - 1];
        this.areas = new Chart3DStrip[this.fill][2];
        this.drawAreaSurface = this.paper.getUnit();
        this.drawAreaSurface[2] = this.paper.getLength()[2] / 2.0f;
        float f3 = 30.0f;
        if (f3 > this.drawAreaSurface[2]) {
            f3 = this.drawAreaSurface[2];
        }
        float f4 = this.paper.getOriginY();
        float f5 = this.drawAreaSurface[0];
        float f6 = 0.0f;
        float f7 = this.drawAreaSurface[2] - f3 / 2.0f;
        this.drawSelectedShape = new float[this.availableOriginY][this.availableLength];
        this.areaSurface = new boolean[this.availableOriginY][];
        float[] fArray2 = new float[this.availableLength];
        if (this.paper.getProperties().getGraphProperties().isShowThresholdLine() && this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.fill = 2;
            this.floatValue = new float[this.fill];
            this.get = new Color[this.fill];
            this.floatValue[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.floatValue[1] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.get[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
            this.get[1] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine()) {
            this.fill = 1;
            this.floatValue = new float[this.fill];
            this.get = new Color[this.fill];
            this.floatValue[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.get[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.fill = 1;
            this.floatValue = new float[this.fill];
            this.get = new Color[this.fill];
            this.floatValue[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.get[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else {
            this.fill = 0;
            this.floatValue = new float[this.fill];
            this.get = new Color[this.fill];
        }
        for (int i = 0; i < this.fill; ++i) {
            float f8 = 0.0f;
            for (n3 = i; n3 < this.fill; ++n3) {
                if (!(this.floatValue[i] > this.floatValue[n3])) continue;
                f8 = this.floatValue[n3];
                this.floatValue[n3] = this.floatValue[i];
                this.floatValue[i] = f8;
                Color color = this.get[n3];
                this.get[n3] = this.get[i];
                this.get[i] = color;
            }
        }
        float[] fArray3 = new float[this.fill];
        for (n2 = 0; n2 < this.fill; ++n2) {
            fArray3[n2] = this.paper.availableLength(this.floatValue[n2] * this.drawAreaSurface[1]);
            if (!(fArray3[n2] < 2.0f) || fArray3[n2] == 0.0f) continue;
            fArray3[n2] = fArray3[n2] + 3.0f;
        }
        for (n2 = 0; n2 < this.availableLength; ++n2) {
            for (int i = 0; i < this.availableOriginY; ++i) {
                if (((Chart1DDataSet)this.dataset).getValue(i, n2) == null) {
                    this.drawSelectedShape[i][n2] = 0.0f;
                    continue;
                }
                float f9 = ((Chart1DDataSet)this.dataset).getValue(i, n2).floatValue();
                this.drawSelectedShape[i][n2] = Math.abs(f9);
            }
            fArray2[n2] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n2);
        }
        float f10 = f6;
        float f11 = f7;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float[][] fArray4 = new float[this.availableLength - 1][2];
        for (n = 0; n < this.availableLength - 1; ++n) {
            fArray4[n][0] = 0.0f;
            fArray4[n][1] = 0.0f;
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            this.sideArea = new Chart3DStrip[this.fill][2];
            for (n = 0; n < this.fill; ++n) {
                this.sideArea[n][0] = new Chart3DStrip(this.pattern[0], this.custommerConstant, this.draw);
                this.sideArea[n][1] = new Chart3DStrip(this.pattern[0], this.custommerConstant, this.draw);
                this.sideArea[n][0].setThresholdColor(this.get[n], this.getAbsoluteValueSumOfCategory);
                this.sideArea[n][1].setThresholdColor(this.get[n], this.getAbsoluteValueSumOfCategory);
            }
        }
        ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)this.paper.getAxisX1();
        if (this.paper.getAxisX1().custommerConstant()) {
            for (n3 = 0; n3 < this.fill; ++n3) {
                Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(0);
                f2 = chartCategoryAxis.getX(object, this.drawAreaSurface[0]);
                f12 = chartCategoryAxis.getX(object, this.drawAreaSurface[0]);
                this.sideArea[n3][0].setLineVertex1(0.0f, fArray3[n3], 0.0f, 0.0f, this.drawAreaSurface[2] * 2.0f, f2);
                object = this.getChartDataSet().getChartDataSetModel().getCategoryName(this.availableLength - 1);
                f = chartCategoryAxis.getX(object, this.drawAreaSurface[0]);
                this.sideArea[n3][1].setLineVertex1(f, fArray3[n3], 0.0f, 0.0f, this.drawAreaSurface[2] * 2.0f, this.paper.getLength()[0] - f);
            }
        }
        for (n3 = 0; n3 < this.availableOriginY; ++n3) {
            float f15 = f11;
            for (int i = 0; i < this.availableLength - 1; ++i) {
                f14 = fArray2[i] != 0.0f ? this.drawAreaSurface[1] * this.drawSelectedShape[n3][i] / fArray2[i] : 0.0f;
                f13 = fArray2[i + 1] != 0.0f ? this.drawAreaSurface[1] * this.drawSelectedShape[n3][i + 1] / fArray2[i + 1] : 0.0f;
                f2 = this.paper.availableLength(f14);
                f = this.paper.availableLength(f13);
                f12 = f10 + f5;
                if (this.paper.getAxisX1().custommerConstant()) {
                    float f16;
                    Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(i);
                    f10 = f16 = chartCategoryAxis.getX(object, this.drawAreaSurface[0]);
                    object = this.getChartDataSet().getChartDataSetModel().getCategoryName(i + 1);
                    f12 = chartCategoryAxis.getX(object, this.drawAreaSurface[0]);
                }
                f4 = this.paper.availableOriginY(f4);
                this.strip[n3][i] = new Chart3DStrip(this.pattern[n3], this.custommerConstant, this.draw);
                this.strip[n3][i].setAreaSurfaceVertex(f10, f2, f11, f12, f, f15, f3);
                this.bottom[n3][i] = new Chart3DStrip(this.pattern[n3], this.custommerConstant, this.draw);
                this.bottom[n3][i].setAreaSurfaceVertex(f10, f4, f11, f12, f4, f15, f3);
                f10 = f12;
                fArray4[i][0] = f14;
                fArray4[i][1] = f13;
            }
            f10 = f6;
        }
        float f17 = 0.0f;
        float f18 = 0.0f;
        if (this.paper.getAxisX1().custommerConstant()) {
            Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(0);
            f = chartCategoryAxis.getX(object, this.drawAreaSurface[0]);
            object = this.getChartDataSet().getChartDataSetModel().getCategoryName(this.availableLength - 1);
            f18 = f;
            f17 = chartCategoryAxis.getX(object, this.drawAreaSurface[0]) - f;
        } else {
            f18 = 0.0f;
            f17 = this.drawAreaSurface[0] * (float)(this.availableLength - 1);
        }
        for (int i = 0; i < this.fill; ++i) {
            this.areas[i][0] = new Chart3DStrip(this.pattern[0], this.custommerConstant, this.draw);
            this.areas[i][0].setLineVertex1(f18, fArray3[i], 0.0f, 0.0f, this.drawAreaSurface[2] - f3 / 2.0f, f17);
            this.areas[i][1] = new Chart3DStrip(this.pattern[0], this.custommerConstant, this.draw);
            this.areas[i][1].setLineVertex1(f18, fArray3[i], this.drawAreaSurface[2] + f3 / 2.0f, 0.0f, this.drawAreaSurface[2] - f3 / 2.0f, f17);
            this.areas[i][0].setThresholdColor(this.get[i], this.getAbsoluteValueSumOfCategory);
            this.areas[i][1].setThresholdColor(this.get[i], this.getAbsoluteValueSumOfCategory);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        if (this.availableLength < 2) {
            return;
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            n3 = 0;
            if (!this.innerAscending) {
                n3 = 1;
            }
            if (this.toUpAscending) {
                for (n2 = 0; n2 < this.fill; ++n2) {
                    this.sideArea[n2][n3].drawArea(graphics2D, 0);
                }
            } else {
                for (n2 = this.fill - 1; n2 >= 0; --n2) {
                    this.sideArea[n2][n3].drawArea(graphics2D, 0);
                }
            }
        }
        for (n3 = 0; n3 < this.fill; ++n3) {
            if (!this.outerAscending) {
                this.areas[n3][1].drawArea(graphics2D, 0);
                continue;
            }
            this.areas[n3][0].drawArea(graphics2D, 0);
        }
        n3 = this.availableOriginY - 1;
        for (n2 = 0; n2 < this.availableLength - 1; ++n2) {
            n = n2;
            if (!this.innerAscending) {
                n = this.availableLength - n2 - 1 - 1;
            }
            if ((this.paper.getShownFace() >> 3 & 1) == 1) {
                this.bottom[0][n].drawAreaSurface(graphics2D, this.custommerConstant);
                this.strip[n3][n].drawAreaSurface(graphics2D, this.custommerConstant);
                continue;
            }
            this.strip[n3][n].drawAreaSurface(graphics2D, this.custommerConstant);
            this.bottom[0][n].drawAreaSurface(graphics2D, this.custommerConstant);
        }
        for (n2 = this.availableOriginY - 1; n2 >= 0; --n2) {
            this.paintInnerFace(graphics2D, n2);
            this.paintOuterFace(graphics2D, n2);
        }
        for (n2 = 0; n2 < this.fill; ++n2) {
            if (!this.outerAscending) {
                this.areas[n2][0].drawArea(graphics2D, 0);
                continue;
            }
            this.areas[n2][1].drawArea(graphics2D, 0);
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            n2 = 0;
            if (this.innerAscending) {
                n2 = 1;
            }
            if (this.toUpAscending) {
                for (n = 0; n < this.fill; ++n) {
                    this.sideArea[n][n2].drawArea(graphics2D, 0);
                }
            } else {
                for (n = this.fill - 1; n >= 0; --n) {
                    this.sideArea[n][n2].drawArea(graphics2D, 0);
                }
            }
        }
        this.areas(graphics2D);
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.strip[n][n2].toHtml();
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        if (this.availableLength < 2) {
            this.selectedSeriesIndex = -1;
            return null;
        }
        String[] stringArray = null;
        for (int i = 0; i < this.availableOriginY; ++i) {
            for (int j = 0; j < this.availableLength - 1; ++j) {
                if (this.inSide(i, j, n, n2)) {
                    this.selectedSeriesIndex = i;
                    if (this.paper.getProperties().isShowCategoryAndSeries()) {
                        stringArray = new String[3];
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(i, j);
                    } else {
                        stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(i, j))};
                    }
                    this.selectedSeriesIndex = i;
                    this.drilldown = new int[2];
                    this.drilldown[0] = i;
                    this.drilldown[1] = j;
                    return stringArray;
                }
                if (j != this.availableLength - 2) continue;
                float f = this.strip[i][j].tVertex[1][0];
                float f2 = this.strip[i][j].tVertex[2][0];
                float f3 = this.strip[i][j].tVertex[1][1];
                float f4 = this.strip[i][j].tVertex[1][1] + 5.0f;
                float f5 = 5.0f;
                if (!((float)n >= f - f5) || !((float)n <= f2 + f5) || !((float)n2 <= Math.max(f3 + f5, f4 + f5)) || !((float)n2 >= Math.min(f3 - f5, f4 - f5))) continue;
                if (this.paper.getProperties().isShowCategoryAndSeries()) {
                    stringArray = new String[3];
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(i, j + 1);
                } else {
                    stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(i, j + 1))};
                }
                this.selectedSeriesIndex = i;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j + 1;
                return stringArray;
            }
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    public boolean inSide(int n, int n2, int n3, int n4) {
        float f = 5.0f;
        float f2 = this.strip[n][n2].tVertex[0][0];
        float f3 = this.strip[n][n2].tVertex[3][0];
        float f4 = this.strip[n][n2].tVertex[0][1];
        float f5 = this.strip[n][n2].tVertex[0][1] + f;
        return (float)n3 >= f2 - f && (float)n3 <= f3 + f && (float)n4 <= Math.max(f5 + f, f4 - f) && (float)n4 >= Math.min(f5 + f, f4 - f);
    }

    protected void paintInnerFace(Graphics2D graphics2D, int n) {
        int n2 = this.strip[n].length - 1;
        this.drawArea.reset();
        if (!this.innerAscending) {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            this.drawArea.lineTo(this.strip[n][0].tVertex[0][0], this.strip[n][0].tVertex[0][1]);
            this.drawArea.lineTo(this.strip[n][0].tVertex[3][0], this.strip[n][0].tVertex[3][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.drawArea.moveTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
        }
        if (this.pattern[n] != null) {
            this.pattern[n].fill(graphics2D, this.drawArea);
        }
        if (this.custommerConstant) {
            this.draw.draw(graphics2D, this.drawArea);
        }
        if (n == this.selectedSeriesIndex && this.status == 1) {
            ChartGraphicsUtil.drawSelectedShape(graphics2D, this.drawArea);
        }
    }

    protected void paintOuterFace(Graphics2D graphics2D, int n) {
        int n2 = this.strip[n].length - 1;
        this.drawArea.reset();
        if (!this.outerAscending) {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            for (int i = 0; i <= n2; ++i) {
                this.drawArea.lineTo(this.strip[n][i].tVertex[0][0], this.strip[n][i].tVertex[0][1]);
            }
            this.drawArea.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            for (int i = 0; i <= n2; ++i) {
                this.drawArea.lineTo(this.strip[n][i].tVertex[3][0], this.strip[n][i].tVertex[3][1]);
            }
            this.drawArea.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
        }
        if (this.pattern[n] != null) {
            this.pattern[n].fill(graphics2D, this.drawArea);
        }
        if (this.custommerConstant) {
            this.draw.draw(graphics2D, this.drawArea);
        }
        if (n == this.selectedSeriesIndex && this.status == 1) {
            ChartGraphicsUtil.drawSelectedShape(graphics2D, this.drawArea);
        }
    }

    private void SEDU() {
        this.add();
        this.abs();
        this.areaSurface();
    }

    private void abs() {
        this.outerAscending = (this.paper.getShownFace() >> 5 & 1) == 1;
    }

    private void add() {
        this.innerAscending = (this.paper.getShownFace() & 1) != 1;
    }

    private void areaSurface() {
        this.toUpAscending = (this.paper.getShownFace() >> 3 & 1) == 1;
    }

    public void setCompass(ChartCompass chartCompass) {
        this.compass = chartCompass;
    }

    protected Area innerFaceCover(int n) {
        int n2 = this.strip[n].length - 1;
        this.drawArea.reset();
        if (!this.innerAscending) {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            this.drawArea.lineTo(this.strip[n][0].tVertex[0][0], this.strip[n][0].tVertex[0][1]);
            this.drawArea.lineTo(this.strip[n][0].tVertex[3][0], this.strip[n][0].tVertex[3][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.drawArea.moveTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
        }
        return new Area(this.drawArea);
    }

    protected Area outerFaceCover(int n) {
        int n2 = this.strip[n].length - 1;
        this.drawArea.reset();
        if (!this.outerAscending) {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            for (int i = 0; i <= n2; ++i) {
                this.drawArea.lineTo(this.strip[n][i].tVertex[0][0], this.strip[n][i].tVertex[0][1]);
            }
            this.drawArea.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            for (int i = 0; i <= n2; ++i) {
                this.drawArea.lineTo(this.strip[n][i].tVertex[3][0], this.strip[n][i].tVertex[3][1]);
            }
            this.drawArea.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
        }
        return new Area(this.drawArea);
    }

    protected Area bottomCover(int n) {
        Area area = new Area();
        for (int i = 0; i < this.strip[n].length; ++i) {
            int n2 = i;
            if (!this.innerAscending) {
                n2 = this.strip[n].length - i - 1;
            }
            if ((this.paper.getShownFace() >> 3 & 1) == 1) {
                if (this.areaSurface[n][n2]) {
                    area.add(this.strip[n][n2].areaSurface());
                    area.add(this.bottom[n][n2].areaSurface());
                    continue;
                }
                area.add(this.bottom[n][n2].areaSurface());
                area.add(this.strip[n][n2].areaSurface());
                continue;
            }
            if (this.areaSurface[n][n2]) {
                area.add(this.bottom[n][n2].areaSurface());
                area.add(this.strip[n][n2].areaSurface());
                continue;
            }
            area.add(this.strip[n][n2].areaSurface());
            area.add(this.bottom[n][n2].areaSurface());
        }
        return area;
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        if (this.availableLength < 2) {
            return null;
        }
        Shape[][] shapeArray = new Shape[this.availableOriginY][this.availableLength];
        float f = 5.0f;
        for (int i = 0; i < this.availableOriginY; ++i) {
            for (int j = 0; j < this.availableLength; ++j) {
                float f2;
                float f3;
                float f4;
                float f5;
                if (j == this.availableLength - 1) {
                    f5 = Math.min(this.strip[i][j - 1].tVertex[1][0], this.strip[i][j - 1].tVertex[2][0]);
                    f4 = Math.max(this.strip[i][j - 1].tVertex[2][0], this.strip[i][j - 1].tVertex[1][0]);
                    f3 = Math.max(this.strip[i][j - 1].tVertex[1][1], this.strip[i][j - 1].tVertex[1][1]);
                    f2 = Math.min(this.strip[i][j - 1].tVertex[1][1], this.strip[i][j - 1].tVertex[1][1]);
                } else {
                    f5 = Math.min(this.strip[i][j].tVertex[0][0], this.strip[i][j].tVertex[3][0]);
                    f4 = Math.max(this.strip[i][j].tVertex[3][0], this.strip[i][j].tVertex[0][0]);
                    f2 = Math.min(this.strip[i][j].tVertex[0][1], this.strip[i][j].tVertex[0][1]);
                    f3 = Math.max(this.strip[i][j].tVertex[0][1], this.strip[i][j].tVertex[0][1]);
                }
                shapeArray[i][j] = new GeneralPath();
                ((GeneralPath)shapeArray[i][j]).moveTo(f5 - f, f3 + f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f4 + f, f3 + f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f4 + f, f2 - f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f5 - f, f2 - f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f5 - f, f3 + f);
            }
        }
        return shapeArray;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    private void areas(Graphics2D graphics2D) {
        if (this.availableLength < 2) {
            return;
        }
        for (int i = 0; i < this.availableOriginY; ++i) {
            if (this.strip[i] == null) continue;
            for (int j = 0; j < this.strip[i].length; ++j) {
                if (this.selectedSeriesIndex != i || this.status != 1) continue;
                this.strip[i][j].drawSelectedOutLine(graphics2D);
            }
        }
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        if (this.availableLength < 2) {
            return null;
        }
        int[] nArray = null;
        for (int i = 0; i < this.availableOriginY; ++i) {
            for (int j = 0; j < this.availableLength - 1; ++j) {
                if (this.inSide(i, j, n, n2)) {
                    ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                    if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                        nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                    }
                    return nArray;
                }
                if (j != this.availableLength - 2) continue;
                float f = this.strip[i][j].tVertex[1][0];
                float f2 = this.strip[i][j].tVertex[2][0];
                float f3 = this.strip[i][j].tVertex[1][1];
                float f4 = this.strip[i][j].tVertex[1][1] + 5.0f;
                float f5 = 5.0f;
                if (!((float)n >= f - f5) || !((float)n <= f2 + f5) || !((float)n2 <= Math.max(f3 + f5, f4 + f5)) || !((float)n2 >= Math.min(f3 - f5, f4 - f5))) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

