/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartCategoryAxis;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartCube;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.List;

public class Graph3DBarSi
extends Chart3DObject {
    ChartDataSet addVertex;
    protected int[] grpIdx;
    protected int[][] barIdx;
    protected boolean contour;
    private ChartPenStyle availableLength;
    private ChartCompass availableOriginY;
    ChartCube[][] custommerConstant;
    boolean[][] draw1;
    int draw2;
    protected ChartMatrix tempM = new ChartMatrix();
    private boolean floatValue;
    private boolean get;
    private boolean getAbsoluteValueSumOfCategory;
    int[] getAngle;
    protected ChartMatrix matrix;
    protected int col;
    protected int row;
    protected int numofTicks;
    protected ChartFillPattern[] pattern;
    float[] getAxisX1;
    float[][] getBarWidth;
    int getCategoryName = 2;
    float[] getCategorySize;
    Color[] getChartDataSet;
    float getChartDataSetInfo = 0.6f;
    private boolean getChartDataSetModel;
    private ChartShowValueCondition getChartLink = null;

    Graph3DBarSi(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.addVertex = chartDataSet;
        this.getAngle = chart3DPaper.getIntType();
        this.paper = chart3DPaper;
        this.col = chartDataSet.getCategorySize();
        this.row = chartDataSet.getSeriesSize();
        this.pattern = chart3DPaper.getChartPlatform().getFillPatternByArarry(0);
        this.getChartDataSetInfo = chart3DPaper.getProperties().getGraphProperties().getThresholdFillTransparency();
    }

    @Override
    public void init() {
        int n;
        int n2;
        int n3 = this.dataset.getChartDataSetInfo().getChartType();
        int n4 = ChartTypeInfo.getPrimType(n3);
        this.getChartDataSetModel = n4 == 1;
        this.setCompass(this.paper.getCompass());
        this.contour = this.paper.getProperties().getGraphProperties().isContour();
        this.availableLength = this.properties.getGraphProperties().getContourPen();
        this.custommerConstant = new ChartCube[this.row][this.col];
        this.getBarWidth = new float[this.row][this.col];
        this.draw1 = new boolean[this.row][this.col];
        this.getAxisX1 = this.paper.getUnit();
        this.getAxisX1[2] = this.paper.getLength()[2] / 2.0f;
        float f = this.getAxisX1[0] / (float)this.row * this.paper.getProperties().getGraphProperties().getBarWidth();
        float f2 = (this.getAxisX1[0] - f * (float)this.row) / 2.0f + f;
        float f3 = this.getAxisX1[2];
        float f4 = this.getAxisX1[0] * (1.0f - this.paper.getProperties().getGraphProperties().getBarWidth());
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        f10 = this.paper.getOriginY();
        f7 = this.paper.getLength()[2] / 2.0f + f3 / 2.0f;
        f9 = 0.0f;
        float[] fArray2 = new float[this.col];
        if (this.dataset.getChartDataSetModel().isOneGroupForBar()) {
            for (n2 = 0; n2 < this.col; ++n2) {
                for (n = 0; n < this.col; ++n) {
                    fArray2[n2] = fArray2[n2] + (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n);
                }
            }
        } else {
            for (n2 = 0; n2 < this.col; ++n2) {
                fArray2[n2] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n2);
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    this.getBarWidth[n2][n] = 0.0f;
                    continue;
                }
                this.getBarWidth[n2][n] = !((ChartNumericAxisProperties)this.paper.C.getProperties()).getIsShowPercent() ? number.floatValue() : number.floatValue() / fArray2[n];
                if (!(this.getBarWidth[n2][n] < 0.0f)) continue;
                this.draw1[n2][n] = true;
            }
        }
        if (this.paper.getProperties().getGraphProperties().isShowThresholdLine() && this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.getCategoryName = 2;
            this.getCategorySize = new float[this.getCategoryName];
            this.getChartDataSet = new Color[this.getCategoryName];
            this.getCategorySize[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.getCategorySize[1] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.getChartDataSet[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
            this.getChartDataSet[1] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine()) {
            this.getCategoryName = 1;
            this.getCategorySize = new float[this.getCategoryName];
            this.getChartDataSet = new Color[this.getCategoryName];
            this.getCategorySize[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.getChartDataSet[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.getCategoryName = 1;
            this.getCategorySize = new float[this.getCategoryName];
            this.getChartDataSet = new Color[this.getCategoryName];
            this.getCategorySize[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.getChartDataSet[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else {
            this.getCategoryName = 0;
            this.getCategorySize = new float[this.getCategoryName];
            this.getChartDataSet = new Color[this.getCategoryName];
        }
        for (n2 = 0; n2 < this.getCategoryName; ++n2) {
            float f12 = 0.0f;
            for (int i = n2; i < this.getCategoryName; ++i) {
                if (!(this.getCategorySize[n2] > this.getCategorySize[i])) continue;
                f12 = this.getCategorySize[i];
                this.getCategorySize[i] = this.getCategorySize[n2];
                this.getCategorySize[n2] = f12;
                Color color = this.getChartDataSet[i];
                this.getChartDataSet[i] = this.getChartDataSet[n2];
                this.getChartDataSet[n2] = color;
            }
        }
        float[] fArray3 = new float[this.getCategoryName];
        for (int i = 0; i < this.getCategoryName; ++i) {
            fArray3[i] = this.paper.availableLength(this.getCategorySize[i] * this.getAxisX1[1]);
            if (!(fArray3[i] < 2.0f) || fArray3[i] == 0.0f) continue;
            fArray3[i] = fArray3[i] + 3.0f;
        }
        ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)this.paper.getAxisX1();
        float f13 = this.properties.getGraphProperties().getBarWidth();
        float f14 = chartCategoryAxis.getMinUnit(this.getAxisX1[0]);
        float f15 = f14 * f13;
        for (int i = 0; i < this.row; ++i) {
            int n5;
            if (!this.paper.getAxisX1().custommerConstant()) {
                f8 = f2 - f;
                f5 = f2;
                for (n5 = 0; n5 < i; ++n5) {
                    f5 += f;
                    f8 += f;
                }
            }
            for (n5 = 0; n5 < this.col; ++n5) {
                int n6;
                int n7;
                float f16;
                Object object;
                if (this.paper.getAxisX1().custommerConstant()) {
                    object = this.getChartDataSet().getChartDataSetModel().getCategoryName(n5);
                    f16 = chartCategoryAxis.getX(object, this.getAxisX1[0]);
                    f5 = f16 + f15 / (float)this.row * (float)i;
                    f = f15 / (float)this.row;
                    f8 = f5 - f;
                }
                this.custommerConstant[i][n5] = new ChartCube();
                this.custommerConstant[i][n5].I = this.getCategoryName;
                this.custommerConstant[i][n5].setPattern(this.pattern[i]);
                f11 = this.paper.availableLength(this.getBarWidth[i][n5] * this.getAxisX1[1]);
                f6 = this.paper.availableOriginY(f10);
                object = new int[3];
                object[0] = this.getCategoryName;
                object[1] = false;
                object[2] = false;
                this.custommerConstant[i][n5].addVertex(f5 - f, f6, f7 - f3);
                this.custommerConstant[i][n5].addVertex(f5, f6, f7 - f3);
                this.custommerConstant[i][n5].addVertex(f5, f6, f7);
                this.custommerConstant[i][n5].addVertex(f5 - f, f6, f7);
                if (f6 <= f11) {
                    for (n7 = 0; n7 < this.getCategoryName; ++n7) {
                        if (fArray3[n7] < f11 && fArray3[n7] > f6) {
                            this.custommerConstant[i][n5].addVertex(f5 - f, fArray3[n7], f7 - f3);
                            this.custommerConstant[i][n5].addVertex(f5, fArray3[n7], f7 - f3);
                            this.custommerConstant[i][n5].addVertex(f5, fArray3[n7], f7);
                            this.custommerConstant[i][n5].addVertex(f5 - f, fArray3[n7], f7);
                            Object object2 = object;
                            object2[1] = object2[1] + true;
                            continue;
                        }
                        if (!(fArray3[n7] <= f6)) continue;
                        Object object3 = object;
                        object3[2] = object3[2] + true;
                    }
                } else {
                    for (n7 = this.getCategoryName - 1; n7 >= 0; --n7) {
                        if (fArray3[n7] > f11 && fArray3[n7] < f6) {
                            this.custommerConstant[i][n5].addVertex(f5 - f, fArray3[n7], f7 - f3);
                            this.custommerConstant[i][n5].addVertex(f5, fArray3[n7], f7 - f3);
                            this.custommerConstant[i][n5].addVertex(f5, fArray3[n7], f7);
                            this.custommerConstant[i][n5].addVertex(f5 - f, fArray3[n7], f7);
                            Object object4 = object;
                            object4[1] = object4[1] + true;
                            continue;
                        }
                        if (!(fArray3[n7] >= f6)) continue;
                        Object object5 = object;
                        object5[2] = object5[2] + true;
                    }
                }
                this.custommerConstant[i][n5].addVertex(f5 - f, f11, f7 - f3);
                this.custommerConstant[i][n5].addVertex(f5, f11, f7 - f3);
                this.custommerConstant[i][n5].addVertex(f5, f11, f7);
                this.custommerConstant[i][n5].addVertex(f5 - f, f11, f7);
                f16 = 0.0f;
                float f17 = 0.0f;
                if (this.paper.getAxisX1().custommerConstant()) {
                    float f18;
                    f17 = 0.0f;
                    f16 = f;
                    if (n5 != this.col - 1 && i == this.row - 1) {
                        Object object6 = this.getChartDataSet().getChartDataSetModel().getCategoryName(n5 + 1);
                        f18 = chartCategoryAxis.getX(object6, this.getAxisX1[0]);
                        f16 = f18 - f5;
                    } else if (n5 == this.col - 1 && i == this.row - 1) {
                        Object object7 = this.getChartDataSet().getChartDataSetModel().getCategoryName(n5);
                        f18 = chartCategoryAxis.getX(object7, this.getAxisX1[0]);
                        f16 = this.paper.getLength()[0] - f18;
                    }
                } else if (i != 0 && i != this.row - 1) {
                    f17 = 0.0f;
                    f16 = f;
                } else if (i == 0) {
                    f16 = f4 / 2.0f + f;
                    f17 = -f4 / 2.0f;
                    if (i == this.row - 1) {
                        f17 = -f4 / 2.0f;
                        f16 = f4;
                    }
                    if (this.row == 1) {
                        f16 = f4 + f;
                        f17 = -f4 / 2.0f;
                    }
                } else {
                    f17 = 0.0f;
                    f16 = f4 / 2.0f + f;
                }
                if (f6 <= f11) {
                    for (n6 = 0; n6 < this.getCategoryName; ++n6) {
                        this.custommerConstant[i][n5].addVertex(f8 + f17, fArray3[n6], f9);
                        this.custommerConstant[i][n5].addVertex(f8 + f17 + f16, fArray3[n6], f9);
                        this.custommerConstant[i][n5].addVertex(f8 + f17 + f16, fArray3[n6], f9 + this.getAxisX1[2] * 2.0f);
                        this.custommerConstant[i][n5].addVertex(f8 + f17, fArray3[n6], f9 + this.getAxisX1[2] * 2.0f);
                    }
                } else {
                    for (n6 = this.getCategoryName - 1; n6 >= 0; --n6) {
                        this.custommerConstant[i][n5].addVertex(f8 + f17, fArray3[n6], f9);
                        this.custommerConstant[i][n5].addVertex(f8 + f17 + f16, fArray3[n6], f9);
                        this.custommerConstant[i][n5].addVertex(f8 + f17 + f16, fArray3[n6], f9 + this.getAxisX1[2] * 2.0f);
                        this.custommerConstant[i][n5].addVertex(f8 + f17, fArray3[n6], f9 + this.getAxisX1[2] * 2.0f);
                    }
                }
                this.custommerConstant[i][n5].setNumber((int[])object);
                this.custommerConstant[i][n5].setThresholdColor(this.getChartDataSet, this.getChartDataSetInfo);
                if (!this.paper.getAxisX1().custommerConstant()) {
                    if (((Chart1DDataSet)this.dataset).getValue(i, n5) == null) {
                        this.custommerConstant[i][n5].isNullValueBar(true);
                    }
                    f5 += this.getAxisX1[0];
                    f8 += this.getAxisX1[0];
                    continue;
                }
                if (((Chart1DDataSet)this.dataset).getValue(i, n5) != null) continue;
                this.custommerConstant[i][n5].isNullValueBar(true);
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.paper.I.getShowValueConditions() != null && this.paper.I.getShowValueConditions().getConditions() != null && this.paper.I.getShowValueConditions().getConditions().size() > 0) {
            this.getChartLink = (ChartShowValueCondition)this.paper.I.getShowValueConditions().getConditions().get(0);
        }
        double d = ChartMatrix.getAngle(this.paper.rm)[1];
        int[] nArray = new int[]{0, this.col - 1};
        if (this.paper.getFilterConstant() != null) {
            nArray = this.paper.getFilterConstant();
        }
        if (this.row == 1 && d % 180.0 <= 2.0 && d % 180.0 >= -2.0) {
            this.SEDU(graphics2D);
        } else {
            for (int i = 0; i < this.col; ++i) {
                int n = i;
                if (!this.get) {
                    n = this.col - i - 1;
                }
                if (n < nArray[0] || n > nArray[1]) continue;
                for (int j = 0; j < this.row; ++j) {
                    int n2 = j;
                    if (!this.get) {
                        n2 = this.row - j - 1;
                    }
                    this.draw2 = this.availableOriginY.shownFace(this.custommerConstant[n2][n].tVertex, 0);
                    if (this.draw1[n2][n]) {
                        this.availableLength();
                    }
                    if (this.dataset.getChartDataSetModel().isOneGroupForBar() && !this.dataset.getChartDataSetModel().isTurnedXZ()) {
                        if (this.paper.getProperties().getGraphProperties().isVaryColorbyValues()) {
                            this.custommerConstant[n2][n].setPattern(this.pattern[n]);
                        } else {
                            this.custommerConstant[n2][n].setPattern(this.pattern[0]);
                        }
                    } else {
                        this.custommerConstant[n2][n].setPattern(this.pattern[n2]);
                    }
                    if (this.status == 1 && n2 == this.selectedSeriesIndex) {
                        this.custommerConstant[n2][n].setSelectedStatus(true);
                    } else {
                        this.custommerConstant[n2][n].setSelectedStatus(false);
                    }
                    float f = 0.0f;
                    if (((Chart1DDataSet)this.dataset).getValue(n2, n) != null) {
                        f = ((Chart1DDataSet)this.dataset).getValue(n2, n).floatValue();
                    }
                    float f2 = this.paper.getMinAxisValue();
                    float f3 = this.paper.getMaxAxisValue();
                    if (f >= 0.0f) {
                        if (f2 < 0.0f) {
                            f2 = 0.0f;
                        }
                        if (f3 > f) {
                            f3 = f;
                        }
                        f = f3;
                    } else if (this.paper.getMaxAxisValue() >= 0.0f) {
                        f3 = 0.0f;
                        if (f2 < f) {
                            f2 = f;
                        } else {
                            f = f2;
                        }
                    } else {
                        f3 = this.paper.getMaxAxisValue();
                        if (f2 < f) {
                            f2 = f;
                        } else {
                            f = f2;
                        }
                    }
                    this.custommerConstant[n2][n].setValueScope(f2, f3, f, this.getCategorySize);
                    this.custommerConstant[n2][n].setConditionalFill(this.getChartLink);
                    if (this.getChartLink != null) {
                        int n3 = this.getChartLink.getConditionType();
                        switch (n3) {
                            case 1: 
                            case 5: {
                                int n4 = this.getChartLink.getExpressionIndex(n2, n);
                                ChartFillPattern chartFillPattern = n4 != -1 ? this.getChartLink.getSubCondition(n4).getFillColor() : this.getChartLink.getOtherColor();
                                this.custommerConstant[n2][n].setPattern(chartFillPattern);
                            }
                        }
                    }
                    if (this.getAbsoluteValueSumOfCategory) {
                        if (!this.draw1[n2][n]) {
                            this.custommerConstant[n2][n].draw1(graphics2D, this.draw2, this.contour, true, this.availableLength);
                            continue;
                        }
                        this.custommerConstant[n2][n].draw2(graphics2D, this.draw2, this.contour, false, this.availableLength);
                        continue;
                    }
                    if (!this.draw1[n2][n]) {
                        this.custommerConstant[n2][n].draw2(graphics2D, this.draw2, this.contour, true, this.availableLength);
                        continue;
                    }
                    this.custommerConstant[n2][n].draw1(graphics2D, this.draw2, this.contour, false, this.availableLength);
                }
            }
        }
    }

    private void SEDU(Graphics2D graphics2D) {
        int[] nArray = new int[]{0, this.col - 1};
        if (this.paper.getFilterConstant() != null) {
            nArray = this.paper.getFilterConstant();
        }
        int n = this.col / 2;
        for (int i = this.col / 2 + 1; i >= 0; --i) {
            int n2;
            int n3 = n - i >= 0 ? n - i : 0;
            int n4 = n2 = n + i < this.col ? n + i : this.col - 1;
            if (n3 >= nArray[0] && n3 <= nArray[1]) {
                this.addVertex(graphics2D, 0, n3);
            }
            if (n2 < nArray[0] || n2 > nArray[1]) continue;
            this.addVertex(graphics2D, 0, n2);
        }
    }

    private void addVertex(Graphics2D graphics2D, int n, int n2) {
        this.draw2 = this.availableOriginY.shownFace(this.custommerConstant[n][n2].tVertex, 0);
        if (this.draw1[n][n2]) {
            this.availableLength();
        }
        if (this.dataset.getChartDataSetModel().isOneGroupForBar() && !this.dataset.getChartDataSetModel().isTurnedXZ()) {
            if (this.paper.getProperties().getGraphProperties().isVaryColorbyValues()) {
                this.custommerConstant[n][n2].setPattern(this.pattern[n2]);
            } else {
                this.custommerConstant[n][n2].setPattern(this.pattern[0]);
            }
        } else {
            this.custommerConstant[n][n2].setPattern(this.pattern[n]);
        }
        if (this.status == 1 && n == this.selectedSeriesIndex) {
            this.custommerConstant[n][n2].setSelectedStatus(true);
        } else {
            this.custommerConstant[n][n2].setSelectedStatus(false);
        }
        float f = 0.0f;
        if (((Chart1DDataSet)this.dataset).getValue(n, n2) != null) {
            f = ((Chart1DDataSet)this.dataset).getValue(n, n2).floatValue();
        }
        float f2 = this.paper.getMinAxisValue();
        float f3 = this.paper.getMaxAxisValue();
        if (f >= 0.0f) {
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > f) {
                f3 = f;
            }
            f = f3;
        } else if (this.paper.getMaxAxisValue() >= 0.0f) {
            f3 = 0.0f;
            if (f2 < f) {
                f2 = f;
            } else {
                f = f2;
            }
        } else {
            f3 = this.paper.getMaxAxisValue();
            if (f2 < f) {
                f2 = f;
            } else {
                f = f2;
            }
        }
        this.custommerConstant[n][n2].setValueScope(f2, f3, f, this.getCategorySize);
        this.custommerConstant[n][n2].setConditionalFill(this.getChartLink);
        if (this.getChartLink != null) {
            int n3 = this.getChartLink.getConditionType();
            switch (n3) {
                case 1: 
                case 5: {
                    int n4 = this.getChartLink.getExpressionIndex(n, n2);
                    ChartFillPattern chartFillPattern = n4 != -1 ? this.getChartLink.getSubCondition(n4).getFillColor() : this.getChartLink.getOtherColor();
                    this.custommerConstant[n][n2].setPattern(chartFillPattern);
                }
            }
        }
        if (this.getAbsoluteValueSumOfCategory) {
            if (!this.draw1[n][n2]) {
                this.custommerConstant[n][n2].draw1(graphics2D, this.draw2, this.contour, true, this.availableLength);
            } else {
                this.custommerConstant[n][n2].draw2(graphics2D, this.draw2, this.contour, false, this.availableLength);
            }
        } else if (!this.draw1[n][n2]) {
            this.custommerConstant[n][n2].draw2(graphics2D, this.draw2, this.contour, true, this.availableLength);
        } else {
            this.custommerConstant[n][n2].draw1(graphics2D, this.draw2, this.contour, false, this.availableLength);
        }
    }

    @Override
    public void locate() {
    }

    private void availableLength() {
        int n;
        int[] nArray = new int[6];
        int n2 = 0;
        for (n = 0; n < 6; ++n) {
            nArray[n] = this.draw2 >> n & 1;
        }
        this.draw2 = 0;
        for (n = 5; n >= 0; --n) {
            n2 = n % 2 == 0 ? n + 1 : n - 1;
            this.draw2 += nArray[n2];
            if (n == 0) continue;
            this.draw2 <<= 1;
        }
    }

    @Override
    void transform(ChartMatrix chartMatrix) {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.custommerConstant[i][j].transform(chartMatrix);
                this.custommerConstant[i][j].updateXUnit();
            }
        }
        this.availableOriginY();
    }

    private void availableOriginY() {
        this.contour();
        this.col();
        this.custommerConstant();
    }

    private void col() {
        this.floatValue = (this.paper.getShownFace() >> 5 & 1) == 1;
    }

    private void contour() {
        this.get = (this.paper.getShownFace() & 1) != 1;
    }

    private void custommerConstant() {
        this.getAbsoluteValueSumOfCategory = (this.paper.getShownFace() >> 3 & 1) == 1;
    }

    public void setCompass(ChartCompass chartCompass) {
        this.availableOriginY = chartCompass;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.custommerConstant[n][n2].toHtml();
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        Shape[][] shapeArray = new Shape[this.row][this.col];
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                shapeArray[i][j] = this.getShapeByItem(i, j);
            }
        }
        return shapeArray;
    }

    @Override
    public String[] search(int n, int n2) {
        String[] stringArray = null;
        for (int i = 0; i < this.col; ++i) {
            int n3 = i;
            if (this.get) {
                n3 = this.col - i - 1;
            }
            for (int j = 0; j < this.row; ++j) {
                int n4 = j;
                if (this.get) {
                    n4 = this.row - j - 1;
                }
                this.draw2 = this.paper.getShownFace();
                if (this.draw1[n4][n3]) {
                    this.availableLength();
                }
                if (!this.custommerConstant[n4][n3].inBar(n4, n3, n, n2)) continue;
                if (this.paper.getProperties().isShowCategoryAndSeries()) {
                    stringArray = new String[3];
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(n4, n3);
                } else {
                    stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(n4, n3))};
                }
                this.selectedSeriesIndex = n4;
                this.drilldown = new int[2];
                this.drilldown[0] = n4;
                this.drilldown[1] = n3;
                return stringArray;
            }
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return -1;
    }

    public boolean isBench() {
        return this.getChartDataSetModel;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        for (int i = 0; i < this.col; ++i) {
            int n3 = i;
            if (this.get) {
                n3 = this.col - i - 1;
            }
            for (int j = 0; j < this.row; ++j) {
                int n4 = j;
                if (this.get) {
                    n4 = this.row - j - 1;
                }
                this.draw2 = this.paper.getShownFace();
                if (this.draw1[n4][n3]) {
                    this.availableLength();
                }
                if (!this.custommerConstant[n4][n3].inBar(n4, n3, n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n4, n3);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n4)).get(n3)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

