/*
 * Decompiled with CFR 0.152.
 */
package chart.data;

import chart.util.ChartMath;
import com.jinfonet.util.JRLog;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;

public class ChartDataFilter
implements Cloneable {
    public static final int SCALE = 0;
    public static final int NUMBER = 1;
    public static final int DATATIME = 2;
    public static final int TEXT = 3;
    public static final int MAPPING = 4;
    private static final String[] CEILING = new String[]{"Scale", "Number", "Date/Time", "Text", "Mapping"};
    private static final String[][] DOWN = new String[][]{{"Logarithm", "Hundreds", "Thousands", "Millions", "Billions", "Trillions"}, {"0", "#,##0", "#,##0;-#,##0", "0.00", "#,##0.00", "#,##0.00;-#,##0.00", "0.00E00", "##0.0E0", "$0", "$#,##0", "$#,##0;-$#,##0", "$0.00", "$#,##0.00", "$#,##0.00;-$#,##0.00", "$0.00E00", "$##0.0E0", "0%", "0.00%"}, {"G", "yyyy", "yy", "yyyy G", "MM", "MMM", "MMMMMMMM", "dd/MM/yy", "dd-MMM-yy", "dd-MMM", "MMM-yy", "MMM yyyy", "dd", "DDD", "ww", "W", "EEE", "EEEEEE", "HH", "kk", "KK a", "hh a", "mm", "hh:mm a", "ss", "hh:mm:ss", "hh:mm:ss a", "mm:ss", "MMMMM dd yyyy G (EEEEEE) hh:mm:ss aa z"}, {"Default Length"}, {"One-to-One Mapping", "Range Mapping", "Text Mapping", "Prefix", "Suffix"}};
    private static final String[][] FLOOR = new String[][]{{"Logarithm", "Hundreds", "Thousands", "Millions", "Billions", "Trillions"}, {"0", "#,##0", "#,##0;-#,##0", "0.00", "#,##0.00", "#,##0.00;-#,##0.00", "0.00E00", "##0.0E0", "$0", "$#,##0", "$#,##0;-$#,##0", "$0.00", "$#,##0.00", "$#,##0.00;-$#,##0.00", "$0.00E00", "$##0.0E0", "0%", "0.00%"}, {"Default Length"}, {"One-to-One Mapping", "Range Mapping", "Text Mapping", "Prefix", "Suffix"}};
    private Vector HALF_DOWN;
    private List HALF_EVEN;
    private boolean HALF_UP;
    private TimeZone SEDU;
    private Locale UP;
    private RoundingMode abs;
    private JFieldValueNLSManager add = null;
    private JFieldValueNLSManager append = null;
    private String clone;
    private Vector convertConstantToRoundingMode;
    private Vector doubleValue;
    private Vector equals;
    private Vector error;
    boolean filter = false;
    boolean format = false;
    boolean get = false;
    boolean getCatalogDataMappingM = false;

    public ChartDataFilter() {
        this.HALF_DOWN = new Vector();
    }

    public ChartDataFilter(Vector vector) {
        this.HALF_DOWN = vector;
    }

    public void setFilters(Vector vector) {
        this.HALF_DOWN = vector;
    }

    public List getFilters() {
        return this.HALF_DOWN;
    }

    public boolean isLogScale() {
        return this.HALF_UP;
    }

    public void setLogScale(boolean bl) {
        this.HALF_UP = bl;
    }

    public Number log10Scale(Number number) {
        if (this.HALF_UP) {
            number = ChartMath.log10(number);
        }
        return number;
    }

    public Number scale(Number number, List list) {
        Number number2 = number;
        int n = list.size();
        if (number2 == null || n <= 0) {
            return number2;
        }
        double d = number2.doubleValue();
        if (this.HALF_UP) {
            d = ChartMath.power10(d);
        } else {
            block7: for (int i = 0; i < n; ++i) {
                switch ((Integer)list.get(i)) {
                    case 1: {
                        d /= 100.0;
                        continue block7;
                    }
                    case 2: {
                        d /= 1000.0;
                        continue block7;
                    }
                    case 3: {
                        d /= 1000000.0;
                        continue block7;
                    }
                    case 4: {
                        d /= 1.0E9;
                        continue block7;
                    }
                    case 5: {
                        d /= 1.0E12;
                    }
                }
            }
        }
        return new Double(d);
    }

    private Object CEILING(Number number, List list) {
        if (number == null) {
            return null;
        }
        Object object = number;
        int n = list.size();
        if (n > 0) {
            DecimalFormat decimalFormat = (DecimalFormat)list.get(0);
            if (decimalFormat != null) {
                object = decimalFormat.format(number);
            }
        } else if (this.DOWN(number.doubleValue())) {
            object = new DecimalFormat("0.00").format(number);
        }
        return object;
    }

    private boolean DOWN(double d) {
        boolean bl = false;
        if (!(Math.abs(d - (double)Math.round(d)) < 1.0E-5)) {
            bl = true;
        }
        return bl;
    }

    private String FLOOR(Date date, List list) {
        SimpleDateFormat simpleDateFormat;
        if (date == null) {
            return null;
        }
        String string = date.toLocaleString();
        int n = list.size();
        if (n > 0 && (simpleDateFormat = (SimpleDateFormat)list.get(0)) != null) {
            if (this.SEDU != null) {
                simpleDateFormat.setTimeZone(this.SEDU);
            }
            string = simpleDateFormat.format(date);
        }
        return string;
    }

    private Object HALF_DOWN(Object object, int n, List list) {
        int n2 = list.size();
        Object object2 = object;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                Object[] objectArray = (Object[])list.get(i);
                if (objectArray == null) continue;
                if (objectArray.length == 3) {
                    int n3 = (Integer)objectArray[0];
                    int n4 = (Integer)objectArray[1];
                    String string = (String)objectArray[2];
                    if (n4 == -1) {
                        n4 = Integer.MAX_VALUE;
                    }
                    if (n == Integer.MIN_VALUE) continue;
                    int n5 = n3;
                    n3 = Math.min(n5, n4);
                    n4 = Math.max(n5, n4);
                    if (n < n3 || n > n4) continue;
                    object = string;
                    continue;
                }
                if (objectArray.length == 2) {
                    String string = (String)objectArray[0];
                    String string2 = (String)objectArray[1];
                    if (string.equals("Pre")) {
                        object = this.prefix(object, string2);
                        continue;
                    }
                    object = this.suffix(object, string2);
                    continue;
                }
                if (objectArray.length == 4) {
                    String string = (String)objectArray[0];
                    String string3 = (String)objectArray[1];
                    if (string == null || string3 == null || object == null || !object.toString().equals(string)) continue;
                    object = string3;
                    continue;
                }
                int n6 = (Integer)objectArray[0];
                String string = (String)objectArray[1];
                if (n != n6) continue;
                object = string;
            }
            object2 = object;
        }
        return object2;
    }

    private String prefix(Object object, String string) {
        try {
            if (object instanceof Double) {
                DecimalFormat decimalFormat = new DecimalFormat();
                String string2 = decimalFormat.format(object);
                return string + string2;
            }
            if (object instanceof Date) {
                return string + ((Date)object).toLocaleString();
            }
            return string + object.toString();
        }
        catch (JRInterruptedException jRInterruptedException) {
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private String suffix(Object object, String string) {
        try {
            if (object instanceof Double) {
                DecimalFormat decimalFormat = new DecimalFormat();
                String string2 = decimalFormat.format(object);
                return string2 + string;
            }
            if (object instanceof Date) {
                return string + ((Date)object).toLocaleString();
            }
            return object.toString() + string;
        }
        catch (JRInterruptedException jRInterruptedException) {
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private Object HALF_EVEN(Object object, List list) {
        if (object == null) {
            return null;
        }
        Object object2 = object;
        int n = list.size();
        if (n > 0) {
            int n2 = (Integer)list.get(0);
            String string = object2.toString();
            n2 = Math.min(n2, string.length());
            string = string.substring(0, n2);
            object2 = string;
        }
        return object2;
    }

    public String filter(Object object) {
        return this.filter(object, 0);
    }

    public String filter(Object object, int n) {
        return this.filter(object, n, true);
    }

    public String filter(Object object, int n, boolean bl) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (this.HALF_EVEN == null) {
            this.init();
        }
        List list = (List)this.HALF_EVEN.get(0);
        List list2 = (List)this.HALF_EVEN.get(1);
        List list3 = (List)this.HALF_EVEN.get(2);
        List list4 = (List)this.HALF_EVEN.get(3);
        List list5 = (List)this.HALF_EVEN.get(4);
        Object object3 = null;
        if (object instanceof Number) {
            object2 = this.scale((Number)object, list);
            object = this.CEILING((Number)object2, list2);
        }
        if (object instanceof Date) {
            if (object != null && this.getCatalogDataMappingM) {
                object3 = ((Date)object).clone();
            }
            object = this.FLOOR((Date)object, list3);
        }
        if (object instanceof Double) {
            object2 = new DecimalFormat();
            try {
                object = Long.valueOf(((Format)object2).format((Double)object));
            }
            catch (JRInterruptedException jRInterruptedException) {
                throw jRInterruptedException;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object = this.HALF_DOWN(object, n, list4);
        object = this.HALF_EVEN(object, list5);
        object2 = object.toString();
        String string = null;
        JFieldValueNLSManager jFieldValueNLSManager = null;
        String string2 = "";
        boolean bl2 = true;
        if (list5.size() > 0 || list4.size() > 0) {
            bl2 = false;
        }
        if (bl && this.add != null && this.clone != null && !this.clone.equals("")) {
            jFieldValueNLSManager = this.add;
            string2 = this.clone;
        } else if (bl2) {
            jFieldValueNLSManager = this.append;
            if (this.filter && this.convertConstantToRoundingMode != null) {
                if (this.convertConstantToRoundingMode.size() > 0) {
                    string2 = (String)this.convertConstantToRoundingMode.get(0);
                }
            } else if (this.format && this.doubleValue != null) {
                if (this.doubleValue.size() > 0) {
                    string2 = (String)this.doubleValue.get(0);
                }
            } else if (this.get && this.equals != null && this.equals.size() > 0) {
                string2 = (String)this.equals.get(0);
            }
        }
        if (jFieldValueNLSManager != null && string2 != null && !string2.equals("")) {
            if (object3 != null) {
                object2 = object3.toString();
            }
            if ((string = jFieldValueNLSManager.getFieldBindNLSValue(string2, (String)object2)) != null) {
                if (this.error == null) {
                    this.error = new Vector();
                }
                String[] stringArray = new String[]{"4", "Text: " + (String)object2 + "~" + string};
                boolean bl3 = false;
                for (int i = 0; i < this.error.size(); ++i) {
                    if (!((String[])this.error.get(i))[1].equals(stringArray[1])) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    this.error.add(stringArray);
                }
                object2 = string;
            }
        }
        return object2;
    }

    public void init() {
        this.HALF_EVEN = new ArrayList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<DecimalFormat> arrayList2 = new ArrayList<DecimalFormat>(1);
        ArrayList<SimpleDateFormat> arrayList3 = new ArrayList<SimpleDateFormat>(1);
        ArrayList<Object[]> arrayList4 = new ArrayList<Object[]>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>(1);
        this.HALF_EVEN.add(arrayList);
        this.HALF_EVEN.add(arrayList2);
        this.HALF_EVEN.add(arrayList3);
        this.HALF_EVEN.add(arrayList4);
        this.HALF_EVEN.add(arrayList5);
        this.convertConstantToRoundingMode();
        int n = this.HALF_DOWN.size();
        block7: for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])this.HALF_DOWN.get(i);
            int n2 = (Integer)objectArray[0];
            String string = (String)objectArray[1];
            switch (n2) {
                case 0: {
                    arrayList.add(this.HALF_UP(string));
                    continue block7;
                }
                case 1: {
                    arrayList2.add(this.UP(string));
                    continue block7;
                }
                case 2: {
                    arrayList3.add(this.add(string));
                    continue block7;
                }
                case 3: {
                    arrayList5.add(this.SEDU(string));
                    continue block7;
                }
                case 4: {
                    arrayList4.add(this.append(string));
                }
            }
        }
        this.HALF_UP = arrayList.size() > 0 && (Integer)arrayList.get(0) == 0;
    }

    private Integer HALF_UP(String string) {
        int n = DOWN[0].length;
        for (int i = 0; i < n; ++i) {
            if (!DOWN[0][i].equals(string)) continue;
            return new Integer(i);
        }
        return new Integer(-1);
    }

    private Integer SEDU(String string) {
        if (string == null || string.length() == 0) {
            return new Integer(Integer.MAX_VALUE);
        }
        return new Integer(string.length());
    }

    private DecimalFormat UP(String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string, new DecimalFormatSymbols(Locale.getDefault()));
        this.abs(decimalFormat, this.abs);
        return decimalFormat;
    }

    private void abs(NumberFormat numberFormat, RoundingMode roundingMode) {
        if (numberFormat != null && roundingMode != null) {
            numberFormat.setRoundingMode(roundingMode);
        }
    }

    private SimpleDateFormat add(String string) {
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = this.UP == null ? new SimpleDateFormat(string, Locale.getDefault()) : new SimpleDateFormat(string, this.UP);
        return simpleDateFormat;
    }

    private Object[] append(String string) {
        Object[] objectArray;
        block23: {
            try {
                int n = string.indexOf(125);
                if (n != -1 && !string.startsWith("Text")) {
                    int n2 = string.indexOf("}:{");
                    if (n2 != -1) {
                        objectArray = new Object[3];
                        String string2 = string.substring(1, n);
                        try {
                            objectArray[0] = Integer.valueOf(string2);
                        }
                        catch (JRInterruptedException jRInterruptedException) {
                            throw jRInterruptedException;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                        n = n2 + 3;
                        int n3 = string.indexOf("}->");
                        try {
                            string2 = string.substring(n, n3);
                            objectArray[1] = Integer.valueOf(string2);
                        }
                        catch (JRInterruptedException jRInterruptedException) {
                            throw jRInterruptedException;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                        n = string.indexOf("}->") + 3;
                        n3 = string.length();
                        string2 = string.substring(n, n3);
                        objectArray[2] = string2;
                        break block23;
                    }
                    objectArray = new Object[5];
                    String string3 = string.substring(1, n);
                    try {
                        objectArray[0] = Integer.valueOf(string3);
                    }
                    catch (JRInterruptedException jRInterruptedException) {
                        throw jRInterruptedException;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    n = string.indexOf("}->") + 3;
                    string3 = string.substring(n);
                    objectArray[1] = string3;
                    break block23;
                }
                if (!string.startsWith("Text")) {
                    objectArray = new Object[2];
                    if (string.substring(0, 8).equals("Prefix: ")) {
                        objectArray[0] = "Pre";
                        objectArray[1] = string.substring(8);
                    } else if (string.substring(0, 8).equals("Suffix: ")) {
                        objectArray[0] = "Suf";
                        objectArray[1] = string.substring(8);
                    } else if (string.substring(0, 7).equals("Prefix:")) {
                        objectArray[0] = "Pre";
                        objectArray[1] = string.substring(7);
                    } else if (string.substring(0, 7).equals("Suffix:")) {
                        objectArray[0] = "Suf";
                        objectArray[1] = string.substring(7);
                    }
                } else {
                    objectArray = new Object[4];
                    int n4 = string.indexOf("~");
                    String string4 = string.substring(6, n4);
                    objectArray[0] = string4;
                    String string5 = string.substring(n4 + 1);
                    objectArray[1] = string5;
                }
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(3, "Chart's format is error: " + string);
                }
                return null;
            }
        }
        return objectArray;
    }

    public Object clone() {
        ChartDataFilter chartDataFilter = new ChartDataFilter((Vector)this.HALF_DOWN.clone());
        chartDataFilter.setCategoryNlsPrefix(this.getCategoryNlsPrefix());
        chartDataFilter.setSeriesNlsPrefix(this.getSeriesNlsPrefix());
        chartDataFilter.setValuesNlsPrefix(this.getValuesNlsPrefix());
        chartDataFilter.setCatalogDataMappingM(this.getCatalogDataMappingM());
        chartDataFilter.setUsedCategory(this.filter);
        chartDataFilter.setUsedSeries(this.format);
        chartDataFilter.setUsedShowValue(this.get);
        return chartDataFilter;
    }

    public String[] getBuiltinFilters() {
        return CEILING;
    }

    public String[] getBuiltinPatterns(int n) {
        return DOWN[n];
    }

    public void setRoundMode(int n) {
        this.abs = ChartDataFilter.convertConstantToRoundingMode(n);
    }

    public static void setDefaultNumberFormat(ChartDataFilter chartDataFilter) {
        if (chartDataFilter == null) {
            return;
        }
        List list = chartDataFilter.getFilters();
        if (list != null) {
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                Integer n;
                Object e = list.get(i);
                if (e == null || !(e instanceof Object[]) || ((Object[])e).length != 2 || (n = (Integer)((Object[])e)[0]) != 1) continue;
                bl = true;
            }
            if (!bl) {
                Object[] objectArray = new Object[]{new Integer(1), "##,###.####"};
                list.add(objectArray);
            }
        }
    }

    public static RoundingMode convertConstantToRoundingMode(int n) {
        RoundingMode roundingMode;
        switch (n) {
            case 0: {
                roundingMode = RoundingMode.UP;
                break;
            }
            case 1: {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case 2: {
                roundingMode = RoundingMode.CEILING;
                break;
            }
            case 3: {
                roundingMode = RoundingMode.FLOOR;
                break;
            }
            case 4: {
                roundingMode = RoundingMode.HALF_UP;
                break;
            }
            case 5: {
                roundingMode = RoundingMode.HALF_DOWN;
                break;
            }
            case 6: {
                roundingMode = RoundingMode.HALF_EVEN;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_EVEN;
            }
        }
        return roundingMode;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.UP = (Locale)locale.clone();
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.SEDU = (TimeZone)timeZone.clone();
        }
    }

    public void setDataMappingManager(JFieldValueNLSManager jFieldValueNLSManager) {
        this.add = jFieldValueNLSManager;
    }

    public JFieldValueNLSManager getDataMappingManager() {
        return this.add;
    }

    public void setCatalogDataMappingM(JFieldValueNLSManager jFieldValueNLSManager) {
        this.append = jFieldValueNLSManager;
    }

    public JFieldValueNLSManager getCatalogDataMappingM() {
        return this.append;
    }

    public void setDataMappingFile(String string) {
        this.clone = string;
    }

    public String getDataMappingFile() {
        return this.clone;
    }

    public Vector getDataMappingFliter() {
        return this.error;
    }

    public boolean usedFormat() {
        boolean bl = false;
        if (this.HALF_DOWN != null && this.HALF_DOWN.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public void setCategoryNlsPrefix(Vector vector) {
        this.convertConstantToRoundingMode = vector;
    }

    public void setSeriesNlsPrefix(Vector vector) {
        this.doubleValue = vector;
    }

    public void setValuesNlsPrefix(Vector vector) {
        this.equals = vector;
    }

    public Vector getCategoryNlsPrefix() {
        return this.convertConstantToRoundingMode;
    }

    public Vector getSeriesNlsPrefix() {
        return this.doubleValue;
    }

    public Vector getValuesNlsPrefix() {
        return this.equals;
    }

    public void setUsedCategory(boolean bl) {
        this.filter = bl;
    }

    public void setUsedSeries(boolean bl) {
        this.format = bl;
    }

    public void setUsedShowValue(boolean bl) {
        this.get = bl;
    }

    void convertConstantToRoundingMode() {
        this.getCatalogDataMappingM = true;
        if (this.HALF_DOWN == null) {
            this.init();
        }
        if (this.HALF_DOWN != null) {
            for (int i = 0; i < this.HALF_DOWN.size(); ++i) {
                Object[] objectArray;
                if (this.HALF_DOWN.get(i) == null || !(this.HALF_DOWN.get(i) instanceof Object[]) || ((Object[])this.HALF_DOWN.get(i)).length <= 0 || ((Number)(objectArray = (Object[])this.HALF_DOWN.get(i))[0]).intValue() != 2) continue;
                this.getCatalogDataMappingM = false;
                return;
            }
        }
    }

    public boolean usedTextFormat() {
        if (this.HALF_EVEN == null) {
            this.init();
        }
        List list = (List)this.HALF_EVEN.get(0);
        List list2 = (List)this.HALF_EVEN.get(1);
        List list3 = (List)this.HALF_EVEN.get(2);
        List list4 = (List)this.HALF_EVEN.get(3);
        List list5 = (List)this.HALF_EVEN.get(4);
        return list4 != null && list4.size() > 0 || list5 != null && list5.size() > 0;
    }
}

