/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.RoundGradientPaint;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ChartGradientPattern
implements ChartFillPattern {
    private static final String[] D = new String[]{"Linear", "Cyclic Linear", "Square Radial", "Round Radial"};
    private int F;
    private boolean SEDU;
    private ChartColorPattern abs;
    private Point2D.Float brighter;
    private ChartColorPattern clip;
    private Point2D.Float clone;

    public ChartGradientPattern(int n, boolean bl, ChartColorPattern chartColorPattern, Point2D.Float float_, ChartColorPattern chartColorPattern2, Point2D.Float float_2) {
        this.F = n;
        this.SEDU = bl;
        this.abs = chartColorPattern;
        this.brighter = float_;
        this.clip = chartColorPattern2;
        this.clone = float_2;
    }

    public ChartGradientPattern(int n) {
        this.F = n;
        switch (n) {
            case 0: {
                this.abs = new ChartColorPattern("Navy");
                this.clip = new ChartColorPattern("LightCoral");
                this.brighter = new Point2D.Float(0.5f, 0.28f);
                this.clone = new Point2D.Float(0.5f, 0.93f);
                this.SEDU = false;
                break;
            }
            case 1: {
                this.abs = new ChartColorPattern("Blue");
                this.clip = new ChartColorPattern("White");
                this.brighter = new Point2D.Float(0.4f, 0.6f);
                this.clone = new Point2D.Float(0.6f, 0.4f);
                this.SEDU = true;
                break;
            }
            case 2: {
                this.abs = new ChartColorPattern("White");
                this.clip = new ChartColorPattern("Navy");
                this.brighter = new Point2D.Float(0.35f, 0.37f);
                this.clone = new Point2D.Float(0.7f, 0.84f);
                this.SEDU = false;
                break;
            }
            case 3: {
                this.abs = new ChartColorPattern("White");
                this.clip = new ChartColorPattern("Black");
                this.brighter = new Point2D.Float(0.28f, 0.19f);
                this.clone = new Point2D.Float(0.98f, 0.75f);
                this.SEDU = false;
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
    }

    public ChartGradientPattern(String string) {
        this(ChartGradientPattern.getBuiltinGradient(string));
    }

    public int getPattern() {
        return this.F;
    }

    public ChartColorPattern getStartColor() {
        return this.abs;
    }

    public ChartColorPattern getEndColor() {
        return this.clip;
    }

    public Point2D.Float getStartPoint() {
        return this.brighter;
    }

    public Point2D.Float getEndPoint() {
        return this.clone;
    }

    @Override
    public float getAlpha() {
        return this.abs.isNoColor() ? this.clip.getAlpha() : this.abs.getAlpha();
    }

    @Override
    public void setAlpha(float f) {
        this.abs.setAlpha(f);
        this.clip.setAlpha(f);
    }

    public boolean isCyclic() {
        return this.SEDU;
    }

    @Override
    public Paint getPaint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Color color = this.abs.getColor();
        Color color2 = this.clip.getColor();
        if (color == null) {
            if (color2 != null) {
                color = color2.brighter();
            } else {
                return null;
            }
        }
        if (color2 == null) {
            if (color != null) {
                color2 = color.darker();
            } else {
                return null;
            }
        }
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Point2D.Float float_ = new Point2D.Float(f + f3 * this.brighter.x, f2 + f4 * this.brighter.y);
        Point2D.Float float_2 = new Point2D.Float(f + f3 * this.clone.x, f2 + f4 * this.clone.y);
        if (this.F == 0 || this.F == 1) {
            GradientPaint gradientPaint = new GradientPaint(float_, color, float_2, color2, this.SEDU);
            return gradientPaint;
        }
        return null;
    }

    @Override
    public void fill(Graphics2D graphics2D, Shape shape) {
        Color color = this.abs.getColor();
        Color color2 = this.clip.getColor();
        if (color == null) {
            if (color2 != null) {
                color = color2.brighter();
            } else {
                return;
            }
        }
        if (color2 == null) {
            if (color != null) {
                color2 = color.darker();
            } else {
                return;
            }
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Point2D.Float float_ = new Point2D.Float(f + f3 * this.brighter.x, f2 + f4 * this.brighter.y);
        Point2D.Float float_2 = new Point2D.Float(f + f3 * this.clone.x, f2 + f4 * this.clone.y);
        graphics2D.setColor(color);
        graphics2D.fill(new Rectangle(0, 0, 0, 0));
        switch (this.F) {
            case 0: 
            case 1: {
                GradientPaint gradientPaint = new GradientPaint(float_, color, float_2, color2, this.SEDU);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(shape);
                break;
            }
            case 2: {
                float f5 = Math.abs(float_2.x - float_.x);
                float f6 = Math.abs(float_2.y - float_.y);
                float_2.x = float_.x - f5;
                float_2.y = float_.y - f6;
                GradientPaint gradientPaint = new GradientPaint(float_, color, float_2, color2, false);
                graphics2D.setPaint(gradientPaint);
                Rectangle2D.Double double_ = new Rectangle2D.Double(f, f2, float_.x - f, float_.y - f2);
                Shape shape2 = graphics2D.getClip();
                graphics2D.clip(ChartGradientPattern.D(double_, shape));
                graphics2D.fill(shape);
                graphics2D.setClip(shape2);
                float_2.x = float_.x + f5;
                gradientPaint = new GradientPaint(float_, color, float_2, color2, false);
                graphics2D.setPaint(gradientPaint);
                double_.x = float_.x;
                double_.width = (double)f3 - double_.width;
                shape2 = graphics2D.getClip();
                graphics2D.clip(ChartGradientPattern.D(double_, shape));
                graphics2D.fill(shape);
                graphics2D.setClip(shape2);
                float_2.x = float_.x - f5;
                float_2.y = float_.y + f6;
                gradientPaint = new GradientPaint(float_, color, float_2, color2, false);
                graphics2D.setPaint(gradientPaint);
                double_.x = f;
                double_.y = float_.y;
                double_.width = float_.x - f;
                double_.height = (double)f4 - double_.height;
                shape2 = graphics2D.getClip();
                graphics2D.clip(ChartGradientPattern.D(double_, shape));
                graphics2D.fill(shape);
                graphics2D.setClip(shape2);
                float_2.x = float_.x + f5;
                float_2.y = float_.y + f6;
                gradientPaint = new GradientPaint(float_, color, float_2, color2, false);
                graphics2D.setPaint(gradientPaint);
                double_.x = float_.x;
                double_.y = float_.y;
                double_.width = (double)f3 - double_.width;
                shape2 = graphics2D.getClip();
                graphics2D.clip(ChartGradientPattern.D(double_, shape));
                graphics2D.fill(shape);
                graphics2D.setClip(shape2);
                break;
            }
            case 3: {
                double d = Point2D.distance(float_.x, float_.y, float_2.x, float_2.y);
                if (d <= 0.0) {
                    d = 1.0;
                }
                Point2D.Double double_ = new Point2D.Double(0.0, d);
                RoundGradientPaint roundGradientPaint = new RoundGradientPaint((Point2D)float_, color, double_, color2);
                graphics2D.setPaint(roundGradientPaint);
                graphics2D.fill(shape);
            }
        }
    }

    private static Shape D(Shape shape, Shape shape2) {
        Area area = new Area(shape2);
        Area area2 = new Area(shape);
        Area area3 = (Area)area.clone();
        area3.subtract(area2);
        area.subtract(area3);
        return area;
    }

    public void setPattern(int n) {
        this.F = n;
    }

    public void setStartColor(ChartColorPattern chartColorPattern) {
        this.abs = chartColorPattern;
    }

    public void setEndColor(ChartColorPattern chartColorPattern) {
        this.clip = chartColorPattern;
    }

    public void setStartPoint(Point2D.Float float_) {
        this.brighter = float_;
    }

    public void setEndPoint(Point2D.Float float_) {
        this.clone = float_;
    }

    public void setCyclic(boolean bl) {
        this.SEDU = bl;
    }

    @Override
    public Object clone() {
        if (this == null) {
            return null;
        }
        return new ChartGradientPattern(this.F, this.SEDU, (ChartColorPattern)this.abs.clone(), this.brighter, (ChartColorPattern)this.clip.clone(), this.clone);
    }

    public static String[] getBuiltinGradientNames() {
        return D;
    }

    public static int getBuiltinGradient(String string) {
        for (int i = 0; i < D.length; ++i) {
            if (!string.equals(D[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void highLightFill(Graphics2D graphics2D, Shape shape, int n) {
        if (this.abs == null || this.clip == null) {
            return;
        }
        ChartColorPattern chartColorPattern = (ChartColorPattern)this.abs.clone();
        ChartColorPattern chartColorPattern2 = (ChartColorPattern)this.clip.clone();
        chartColorPattern.setColor(ChartGraphicsUtil.highlight(chartColorPattern.getColor(), n));
        chartColorPattern2.setColor(ChartGraphicsUtil.highlight(chartColorPattern2.getColor(), n));
        ChartGradientPattern chartGradientPattern = new ChartGradientPattern(this.F, this.SEDU, chartColorPattern, this.brighter, chartColorPattern2, this.clone);
        chartGradientPattern.fill(graphics2D, shape);
    }
}

