/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;

public class ChartPenStyle
implements Cloneable {
    private static final float[][] SEDU = new float[][]{null, {2.1f, 2.1f}, {6.0f, 6.0f}, {12.0f, 12.0f}, {6.0f, 2.0f}, {4.0f, 4.0f, 4.0f, 4.0f, 12.0f, 4.0f, 12.0f, 4.0f, 12.0f, 4.0f}, {3.0f, 12.0f}, {24.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f}, {2.0f, 2.0f, 2.0f, 2.0f, 12.0f, 2.0f}, null};
    private static final String[] clone = new String[]{"Solid Line", "Dotted", "Dashed", "Long Dashed", "Dash-Dotted", "2Dots,3Dashes", "Fine Dotted", "Line dots", "2Dots,2Dashes", "Invisible"};
    private static final String[] createStroke = new String[]{"BUTT", "ROUND", "SQUARE"};
    private static final String[] createStrokedShape = new String[]{"MITER", "ROUND", "BEVEL", "RoundBox"};
    private float draw;
    private int equals;
    private int getBuiltinDashPattern;
    private int getColor;
    private boolean getStroke;
    private boolean isNoColor;
    private ChartColorPattern setAlpha;
    private BasicStroke setColor;
    private int setStroke;
    private float I;
    private float Z = 0.0f;
    private boolean C;
    private boolean B;
    private String D;
    private String F;

    public ChartPenStyle(String string) {
        this(ChartPenStyle.getBuiltinDashPattern(string));
    }

    public ChartPenStyle(int n) {
        this(1.0f, 2, 0, n, false, false, null);
    }

    public ChartPenStyle() {
        this(1.0f, 2, 0, 0, false, false, null);
    }

    public ChartPenStyle(int n, ChartColorPattern chartColorPattern) {
        this(1.0f, 2, 0, n, false, false, chartColorPattern);
    }

    public ChartPenStyle(ChartColorPattern chartColorPattern) {
        this(1.0f, 2, 0, 0, false, false, chartColorPattern);
    }

    public ChartPenStyle(float f) {
        this(f, 2, 0, 0, false, false, null);
    }

    public ChartPenStyle(float f, int n, int n2, int n3, boolean bl, boolean bl2, ChartColorPattern chartColorPattern) {
        this.draw = f;
        this.equals = n;
        this.getBuiltinDashPattern = n2;
        this.getColor = n3;
        this.getStroke = bl;
        this.isNoColor = bl2;
        this.setAlpha = chartColorPattern;
        this.setColor = null;
    }

    public Shape getPathOutline(Graphics2D graphics2D, Shape shape) {
        if (this.getColor == clone.length - 1 || this.draw == 0.0f || this.setAlpha.isNoColor()) {
            return null;
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(0.0f));
        Shape shape2 = this.createStroke().createStrokedShape(shape);
        graphics2D.setStroke(stroke);
        return shape2;
    }

    public void draw(Graphics2D graphics2D, Shape shape) {
        if (this.getColor == clone.length - 1 || this.draw == 0.0f) {
            return;
        }
        if (this.setAlpha != null) {
            if (this.setAlpha.isNoColor()) {
                return;
            }
        } else {
            this.setAlpha = new ChartColorPattern();
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.setAlpha.getColor());
        if (this.getStroke) {
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.draw(this.createStroke().createStrokedShape(shape));
        } else {
            graphics2D.setStroke(this.createStroke());
            graphics2D.draw(shape);
        }
        graphics2D.setStroke(stroke);
    }

    public BasicStroke createStroke() {
        if (this.getColor == clone.length - 1) {
            return null;
        }
        if (this.draw == 0.0f) {
            return null;
        }
        if (this.setColor == null) {
            float[] fArray2;
            float[] fArray3 = SEDU[this.getColor];
            if (this.isNoColor) {
                if (fArray3 == null) {
                    fArray2 = null;
                } else {
                    fArray2 = new float[fArray3.length];
                    for (int i = 0; i < fArray2.length; ++i) {
                        fArray2[i] = this.draw * fArray3[i];
                    }
                }
            } else {
                fArray2 = fArray3;
            }
            this.setColor = new BasicStroke(this.draw, this.equals, this.getBuiltinDashPattern < 3 ? this.getBuiltinDashPattern : 0, 100.0f, fArray2, 0.0f);
        }
        return this.setColor;
    }

    public ChartColorPattern getPenColor() {
        if (this.setAlpha == null) {
            this.setAlpha = new ChartColorPattern();
        }
        return this.setAlpha;
    }

    public boolean isOutlined() {
        return this.getStroke;
    }

    public boolean isVariabledDash() {
        return this.isNoColor;
    }

    public float getPenWidth() {
        return this.draw;
    }

    public int getEndCaps() {
        return this.equals;
    }

    public int getLineJoints() {
        return this.getBuiltinDashPattern;
    }

    public int getDashPattern() {
        return this.getColor;
    }

    public void setPenColor(ChartColorPattern chartColorPattern) {
        this.setAlpha = chartColorPattern;
        this.setColor = null;
    }

    public void setOutlined(boolean bl) {
        this.getStroke = bl;
        this.setColor = null;
    }

    public void setVariabledDash(boolean bl) {
        this.isNoColor = bl;
        this.setColor = null;
    }

    public void setPenWidth(float f) {
        this.draw = f < 0.0f ? 0.0f : f;
        this.setColor = null;
    }

    public void setEndCaps(int n) {
        this.equals = n;
        this.setColor = null;
    }

    public void setLineJoints(int n) {
        this.getBuiltinDashPattern = n;
        this.setColor = null;
    }

    public void setDashPattern(int n) {
        this.getColor = n;
        this.setColor = null;
    }

    public Object clone() {
        if (this.setAlpha != null) {
            return new ChartPenStyle(this.draw, this.equals, this.getBuiltinDashPattern, this.getColor, this.getStroke, this.isNoColor, (ChartColorPattern)this.setAlpha.clone());
        }
        return new ChartPenStyle(this.draw, this.equals, this.getBuiltinDashPattern, this.getColor, this.getStroke, this.isNoColor, null);
    }

    public static String[] getBuiltinDashNames() {
        return clone;
    }

    public static int getBuiltinDashPattern(String string) {
        for (int i = 0; i < clone.length; ++i) {
            if (!string.equals(clone[i])) continue;
            return i;
        }
        return -1;
    }

    public static String[] getBuiltinPenCapNames() {
        return createStroke;
    }

    public static int getBuiltinPenCap(String string) {
        for (int i = 0; i < createStroke.length; ++i) {
            if (!string.equals(createStroke[i])) continue;
            return i;
        }
        return -1;
    }

    public static String[] getBuiltinPenJointNames() {
        return createStrokedShape;
    }

    public static int getBuiltinPenJoint(String string) {
        for (int i = 0; i < createStrokedShape.length; ++i) {
            if (!string.equals(createStrokedShape[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean getOutlined() {
        return this.getStroke;
    }

    public void setJointRadiusUnit(int n) {
        this.setStroke = n;
    }

    public int getJointRadiusUnit() {
        return this.setStroke;
    }

    public float getJointRadiusPixel() {
        return this.I;
    }

    public void setJointRadiusPixel(float f) {
        this.I = f;
    }

    public void setTransparency(float f) {
        float f2 = f < 0.0f ? 0.0f : (this.Z = f > 1.0f ? 1.0f : f);
        if (this.setAlpha.getColor() != null) {
            this.setAlpha.setAlpha(this.Z);
        }
    }

    public float getTransparency() {
        return this.Z;
    }

    public boolean getIsChangedTransparencyByFml() {
        return this.C;
    }

    public void setIsChangedTransparencyByFml(boolean bl) {
        this.C = bl;
    }

    public boolean getIsChangedPenColorByFml() {
        return this.B;
    }

    public void setIsChangedPenColorByFml(boolean bl) {
        this.B = bl;
    }

    public String getPenColorFml() {
        return this.D;
    }

    public void setPenColorFml(String string) {
        this.D = string;
    }

    public String getTransparencyFml() {
        return this.F;
    }

    public void setTransparencyFml(String string) {
        this.F = string;
    }
}

