/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import chart.properties.ChartAxisProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ChartMath {
    public static double log10 = Math.log(10.0);
    public static final String JR_FILE_SEPARATOR = "/";
    public static final String JR_FILE_PARENT = "../";
    public static final String JR_FILE_ROOT = "/";
    public static final String FILE_PARENT = ".." + File.separator;
    public static final String FILE_ROOT = File.separator;

    public static Number log10(Number number) {
        Double d = null;
        if (number != null && number.doubleValue() > 0.0) {
            d = new Double(ChartMath.log10(number.doubleValue()));
        }
        return d;
    }

    public static double log10(double d) {
        return Math.log(d) / log10;
    }

    public static double power10(double d) {
        return Math.pow(10.0, d);
    }

    public static float[] getScrollInfo(ChartAxisProperties chartAxisProperties, List list) {
        int n;
        Object object;
        float[] fArray2 = new float[]{0.0f, 1.0f};
        List list2 = list;
        int n2 = chartAxisProperties.getScrollableVisibleValue();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list2.size(); ++i) {
            object = list2.get(i);
            if (object == null || !(object instanceof Number) && !(object instanceof Date)) continue;
            arrayList.add(list2.get(i));
        }
        if (arrayList.size() <= 0) {
            return fArray2;
        }
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray);
        object = new Object[2];
        for (n = 0; n < objectArray.length; ++n) {
            if (object[0] != null || objectArray[n] == null) continue;
            object[0] = objectArray[n];
            break;
        }
        if (objectArray.length == 1 && objectArray[0] != null && objectArray[0] instanceof Date) {
            object[1] = new Date(((Date)objectArray[0]).getTime() + 1000L);
        } else {
            for (n = objectArray.length - 1; n >= 0; --n) {
                if (object[1] != null || objectArray[n] == null) continue;
                object[1] = objectArray[n];
                break;
            }
        }
        if (object[0] instanceof Date) {
            n = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl = chartAxisProperties.getUnitProperties().getAutoStart();
            boolean bl2 = chartAxisProperties.getUnitProperties().getAutoEnd();
            boolean bl3 = chartAxisProperties.getUnitProperties().getAutoMajorUnit();
            boolean bl4 = chartAxisProperties.getUnitProperties().getAutoMinorUnit();
            long l = 0L;
            long l2 = 0L;
            int[] nArray = null;
            l = ((Date)object[0]).getTime();
            l2 = ((Date)object[1]).getTime();
            if (bl3 || l2 <= l) {
                nArray = ChartMath.getTimeUnit(((Date)object[1]).getTime() - ((Date)object[0]).getTime());
                n4 = nArray[0];
                n = nArray[1];
            } else {
                n = chartAxisProperties.getUnitProperties().getMajorUnitInt();
                n4 = chartAxisProperties.getUnitProperties().getMajorUnitDateType();
            }
            int n5 = n = n < 1 ? 1 : n;
            if (bl4 || chartAxisProperties.getUnitProperties().getMinorUnitInt() <= 0) {
                nArray = ChartMath.getMinorTimeUnit(n4, n);
                n3 = nArray[1];
            } else {
                n3 = chartAxisProperties.getUnitProperties().getMinorUnitInt();
            }
            n3 = n3 < 1 ? 1 : n3;
            l = chartAxisProperties.getUnitProperties().getStartTime();
            l2 = chartAxisProperties.getUnitProperties().getEndTime();
            if (l == l2 && l == -1L && l2 == -1L) {
                bl = true;
                bl2 = true;
            }
            if (bl) {
                l = ((Date)object[0]).getTime();
            }
            if (bl2) {
                l2 = ((Date)object[1]).getTime();
            }
            l2 = l > l2 ? l : l2;
            double d = 0.0;
            if (bl2 && (l2 - l) % ChartMath.getTime(n4, n) > 0L) {
                l2 += ChartMath.getTime(n4, n) - (l2 - l) % ChartMath.getTime(n4, n);
            }
            int n6 = arrayList.size() > n2 ? n2 : arrayList.size() - 1;
            n6 = --n6 < 0 ? 0 : n6;
            Date date = (Date)arrayList.get(n6);
            fArray2[0] = 0.0f;
            d = date.getTime();
            d -= (double)l;
            fArray2[1] = (float)(d /= (double)(l2 - l));
        }
        return fArray2;
    }

    protected static int[] getTimeUnit(long l) {
        int n = 0;
        int n2 = 1;
        long l2 = 1L;
        long[] lArray = new long[]{31536000000L, 7776000000L, 2592000000L, 86400000L, 3600000L, 60000L, 1000L};
        if (l > lArray[0] * 3L) {
            n = 0;
            n2 = (int)(l / lArray[0]);
            n2 = (n2 = ChartMath.getNumberUnit(n2)) < 1 ? 1 : n2;
        } else if (l > lArray[1] * 4L) {
            n = 1;
            n2 = 1;
        } else if (l > lArray[2] * 2L) {
            n = 2;
            n2 = 1;
        } else if (l > lArray[3]) {
            n = 4;
            n2 = 1;
        } else if (l > lArray[4]) {
            n = 5;
            n2 = (int)(l / lArray[4]);
            n2 = (n2 /= 10) < 1 ? 1 : n2;
        } else if (l > lArray[5]) {
            n = 6;
            n2 = (int)(l / lArray[5]);
            n2 = (n2 /= 10) < 1 ? 1 : n2;
        } else {
            n = 7;
            n2 = (int)(l / lArray[6]);
            n2 = (n2 /= 10) <= 1 ? 1 : 5;
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    protected static int getNumberUnit(int n) {
        int n2 = 1;
        if (n > 0) {
            int n3 = n;
            int n4 = 1;
            while (n3 > 50) {
                n4 = (int)((float)n4 * 10.0f);
                n3 = (int)((float)n3 / 10.0f);
            }
            if (n3 > 20) {
                n4 *= 5;
            } else if (n3 > 10) {
                n4 *= 2;
            }
            n2 *= n4;
        }
        return n2;
    }

    protected static int[] getMinorTimeUnit(int n, int n2) {
        int n3 = -1;
        int n4 = 1;
        switch (n) {
            case 0: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = ChartMath.getNumberUnit(n2);
                    break;
                }
                n3 = 2;
                n4 = 2;
                break;
            }
            case 1: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = ChartMath.getNumberUnit(n2);
                    break;
                }
                n3 = 2;
                n4 = 1;
                break;
            }
            case 2: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = ChartMath.getNumberUnit(n2);
                    break;
                }
                n3 = 2;
                n4 = 1;
                break;
            }
            case 3: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = ChartMath.getNumberUnit(n2);
                    break;
                }
                n3 = 4;
                n4 = 1;
                break;
            }
            case 4: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = ChartMath.getNumberUnit(n2);
                    break;
                }
                n3 = 4;
                n4 = 1;
                break;
            }
            case 5: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = ChartMath.getNumberUnit(n2);
                    break;
                }
                n3 = 6;
                n4 = 30;
                break;
            }
            case 6: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = ChartMath.getNumberUnit(n2);
                    break;
                }
                n3 = 7;
                n4 = 30;
                break;
            }
            case 7: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = ChartMath.getNumberUnit(n2);
                    break;
                }
                n3 = 7;
                n4 = 1;
                break;
            }
        }
        n3 = n3 == -1 ? 0 : n3;
        int[] nArray = new int[]{n3, n4};
        return nArray;
    }

    protected static long getTime(int n, int n2) {
        long[] lArray = new long[]{31536000000L, 7776000000L, 2592000000L, 86400000L, 3600000L, 60000L, 1000L};
        switch (n) {
            case 0: {
                return (long)n2 * lArray[0];
            }
            case 1: {
                return (long)n2 * lArray[1];
            }
            case 2: {
                return (long)n2 * lArray[2];
            }
            case 3: {
                return (long)n2 * lArray[3] * 7L;
            }
            case 4: {
                return (long)n2 * lArray[3];
            }
            case 5: {
                return (long)n2 * lArray[4];
            }
            case 6: {
                return (long)n2 * lArray[5];
            }
            case 7: {
                return (long)n2 * lArray[6];
            }
        }
        return 1L;
    }

    public static float getYforUsedStartAndEndPoint(float[] fArray2, float[] fArray3, float f) {
        float f2 = 0.0f;
        f2 = (f - fArray2[0]) * (fArray3[1] - fArray2[1]) / (fArray3[0] - fArray2[0]) + fArray2[1];
        return f2;
    }

    public static boolean isEquals(float f, float f2) {
        return (double)Math.abs(f - f2) < 1.0E-7;
    }

    public static boolean isEquals(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-7;
    }
}

