/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.reg;

import com.jinfonet.reg.RegisterException;
import com.jinfonet.reg.util.QueryString;
import com.jinfonet.reg.util.RegAlgorithm;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jet.ReportEnv;
import jet.util.KeyChecker;
import jet.util.rpRW;

public final class RegisterAPI {
    private static final String[] BuildNumber = new String[]{"JReport Designer", "JReport Enterprise Server", "JReport Designer Bean", "JReport Designer Bean for Novell", "JReport Runtime", "JReport Server Engine", "JReport Designer API", "JReport Server Designer API", "JReport Team Designer"};
    private static final int[] FILE_PATH = new int[]{16, 96, 80, 0, 64, 97, 17, 98, 101};
    private static int SEDU = 60;
    private static String addQuery;
    private static String append;
    private static String buildLicense;
    private String check;
    private String checkISV;
    private String close;
    private String currentTimeMillis;
    private String delete;
    private String dot3;
    private String endsWith;
    private String equalsIgnoreCase;
    private int exists = -1;
    private int get = -1;
    private String getAllByName = null;
    private long getExtNum = -1L;
    private long getHostName = -1L;
    private static PrintStream getISV;

    public RegisterAPI() {
        this.BuildNumber();
    }

    public void setCompany(String string) {
        this.check = string;
    }

    public String getCompany() {
        return this.check;
    }

    public void setFirstName(String string) {
        this.checkISV = string;
    }

    public String getFirstName() {
        return this.checkISV;
    }

    public void setLastName(String string) {
        this.close = string;
    }

    public String getLastName() {
        return this.close;
    }

    public void setEmail(String string) {
        this.currentTimeMillis = string;
    }

    public String getEmail() {
        return this.currentTimeMillis;
    }

    public void setPhone(String string) {
        this.delete = string;
    }

    public String getPhone() {
        return this.delete;
    }

    public void setISV(String string) {
        this.dot3 = string;
    }

    public String getISV() {
        return this.dot3;
    }

    public void setExtNum(int n) {
        this.get = n;
    }

    public int getExtNum() {
        return this.get;
    }

    public void setUserID(String string) {
        append = string;
    }

    public String getUserID() {
        return append;
    }

    public void setMacNum(int n) {
        this.exists = n;
    }

    public int getMacNum() throws FileNotFoundException, IOException {
        if (this.exists == -1) {
            this.SEDU();
        }
        return this.exists;
    }

    public boolean setPrdName(String string) {
        if (RegisterAPI.getPrdID(string) != -1) {
            this.equalsIgnoreCase = string;
            return true;
        }
        return false;
    }

    public String getPrdName() {
        return this.equalsIgnoreCase;
    }

    public void setInstallRoot(String string) {
        addQuery = string;
        RegisterAPI.currentTimeMillis();
    }

    public String getInstallRoot() {
        return addQuery;
    }

    public boolean setGracePeriod(int n) {
        if (n <= 0 || n > 60) {
            return false;
        }
        SEDU = n;
        return true;
    }

    public int getGracePeriod() {
        return SEDU;
    }

    public String doRegister() {
        String string = null;
        String string2 = "http://www.jinfonet.com:8080/servlets/jregister/config";
        try {
            string = this.equalsIgnoreCase(string2);
            RegisterAPI.log("Try to register, 1st: " + string);
            if (this.getRegCode(string) == null) {
                throw new RegisterException(1013);
            }
        }
        catch (RegisterException registerException) {
            RegisterAPI.log(registerException);
            try {
                String[] stringArray = this.exists();
                string2 = "http://" + stringArray[0] + ":" + stringArray[1] + "/" + "servlets/jregister" + "/" + "config";
                string = this.equalsIgnoreCase(string2);
                RegisterAPI.log("Try to register, 2nd: " + string);
                if (string == null) {
                    string = "No response! Please contact support@jinfonet.com for assistance!";
                }
            }
            catch (RegisterException registerException2) {
                RegisterAPI.log(registerException2);
            }
        }
        return string;
    }

    public String getRegCode(String string) {
        String string2;
        int n;
        String string3 = null;
        if (string != null && string.startsWith("REGISTERCODE:") && (n = (string2 = string.substring("REGISTERCODE:".length()).trim()).indexOf("ER56T78")) != -1) {
            string3 = string2.substring(0, n);
        }
        return string3;
    }

    public void writeRegCode(String string) throws IOException {
        RegisterAPI.delete(RegisterAPI.endsWith(addQuery), "regCode", string);
    }

    public static void writePrdKey(String string, String string2, String string3) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("uid", string2);
        hashtable.put(rpRW.getPaJrKey(), string3);
        rpRW.write(RegisterAPI.endsWith(string), hashtable);
        addQuery = string;
        RegisterAPI.check(string);
    }

    public boolean isValidKey() throws FileNotFoundException {
        String string = RegisterAPI.endsWith(addQuery);
        if (!new File(string).exists()) {
            throw new FileNotFoundException("Cannot find the data file '" + string + "'!");
        }
        boolean bl = KeyChecker.check(string);
        if (bl) {
            append = KeyChecker.userID;
        }
        return bl;
    }

    public boolean isMasterKey() throws FileNotFoundException {
        boolean bl = false;
        if (this.isValidKey()) {
            bl = KeyChecker.isRegisterRequired();
        }
        return bl;
    }

    public boolean isFirstTry() throws FileNotFoundException, IOException {
        if (this.getHostName == -1L) {
            this.SEDU();
        }
        return System.currentTimeMillis() - this.getHostName < 60000L;
    }

    public int getLeftDays() throws FileNotFoundException, IOException {
        if (this.getExtNum == -1L) {
            this.SEDU();
        }
        String string = this.FILE_PATH();
        int n = -1;
        if (string == null || string.length() == 0) {
            n = SEDU - (int)((System.currentTimeMillis() - this.getExtNum) / 86400000L);
            if (n <= 0) {
                n = -1;
            }
        } else {
            int n2 = RegAlgorithm.getExtNum(string);
            if (n2 == 0) {
                n = 0;
            } else {
                n = SEDU * (n2 + 1) - (int)((System.currentTimeMillis() - this.getExtNum) / 86400000L);
                if (n <= 0) {
                    n = -1;
                }
            }
        }
        return n;
    }

    public boolean isRegistrationValid() throws FileNotFoundException, IOException {
        String string = this.FILE_PATH();
        return this.isRegCodeValid(string);
    }

    public boolean isRegCodeValid(String string) throws FileNotFoundException, IOException {
        if (RegAlgorithm.getMacNum(string) != this.getMacNum()) {
            return false;
        }
        return RegAlgorithm.checkISV(string, this.getISV());
    }

    public static final String[] getPrdList() {
        return BuildNumber;
    }

    public static final String getPrdName(int n) {
        if (n >= 0 && n < 8) {
            return BuildNumber[n];
        }
        return null;
    }

    public static final int getPrdID(String string) {
        for (int i = 0; i < BuildNumber.length; ++i) {
            if (!string.trim().equalsIgnoreCase(BuildNumber[i])) continue;
            return i;
        }
        return -1;
    }

    public static void setLogFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        getISV = new PrintStream(new FileOutputStream(file));
    }

    public static void log(String string) {
        if (getISV != null) {
            getISV.println(string);
        }
    }

    public static void log(Throwable throwable) {
        if (getISV != null) {
            throwable.printStackTrace(getISV);
        }
    }

    private final void BuildNumber() {
        String string = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (int i = 0; i < inetAddressArray.length; ++i) {
                string = string + inetAddressArray[i].toString() + ";";
            }
        }
        catch (UnknownHostException unknownHostException) {
            RegisterAPI.log(new UnknownHostException(""));
        }
        this.endsWith = string;
    }

    private String FILE_PATH() throws FileNotFoundException, IOException {
        if (this.getAllByName == null) {
            this.SEDU();
        }
        return this.getAllByName;
    }

    private final void SEDU() throws FileNotFoundException, IOException {
        Hashtable hashtable = null;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(RegisterAPI.endsWith(addQuery)));
        hashtable = rpRW.read(dataInputStream);
        String string = (String)hashtable.get("regVer");
        int n = 0;
        n = string == null || string.trim().length() == 0 ? 0 : Integer.parseInt(string);
        this.getAllByName = (String)hashtable.get("regCode");
        string = (String)hashtable.get("firstTry");
        this.getHostName = string == null || string.trim().length() == 0 ? -1L : Long.parseLong(string);
        this.addQuery();
        if (this.getHostName == -1L) {
            this.buildLicense();
        }
    }

    private final void addQuery() {
        Hashtable hashtable = RegisterAPI.append(RegisterAPI.dot3());
        String string = (String)hashtable.get("macNum");
        this.exists = string == null || string.trim().length() == 0 ? -1 : (int)((Long.parseLong(string) & 0xFFFFL) * 10000L / 65535L);
        String string2 = RegisterAPI.close();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            long l;
            String string3 = (String)enumeration.nextElement();
            if (string3.indexOf(string2) != 0 || (l = (string = (String)hashtable.get(RegisterAPI.checkISV())) == null || string.trim().length() == 0 ? -1L : Long.parseLong(string)) <= this.getExtNum) continue;
            this.getExtNum = l;
        }
    }

    private static final Hashtable append(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = rpRW.read(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(new RegisterException(1005));
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1006));
        }
        return hashtable;
    }

    private final void buildLicense() throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("regVer", "1");
        hashtable.put("regCode", this.getAllByName == null ? "" : this.getAllByName);
        this.getHostName = System.currentTimeMillis();
        hashtable.put("firstTry", "" + this.getHostName);
        rpRW.write(RegisterAPI.endsWith(addQuery), hashtable);
    }

    private static final void check(String string) {
        if (!new File(RegisterAPI.dot3()).exists()) {
            long l = System.currentTimeMillis();
            long l2 = (int)l;
            long l3 = (int)l >> 32;
            try {
                RegisterAPI.delete(RegisterAPI.dot3(), "macNum", "" + l3 * l2);
            }
            catch (IOException iOException) {
                RegisterAPI.log(new RegisterException(1007));
            }
        }
        try {
            String string2 = RegisterAPI.checkISV();
            Hashtable hashtable = RegisterAPI.append(RegisterAPI.dot3());
            String string3 = (String)hashtable.get(string2);
            if (string3 == null) {
                long l = System.currentTimeMillis();
                RegisterAPI.delete(RegisterAPI.dot3(), string2, "" + l);
            }
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1008));
        }
    }

    private static final String checkISV() {
        return RegisterAPI.close() + "_" + ReportEnv.major + "." + ReportEnv.minor + "." + ReportEnv.dot3 + "_Build" + ReportEnv.BuildNumber + "_Help" + 800 + "_Release(" + ReportEnv.releaseDate + ")";
    }

    private static final String close() {
        RegisterAPI.currentTimeMillis();
        long l = ReportEnv.buildLicense(append, buildLicense);
        int n = (int)(l >> 52) & 0xFF;
        return "JRProd#" + RegisterAPI.get(n);
    }

    private static final void currentTimeMillis() {
        if (append == null || append.length() == 0 || buildLicense == null || buildLicense.length() == 0) {
            try {
                Hashtable hashtable = rpRW.read(new FileInputStream(RegisterAPI.endsWith(addQuery)));
                append = (String)hashtable.get("uid");
                buildLicense = (String)hashtable.get(rpRW.getPaJrKey());
            }
            catch (Exception exception) {
                RegisterAPI.log(exception);
            }
        }
    }

    private static final void delete(String string, String string2, String string3) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(string2, string3);
        rpRW.write(string, hashtable);
    }

    private static final String dot3() {
        String string = null;
        Properties properties = System.getProperties();
        boolean bl = properties.getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1;
        String string2 = properties.getProperty("java.library.path");
        String string3 = properties.getProperty("path.separator");
        if (bl) {
            string2 = string2.toUpperCase();
            int n = -1;
            n = string2.indexOf("WINNT\\SYSTEM32") != -1 ? string2.indexOf("WINNT\\SYSTEM32") : (string2.indexOf("WINDOWS\\SYSTEM32") != -1 ? string2.indexOf("WINDOWS\\SYSTEM32") : (string2.indexOf("WINNT") != -1 ? string2.indexOf("WINNT") : (string2.indexOf("WINDOWS") != -1 ? string2.indexOf("WINDOWS") : 0)));
            int n2 = string2.lastIndexOf(string3, n) + 1;
            int n3 = string2.indexOf(string3, n);
            if (n3 == -1) {
                n3 = string2.length();
            }
            string = string2.substring(n2, n3) + File.separator + "mscpxw32dr.dll";
        } else if (new File("/usr/lib").exists()) {
            string = "/usr/lib" + File.separator + "liblnm1.0.1.dev1.4.2.os";
        } else {
            int n = string2.indexOf(string3);
            string = string2.substring(0, n) + File.separator + "liblnm1.0.1.dev1.4.2.os";
        }
        return string;
    }

    private static String endsWith(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string + rpRW.FILE_PATH;
    }

    private String equalsIgnoreCase(String string) throws RegisterException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            QueryString queryString = new QueryString();
            queryString.addQuery("COMPANY", this.check);
            queryString.addQuery("FIRSTNAME", this.checkISV);
            queryString.addQuery("LASTNAME", this.close);
            queryString.addQuery("EMAIL", this.currentTimeMillis);
            queryString.addQuery("PHONE", this.delete);
            if (this.dot3 == null) {
                this.dot3 = "";
            }
            queryString.addQuery("ISVNAME", this.dot3);
            if (append == null) {
                append = "";
            }
            queryString.addQuery("USERID", append);
            queryString.addQuery("IPS", this.endsWith);
            queryString.addQuery("EXTTIMES", this.get + "");
            queryString.addQuery("MACHINECODE", this.exists + "");
            if (this.equalsIgnoreCase == null) {
                this.equalsIgnoreCase = BuildNumber[0];
            }
            queryString.addQuery("PRODUCTID", RegisterAPI.getPrdID(this.equalsIgnoreCase) + 1 + "");
            queryString.addQuery("GRACEPERIOD", SEDU + "");
            queryString.addQuery("ADDINFOS", RegisterAPI.getAllByName(addQuery));
            String string3 = queryString.toString();
            if (string3.length() != 0) {
                string = string + "?" + string3;
            }
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            string2 = bufferedReader.readLine();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RegisterException(1001);
        }
        catch (IOException iOException) {
            throw new RegisterException(1002);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new RegisterException(1003);
                }
            }
        }
        return string2;
    }

    private String[] exists() throws RegisterException {
        String[] stringArray = new String[2];
        String string = "http://www.jinfonet.com/reg/reghost.ini";
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(false);
            uRLConnection.setDoInput(true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("host")) {
                    stringArray[0] = string2.substring(string2.indexOf("=") + 1).trim();
                    continue;
                }
                if (!string2.startsWith("port")) continue;
                stringArray[1] = string2.substring(string2.indexOf("=") + 1).trim();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RegisterException(1009);
        }
        catch (IOException iOException) {
            throw new RegisterException(1010);
        }
        return stringArray;
    }

    private static final int get(int n) {
        for (int i = 0; i < FILE_PATH.length; ++i) {
            if (n != FILE_PATH[i]) continue;
            return i;
        }
        return -1;
    }

    private static final String getAllByName(String string) {
        String string2;
        Enumeration enumeration;
        Serializable serializable;
        if (string == null) {
            return "";
        }
        Hashtable hashtable = null;
        try {
            hashtable = rpRW.read(new FileInputStream(RegisterAPI.dot3()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(new RegisterException(1011));
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1012));
        }
        try {
            serializable = rpRW.read(new FileInputStream(RegisterAPI.endsWith(string)));
            enumeration = ((Hashtable)serializable).keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                hashtable.put(string2, ((Hashtable)serializable).get(string2));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(fileNotFoundException);
        }
        catch (IOException iOException) {
            RegisterAPI.log(iOException);
        }
        serializable = new StringBuffer();
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            ((StringBuffer)serializable).append(string2.toString() + "=" + hashtable.get(string2).toString() + "\r\n");
        }
        return ((StringBuffer)serializable).toString();
    }

    static {
        getISV = null;
    }
}

