/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util;

import com.jinfonet.web.util.StringUtil;

public class CharArray {
    protected char[] cbuf;
    protected int size;
    protected int wp;
    protected int rp;
    private static final ThreadLocal SEDU = new ThreadLocal();

    public CharArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.cbuf = new char[n];
    }

    public CharArray() {
        this.cbuf = (char[])SEDU.get();
        if (this.cbuf == null) {
            this.cbuf = new char[16];
        } else {
            SEDU.set(null);
        }
    }

    public CharArray(char[] cArray, int n) {
        this.cbuf = cArray;
        this.wp = this.size = n;
    }

    public CharArray(String string) {
        this(string.toCharArray(), string.length());
    }

    public final char[] getChars() {
        return this.cbuf;
    }

    public final char[] expandCapacity(int n) {
        if (n > this.cbuf.length) {
            char[] cArray = new char[Math.max(this.cbuf.length << 1, n)];
            System.arraycopy(this.cbuf, 0, cArray, 0, this.wp);
            this.cbuf = cArray;
        }
        return this.cbuf;
    }

    public final int size() {
        this.size = this.size < this.wp ? this.wp : this.size;
        return this.size;
    }

    public final void setSize(int n) {
        int n2 = n = n < 0 ? 0 : n;
        if (n < this.wp) {
            this.wp = n;
        } else if (n > this.cbuf.length) {
            this.expandCapacity(n);
        }
        this.size = n;
    }

    public final int tellp() {
        return this.wp;
    }

    public final void seekp(int n) {
        int n2 = n = n < 0 ? 0 : n;
        if (this.size < n) {
            this.size = n;
        }
        this.wp = n;
    }

    public final CharArray backp() {
        --this.wp;
        return this;
    }

    public final CharArray put(char c) {
        if (this.wp + 1 > this.cbuf.length) {
            this.expandCapacity(this.wp + 1);
        }
        this.cbuf[this.wp++] = c;
        return this;
    }

    public final CharArray put(char[] cArray, int n, int n2) {
        int n3 = this.wp + n2;
        if (n3 > this.cbuf.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.cbuf, this.wp, n2);
        this.seekp(n3);
        return this;
    }

    public final int tellg() {
        return this.rp;
    }

    public final void seekg(int n) {
        int n2 = n = n < 0 ? 0 : n;
        if (n > this.size()) {
            n = this.size > 0 ? this.size - 1 : 0;
        }
        this.rp = n;
    }

    public final CharArray backg() {
        --this.rp;
        return this;
    }

    public final int get() {
        return this.rp < this.size() ? this.cbuf[this.rp++] : -1;
    }

    public final int peek(int n) {
        return n < 0 || n >= this.size ? -1 : this.cbuf[n];
    }

    public final int peek() {
        return this.peek(this.rp);
    }

    public final void skip() {
        if (this.rp >= this.size) {
            return;
        }
        int[] nArray = StringUtil.masks;
        char c = this.cbuf[this.rp];
        while (c < '\u0080' && nArray[c] == 128) {
            ++this.rp;
            if (this.rp >= this.size) {
                return;
            }
            c = this.cbuf[this.rp];
        }
        if (this.rp + 1 >= this.size) {
            return;
        }
        int n = this.rp;
        if ('/' == c && '*' == this.cbuf[this.rp + 1]) {
            if (this.rp + 3 >= this.size) {
                return;
            }
            this.rp += 2;
            char c2 = this.cbuf[this.rp++];
            c = this.cbuf[this.rp];
            while ('/' != c || '*' != c2) {
                ++this.rp;
                if (this.rp >= this.size) {
                    this.rp = n;
                    return;
                }
                c2 = c;
                c = this.cbuf[this.rp];
            }
            ++this.rp;
        }
        if (this.rp + 1 >= this.size) {
            return;
        }
        c = this.cbuf[this.rp];
        if (c < '\u0080' && nArray[c] == 128) {
            this.skip();
        }
    }

    public final String getString() {
        SEDU.set(this.cbuf);
        return new String(this.cbuf, 0, this.size());
    }

    public final String toString() {
        return "R:[" + (char)(this.rp < this.size() ? this.cbuf[this.rp] : -1) + "]@" + this.rp + " W:[" + (char)(this.wp < this.size() ? this.cbuf[this.wp - 1] : -1) + "]@" + (this.wp - 1) + " L:" + this.size();
    }
}

