/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.json;

import com.jinfonet.web.util.CharArray;
import com.jinfonet.web.util.json.JSON;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class JSONArray
implements List,
Cloneable,
RandomAccess,
Serializable {
    private List list;
    private static final long serialVersionUID = -1591081068651327774L;

    public JSONArray() {
        this(new ArrayList());
    }

    public JSONArray(String string) throws JSONException {
        this((Collection)null);
        if (string == null) {
            throw new JSONException("The JSONArray string can not be null");
        }
        try {
            this.list = (JSONArray)JSON.CollParser.parse(new CharArray(string));
        }
        catch (ParseException parseException) {
            throw new JSONException(parseException.getMessage() + " " + parseException.getErrorOffset());
        }
    }

    public JSONArray(Collection collection) {
        this.list = collection == null ? new ArrayList() : new ArrayList(collection);
    }

    public JSONArray(Object[] objectArray) {
        this((Collection)null);
        for (Object object : objectArray) {
            this.add(object);
        }
    }

    public CharArray toCharArray() {
        CharArray charArray = new CharArray();
        JSON.CollConverter.convert(this, charArray);
        return charArray;
    }

    public String toString() {
        return this.toCharArray().getString();
    }

    public boolean getBoolean(int n) throws JSONException {
        try {
            return JSON.castBoolean(this.get(n));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + n + "\"] not found or is not a Boolean.", jSONException);
        }
    }

    public int getInt(int n) throws JSONException {
        try {
            return JSON.castInteger(this.get(n));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + n + "\"] not found or is not a Number.", jSONException);
        }
    }

    public long getLong(int n) throws JSONException {
        try {
            return JSON.castLong(this.get(n));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + n + "\"] not found or is not a Number.", jSONException);
        }
    }

    public float getFloat(int n) throws JSONException {
        try {
            return JSON.castFloat(this.get(n));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + n + "\"] not found or is not a Number.", jSONException);
        }
    }

    public double getDouble(int n) throws JSONException {
        try {
            return JSON.castDouble(this.get(n));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + n + "\"] not found or is not a Number.", jSONException);
        }
    }

    public String getString(int n) throws JSONException {
        try {
            return JSON.castString(this.get(n));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + n + "\"] not found or is not a String.", jSONException);
        }
    }

    public JSONObject getJSONObject(int n) throws JSONException {
        try {
            return JSON.castJSONObject(this.get(n));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + n + "\"] not found or is not a JSONObject.", jSONException);
        }
    }

    public JSONArray getJSONArray(int n) throws JSONException {
        try {
            return JSON.castJSONArray(this.get(n));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + n + "\"] not found or is not a JSONArray.", jSONException);
        }
    }

    public Object opt(int n) {
        Object object = this.get(n);
        return object instanceof JSONObject.Null ? null : object;
    }

    public boolean optBoolean(int n) {
        return this.optBoolean(n, false);
    }

    public boolean optBoolean(int n, boolean bl) {
        try {
            return this.getBoolean(n);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public int optInt(int n) {
        return this.optInt(n, 0);
    }

    public int optInt(int n, int n2) {
        try {
            return this.getInt(n);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public long optLong(int n) {
        return this.optLong(n, 0L);
    }

    public long optLong(int n, long l) {
        try {
            return this.getLong(n);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public float optFloat(int n) {
        return this.optFloat(n, 0.0f);
    }

    public float optFloat(int n, float f) {
        try {
            return this.getFloat(n);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public double optDouble(int n) {
        return this.optDouble(n, 0.0);
    }

    public double optDouble(int n, double d) {
        try {
            return this.getDouble(n);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public String optString(int n) {
        return this.optString(n, null);
    }

    public String optString(int n, String string) {
        String string2 = this.getString(n);
        return string2 == null ? string : string2;
    }

    public JSONObject optJSONObject(int n) {
        Object object = this.opt(n);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public JSONArray optJSONArray(int n) {
        Object object = this.opt(n);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public boolean put(Object object) {
        return this.add(object);
    }

    public int length() {
        return this.size();
    }

    public static JSONArray listToJSONArray(Collection collection) throws JSONException {
        if (collection == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        for (Object e : collection) {
            if (e instanceof JSONObject.JSONObjectable) {
                jSONArray.put(((JSONObject.JSONObjectable)e).toJSONObject());
                continue;
            }
            jSONArray.put(e);
        }
        return jSONArray;
    }

    public static JSONArray arrayToJSONArray(Object[] objectArray) {
        return objectArray != null ? new JSONArray(objectArray) : null;
    }

    public static JSONArray int1ArrayToJSONArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        for (int n : nArray) {
            jSONArray.add((Object)n);
        }
        return jSONArray;
    }

    public static JSONArray int2ArrayToJSONArray(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        for (int[] nArray2 : nArray) {
            jSONArray.add(nArray2);
        }
        return jSONArray;
    }

    public static JSONArray double1ArrayToJSONArray(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        for (double d : dArray) {
            jSONArray.add((Object)d);
        }
        return jSONArray;
    }

    @Override
    public boolean add(Object object) {
        return this.list.add(object);
    }

    public void add(int n, Object object) {
        this.list.add(n, object);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    public Object get(int n) {
        return this.list.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.list.listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    public Object remove(int n) {
        return this.list.remove(n);
    }

    public Object set(int n, Object object) {
        return this.list.set(n, object);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public List subList(int n, int n2) {
        return this.list.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    protected Object clone() {
        return new JSONArray(new ArrayList(this.list));
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.list.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.list.addAll(n, collection);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.list.retainAll(collection);
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.list.toArray(objectArray);
    }
}

