/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import guitools.UIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.Vector;

public class GuiUtil {
    public static Color BACKGROUND = UIResource.getColor("Control Background");
    public static Color FOREGROUND = UIResource.getColor("Control Foreground");
    public static Color DARK_BACKGROUND = BACKGROUND.darker();
    public static Color BRIGHT_BACKGROUND = BACKGROUND.brighter();
    public static Color BLACK_BACKGROUND = BACKGROUND.darker();
    public static Color BRIGHT_BACKGROUND_ = BACKGROUND.brighter();
    public static int unx;
    private static boolean C;

    public static String filter(String string, char c, char c2) {
        String string2 = new String("");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c3 = string.charAt(i);
            if (c3 < c || c3 > c2) continue;
            string2 = string2 + c3;
        }
        return string2;
    }

    public static boolean areEqual(String string, String string2) {
        return (string == null || string.length() == 0) && (string2 == null || string2.length() == 0) || string != null && string2 != null && string.equals(string2);
    }

    public static boolean areEqualIgnoreCase(String string, String string2) {
        return (string == null || string.length() == 0) && (string2 == null || string2.length() == 0) || string != null && string2 != null && string.equalsIgnoreCase(string2);
    }

    public static String readLine(char c, InputStream inputStream) throws IOException {
        int n;
        String string = new String("");
        while ((n = inputStream.read()) != -1) {
            string = string + (char)n;
            if ((char)n != c) continue;
            break;
        }
        return string;
    }

    public static String getBefore(String string, char c) {
        char c2;
        String string2 = new String("");
        int n = string.length();
        for (int i = 0; i < n && (c2 = string.charAt(i)) != c; ++i) {
            string2 = string2 + c2;
        }
        return string2;
    }

    public static byte[] getByteArrayFrom(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    public static Vector getFormFile(String string) throws IOException {
        Vector<String> vector = new Vector<String>();
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        String string2 = null;
        string2 = randomAccessFile.readLine();
        while (string2 != null) {
            string2 = string2.trim();
            vector.addElement(string2);
            string2 = randomAccessFile.readLine();
        }
        randomAccessFile.close();
        return vector;
    }

    public static void drawDotLine(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        block4: {
            if (n4 <= 0) break block4;
            if (bl) {
                for (int i = n2 + n4; i < n3; i += n4) {
                    graphics.drawLine(n, i - n4, n, i);
                }
            } else {
                for (int i = n2 + n4; i < n3; i += n4) {
                    graphics.drawLine(i - n4, n, i, n);
                }
            }
        }
    }

    public static void drawDotRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        GuiUtil.drawDotLine(graphics, n, n2, n6, 2, true);
        GuiUtil.drawDotLine(graphics, n2, n, n5, 2, false);
        GuiUtil.drawDotLine(graphics, n5, n2, n6, 2, true);
        GuiUtil.drawDotLine(graphics, n6, n, n5, 2, false);
    }

    public static String tryDirectory(String string, boolean bl) {
        String string2 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            String string4 = string3 + File.separatorChar + string;
            File file = new File(string3);
            if (!file.isDirectory()) continue;
            file = new File(string4);
            if (file.isDirectory()) {
                return string4;
            }
            if (!bl) continue;
            file.mkdirs();
            return string4;
        }
        return null;
    }

    public static String tryFileName(String string) {
        return GuiUtil.tryFileName(string, '\\');
    }

    public static String tryFileName(String string, char c) {
        String string2 = null;
        String string3 = System.getProperty("java.class.path");
        String string4 = System.getProperty("path.separator");
        String string5 = System.getProperty("file.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string4);
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            String string7 = string6 + string.replace(c, string5.charAt(0));
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(string7));
                fileInputStream.close();
                string2 = string7;
                break;
            }
            catch (IOException iOException) {
            }
        }
        return string2;
    }

    public static Vector getFiles(String string, String string2) {
        File file;
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (!string2.startsWith(".")) {
            string2 = "." + string2;
        }
        if ((stringArray = (file = new File(string)).list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!string3.toLowerCase().endsWith(string2)) continue;
                string3 = string3.substring(0, string3.length() - string2.length());
                vector.addElement(string3);
            }
        }
        return vector;
    }

    public static final String getPath(String string) {
        String string2 = null;
        String string3 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            String string5 = string4 + string;
            File file = new File(string5);
            if (!file.isDirectory()) continue;
            string2 = string5;
            break;
        }
        return string2;
    }

    public static void draw3DRect(int n, int n2, int n3, int n4, boolean bl, Graphics graphics) {
        if (graphics != null) {
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            if (bl) {
                graphics.setColor(BRIGHT_BACKGROUND);
                graphics.drawLine(n, n2, n5, n2);
                graphics.drawLine(n, n2, n, n6);
                graphics.setColor(BACKGROUND);
                graphics.drawLine(n + 1, n2 + 1, n5 - 1, n2 + 1);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n6 - 1);
                graphics.setColor(DARK_BACKGROUND);
                graphics.drawLine(n + 1, n6 - 1, n5 - 1, n6 - 1);
                graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 1);
                graphics.setColor(BLACK_BACKGROUND);
                graphics.drawLine(n, n6, n5, n6);
                graphics.drawLine(n5, n2, n5, n6);
            } else {
                graphics.setColor(BLACK_BACKGROUND);
                graphics.drawLine(n, n2, n5 - 1, n2);
                graphics.drawLine(n, n2, n, n6 - 1);
                graphics.setColor(DARK_BACKGROUND);
                graphics.drawLine(n + 1, n2 + 1, n5 - 1, n2 + 1);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n6 - 1);
                graphics.setColor(BRIGHT_BACKGROUND);
                graphics.drawLine(n + 1, n6, n5, n6);
                graphics.drawLine(n5, n2 + 1, n5, n6);
                graphics.setColor(BACKGROUND);
                graphics.drawLine(n + 1, n6 - 1, n5 - 1, n6 - 1);
                graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 1);
            }
        }
    }

    public static void draw3DLine(int n, int n2, int n3, boolean bl, boolean bl2, Graphics graphics) {
        Color color = null;
        Color color2 = null;
        if (bl2) {
            color = DARK_BACKGROUND;
            color2 = BRIGHT_BACKGROUND;
        } else {
            color = BRIGHT_BACKGROUND;
            color2 = DARK_BACKGROUND;
        }
        int n4 = 0;
        int n5 = 0;
        if (bl) {
            n4 = n + n3;
            n5 = n2;
        } else {
            n4 = n;
            n5 = n2 + n3;
        }
        graphics.setColor(color);
        graphics.drawLine(n, n2, n4, n5);
        graphics.setColor(color2);
        if (bl) {
            graphics.drawLine(n, ++n5, n4, n5);
        } else {
            graphics.drawLine(++n4, n2, n4, n5);
        }
    }

    public static void drawString(String string, int n, int n2, int n3, int n4, boolean bl, Graphics graphics) {
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getHeight() - 3;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n7 = bl ? (n3 - n5) / 2 : n3 - n5;
        n8 = n7 > 0 ? n7 : 0;
        n7 = (n4 - n6) / 2 + 1;
        n9 = n4 < n6 ? n4 : n4 - n7;
        graphics.drawString(string, n + n8, n2 + n9 - 1);
    }

    public static Frame getFrame(Component component) {
        if (component != null) {
            int n = 0;
            while (!(component instanceof Frame)) {
                if (n++ > 100) {
                    component = null;
                    break;
                }
                component = component.getParent();
            }
        }
        return (Frame)component;
    }

    public static int getWidthOfString(Graphics graphics, String string, int n) {
        int n2 = GuiUtil.getWidthOfString(graphics, string);
        if (n2 < 0 || n2 < n) {
            n2 = n;
        }
        return n2;
    }

    public static int getWidthOfString(Graphics graphics, String string) {
        int n = -1;
        if (graphics != null && string != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.stringWidth(string);
        }
        return n;
    }

    public static boolean isWindows() {
        return C;
    }

    public static int getRealHeight(int n) {
        return GuiUtil.isWindows() ? n : n + unx;
    }

    static {
        Object object = BACKGROUND;
        float[] fArray2 = new float[3];
        float f = 0.1f;
        Color.RGBtoHSB(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), fArray2);
        float f2 = fArray2[2] + f;
        object = Color.getHSBColor(fArray2[0], fArray2[1], f2 >= 1.0f ? 1.0f : f2);
        if (object != null) {
            BRIGHT_BACKGROUND = object;
        }
        if ((object = Color.getHSBColor(fArray2[0], fArray2[1], (f2 = fArray2[2] - f) <= 0.0f ? 0.0f : f2)) != null) {
            DARK_BACKGROUND = object;
        }
        if ((object = Color.getHSBColor(fArray2[0], fArray2[1], (f2 = fArray2[2] - 0.5f) <= 0.0f ? 0.0f : f2)) != null) {
            BLACK_BACKGROUND = object;
        }
        if ((object = Color.getHSBColor(fArray2[0], fArray2[1], (f2 = fArray2[2] + f + 0.05f) >= 1.0f ? 1.0f : f2)) != null) {
            BRIGHT_BACKGROUND_ = object;
        }
        unx = 10;
        C = true;
        object = System.getProperty("os.name");
        C = object != null && ((String)object).startsWith("Windows");
    }
}

