/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import guitools.Painter;
import guitools.PainterConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedString;
import java.util.Vector;

public class Painter2D
implements PainterConstants {
    private static boolean F = false;
    private static boolean FAMILY = false;

    public static void drawText(Graphics graphics, String string, int n, int n2, boolean bl) {
        if (string.length() > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            if (bl) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
            Font font = graphics.getFont();
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FAMILY, font.getFontName());
            attributedString.addAttribute(TextAttribute.SIZE, new Float(font.getSize2D()));
            int n3 = font.getStyle();
            if ((n3 & 1) != 0) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if ((n3 & 2) != 0) {
                attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            attributedString.addAttribute(TextAttribute.FONT, font);
            graphics2D.drawString(attributedString.getIterator(), n, n2);
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, int n3, char c, boolean bl4) {
        if (string != null && string.length() > 0 && color != null) {
            Dimension dimension;
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            if (bl4) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl4);
            int n4 = 0;
            n = n > 0 ? n : 0;
            Vector<String> vector = new Vector<String>();
            if (bl) {
                dimension = Painter.layoutText(vector, string, n, rectangle.width, font, c, bl4);
            } else {
                String string2 = Painter.adjustString(string);
                vector.addElement(string2);
                n4 = (int)Math.round(font.getStringBounds(string2, fontRenderContext).getWidth());
                dimension = new Dimension(n4, fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent());
            }
            if (dimension.width > rectangle.width || dimension.height > rectangle.height) {
                n2 = n3;
            }
            int n5 = rectangle.y;
            switch (n2) {
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    n5 += (rectangle.height - dimension.height) / 2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    n5 += rectangle.height - dimension.height;
                }
            }
            int n6 = fontMetrics.getMaxAscent();
            int n7 = n6 + fontMetrics.getLeading() + fontMetrics.getMaxDescent() + n;
            graphics2D.setColor(color);
            for (int i = 0; i < vector.size() && n5 < rectangle.y + rectangle.height; n5 += n7 - n6, ++i) {
                int n8;
                String string3;
                if ((n5 += n6) <= 0 || (string3 = (String)vector.elementAt(i)).length() <= 0) continue;
                int n9 = (int)Math.round(font.getStringBounds(string3, fontRenderContext).getWidth());
                int n10 = rectangle.x;
                switch (n2) {
                    case 2: 
                    case 5: 
                    case 8: {
                        n10 += (rectangle.width - n9) / 2;
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 9: {
                        n10 += rectangle.width - n9 - 1;
                    }
                }
                if (vector.size() > 1 && n2 > 9) {
                    n8 = 1;
                    char[] cArray = string3.toCharArray();
                    for (int j = 0; n8 != 0 && j < cArray.length; n8 &= cArray[j] == ' ' || cArray[j] == '\n' ? 1 : 0, ++j) {
                    }
                    if (i == vector.size() - 1) {
                        n8 = 1;
                    }
                    if (n8 == 0) {
                        int n11;
                        while ((n11 = string3.length()) > 0 && string3.charAt(n11 - 1) == ' ') {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                        n9 = (int)Math.round(font.getStringBounds(string3, fontRenderContext).getWidth());
                        int n12 = string3.indexOf(32);
                        if (n12 > 0 && n12 < n11 - 1) {
                            int n13 = fontMetrics.charWidth(' ');
                            while ((n9 = (int)Math.round(font.getStringBounds(string3, fontRenderContext).getWidth())) < rectangle.width - n13) {
                                int n14 = (rectangle.width - n9) / n13;
                                string3 = Painter.adjustJustifyString(string3, n14);
                            }
                        }
                    }
                }
                AttributedString attributedString = new AttributedString(string3);
                attributedString.addAttribute(TextAttribute.FONT, font);
                attributedString.addAttribute(TextAttribute.FAMILY, font.getFontName());
                attributedString.addAttribute(TextAttribute.SIZE, new Float(font.getSize2D()));
                int n15 = font.getStyle();
                if ((n15 & 1) != 0) {
                    attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
                if ((n15 & 2) != 0) {
                    attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                }
                graphics2D.drawString(attributedString.getIterator(), n10, n5);
                n8 = Math.max((font.getSize() + (font.isBold() ? 2 : 0)) / 10, 1);
                if (bl2) {
                    graphics2D.fillRect(n10, n5 + 2, n9, n8);
                }
                if (!bl3) continue;
                graphics2D.fillRect(n10, n5 - fontMetrics.getAscent() / 2 + 1, n9, n8);
            }
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public static void drawText(Graphics graphics, String string, int n, int n2) {
        Painter2D.drawText(graphics, string, n, n2, true);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, int n3, char c) {
        Painter2D.drawText(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n3, c, true);
    }

    private static Stroke F(int n, float f) {
        BasicStroke basicStroke = null;
        switch (n) {
            case 1: {
                basicStroke = new BasicStroke(f, 0, 0);
                break;
            }
            case 2: {
                basicStroke = new BasicStroke(f, 0, 0, 10.0f, new float[]{10.0f, 5.0f}, 0.0f);
                break;
            }
            case 3: {
                basicStroke = new BasicStroke(f, 0, 0, 10.0f, new float[]{f, 6.0f}, 0.0f);
                break;
            }
            case 4: {
                basicStroke = new BasicStroke(f, 0, 0, 10.0f, new float[]{10.0f, 5.0f, f, 5.0f}, 0.0f);
            }
        }
        return basicStroke;
    }

    public static void drawArc(Graphics graphics, float f, float f2, float f3, float f4, Color color, Color color2, float f5, int n, float f6, float f7) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f8 = f5 / 2.0f;
        Arc2D.Float float_ = new Arc2D.Float(f + f8, f2 + f8, Math.max(f3 - f8 * 2.0f, 0.0f), Math.max(f4 - f8 * 2.0f, 0.0f), f6, f7, 0);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(float_);
        }
        if (n != 0 && color2 != null && !color2.equals(color)) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            graphics2D.setColor(color2);
            graphics2D.setStroke(Painter2D.F(n, f5));
            graphics2D.draw(float_);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setStroke(stroke);
    }

    public static void drawBox(Graphics graphics, float f, float f2, float f3, float f4, Color color, Color color2, float f5, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f6 = f5 / 2.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f + f6, f2 + f6, Math.max(f3 - f6 * 2.0f, 0.0f), Math.max(f4 - f6 * 2.0f, 0.0f));
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(float_);
        }
        if (n != 0 && color2 != null && !color2.equals(color)) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            graphics2D.setColor(color2);
            graphics2D.setStroke(Painter2D.F(n, f5));
            graphics2D.draw(float_);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setStroke(stroke);
    }

    public static void drawLine(Graphics graphics, float f, float f2, float f3, float f4, Color color, float f5, int n) {
        if (color != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(color);
            graphics2D.setStroke(Painter2D.F(n, f5));
            graphics2D.draw(new Line2D.Float(f, f2, f3, f4));
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.setStroke(stroke);
        }
    }

    public static void drawOval(Graphics graphics, float f, float f2, float f3, float f4, Color color, Color color2, float f5, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f6 = f5 / 2.0f;
        Ellipse2D.Float float_ = new Ellipse2D.Float(f + f6, f2 + f6, Math.max(f3 - f6 * 2.0f, 0.0f), Math.max(f4 - f6 * 2.0f, 0.0f));
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(float_);
        }
        if (n != 0 && color2 != null && !color2.equals(color)) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            graphics2D.setColor(color2);
            graphics2D.setStroke(Painter2D.F(n, f5));
            graphics2D.draw(float_);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setStroke(stroke);
    }

    public static void drawRoundBox(Graphics graphics, float f, float f2, float f3, float f4, Color color, Color color2, float f5, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f6 = f5 / 2.0f;
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(f + f6, f2 + f6, Math.max(f3 - f6 * 2.0f, 0.0f), Math.max(f4 - f6 * 2.0f, 0.0f), n2, n2);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(float_);
        }
        if (n != 0 && color2 != null && !color2.equals(color)) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            graphics2D.setColor(color2);
            graphics2D.setStroke(Painter2D.F(n, f5));
            graphics2D.draw(float_);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setStroke(stroke);
    }
}

