/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbDecimal;
import jet.connect.DbValue;

public class DbBigDecimalColumnBuffer
extends DbColumnBuffer {
    byte[][] SEDU;
    int arraycopy = 0;
    byte[] clearMem;
    byte[] decimalNeedBytes;
    byte[] get;

    public byte[][] getBuffer() {
        return this.SEDU;
    }

    public DbBigDecimalColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.arraycopy = DbBuffer.decimalNeedBytes(dbColDesc);
        this.clearMem = new byte[this.arraycopy];
        this.decimalNeedBytes = new byte[this.arraycopy];
        this.get = new byte[this.arraycopy];
        for (int i = 0; i < this.arraycopy; ++i) {
            this.clearMem[i] = 0;
            this.decimalNeedBytes[i] = -1;
        }
        this.SEDU = new byte[n][this.arraycopy];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        if (((DbDecimal)dbValue).get() == null) {
            System.arraycopy(this.clearMem, 0, this.SEDU[n], 0, this.arraycopy);
        } else {
            byte[] byArray = ((DbDecimal)dbValue).get().movePointRight(this.C.getScale()).toBigInteger().toByteArray();
            if ((byArray[0] & 0x80) != 128) {
                System.arraycopy(this.clearMem, 0, this.SEDU[n], 0, this.arraycopy);
            } else {
                System.arraycopy(this.decimalNeedBytes, 0, this.SEDU[n], 0, this.arraycopy);
            }
            System.arraycopy(byArray, 0, this.SEDU[n], this.arraycopy - byArray.length, byArray.length);
        }
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbDecimal)dbValue).set(new BigDecimal(new BigInteger(this.SEDU[n]), this.C.getScale()));
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            dataOutput.write(this.SEDU[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            dataInput.readFully(this.SEDU[i]);
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.SEDU = null;
        this.clearMem = null;
        this.decimalNeedBytes = null;
        this.get = null;
    }
}

