/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.datasource.JRHierarchicalDataset;

public class DbDate
extends DbDateTime {
    public DbDate() {
    }

    public DbDate(Date date) {
        this.value = date.getTime();
        this.bNull = false;
    }

    public DbDate(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public final Date getDate() {
        return new Date(this.value);
    }

    public final void setDate(Date date) {
        this.value = date.getTime();
        this.bNull = false;
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        Date date = resultSet.getDate(n);
        if (date != null) {
            this.value = date.getTime();
            this.bNull = resultSet.wasNull();
        } else {
            this.bNull = true;
        }
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        Date date = jRHierarchicalDataset.getDate(n);
        if (date != null) {
            this.value = date.getTime();
            this.bNull = jRHierarchicalDataset.wasNull();
        } else {
            this.bNull = true;
        }
    }

    @Override
    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return this.getDate().toString();
    }

    @Override
    public Object clone() {
        DbDate dbDate = new DbDate(this.desc);
        dbDate.bNull = this.bNull;
        dbDate.value = this.value;
        return dbDate;
    }

    @Override
    public void setValue(String string) {
        this.value = Date.valueOf(string).getTime();
        this.bNull = false;
    }
}

