/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBigInt;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbLongColumnBuffer
extends DbColumnBuffer {
    long[] B;

    public long[] getBuffer() {
        return this.B;
    }

    public DbLongColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.B = new long[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.B[n] = ((DbBigInt)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbBigInt)dbValue).set(this.B[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.B.length; ++i) {
            dataOutput.writeLong(this.B[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.B.length; ++i) {
            this.B[i] = dataInput.readLong();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.B = null;
    }
}

