/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbNumber;
import jet.datasource.JRHierarchicalDataset;

public class DbTinyInt
extends DbNumber {
    public byte value;

    public DbTinyInt() {
    }

    public DbTinyInt(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public int get() {
        return this.value;
    }

    public void set(byte by) {
        this.value = by;
        this.bNull = false;
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        this.value = resultSet.getByte(n);
        this.bNull = resultSet.wasNull();
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        this.value = jRHierarchicalDataset.getByte(n);
        this.bNull = jRHierarchicalDataset.wasNull();
    }

    @Override
    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return String.valueOf(this.value);
    }

    @Override
    public Object clone() {
        DbTinyInt dbTinyInt = new DbTinyInt(this.desc);
        dbTinyInt.bNull = this.bNull;
        dbTinyInt.value = this.value;
        return dbTinyInt;
    }

    @Override
    public boolean equals(DbNumber dbNumber) {
        if (dbNumber == null) {
            return false;
        }
        if (dbNumber.bNull != this.bNull) {
            return false;
        }
        if (this.bNull) {
            return true;
        }
        return this.byteValue() == dbNumber.byteValue();
    }

    @Override
    protected int compareToWithSameSQLType(DbNumber dbNumber) {
        DbTinyInt dbTinyInt = (DbTinyInt)dbNumber;
        if (dbTinyInt.bNull) {
            if (this.bNull) {
                return 0;
            }
            return 1;
        }
        if (this.bNull) {
            if (dbTinyInt.bNull) {
                return 0;
            }
            return -1;
        }
        if (this.value == dbTinyInt.value) {
            return 0;
        }
        if (this.value < dbTinyInt.value) {
            return -1;
        }
        return 1;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void setValue(DbNumber dbNumber) {
        boolean bl = this.bNull = dbNumber == null || dbNumber.bNull;
        if (dbNumber instanceof DbTinyInt) {
            this.value = ((DbTinyInt)dbNumber).value;
        } else if (!this.bNull) {
            this.value = dbNumber.byteValue();
        }
    }

    @Override
    public void setValue(String string) {
        this.value = Byte.parseByte(string);
        this.bNull = false;
    }

    @Override
    public String toStringValue() {
        byte[] byArray = null;
        byArray = this.isNull() ? new byte[1] : new byte[]{1, this.value};
        return Base64.encode(byArray);
    }
}

