/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.datatypes.DataTypeUtils;
import com.jinfonet.util.JRLog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbArray;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.datastream.DSArea;
import jet.datastream.DSAreaLabel;
import jet.datastream.DSContainable;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSOtherField;
import jet.datastream.DSPage;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.util.DSTool;
import jet.util.Converter;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;
import jet.util.Propertiable;
import jet.util.ReportFormat;
import jet.util.UpdLFString;
import jet.util.VersionControlable;

public class DSAreaDBField
extends DSOtherField
implements DSContainable {
    private boolean I = false;
    private double SEDU = 1.0;
    private double Z = 1.0;
    Vector add = new Vector(10);

    @Override
    public void add(JRObjectResult jRObjectResult) {
        if (jRObjectResult == null) {
            return;
        }
        this.add.addElement(jRObjectResult);
        jRObjectResult.setParent(this);
    }

    @Override
    public void remove(JRObjectResult jRObjectResult) {
        int n = this.add.indexOf(jRObjectResult);
        if (n >= 0) {
            this.add.removeElementAt(n);
            jRObjectResult.setParent(null);
        }
    }

    @Override
    public void removeAll() {
        for (int i = this.add.size() - 1; i >= 0; --i) {
            JRObjectResult jRObjectResult = (JRObjectResult)this.add.elementAt(i);
            this.add.removeElementAt(i);
            jRObjectResult.setParent(null);
        }
    }

    @Override
    public Vector getChildren() {
        return this.add;
    }

    public void setZoom(double d, double d2) {
        this.SEDU = d;
        this.Z = d2;
    }

    @Override
    public void paint(Graphics graphics) {
        Render render = this.getRender();
        render.setPaintCalledByField(true);
        double d = render.getRotation();
        if (this.I) {
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, this.getBounds());
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            graphics2D.rotate(d, render.getRotationX(), render.getRotationY());
            render.paintFieldBackground(graphics2D);
            render.paintFieldBorder(graphics2D);
            Graphics2D graphics2D2 = (Graphics2D)graphics;
            graphics2D2.scale(this.SEDU, this.Z);
            render.paint(graphics2D2);
            graphics2D.rotate(-d, render.getRotationX(), render.getRotationY());
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else if (render instanceof RenderBarCode && !this.I) {
            Rectangle rectangle = new Rectangle(0, 0, 1, 1);
            if (this.getWidth() <= 0) {
                rectangle.setBounds(0, 0, 1, 1);
            } else {
                rectangle = this.getBounds();
            }
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, rectangle);
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            render.paintFieldBackground(graphics2D);
            render.paintFieldBorder(graphics2D);
            Graphics2D graphics2D3 = (Graphics2D)graphics;
            graphics2D3.scale(this.SEDU, this.Z);
            render.paint(graphics2D3);
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else {
            render.paintFieldBackground(graphics);
            render.paintFieldBorder(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.scale(this.SEDU, this.Z);
            render.paint(graphics2D);
        }
        render.setPaintCalledByField(false);
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        int n = ((VersionControlable)((Object)dataInput)).getVersion();
        if (n < 262416 && n != 0) {
            return;
        }
        int n2 = dataInput.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = dataInput.readInt();
            JRObjectResult jRObjectResult = DSPage.createJRObjectResult(n3, this.locale, this.timezone);
            jRObjectResult.read(dataInput, dSDataStreamable);
            this.add(jRObjectResult);
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        int n = this.add.size();
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            ((JRObjectResult)this.add.elementAt(i)).write(dataOutput);
        }
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 4;
        int n2 = this.add.size();
        for (int i = 0; i < n2; ++i) {
            n += ((JRObjectResult)this.add.elementAt(i)).length();
        }
        return n;
    }

    @Override
    public void dump(PrintStream printStream) {
        int n = this.add.size();
        for (int i = 0; i < n; ++i) {
            ((JRObjectResult)this.add.elementAt(i)).dump(printStream);
        }
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timezone;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSAreaLabel());
    }

    public DSAreaLabel dup(DSAreaLabel dSAreaLabel) {
        super.dup(dSAreaLabel);
        for (int i = 0; i < this.add.size(); ++i) {
            dSAreaLabel.add((JRObjectResult)((JRObjectResult)this.add.elementAt(i)).copyObject());
        }
        dSAreaLabel.locale = this.locale;
        dSAreaLabel.timezone = this.timezone;
        return dSAreaLabel;
    }

    @Override
    public int getLinkCondition() {
        return ((DSArea)this.getParent()).getLinkCondition();
    }

    @Override
    public int getLinkPage() {
        return ((DSArea)this.getParent()).getLinkPage();
    }

    @Override
    public int getLinkComm() {
        return ((DSArea)this.getParent()).getLinkComm();
    }

    @Override
    public Record getSynRecord() {
        return ((DSArea)this.getParent()).getSynRecord();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Propertiable getPropertyByName(String string, Record record) {
        Propertiable propertiable = null;
        if (((Boolean)this.template.getPropertyByName("UseDefault").getObject()).booleanValue() && this.template.getBasedMapDBField() != null) {
            if (string.equals("X")) return super.getPropertyByName(string, record);
            if (string.equals("Y")) return super.getPropertyByName(string, record);
            if (string.equals("Width")) return super.getPropertyByName(string, record);
            if (string.equals("Height")) return super.getPropertyByName(string, record);
            if (string.equals("UseDefault")) return super.getPropertyByName(string, record);
            propertiable = this.template.getBasedMapDBField().getPropertyByName(string);
            if (propertiable == null) return propertiable;
            boolean bl = propertiable.isChangeByOther();
            boolean bl2 = propertiable.isChagneByFmtt();
            boolean bl3 = propertiable.isChangeByBL();
            if (!bl && !bl2) {
                if (!bl3) return propertiable;
            }
            Object object = null;
            object = bl2 ? propertiable.getUnifiedObject() : (bl ? propertiable.getObject() : propertiable.getChangeByBL());
            try {
                String string2 = object.toString().toUpperCase();
                DSArea dSArea = (DSArea)this.getParent();
                if (dSArea != null && dSArea.S != null && dSArea.S.size() > 0 && dSArea.S.containsKey(string2)) {
                    return this.I(string, dSArea, propertiable);
                }
                if (bl2 && record == null) {
                    return propertiable;
                }
                DbValue dbValue = null;
                if (dbValue != null) return this.initialProperty(string, string2, propertiable, dbValue);
                if (record == null) return this.initialProperty(string, string2, propertiable, dbValue);
                dbValue = record.getCell(string2);
                return this.initialProperty(string, string2, propertiable, dbValue);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (!JRLog.isError(2)) throw jRInterruptedException;
                JRLog.error(2, jRInterruptedException);
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) return propertiable;
                JRLog.error(2, exception);
            }
            return propertiable;
        }
        propertiable = this.template.getPropertyByName(string);
        boolean bl = propertiable.isChangeByOther();
        boolean bl4 = propertiable.isChagneByFmtt();
        boolean bl5 = propertiable.isChangeByBL();
        if (!bl && !bl4) {
            if (!bl5) return super.getPropertyByName(string, record);
        }
        Object object = null;
        object = bl4 ? propertiable.getUnifiedObject() : (bl ? propertiable.getObject() : propertiable.getChangeByBL());
        try {
            String string3 = object.toString().toUpperCase();
            DSArea dSArea = (DSArea)this.getParent();
            if (dSArea != null && dSArea.S != null && dSArea.S.size() > 0 && dSArea.S.containsKey(string3)) {
                return this.I(string, dSArea, propertiable);
            }
            if (bl4 && record == null) {
                return propertiable;
            }
            DbValue dbValue = null;
            if (dbValue != null) return this.initialProperty(string, string3, propertiable, dbValue);
            if (record == null) return this.initialProperty(string, string3, propertiable, dbValue);
            dbValue = record.getCell(string3);
            return this.initialProperty(string, string3, propertiable, dbValue);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (!JRLog.isError(2)) throw jRInterruptedException;
            JRLog.error(2, jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (!JRLog.isError(2)) return propertiable;
            JRLog.error(2, exception);
            return propertiable;
        }
    }

    private Propertiable I(String string, JRVisiableResult jRVisiableResult, Propertiable propertiable) {
        block5: {
            Object object = propertiable.getObject();
            String string2 = object.toString().toUpperCase();
            Hashtable hashtable = jRVisiableResult.S;
            try {
                if (hashtable != null && hashtable.containsKey(string2)) {
                    DbValue dbValue = (DbValue)jRVisiableResult.getCompLevelValue(string2);
                    propertiable = jRVisiableResult.initialProperty(string, string2, propertiable, dbValue);
                }
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, exception);
            }
        }
        return propertiable;
    }

    @Override
    public String getText() {
        String string;
        Object object;
        String string2;
        String string3;
        DbValue dbValue = this.getValue();
        if (dbValue != null && !dbValue.isNull()) {
            string3 = (String)this.getPropertyByName("Format").getObject();
            if (string3.equals("")) {
                string3 = DataTypeUtils.getDefaultFormat(dbValue.getSqlType());
            }
            if (string3 == null || string3.equals("") || string3.equalsIgnoreCase("null")) {
                string2 = dbValue.toString();
            } else {
                this.timezone = TimeZone.getTimeZone(TimeZone.getDefault().getID());
                object = null;
                try {
                    object = ReportFormat.getOneFormat(dbValue.getSqlType(), string3, this.getLocale(), this.timezone);
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    object = null;
                }
                if (DSTool.isNumericSqlData(dbValue.getSqlType()) && object instanceof DecimalFormat) {
                    ((DecimalFormat)object).setRoundingMode(DSTool.getRoundingMode(this));
                }
                if (dbValue instanceof DbArray) {
                    string = UpdLFString.getUpdString((String)this.getPropertyByName("ValueDelimiter").getObject());
                    string2 = object != null ? object.format(dbValue, string) : dbValue.toString();
                } else {
                    string2 = object != null ? object.format(dbValue) : dbValue.toString();
                }
            }
        } else {
            block30: {
                string2 = null;
                try {
                    string2 = (String)this.getPropertyByName("DisplayNull").getObject();
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block30;
                    JRLog.error(2, exception);
                }
            }
            if (string2 == null) {
                string2 = "NULL";
            }
        }
        string3 = null;
        if (this.nlsBundle != null) {
            string3 = this.nlsBundle.getDataMapped(string2);
            if (string3 != null && this.nlsManager != null) {
                this.nlsManager.putSelfDefinedMapping(string2, string3);
            }
        } else {
            object = this.getPropertyByName("DataMappingFile");
            string = null;
            if (object != null) {
                string = (String)object.getObject();
            }
            if (string != null) {
                JFieldValueNLSManager jFieldValueNLSManager;
                if (this.nlsManager != null) {
                    string3 = this.nlsManager.getFieldBindNLSValue(string, string2);
                } else if (string.length() != 0 && this.getParent() != null && (jFieldValueNLSManager = this.getCommunicator().getFieldNLSManager()) != null) {
                    string3 = jFieldValueNLSManager.getFieldBindNLSValue(string, string2);
                }
            }
        }
        if (string3 != null) {
            string2 = string3;
        }
        if (this.isRuntimeConvert) {
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string2 = Converter.convertString(string2, this.fromEncoding, this.toEncoding);
            }
        } else {
            object = this.getCommunicator();
            this.fromEncoding = object.getFromEncoding();
            this.toEncoding = object.getToEncoding();
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string2 = Converter.convertString(string2, this.fromEncoding, this.toEncoding);
            }
        }
        return string2;
    }
}

