/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbChar;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTextObj;
import jet.datastream.JRVisiableResult;
import jet.datastream.TextobjFieldable;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderText;
import jet.util.Containable;
import jet.util.Converter;
import jet.util.DbValueFormat;
import jet.util.HashVector;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;
import jet.util.NLSBundleInfo;
import jet.util.Propertiable;
import jet.util.ReportFormat;
import jet.util.VersionControlable;

public class DSField
extends JRVisiableResult {
    Render C = null;
    Integer B = null;
    int clearCacheRecord = -1;
    int D;
    int convertGraphicsToGraphics2D;
    int convertString;
    int convertTextForTextObject;
    int convertUnitToPixel;
    int createConcreteRender;
    int createRender;
    int[][] doEncodingConvert = null;
    int doNLSMapping;
    int drawImage;
    protected Locale locale;
    protected int resolution = -1;
    protected TimeZone timezone;
    private boolean dup = false;
    private int dupRenderText = 0;
    private int equals = 0;
    private int error = -1;
    private ImageObserver format;
    protected boolean isRuntimeConvert = false;
    protected int fromEncoding = -1;
    protected int toEncoding = -1;
    protected JFieldValueNLSManager nlsManager = null;
    protected JFieldValueNLSManager catlogNLSManager = null;
    protected NLSBundleInfo nlsBundle;
    private boolean get = false;
    private Rectangle getBounds = null;
    private String getCatalogNlsManager = null;
    private boolean getCatalogNlsPrefix = false;
    private int getCatlogNLSPreFix = -1;
    boolean getChangeByBL = false;
    private int getCommunicator = -1;
    private Record getDataMapped = null;

    public void setStringValue(String string) {
    }

    public void setLineBreakPos(int[][] nArray) {
        if (nArray.length > 0) {
            this.doEncodingConvert = nArray;
        }
    }

    public int[][] getLineBreakPos() {
        return this.doEncodingConvert;
    }

    public void setStartLine(int n) {
        this.doNLSMapping = n;
    }

    public void setStartLine_split(int n) {
        this.doNLSMapping = n + 1;
    }

    public int getStartLine() {
        return this.doNLSMapping;
    }

    public void setEndLine(int n) {
        this.drawImage = n;
    }

    public int getEndLine() {
        return this.drawImage;
    }

    @Override
    protected void beforeWrite() {
        super.beforeWrite();
        this.flag = (byte)(this.flag | (this.error != -1 ? 64 : 0));
        this.flag = (byte)(this.flag | (this.doEncodingConvert != null ? -128 : 0));
    }

    public String getText(JRecord jRecord) {
        String string;
        if (this.getObjectType() == 257 || this.getObjectType() == 393473) {
            Propertiable propertiable = this.getPropertyByName("DispTextInfo", jRecord);
            string = propertiable == null || propertiable.getObject().equals("") ? (String)this.getPropertyByName("Text", jRecord).getObject() : (String)propertiable.getObject();
        } else {
            throw new RuntimeException();
        }
        string = this.doEncodingConvert(string);
        return string;
    }

    public String getText() {
        String string;
        if (this.getObjectType() == 257 || this.getObjectType() == 393473) {
            Propertiable propertiable = this.getPropertyByName("DispTextInfo");
            string = propertiable == null || propertiable.getObject().equals("") ? (String)this.getPropertyByName("Text").getObject() : (String)propertiable.getObject();
        } else {
            throw new RuntimeException();
        }
        string = this.doNLSMapping(string);
        string = this.doEncodingConvert(string);
        return string;
    }

    protected String doEncodingConvert(String string) {
        if (this.isRuntimeConvert) {
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        } else {
            Communicator communicator = this.getCommunicator();
            this.fromEncoding = communicator.getFromEncoding();
            this.toEncoding = communicator.getToEncoding();
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        }
        return string;
    }

    protected String doNLSMapping(String object) throws JRInterruptedException {
        Object object2;
        boolean bl = true;
        boolean bl2 = false;
        Propertiable propertiable = this.getPropertyByName("DataMappingFile");
        if (propertiable == null) {
            bl = false;
        } else {
            object2 = propertiable.getObject();
            if (object2 == null || object2.toString().equals("")) {
                bl = false;
            }
        }
        object2 = null;
        if (this.nlsBundle != null) {
            object2 = this.nlsBundle.getDataMapped((String)object);
        } else {
            if (bl) {
                String string = null;
                if (propertiable != null) {
                    string = (String)this.getPropertyByName("DataMappingFile").getObject();
                }
                if (string != null) {
                    JFieldValueNLSManager jFieldValueNLSManager;
                    if (this.nlsManager != null) {
                        object2 = this.nlsManager.getFieldBindNLSValue(string, (String)object);
                    } else if (string.length() != 0 && (jFieldValueNLSManager = this.getFieldNLSManager()) != null) {
                        object2 = jFieldValueNLSManager.getFieldBindNLSValue(string, (String)object);
                    }
                }
            } else {
                String string = this.getCatlogNLSPreFix();
                if (string != null) {
                    JFieldValueNLSManager jFieldValueNLSManager = this.catlogNLSManager;
                    if (jFieldValueNLSManager == null) {
                        jFieldValueNLSManager = this.getCommunicator().getCatalogNlsManager(this.getSubIdxOfRpt());
                    }
                    if (jFieldValueNLSManager != null) {
                        object2 = jFieldValueNLSManager.getFieldBindNLSValue(string, (String)object);
                    }
                }
            }
            if (object2 != null) {
                object = object2;
            }
        }
        return object;
    }

    protected String getCatlogNLSPreFix() {
        if (this.getParent() == null) {
            return this.getCatalogNlsManager;
        }
        return this.getCommunicator().getCatalogNlsPrefix(this.getSubIdxOfRpt() + "_" + this.getTemplate().getInstName());
    }

    public String getDataEntity() {
        Propertiable propertiable;
        String string = null;
        int n = this.getObjectType();
        if ((n == 257 || n == 393473) && (propertiable = this.template.getPropertyByName("Text")) != null && propertiable.isSetRuntimeChgBy()) {
            if (propertiable.isChangeByBL()) {
                this.getCatalogNlsPrefix = true;
                string = propertiable.getChangeByBL().toString();
            } else {
                string = propertiable.getRuntimeChangeBy().toString();
            }
        }
        return string;
    }

    public void setStretchHeight(int n) {
        this.clearCacheRecord = n;
    }

    public int getStretchHeight() {
        return this.clearCacheRecord == -1 ? this.getHeight() : this.clearCacheRecord;
    }

    public void setLineNum(int n) {
        this.D = n;
    }

    public int getLineNum() {
        return this.D;
    }

    public void setStartChar(short s) {
        this.convertGraphicsToGraphics2D = s;
    }

    public int getStartChar() {
        return this.convertGraphicsToGraphics2D;
    }

    public void setCharLength(short s) {
        this.convertString = s;
    }

    public int getCharLength() {
        return this.convertString;
    }

    public void setBaseline(int n) {
        this.convertTextForTextObject = n;
    }

    public int getBaseline() {
        return Unit.convertUnitToPixel(this.convertTextForTextObject, this.getResolution());
    }

    public void setUnderlineWidth(int n) {
        this.convertUnitToPixel = n;
    }

    public int getUnderlineWidth() {
        return Unit.convertUnitToPixel(this.convertUnitToPixel, this.getResolution());
    }

    public void setStrikeline(int n) {
        this.createConcreteRender = n;
    }

    public int getStrikeline() {
        return Unit.convertUnitToPixel(this.createConcreteRender, this.getResolution());
    }

    public void setStrikelineWidth(int n) {
        this.createRender = n;
    }

    public int getStrikelineWidth() {
        return Unit.convertUnitToPixel(this.createRender, this.getResolution());
    }

    public static final String convertTextForTextObject(String string) {
        string = string.replace('\t', ' ');
        string = string.replace('\r', ' ');
        string = string.replace('\n', ' ');
        return string;
    }

    public String toString() {
        String string = this.getText();
        if (this.isTextobjFieldable()) {
            int n = (string = DSField.convertTextForTextObject(string)).length();
            if (this.convertGraphicsToGraphics2D < n && this.convertGraphicsToGraphics2D + this.convertString <= n) {
                string = string.substring(this.convertGraphicsToGraphics2D, this.convertGraphicsToGraphics2D + this.convertString);
            } else if (this.getObjectType() == 257 && this.convertGraphicsToGraphics2D < n && this.convertGraphicsToGraphics2D + this.convertString > n) {
                String string2 = string;
                for (int i = this.convertGraphicsToGraphics2D; i < this.convertGraphicsToGraphics2D + this.convertString; i += n) {
                    string2 = string2 + string;
                }
                string = string2.substring(this.convertGraphicsToGraphics2D, this.convertGraphicsToGraphics2D + this.convertString);
            }
        }
        return string;
    }

    private void B(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        boolean bl = true;
        if (dataInput instanceof VersionControlable && (0 == (n = ((VersionControlable)((Object)dataInput)).getVersion()) || n > 262160)) {
            bl = false;
        }
        if (bl) {
            if (this.isTextobjFieldable()) {
                if (dataInput instanceof VersionControlable) {
                    n = ((VersionControlable)((Object)dataInput)).getVersion();
                    if (n >= 131072 || n == 0) {
                        this.D = dataInput.readInt();
                        this.convertGraphicsToGraphics2D = dataInput.readInt();
                        this.convertString = dataInput.readInt();
                        this.convertTextForTextObject = dataInput.readInt();
                        this.convertUnitToPixel = dataInput.readInt();
                        this.createConcreteRender = dataInput.readInt();
                        this.createRender = dataInput.readInt();
                        if (n < 131087 && n != 0) {
                            this.convertTextForTextObject = (int)Math.round((double)this.convertTextForTextObject * 5760.0 / 65535.0);
                            this.convertUnitToPixel = (int)Math.round((double)this.convertUnitToPixel * 5760.0 / 65535.0);
                            this.createConcreteRender = (int)Math.round((double)this.createConcreteRender * 5760.0 / 65535.0);
                            this.createRender = (int)Math.round((double)this.createRender * 5760.0 / 65535.0);
                        }
                    } else {
                        this.D = dataInput.readShort();
                        this.convertGraphicsToGraphics2D = dataInput.readShort();
                        this.convertString = dataInput.readShort();
                        this.convertTextForTextObject = dataInput.readShort();
                        this.convertUnitToPixel = dataInput.readShort();
                        this.createConcreteRender = dataInput.readShort();
                        this.createRender = dataInput.readShort();
                    }
                }
            } else {
                this.clearCacheRecord = dataInput.readInt();
            }
        }
        if (dataInput instanceof VersionControlable) {
            int n2;
            n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n >= 7 && n < 131076) {
                for (n2 = 0; n2 < 2; ++n2) {
                    dataInput.readInt();
                }
            }
            if (n >= 10 && n < 131085) {
                n2 = dataInput.readShort();
                if (n2 != 0) {
                    this.doEncodingConvert = new int[n2][2];
                    for (int i = 0; i < n2; ++i) {
                        this.doEncodingConvert[i][0] = dataInput.readShort();
                        this.doEncodingConvert[i][1] = dataInput.readShort();
                    }
                    this.doNLSMapping = dataInput.readShort();
                    this.drawImage = dataInput.readShort();
                }
            } else if (n >= 131085 && n <= 262160) {
                n2 = dataInput.readInt();
                if (n2 != 0) {
                    this.doEncodingConvert = new int[n2][2];
                    for (int i = 0; i < n2; ++i) {
                        this.doEncodingConvert[i][0] = dataInput.readInt();
                        this.doEncodingConvert[i][1] = dataInput.readInt();
                    }
                    this.doNLSMapping = dataInput.readInt();
                    this.drawImage = dataInput.readInt();
                }
            } else if ((n > 262160 || n == 0) && (this.flag & 0xFFFFFF80) != 0 && (n2 = dataInput.readInt()) != 0) {
                this.doEncodingConvert = new int[n2][2];
                for (int i = 0; i < n2; ++i) {
                    this.doEncodingConvert[i][0] = dataInput.readInt();
                    this.doEncodingConvert[i][1] = dataInput.readInt();
                }
                this.doNLSMapping = dataInput.readInt();
                this.drawImage = dataInput.readInt();
            }
            if (n >= 131098 && n <= 262160) {
                this.getCommunicator = dataInput.readInt();
            }
            if (n >= 262145 || n == 0) {
                n2 = dataInput.readBoolean() ? 1 : 0;
                if (n2 != 0) {
                    this.SEDU(dataInput);
                }
                if (n > 0 && n <= 262160) {
                    this.error = dataInput.readInt();
                } else if ((this.flag & 0x40) != 0) {
                    this.error = dataInput.readInt();
                }
            }
        }
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.B(dataInput, dSDataStreamable);
    }

    public int getRenderType() {
        int n = 0;
        if (this.B != null) {
            n = this.B;
        } else {
            Propertiable propertiable = this.getPropertyByName("renderType");
            if (propertiable != null) {
                this.B = (Integer)propertiable.getObject();
                n = this.B;
            }
        }
        return n;
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        int n;
        super.writeProperties(dataOutput);
        if (this.doEncodingConvert != null) {
            dataOutput.writeInt(this.doEncodingConvert.length);
            for (n = 0; n < this.doEncodingConvert.length; ++n) {
                dataOutput.writeInt(this.doEncodingConvert[n][0]);
                dataOutput.writeInt(this.doEncodingConvert[n][1]);
            }
            dataOutput.writeInt(this.doNLSMapping);
            dataOutput.writeInt(this.drawImage);
        }
        n = 1;
        if (this.C == null || this.B != null && this.B != 0) {
            n = 0;
        }
        dataOutput.writeBoolean(n != 0);
        if (n != 0) {
            this.writeRenderTextProperties(dataOutput);
        }
        if (this.error != -1) {
            dataOutput.writeInt(this.error);
        }
    }

    protected void writeRenderTextProperties(DataOutput dataOutput) throws IOException {
        RenderText renderText = (RenderText)this.C;
        dataOutput.writeInt(this.C.getX());
        dataOutput.writeInt(this.C.getY());
        dataOutput.writeInt(this.C.getWidth());
        dataOutput.writeInt(this.C.getHeight());
        Vector vector = renderText.getVLines();
        int n = vector == null ? 0 : vector.size();
        dataOutput.writeInt(n);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                dataOutput.writeUTF((String)vector.get(i));
            }
            int[][] nArray = renderText.getEveryLinePos();
            for (int i = 0; i < n; ++i) {
                dataOutput.writeInt(nArray[i][0]);
                dataOutput.writeInt(nArray[i][1]);
            }
        }
    }

    private void SEDU(DataInput dataInput) throws IOException {
        this.C = new RenderText(this);
        this.C.setX(dataInput.readInt());
        this.C.setY(dataInput.readInt());
        this.C.setWidth(dataInput.readInt());
        this.C.setHeight(dataInput.readInt());
        int n = dataInput.readInt();
        if (n != 0) {
            Vector<String> vector = new Vector<String>(n);
            for (int i = 0; i < n; ++i) {
                String string = dataInput.readUTF();
                vector.add(string);
            }
            ((RenderText)this.C).setVLines(vector);
            int[][] nArray = new int[n][2];
            for (int i = 0; i < n; ++i) {
                nArray[i][0] = dataInput.readInt();
                nArray[i][1] = dataInput.readInt();
            }
            ((RenderText)this.C).setEveryLinePos(nArray);
        }
    }

    private int UTFLength(Render render) {
        int n = 0;
        if (render != null && render instanceof RenderText) {
            n += 16;
            Vector vector = ((RenderText)render).getVLines();
            int n2 = vector == null ? 0 : vector.size();
            n += 4;
            if (n2 != 0) {
                for (int i = 0; i < n2; ++i) {
                    n += DSField.UTFLength((String)vector.get(i)) + 2;
                }
                n += n2 * 2 * 4;
            }
        }
        return n;
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        if (this.doEncodingConvert != null) {
            n += 12 + 8 * this.doEncodingConvert.length;
        }
        ++n;
        n += this.UTFLength(this.C);
        if (this.error != -1) {
            n += 4;
        }
        return n;
    }

    public boolean isTextobjFieldable() {
        return ((TextobjFieldable)((Object)this.getTemplate())).isTextobjFieldable();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        try {
            this.locale = this.getCommunicator().getLocale();
        }
        catch (NullPointerException nullPointerException) {
            this.locale = null;
        }
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    public TimeZone getTimeZone() {
        if (this.timezone != null) {
            return this.timezone;
        }
        try {
            this.timezone = this.getCommunicator().getTimeZone();
        }
        catch (NullPointerException nullPointerException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "2300073", (Throwable)nullPointerException);
            }
            this.timezone = null;
        }
        if (this.timezone == null && JRLog.isError(2)) {
            JRLog.error(2, "2300073");
        }
        return this.timezone;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSField());
    }

    public DSField dup(DSField dSField) {
        super.dup(dSField);
        dSField.clearCacheRecord = this.clearCacheRecord;
        dSField.D = this.D;
        dSField.convertGraphicsToGraphics2D = this.convertGraphicsToGraphics2D;
        dSField.convertString = this.convertString;
        dSField.convertTextForTextObject = this.convertTextForTextObject;
        dSField.convertUnitToPixel = this.convertUnitToPixel;
        dSField.createConcreteRender = this.createConcreteRender;
        dSField.createRender = this.createRender;
        dSField.doEncodingConvert = this.doEncodingConvert;
        dSField.doNLSMapping = this.doNLSMapping;
        dSField.drawImage = this.drawImage;
        dSField.locale = this.locale;
        dSField.timezone = this.timezone;
        dSField.getCommunicator = this.getCommunicator;
        if (this.C != null && this.C instanceof RenderText) {
            dSField.C = this.dupRenderText((RenderText)this.C);
        }
        dSField.error = this.error;
        return dSField;
    }

    public Render dupRenderText(RenderText renderText) {
        renderText.setX(this.C.getX());
        renderText.setY(this.C.getY());
        renderText.setWidth(this.C.getWidth());
        renderText.setHeight(this.C.getHeight());
        renderText.setVLines(((RenderText)this.C).getVLines());
        renderText.setEveryLineHeight(((RenderText)this.C).getEveryLineHeight());
        renderText.setEveryLinePos(((RenderText)this.C).getEveryLinePos());
        return renderText;
    }

    @Override
    protected String get(DbChar dbChar) {
        String string = (String)this.getPropertyByName("Format").getObject();
        DbValueFormat dbValueFormat = null;
        try {
            dbValueFormat = ReportFormat.getOneFormat(dbChar.getSqlType(), string, this.locale);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2300027, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            dbValueFormat = null;
        }
        return dbValueFormat != null ? dbValueFormat.format(dbChar) : dbChar.toString();
    }

    public String toStringPipe() {
        this.getChangeByBL = true;
        return this.toString();
    }

    public int getTextObjParaFmtNO() {
        return this.getCommunicator;
    }

    public void setTextObjParaFmtNO(int n) {
        this.getCommunicator = n;
    }

    public HashVector getTextObjParaFmts() {
        Containable containable = this.getParent();
        if (this.getCommunicator < 0 || containable == null || !(containable instanceof DSTextObj)) {
            return null;
        }
        return ((DSTextObj)containable).getParaFormat(this.getCommunicator);
    }

    protected Render createRender() {
        Propertiable propertiable = this.getPropertyByName("renderType");
        if (propertiable == null) {
            if (JRLog.isTrace(3)) {
                JRLog.trace(3, 3300025);
            }
            this.B = null;
            return RenderCreator.createConcreteRender(0, this);
        }
        this.B = (Integer)propertiable.getObject();
        return RenderCreator.createConcreteRender(this.B, this);
    }

    @Override
    public Record getSynRecord() {
        if (this.getDataMapped != null) {
            return this.getDataMapped;
        }
        return super.getSynRecord();
    }

    @Override
    public Record getSynRecord2() {
        if (this.getDataMapped != null) {
            return this.getDataMapped;
        }
        return super.getSynRecord2();
    }

    public void clearCacheRecord() {
        this.getDataMapped = null;
    }

    public Render getRenderWithCascade() {
        this.get = true;
        this.C = this.createRender();
        return this.C;
    }

    public Render getRender() {
        if (this.C == null) {
            Render render = this.createRender();
            this.clearCacheRecord();
            return render;
        }
        this.C.setField(this);
        RenderCreator.setCommonRenderProperteis(this.C, this);
        this.clearCacheRecord();
        return this.C;
    }

    public boolean hasRender() {
        return this.C != null;
    }

    public Render getRender(ImageObserver imageObserver) {
        if (this.C == null) {
            this.C = this.createRender();
        }
        this.C.setResolution(this.getResolution());
        this.C.setImageObserver(imageObserver);
        this.format = imageObserver;
        return this.C;
    }

    @Override
    public void paint(Graphics graphics) {
        Render render = this.getRender();
        render.setPaintCalledByField(true);
        double d = render.getRotation();
        if (this.dup) {
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, this.getBounds());
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            graphics2D.rotate(d, render.getRotationX(), render.getRotationY());
            render.paintFieldBackground(graphics2D);
            render.paint(graphics2D);
            render.paintFieldBorder(graphics2D);
            graphics2D.rotate(-d, render.getRotationX(), render.getRotationY());
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else if (render instanceof RenderBarCode && !this.dup) {
            Rectangle rectangle = new Rectangle(0, 0, 1, 1);
            if (this.getWidth() <= 0) {
                rectangle.setBounds(0, 0, 1, 1);
            } else {
                rectangle = this.getBounds();
            }
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, rectangle);
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            render.paintFieldBackground(graphics2D);
            render.paint(graphics2D);
            render.paintFieldBorder(graphics2D);
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else {
            render.paintFieldBackground(graphics);
            render.paint(graphics);
            render.paintFieldBorder(graphics);
        }
        render.setPaintCalledByField(false);
    }

    public int getBeforeRotationHeight() {
        return this.equals;
    }

    public void setBeforeRotationHeight(int n) {
        this.equals = n;
    }

    public int getBeforeRotationWidth() {
        return this.dupRenderText;
    }

    public void setBeforeRotationWidth(int n) {
        this.dupRenderText = n;
    }

    public void setFormIndex(int n) {
        this.error = n;
    }

    public int getFormIndex() {
        return this.error;
    }

    public String getPreviousText() {
        if (this.getDataMapped != null) {
            return this.getText((JRecord)this.getDataMapped);
        }
        return this.getText();
    }

    public void setCacheRecord(Record record) {
        this.getDataMapped = record;
    }

    public Record getCacheRecord() {
        return this.getDataMapped;
    }

    public void setRender(Render render) {
        this.C = render;
    }

    @Override
    public void setNLSManager(JFieldValueNLSManager jFieldValueNLSManager) {
        this.nlsManager = jFieldValueNLSManager;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.format = imageObserver;
    }

    public ImageObserver getImageObserver() {
        return this.format;
    }

    public NLSBundleInfo getNlsBundle() {
        return this.nlsBundle;
    }

    public void setNlsBundle(NLSBundleInfo nLSBundleInfo) {
        this.nlsBundle = nLSBundleInfo;
    }

    public void setRuntimeComvert(boolean bl) {
        this.isRuntimeConvert = bl;
    }

    public void setFromEncoding(int n) {
        this.fromEncoding = n;
    }

    public void setToEncoding(int n) {
        this.toEncoding = n;
    }

    @Override
    public int getResolution() {
        if (this.resolution != -1) {
            return this.resolution;
        }
        return super.getResolution();
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public boolean isParagraphField() {
        return this.get;
    }

    public Rectangle getAutoExpandedRec() {
        return this.getBounds;
    }

    public void setAutoExpandedRec(Rectangle rectangle) {
        this.getBounds = rectangle;
    }

    public boolean isValid() {
        return true;
    }

    public JFieldValueNLSManager getFieldNLSManager() {
        if (null != this.nlsManager) {
            return this.nlsManager;
        }
        int n = this.getSubIdxOfRpt();
        Communicator communicator = this.getCommunicator();
        if (communicator != null) {
            this.nlsManager = communicator.getFiledNlsManager(n);
        }
        return this.nlsManager;
    }

    public void setCatlogNLSManager(JFieldValueNLSManager jFieldValueNLSManager) {
        this.catlogNLSManager = jFieldValueNLSManager;
    }

    public String getRuntimeCatlogNLSPreFix() {
        return this.getCatalogNlsManager;
    }

    public void setRuntimeCatlogNLSPreFix(String string) {
        this.getCatalogNlsManager = string;
    }

    public void resetLineBreakPos() {
        this.doEncodingConvert = null;
    }

    @Override
    public int getSubIdxOfRpt() {
        if (this.getCatlogNLSPreFix != -1) {
            return this.getCatlogNLSPreFix;
        }
        return super.getSubIdxOfRpt();
    }

    public void setSubIdxOfRpt(int n) {
        this.getCatlogNLSPreFix = n;
    }

    public boolean isTextChangeByBL() {
        return this.getCatalogNlsPrefix;
    }
}

