/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSDBField;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DSSubStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.QuickSortIntVector;
import jet.datastream.RandomByteArrayInputStream;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.PJFCommunicator;
import jet.ie.ZipToolkit;
import jet.ie.io.FileBlockInputStream;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataInput;
import jet.ie.io.PJFDataOutput;
import jet.util.IntKeyHashtable;
import jet.util.IntVector;
import jet.util.JRInterruptedException;
import jet.util.QuickSortableVector;
import jet.util.QuickSorter;
import jet.util.RAFile;
import jet.util.intChain;

public class DataStream
extends DSSubStream {
    protected int cacheSize = 10;
    protected IntKeyHashtable cachedPages;
    protected intChain LRU;
    private boolean ASCENDING;
    protected IntKeyHashtable pageEntries = new IntKeyHashtable();
    protected IntKeyHashtable pageLengthes = new IntKeyHashtable();
    private File DESCENDING;
    protected RAFile bufFile;
    protected FileBlockOutputStream out;
    private FileBlockInputStream GZip;
    private boolean SEDU = false;
    protected ResourceStore resourceStore = null;
    private DSPage UnGZip = null;

    public DataStream() {
    }

    public DataStream(Communicator communicator) {
        this(communicator, 4);
    }

    public DataStream(Communicator communicator, int n) {
        super(communicator, 0);
        this.cacheSize = n;
        this.cachedPages = new IntKeyHashtable(n);
        this.LRU = new intChain(n);
    }

    protected void createTempFile() {
        block5: {
            try {
                File file = this.getResourceStore().getDiskStore().getTempRoot();
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                this.DESCENDING = this.getResourceStore().getDiskStore().createTempFile("datastream", null);
                this.bufFile = new RAFile(this.DESCENDING, "rw");
                this.out = new FileBlockOutputStream(this.bufFile);
                this.GZip = new FileBlockInputStream(this.bufFile);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, exception);
            }
        }
    }

    public boolean isInMemory(int n) {
        return (DSPage)this.cachedPages.get(n) != null;
    }

    public void update(DSPage dSPage) throws IOException {
        int n = dSPage.getPageNum();
        Long l = (Long)this.pageEntries.get(n);
        if (l != null) {
            this.out.reset(l);
            RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage.length());
            dSPage.write(new PJFDataOutput(randomByteArrayOutputStream));
            byte[] byArray = randomByteArrayOutputStream.toByteArray();
            if (this.SEDU) {
                byArray = ZipToolkit.GZip(byArray);
            }
            this.out.write(byArray);
            randomByteArrayOutputStream.close();
        }
    }

    public DSPage getPage(int n) throws IOException, JRStopEngineException {
        DSPage dSPage = null;
        dSPage = (DSPage)this.cachedPages.get(n);
        if (dSPage == null) {
            Long l = (Long)this.pageEntries.get(n);
            if (l != null) {
                dSPage = new DSPage(this, n);
                dSPage.setLocale(this.communicator.getLocale());
                dSPage.setTimeZone(this.communicator.getTimeZone());
                this.bufFile.seek(l);
                int n2 = (Integer)this.pageLengthes.get(n);
                this.GZip.reset(n2);
                byte[] byArray = new byte[n2];
                this.GZip.read(byArray);
                byte[] byArray2 = byArray;
                if (this.SEDU) {
                    byArray2 = ZipToolkit.UnGZip(byArray2);
                }
                RandomByteArrayInputStream randomByteArrayInputStream = new RandomByteArrayInputStream(byArray2);
                dSPage.read(new PJFDataInput(randomByteArrayInputStream));
                randomByteArrayInputStream.close();
            } else if (this.communicator instanceof PJFCommunicator) {
                if (this.UnGZip == null || this.UnGZip.getPageNum() != n) {
                    this.UnGZip = this.communicator.getPage(n);
                }
                return this.UnGZip;
            }
            if (dSPage != null) {
                this.cachePage(dSPage);
            }
        }
        return dSPage;
    }

    public boolean isEngineFinished() {
        return this.communicator.isEngineFinished();
    }

    public Rectangle getPageArea() {
        return this.communicator.getHeaderInfo(0).getPaperArea();
    }

    public Rectangle getPrintableArea() {
        return this.communicator.getHeaderInfo(0).getPrintableArea();
    }

    public int ie() {
        return this.communicator.getHeaderInfo(0).getie();
    }

    public Long getPageEntry(int n) {
        return (Long)this.pageEntries.get(n);
    }

    protected void cachePage(DSPage dSPage) throws IOException {
        int n;
        if (this.cachedPages.size() >= this.cacheSize) {
            n = this.LRU.removeLastElement();
            DSPage dSPage2 = (DSPage)this.cachedPages.remove(n);
            if (this.getPageEntry(n) == null) {
                if (this.bufFile == null) {
                    this.createTempFile();
                }
                long l = this.bufFile.length();
                this.bufFile.seek(l);
                this.out.reset(this.bufFile.length());
                RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage2.length());
                dSPage2.write(new PJFDataOutput(randomByteArrayOutputStream));
                byte[] byArray = randomByteArrayOutputStream.toByteArray();
                if (this.SEDU) {
                    byArray = ZipToolkit.GZip(byArray);
                }
                this.out.write(byArray);
                randomByteArrayOutputStream.close();
                this.pageEntries.put(n, l);
                this.pageLengthes.put(n, (int)(this.bufFile.length() - l));
            }
        }
        n = dSPage.getPageNum();
        this.cachedPages.put(n, dSPage);
        this.LRU.insertElementAt(n, 0);
    }

    public long[] saveTo(PJFDataOutput pJFDataOutput) throws IOException, JRStopEngineException {
        return this.saveTo(pJFDataOutput, false);
    }

    public long[] saveTo(PJFDataOutput pJFDataOutput, boolean bl) throws IOException, JRStopEngineException {
        int n = this.communicator.getPageNum();
        long[] lArray = new long[n];
        if (lArray.length > 0) {
            lArray[0] = pJFDataOutput.getPosition();
        }
        for (int i = 1; i <= n; ++i) {
            Object object;
            DSPage dSPage = (DSPage)this.cachedPages.get(i);
            if (dSPage == null && (object = (Long)this.pageEntries.get(i)) != null) {
                dSPage = new DSPage(this, i);
                dSPage.setLocale(this.communicator.getLocale());
                dSPage.setTimeZone(this.communicator.getTimeZone());
                this.bufFile.seek((Long)object);
                int n2 = (Integer)this.pageLengthes.get(i);
                this.GZip.reset(n2);
                byte[] byArray = new byte[n2];
                this.GZip.read(byArray);
                byte[] byArray2 = byArray;
                if (this.SEDU) {
                    byArray2 = ZipToolkit.UnGZip(byArray);
                }
                RandomByteArrayInputStream randomByteArrayInputStream = new RandomByteArrayInputStream(byArray2);
                dSPage.read(new PJFDataInput(randomByteArrayInputStream));
                randomByteArrayInputStream.close();
            }
            object = new RandomByteArrayOutputStream(dSPage.length());
            dSPage.write(new PJFDataOutput((OutputStream)object));
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            if (bl) {
                byArray = ZipToolkit.GZip(byArray);
            }
            pJFDataOutput.write(byArray);
            if (i != n) {
                lArray[i] = lArray[i - 1] + (long)byArray.length;
            }
            ((ByteArrayOutputStream)object).close();
        }
        return lArray;
    }

    @Override
    public void clearMem() {
        block6: {
            super.clearMem();
            if (this.cachedPages != null) {
                this.cachedPages.clear();
            }
            this.cachedPages = null;
            this.LRU = null;
            if (this.DESCENDING != null) {
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.GZip != null) {
                        this.GZip.close();
                    }
                    this.bufFile.close();
                    this.DESCENDING.delete();
                }
                catch (IOException iOException) {
                    if (!JRLog.isError(2)) break block6;
                    JRLog.error(2, iOException);
                }
            }
        }
        this.resourceStore = null;
    }

    public void sort(DSSection dSSection, DbValue dbValue, boolean bl) throws JRStopEngineException {
        block18: {
            Vector vector = new Vector(20);
            DSPage dSPage = (DSPage)dSSection.getParent();
            int n = dSPage.getChildren().indexOf(dSSection);
            try {
                Object object;
                Vector vector2;
                Object object2;
                int n2;
                int n3;
                Object object3;
                int n4;
                int n5;
                int n6;
                int n7;
                boolean bl2 = this.ASCENDING(n, dSPage, vector);
                if (!bl2 && !(this.communicator instanceof PJFCommunicator) && (n7 = dSPage.getPageNum()) != 1) {
                    DSPage dSPage2 = null;
                    for (int i = n7 - 1; i > 0 && !this.ASCENDING(-1, dSPage2 = this.getPage(i), vector); --i) {
                    }
                }
                if ((n7 = (int)(this.DESCENDING(n + 1, dSPage, vector) ? 1 : 0)) == 0 && (n6 = dSPage.getPageNum()) != 1 && !(this.communicator instanceof PJFCommunicator)) {
                    DSPage dSPage3 = null;
                    n5 = this.communicator.getPageNum();
                    for (n4 = n6 + 1; n4 <= n5 && !this.DESCENDING(0, dSPage3 = this.getPage(n4), vector); ++n4) {
                    }
                }
                DbColDesc dbColDesc = dbValue.getColDesc();
                IntVector intVector = null;
                for (n5 = 0; n5 < vector.size(); ++n5) {
                    DSSection dSSection2 = (DSSection)vector.elementAt(n5);
                    if (intVector == null) {
                        JRecord jRecord;
                        block17: {
                            object3 = dSSection2.getRecord().getDependCursor();
                            jRecord = null;
                            try {
                                jRecord = object3.createRecord();
                            }
                            catch (DSException dSException) {
                                if (!JRLog.isError(2)) break block17;
                                JRLog.error(2, dSException);
                            }
                        }
                        intVector = new QuickSortIntVector(20, jRecord, dbColDesc);
                    }
                    intVector.addElement(dSSection2.getRecordIndex());
                }
                int[] nArray = new int[]{bl ? QuickSorter.ASCENDING : QuickSorter.DESCENDING};
                new QuickSorter((QuickSortableVector)((Object)intVector), nArray).sort();
                n4 = vector.size();
                object3 = new Hashtable(n4);
                for (n3 = 0; n3 < n4; ++n3) {
                    DSSection dSSection3 = (DSSection)vector.elementAt(n3);
                    n2 = dSSection3.getRecordIndex();
                    object2 = new Vector(5);
                    vector2 = dSSection3.getChildren();
                    for (int i = 0; i < vector2.size(); ++i) {
                        object = vector2.elementAt(i);
                        if (!(object instanceof DSDBField)) continue;
                        ((Vector)object2).addElement(object);
                    }
                    ((Hashtable)object3).put(new Integer(n2), object2);
                }
                int n8 = -1;
                for (n2 = 0; n2 < n4; ++n2) {
                    Object object4;
                    n3 = intVector.elementAt(n2);
                    object2 = (DSSection)vector.elementAt(n2);
                    ((DSSection)object2).setRecordIndex(n3);
                    vector2 = (Vector)((Hashtable)object3).get(n3);
                    for (int i = 0; i < vector2.size(); ++i) {
                        object = (JRVisiableResult)vector2.elementAt(i);
                        object4 = (DSContainer)((JRObjectResult)object).getParent();
                        if (object4 != null) {
                            ((DSContainer)object4).remove((JRObjectResult)object);
                        }
                        ((DSContainer)object2).add((JRObjectResult)object);
                    }
                    DSPage dSPage4 = (DSPage)((JRObjectResult)object2).getParent();
                    if (dSPage4 != null && n8 == -1) {
                        n8 = dSPage4.getPageNum();
                    }
                    if (dSPage4 == null || n8 == dSPage4.getPageNum() || (object = (Long)this.pageEntries.get(n8 = dSPage4.getPageNum())) == null) continue;
                    this.bufFile.seek((Long)object);
                    this.out.reset(this.bufFile.getPosition());
                    object4 = new RandomByteArrayOutputStream(dSPage4.length());
                    dSPage4.write(new PJFDataOutput((OutputStream)object4));
                    byte[] byArray = ((ByteArrayOutputStream)object4).toByteArray();
                    if (this.SEDU) {
                        byArray = ZipToolkit.GZip(byArray);
                    }
                    this.out.write(byArray);
                }
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block18;
                JRLog.error(2, iOException);
            }
        }
    }

    private boolean ASCENDING(int n, DSPage dSPage, Vector vector) {
        boolean bl = false;
        Vector vector2 = dSPage.getChildren();
        JRObjectResult jRObjectResult = null;
        if (n == -1) {
            n = vector2.size() - 1;
        }
        for (int i = n; i >= 0; --i) {
            jRObjectResult = (JRObjectResult)vector2.elementAt(i);
            int n2 = jRObjectResult.getObjectType();
            if ((n2 & 0x200) != 512 || n2 == 514 || n2 == 517 || n2 == 513 || n2 == 516) continue;
            if (n2 == 519) {
                vector.insertElementAt(jRObjectResult, 0);
                continue;
            }
            bl = true;
            break;
        }
        return bl;
    }

    private boolean DESCENDING(int n, DSPage dSPage, Vector vector) {
        boolean bl = false;
        Vector vector2 = dSPage.getChildren();
        int n2 = vector2.size();
        JRObjectResult jRObjectResult = null;
        if (n == -1) {
            n = vector2.size() - 1;
        }
        for (int i = n; i < n2; ++i) {
            jRObjectResult = (JRObjectResult)vector2.elementAt(i);
            int n3 = jRObjectResult.getObjectType();
            if ((n3 & 0x200) != 512 || n3 == 514 || n3 == 517 || n3 == 513 || n3 == 516) continue;
            if (n3 == 519) {
                vector.addElement(jRObjectResult);
                continue;
            }
            bl = true;
            break;
        }
        return bl;
    }

    public void finish() {
        this.ASCENDING = true;
    }

    public boolean isFinished() {
        return this.ASCENDING;
    }

    public void savePageIfInDisk(int n, DSPage dSPage) {
        block4: {
            Long l = (Long)this.pageEntries.get(n);
            if (l != null) {
                try {
                    this.bufFile.seek(l);
                    this.out.reset(this.bufFile.getPosition());
                    RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage.length());
                    dSPage.write(new PJFDataOutput(randomByteArrayOutputStream));
                    byte[] byArray = randomByteArrayOutputStream.toByteArray();
                    if (this.SEDU) {
                        byArray = ZipToolkit.GZip(byArray);
                    }
                    this.out.write(byArray);
                    randomByteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    if (!JRLog.isError(2)) break block4;
                    JRLog.error(2, iOException);
                }
            }
        }
    }

    public boolean isCacheZip() {
        return this.SEDU;
    }

    public void setCacheZip(boolean bl) {
        this.SEDU = bl;
    }

    @Override
    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }

    @Override
    public void setResourceStore(ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }
}

