/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.util;

import java.math.RoundingMode;
import jet.datastream.DSContainer;
import jet.datastream.JRObjectResult;
import jet.util.Containable;

public class DSTool {
    public static RoundingMode getRoundingMode(JRObjectResult jRObjectResult) {
        RoundingMode roundingMode = RoundingMode.HALF_EVEN;
        JRObjectResult jRObjectResult2 = null;
        Containable containable = jRObjectResult.getParent();
        while (containable != null && containable instanceof JRObjectResult) {
            jRObjectResult2 = (JRObjectResult)((Object)containable);
            if (DSTool.isResourceContainer(jRObjectResult2.getObjectType())) {
                roundingMode = DSTool.convertConstantToRoundingMode(((DSContainer)jRObjectResult2).getRoundingMode());
                break;
            }
            containable = jRObjectResult2.getParent();
        }
        return roundingMode;
    }

    public static boolean isResourceContainer(int n) {
        return n == 262177 || n == 262182 || n == 262179 || n == 45 || n == 71 || n == 34 || n == 40;
    }

    public static boolean isNumericSqlData(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static RoundingMode convertConstantToRoundingMode(int n) {
        RoundingMode roundingMode;
        switch (n) {
            case 0: {
                roundingMode = RoundingMode.UP;
                break;
            }
            case 1: {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case 2: {
                roundingMode = RoundingMode.CEILING;
                break;
            }
            case 3: {
                roundingMode = RoundingMode.FLOOR;
                break;
            }
            case 4: {
                roundingMode = RoundingMode.HALF_UP;
                break;
            }
            case 5: {
                roundingMode = RoundingMode.HALF_DOWN;
                break;
            }
            case 6: {
                roundingMode = RoundingMode.HALF_EVEN;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_EVEN;
            }
        }
        return roundingMode;
    }
}

